/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.wrapper.modelloader;

import com.norwood.mcheli.helper.client._IModelCustom;
import com.norwood.mcheli.helper.client._ModelFormatException;
import com.norwood.mcheli.wrapper.modelloader.GroupObject;
import com.norwood.mcheli.wrapper.modelloader.ModelVBO;
import com.norwood.mcheli.wrapper.modelloader.W_Face;
import com.norwood.mcheli.wrapper.modelloader.W_ModelCustom;
import com.norwood.mcheli.wrapper.modelloader.W_TextureCoordinate;
import com.norwood.mcheli.wrapper.modelloader.W_Vertex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class W_WavefrontObject
extends W_ModelCustom {
    public ArrayList<W_Vertex> vertices = new ArrayList();
    public ArrayList<W_Vertex> vertexNormals = new ArrayList();
    public ArrayList<W_TextureCoordinate> textureCoordinates = new ArrayList();
    public ArrayList<GroupObject> groupObjects = new ArrayList();
    private Pattern vertexPattern = Pattern.compile("(v( (\\-){0,1}\\d+\\.\\d+){3,4} *\\n)|(v( (\\-){0,1}\\d+\\.\\d+){3,4} *$)");
    private Pattern vertexNormalPattern = Pattern.compile("(vn( (\\-){0,1}\\d+\\.\\d+){3,4} *\\n)|(vn( (\\-){0,1}\\d+\\.\\d+){3,4} *$)");
    private Pattern textureCoordinatePattern = Pattern.compile("(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *\\n)|(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *$)");
    private Pattern face_V_VT_VN_Pattern = Pattern.compile("(f( \\d+/\\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+/\\d+){3,4} *$)");
    private Pattern face_V_VT_Pattern = Pattern.compile("(f( \\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+){3,4} *$)");
    private Pattern face_V_VN_Pattern = Pattern.compile("(f( \\d+//\\d+){3,4} *\\n)|(f( \\d+//\\d+){3,4} *$)");
    private Pattern face_V_Pattern = Pattern.compile("(f( \\d+){3,4} *\\n)|(f( \\d+){3,4} *$)");
    private Pattern groupObjectPattern = Pattern.compile("([go]( [-\\$\\w\\d]+) *\\n)|([go]( [-\\$\\w\\d]+) *$)");
    private Matcher vertexMatcher;
    private Matcher vertexNormalMatcher;
    private Matcher textureCoordinateMatcher;
    private Matcher face_V_VT_VN_Matcher;
    private Matcher face_V_VT_Matcher;
    private Matcher face_V_VN_Matcher;
    private Matcher face_V_Matcher;
    private Matcher groupObjectMatcher;
    private GroupObject currentGroupObject;
    private String fileName;

    public W_WavefrontObject(ResourceLocation location, IResource resource) throws _ModelFormatException {
        this.fileName = resource.toString();
        this.loadObjModel(resource.func_110527_b());
    }

    public W_WavefrontObject(String fileName, URL resource) throws _ModelFormatException {
        this.fileName = fileName;
        try {
            this.loadObjModel(resource.openStream());
        }
        catch (IOException e) {
            throw new _ModelFormatException("IO Exception reading model format", e);
        }
    }

    public W_WavefrontObject(String filename, InputStream inputStream) throws _ModelFormatException {
        this.fileName = filename;
        this.loadObjModel(inputStream);
    }

    private boolean isValidVertexLine(String line) {
        if (this.vertexMatcher != null) {
            this.vertexMatcher.reset();
        }
        this.vertexMatcher = this.vertexPattern.matcher(line);
        return this.vertexMatcher.matches();
    }

    private boolean isValidVertexNormalLine(String line) {
        if (this.vertexNormalMatcher != null) {
            this.vertexNormalMatcher.reset();
        }
        this.vertexNormalMatcher = this.vertexNormalPattern.matcher(line);
        return this.vertexNormalMatcher.matches();
    }

    private boolean isValidTextureCoordinateLine(String line) {
        if (this.textureCoordinateMatcher != null) {
            this.textureCoordinateMatcher.reset();
        }
        this.textureCoordinateMatcher = this.textureCoordinatePattern.matcher(line);
        return this.textureCoordinateMatcher.matches();
    }

    private boolean isValidFace_V_VT_VN_Line(String line) {
        if (this.face_V_VT_VN_Matcher != null) {
            this.face_V_VT_VN_Matcher.reset();
        }
        this.face_V_VT_VN_Matcher = this.face_V_VT_VN_Pattern.matcher(line);
        return this.face_V_VT_VN_Matcher.matches();
    }

    private boolean isValidFace_V_VT_Line(String line) {
        if (this.face_V_VT_Matcher != null) {
            this.face_V_VT_Matcher.reset();
        }
        this.face_V_VT_Matcher = this.face_V_VT_Pattern.matcher(line);
        return this.face_V_VT_Matcher.matches();
    }

    private boolean isValidFace_V_VN_Line(String line) {
        if (this.face_V_VN_Matcher != null) {
            this.face_V_VN_Matcher.reset();
        }
        this.face_V_VN_Matcher = this.face_V_VN_Pattern.matcher(line);
        return this.face_V_VN_Matcher.matches();
    }

    private boolean isValidFace_V_Line(String line) {
        if (this.face_V_Matcher != null) {
            this.face_V_Matcher.reset();
        }
        this.face_V_Matcher = this.face_V_Pattern.matcher(line);
        return this.face_V_Matcher.matches();
    }

    private boolean isValidFaceLine(String line) {
        return this.isValidFace_V_VT_VN_Line(line) || this.isValidFace_V_VT_Line(line) || this.isValidFace_V_VN_Line(line) || this.isValidFace_V_Line(line);
    }

    private boolean isValidGroupObjectLine(String line) {
        if (this.groupObjectMatcher != null) {
            this.groupObjectMatcher.reset();
        }
        this.groupObjectMatcher = this.groupObjectPattern.matcher(line);
        return this.groupObjectMatcher.matches();
    }

    @Override
    public boolean containsPart(String partName) {
        for (GroupObject groupObject : this.groupObjects) {
            if (!partName.equalsIgnoreCase(groupObject.name)) continue;
            return true;
        }
        return false;
    }

    private void loadObjModel(InputStream inputStream) throws _ModelFormatException {
        BufferedReader reader = null;
        int lineCount = 0;
        try {
            String currentLine;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            block24: while ((currentLine = reader.readLine()) != null) {
                ++lineCount;
                if ((currentLine = W_WavefrontObject.normalizeWhitespace(currentLine)).startsWith("#") || currentLine.isEmpty()) continue;
                char c0 = currentLine.charAt(0);
                switch (c0) {
                    case 'v': {
                        if (currentLine.length() <= 1) break;
                        char c1 = currentLine.charAt(1);
                        switch (c1) {
                            case ' ': {
                                W_Vertex vertex = this.parseVertex(currentLine, lineCount);
                                if (vertex == null) continue block24;
                                this.checkMinMax(vertex);
                                this.vertices.add(vertex);
                                break;
                            }
                            case 'n': {
                                W_Vertex normal = this.parseVertexNormal(currentLine, lineCount);
                                if (normal == null) continue block24;
                                this.vertexNormals.add(normal);
                                break;
                            }
                            case 't': {
                                W_TextureCoordinate tex = this.parseTextureCoordinate(currentLine, lineCount);
                                if (tex != null) {
                                    this.textureCoordinates.add(tex);
                                } else {
                                    break;
                                }
                            }
                        }
                        continue block24;
                    }
                    case 'f': {
                        if (this.currentGroupObject == null) {
                            this.currentGroupObject = new GroupObject("Default");
                        }
                        W_Face face = this.parseFace(currentLine, lineCount);
                        this.currentGroupObject.faces.add(face);
                        break;
                    }
                    case 'g': {
                        if (currentLine.length() <= 2 || currentLine.charAt(2) != '$') break;
                        GroupObject group = this.parseGroupObject(currentLine, lineCount);
                        if (group != null && this.currentGroupObject != null) {
                            this.groupObjects.add(this.currentGroupObject);
                        }
                        this.currentGroupObject = group;
                        break;
                    }
                    case 'o': {
                        if (currentLine.length() <= 2 || currentLine.charAt(2) != '$') break;
                        GroupObject group2 = this.parseGroupObject(currentLine, lineCount);
                        if (group2 != null && this.currentGroupObject != null) {
                            this.groupObjects.add(this.currentGroupObject);
                        }
                        this.currentGroupObject = group2;
                        break;
                    }
                }
            }
            this.groupObjects.add(this.currentGroupObject);
        }
        catch (IOException var16) {
            throw new _ModelFormatException("IO Exception reading model format", var16);
        }
        finally {
            this.checkMinMaxFinal();
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void renderAll() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        if (this.currentGroupObject != null) {
            builder.func_181668_a(this.currentGroupObject.glDrawingMode, DefaultVertexFormats.field_181710_j);
        } else {
            builder.func_181668_a(4, DefaultVertexFormats.field_181710_j);
        }
        this.tessellateAll(tessellator);
        tessellator.func_78381_a();
    }

    public void tessellateAll(Tessellator tessellator) {
        for (GroupObject groupObject : this.groupObjects) {
            groupObject.render(tessellator);
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        for (GroupObject groupObject : this.groupObjects) {
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(groupObject.name)) continue;
                groupObject.render();
            }
        }
    }

    @Override
    public void renderPart(String partName) {
        for (GroupObject groupObject : this.groupObjects) {
            if (!partName.equalsIgnoreCase(groupObject.name)) continue;
            groupObject.render();
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        for (GroupObject groupObject : this.groupObjects) {
            boolean skipPart = false;
            for (String excludedGroupName : excludedGroupNames) {
                if (!excludedGroupName.equalsIgnoreCase(groupObject.name)) continue;
                skipPart = true;
            }
            if (skipPart) continue;
            groupObject.render();
        }
    }

    @Override
    public _IModelCustom toVBO() {
        return new ModelVBO(this);
    }

    private W_Vertex parseVertex(String line, int lineCount) throws _ModelFormatException {
        W_Vertex vertex;
        block5: {
            vertex = null;
            if (this.isValidVertexLine(line)) {
                line = line.substring(line.indexOf(" ") + 1);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == 2) {
                        return new W_Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]));
                    }
                    if (tokens.length == 3) {
                        return new W_Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new _ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
                }
            }
            throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseVertex$1(line, lineCount, this.fileName));
        }
        return vertex;
    }

    private W_Vertex parseVertexNormal(String line, int lineCount) throws _ModelFormatException {
        W_Vertex vertexNormal;
        block4: {
            vertexNormal = null;
            if (this.isValidVertexNormalLine(line)) {
                line = line.substring(line.indexOf(" ") + 1);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == 3) {
                        return new W_Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    }
                    break block4;
                }
                catch (NumberFormatException e) {
                    throw new _ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
                }
            }
            throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseVertex$1(line, lineCount, this.fileName));
        }
        return vertexNormal;
    }

    private W_TextureCoordinate parseTextureCoordinate(String line, int lineCount) throws _ModelFormatException {
        W_TextureCoordinate textureCoordinate;
        block5: {
            textureCoordinate = null;
            if (this.isValidTextureCoordinateLine(line)) {
                line = line.substring(line.indexOf(" ") + 1);
                String[] tokens = line.split(" ");
                try {
                    if (tokens.length == 2) {
                        return new W_TextureCoordinate(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]));
                    }
                    if (tokens.length == 3) {
                        return new W_TextureCoordinate(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new _ModelFormatException(String.format("Number formatting error at line %d", lineCount), e);
                }
            }
            throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseVertex$1(line, lineCount, this.fileName));
        }
        return textureCoordinate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private W_Face parseFace(String line, int lineCount) throws _ModelFormatException {
        W_Face face = null;
        if (!this.isValidFaceLine(line)) throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseVertex$1(line, lineCount, this.fileName));
        face = new W_Face();
        String trimmedLine = line.substring(line.indexOf(" ") + 1);
        String[] tokens = trimmedLine.split(" ");
        String[] subTokens = null;
        if (tokens.length == 3) {
            if (this.currentGroupObject.glDrawingMode == -1) {
                this.currentGroupObject.glDrawingMode = 4;
            } else if (this.currentGroupObject.glDrawingMode != 4) {
                throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseFace$1(line, lineCount, this.fileName, tokens.length));
            }
        } else if (tokens.length == 4) {
            if (this.currentGroupObject.glDrawingMode == -1) {
                this.currentGroupObject.glDrawingMode = 7;
            } else if (this.currentGroupObject.glDrawingMode != 7) {
                throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseFace$2(line, lineCount, this.fileName, tokens.length));
            }
        }
        if (this.isValidFace_V_VT_VN_Line(line)) {
            face.vertices = new W_Vertex[tokens.length];
            face.textureCoordinates = new W_TextureCoordinate[tokens.length];
            face.vertexNormals = new W_Vertex[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                subTokens = tokens[i].split("/");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[1]) - 1);
                face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[2]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else if (this.isValidFace_V_VT_Line(line)) {
            face.vertices = new W_Vertex[tokens.length];
            face.textureCoordinates = new W_TextureCoordinate[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                subTokens = tokens[i].split("/");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                face.textureCoordinates[i] = this.textureCoordinates.get(Integer.parseInt(subTokens[1]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else if (this.isValidFace_V_VN_Line(line)) {
            face.vertices = new W_Vertex[tokens.length];
            face.vertexNormals = new W_Vertex[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                subTokens = tokens[i].split("//");
                face.vertices[i] = this.vertices.get(Integer.parseInt(subTokens[0]) - 1);
                face.vertexNormals[i] = this.vertexNormals.get(Integer.parseInt(subTokens[1]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
            return face;
        } else {
            if (!this.isValidFace_V_Line(line)) throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseVertex$1(line, lineCount, this.fileName));
            face.vertices = new W_Vertex[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                face.vertices[i] = this.vertices.get(Integer.parseInt(tokens[i]) - 1);
            }
            face.faceNormal = face.calculateFaceNormal();
        }
        return face;
    }

    private GroupObject parseGroupObject(String line, int lineCount) throws _ModelFormatException {
        GroupObject group = null;
        if (this.isValidGroupObjectLine(line)) {
            String trimmedLine = line.substring(line.indexOf(" ") + 1);
            if (trimmedLine.length() > 0) {
                group = new GroupObject(trimmedLine);
            }
        } else {
            throw new _ModelFormatException(W_WavefrontObject.jvmdowngrader$concat$parseVertex$1(line, lineCount, this.fileName));
        }
        return group;
    }

    @Override
    public String getType() {
        return "obj";
    }

    @Override
    public void renderAllLine(int startLine, int maxLine) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        this.renderAllLine(tessellator, startLine, maxLine);
        tessellator.func_78381_a();
    }

    public void renderAllLine(Tessellator tessellator, int startLine, int maxLine) {
        int lineCnt = 0;
        BufferBuilder builder = tessellator.func_178180_c();
        for (GroupObject groupObject : this.groupObjects) {
            if (groupObject.faces.size() <= 0) continue;
            for (W_Face face : groupObject.faces) {
                for (int i = 0; i < face.vertices.length / 3; ++i) {
                    W_Vertex v1 = face.vertices[i * 3 + 0];
                    W_Vertex v2 = face.vertices[i * 3 + 1];
                    W_Vertex v3 = face.vertices[i * 3 + 2];
                    if (++lineCnt > maxLine) {
                        return;
                    }
                    builder.func_181662_b((double)v1.x, (double)v1.y, (double)v1.z).func_181675_d();
                    builder.func_181662_b((double)v2.x, (double)v2.y, (double)v2.z).func_181675_d();
                    if (++lineCnt > maxLine) {
                        return;
                    }
                    builder.func_181662_b((double)v2.x, (double)v2.y, (double)v2.z).func_181675_d();
                    builder.func_181662_b((double)v3.x, (double)v3.y, (double)v3.z).func_181675_d();
                    if (++lineCnt > maxLine) {
                        return;
                    }
                    builder.func_181662_b((double)v3.x, (double)v3.y, (double)v3.z).func_181675_d();
                    builder.func_181662_b((double)v1.x, (double)v1.y, (double)v1.z).func_181675_d();
                }
            }
        }
    }

    @Override
    public int getVertexNum() {
        return this.vertices.size();
    }

    @Override
    public int getFaceNum() {
        return this.getVertexNum() / 3;
    }

    @Override
    public void renderAll(int startFace, int maxFace) {
        if (startFace < 0) {
            startFace = 0;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(4, DefaultVertexFormats.field_181710_j);
        this.renderAll(tessellator, startFace, maxFace);
        tessellator.func_78381_a();
    }

    public void renderAll(Tessellator tessellator, int startFace, int maxLine) {
        int faceCnt = 0;
        for (GroupObject groupObject : this.groupObjects) {
            if (groupObject.faces.size() <= 0) continue;
            for (W_Face face : groupObject.faces) {
                if (++faceCnt < startFace) continue;
                if (faceCnt > maxLine) {
                    return;
                }
                face.addFaceForRender(tessellator);
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseVertex$1(String string, int n, String string2) {
        return "Error parsing entry ('" + string + "', line " + n + ") in file '" + string2 + "' - Incorrect format";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseFace$1(String string, int n, String string2, int n2) {
        return "Error parsing entry ('" + string + "', line " + n + ") in file '" + string2 + "' - Invalid number of points for face (expected 4, found " + n2 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseFace$2(String string, int n, String string2, int n2) {
        return "Error parsing entry ('" + string + "', line " + n + ") in file '" + string2 + "' - Invalid number of points for face (expected 3, found " + n2 + ")";
    }
}

