/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.wrapper.modelloader;

import com.norwood.mcheli.helper.client._IModelCustom;
import com.norwood.mcheli.wrapper.modelloader.GroupObject;
import com.norwood.mcheli.wrapper.modelloader.W_Face;
import com.norwood.mcheli.wrapper.modelloader.W_MetasequoiaObject;
import com.norwood.mcheli.wrapper.modelloader.W_ModelCustom;
import com.norwood.mcheli.wrapper.modelloader.W_TextureCoordinate;
import com.norwood.mcheli.wrapper.modelloader.W_Vertex;
import com.norwood.mcheli.wrapper.modelloader.W_WavefrontObject;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcheli-ce.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={VBOBufferData.class})
public class ModelVBO
extends W_ModelCustom
implements _IModelCustom {
    private static final int FLOAT_SIZE = 4;
    private static final int STRIDE = 36;
    static int VERTEX_SIZE = 3;
    List<VBOBufferData> groups = new ArrayList<VBOBufferData>();

    public ModelVBO(W_WavefrontObject obj) {
        this.uploadVBO(obj.groupObjects);
    }

    public ModelVBO(W_MetasequoiaObject obj) {
        this.uploadVBO(ModelVBO.cleanUpMsqMess(obj.groupObjects));
    }

    private static List<GroupObject> cleanUpMsqMess(ArrayList<GroupObject> groupObjects) {
        ArrayList<GroupObject> result = new ArrayList<GroupObject>();
        GroupObject currentKey = null;
        for (GroupObject obj : groupObjects) {
            String name = obj.name;
            if (name.isEmpty()) continue;
            if (name.charAt(0) == '$') {
                currentKey = new GroupObject(name);
                currentKey.faces.addAll(obj.faces);
                result.add(currentKey);
                continue;
            }
            if (currentKey != null) {
                currentKey.faces.addAll(obj.faces);
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    private void uploadVBO(List<GroupObject> obj) {
        for (GroupObject g : obj) {
            int i;
            VBOBufferData data = new VBOBufferData(this);
            data.name = g.name;
            ArrayList<Float> vertexData = new ArrayList<Float>(g.faces.size() * 3 * VERTEX_SIZE);
            ArrayList<Float> uvwData = new ArrayList<Float>(g.faces.size() * 3 * VERTEX_SIZE);
            ArrayList<Float> normalData = new ArrayList<Float>(g.faces.size() * 3 * VERTEX_SIZE);
            for (W_Face face : g.faces) {
                for (i = 0; i < face.vertices.length; ++i) {
                    W_Vertex normal;
                    W_Vertex vert = face.vertices[i];
                    W_TextureCoordinate tex = new W_TextureCoordinate(0.0f, 0.0f);
                    W_Vertex w_Vertex = normal = face.vertexNormals != null ? face.vertexNormals[i] : new W_Vertex(0.0f, 0.0f, 0.0f);
                    if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                        tex = face.textureCoordinates[i];
                    }
                    ++data.vertices;
                    vertexData.add(Float.valueOf(vert.x));
                    vertexData.add(Float.valueOf(vert.y));
                    vertexData.add(Float.valueOf(vert.z));
                    uvwData.add(Float.valueOf(tex.u));
                    uvwData.add(Float.valueOf(tex.v));
                    uvwData.add(Float.valueOf(tex.w));
                    normalData.add(Float.valueOf(normal.x));
                    normalData.add(Float.valueOf(normal.y));
                    normalData.add(Float.valueOf(normal.z));
                }
            }
            float[] combinedData = new float[data.vertices * 9];
            int dst = 0;
            for (i = 0; i < data.vertices; ++i) {
                combinedData[dst++] = ((Float)vertexData.get(i * 3)).floatValue();
                combinedData[dst++] = ((Float)vertexData.get(i * 3 + 1)).floatValue();
                combinedData[dst++] = ((Float)vertexData.get(i * 3 + 2)).floatValue();
                combinedData[dst++] = ((Float)uvwData.get(i * 3)).floatValue();
                combinedData[dst++] = ((Float)uvwData.get(i * 3 + 1)).floatValue();
                combinedData[dst++] = ((Float)uvwData.get(i * 3 + 2)).floatValue();
                combinedData[dst++] = ((Float)normalData.get(i * 3)).floatValue();
                combinedData[dst++] = ((Float)normalData.get(i * 3 + 1)).floatValue();
                combinedData[dst++] = ((Float)normalData.get(i * 3 + 2)).floatValue();
            }
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)combinedData.length);
            buffer.put(combinedData);
            FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.flip(buffer);
            data.vaoHandle = GL30.glGenVertexArrays();
            data.vboHandle = GL15.glGenBuffers();
            GL30.glBindVertexArray((int)data.vaoHandle);
            GL15.glBindBuffer((int)34962, (int)data.vboHandle);
            GL15.glBufferData((int)34962, (FloatBuffer)buffer, (int)35044);
            GL11.glVertexPointer((int)3, (int)5126, (int)36, (long)0L);
            GL11.glEnableClientState((int)32884);
            GL11.glTexCoordPointer((int)3, (int)5126, (int)36, (long)12L);
            GL11.glEnableClientState((int)32888);
            GL11.glNormalPointer((int)5126, (int)36, (long)24L);
            GL11.glEnableClientState((int)32885);
            GL30.glBindVertexArray((int)0);
            GL15.glBindBuffer((int)34962, (int)0);
            this.groups.add(data);
        }
    }

    public void delete() {
        IntBuffer vaoIDBuffer = BufferUtils.createIntBuffer((int)this.groups.size());
        IntBuffer vboIDBuffer = BufferUtils.createIntBuffer((int)this.groups.size());
        for (VBOBufferData data : this.groups) {
            vaoIDBuffer.put(data.vaoHandle);
            vboIDBuffer.put(data.vboHandle);
        }
        IntBuffer cfr_ignored_0 = (IntBuffer)J_N_Buffer.flip(vaoIDBuffer);
        IntBuffer cfr_ignored_1 = (IntBuffer)J_N_Buffer.flip(vboIDBuffer);
        GL30.glDeleteVertexArrays((IntBuffer)vaoIDBuffer);
        GL15.glDeleteBuffers((IntBuffer)vboIDBuffer);
    }

    private void renderVBO(VBOBufferData data) {
        GL30.glBindVertexArray((int)data.vaoHandle);
        GlStateManager.func_187439_f((int)4, (int)0, (int)data.vertices);
        GL30.glBindVertexArray((int)0);
    }

    @Override
    public String getType() {
        return "obj_vbo";
    }

    @Override
    public void renderAll() {
        for (VBOBufferData data : this.groups) {
            this.renderVBO(data);
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        for (VBOBufferData data : this.groups) {
            for (String name : groupNames) {
                if (!data.name.equalsIgnoreCase(name)) continue;
                this.renderVBO(data);
            }
        }
    }

    @Override
    public void renderPart(String partName) {
        for (VBOBufferData data : this.groups) {
            if (!data.name.equalsIgnoreCase(partName)) continue;
            this.renderVBO(data);
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        for (VBOBufferData data : this.groups) {
            boolean skip = false;
            for (String name : excludedGroupNames) {
                if (!data.name.equalsIgnoreCase(name)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            this.renderVBO(data);
        }
    }

    @Override
    public _IModelCustom toVBO() {
        return this;
    }

    @Override
    public boolean containsPart(String partName) {
        for (VBOBufferData data : this.groups) {
            if (!data.name.equalsIgnoreCase(partName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderAll(int var1, int var2) {
    }

    @Override
    public void renderAllLine(int var1, int var2) {
    }

    @Override
    public int getVertexNum() {
        return 0;
    }

    @Override
    public int getFaceNum() {
        return 0;
    }

    @NestHost(value=ModelVBO.class)
    class VBOBufferData {
        String name;
        int vertices;
        int vboHandle;
        int vaoHandle;

        VBOBufferData(ModelVBO this$0) {
            Objects.requireNonNull(this$0);
            this.vertices = 0;
        }
    }
}

