/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.weapon;

import com.norwood.mcheli.MCH_BaseInfo;
import com.norwood.mcheli.MCH_Color;
import com.norwood.mcheli.MCH_DamageFactor;
import com.norwood.mcheli.compat.ModCompatManager;
import com.norwood.mcheli.compat.hbm.ChemicalContainer;
import com.norwood.mcheli.compat.hbm.MistContainer;
import com.norwood.mcheli.compat.hbm.MukeContainer;
import com.norwood.mcheli.compat.hbm.NTSettingContainer;
import com.norwood.mcheli.compat.hbm.VNTSettingContainer;
import com.norwood.mcheli.helper.MCH_Logger;
import com.norwood.mcheli.helper.addon.AddonResourceLocation;
import com.norwood.mcheli.helper.info.parsers.yaml.YamlParser;
import com.norwood.mcheli.sound.SoundRegistry;
import com.norwood.mcheli.weapon.MCH_BulletModel;
import com.norwood.mcheli.weapon.MCH_Cartridge;
import com.norwood.mcheli.weapon.MCH_SightType;
import com.norwood.mcheli.weapon.MCH_WeaponInfoManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={MuzzleFlash.class, MuzzleFlashRaw.class, RoundItem.class, Payload.class})
public class MCH_WeaponInfo
extends MCH_BaseInfo {
    public static Random rand = new Random();
    public final String name;
    public boolean useHBM = false;
    public Payload payloadNTM = Payload.NONE;
    public boolean effectOnly = false;
    public VNTSettingContainer vntSettingContainer = null;
    public ChemicalContainer chemicalContainer = null;
    public MistContainer mistContainer = null;
    public MukeContainer mukeContainer = null;
    public NTSettingContainer ntSettingContainer = null;
    public String explosionType;
    public String displayName;
    public String type = "";
    public int power = 0;
    public float acceleration = 1.0f;
    public float accelerationInWater = 1.0f;
    public int explosion = 0;
    public int explosionBlock = -1;
    public int explosionInWater = 0;
    public int explosionAltitude = 0;
    public int delayFuse = 0;
    public float bound;
    public int timeFuse = 0;
    public boolean flaming = false;
    public MCH_SightType sight = MCH_SightType.NONE;
    public float[] zoom = new float[]{1.0f};
    public int delay = 10;
    public int reloadTime = 30;
    public int round = 0;
    public int suppliedNum = 1;
    public int maxAmmo = 0;
    public List<RoundItem> roundItems = new ArrayList<RoundItem>();
    public int soundDelay = 0;
    public float soundVolume = 1.0f;
    public float soundPitch = 1.0f;
    public float soundPitchRandom = 0.1f;
    public int soundPattern = 0;
    public int lockTime = 30;
    public boolean ridableOnly = false;
    public float proximityFuseDist = 0.0f;
    public int rigidityTime = 7;
    public float accuracy = 0.0f;
    public int bomblet = 0;
    public int bombletSTime = 10;
    public float bombletDiff = 0.3f;
    public int modeNum = 0;
    public int fixMode = 0;
    public int piercing = 0;
    public int heatCount = 0;
    public int maxHeatCount = 0;
    public boolean isFAE = false;
    public boolean isGuidedTorpedo = false;
    public float gravity = 0.0f;
    public float gravityInWater = 0.0f;
    public float velocityInWater = 0.999f;
    public boolean destruct = false;
    public String trajectoryParticleName = "explode";
    public int trajectoryParticleStartTick = 0;
    public boolean disableSmoke = false;
    public MCH_Cartridge cartridge = null;
    public MCH_Color color = new MCH_Color();
    public MCH_Color colorInWater = new MCH_Color();
    public float smokeSize = 2.0f;
    public int smokeNum = 1;
    public int smokeMaxAge = 100;
    public String dispenseItemLoc = null;
    public Item dispenseItem = null;
    public int dispenseDamege = 0;
    public int dispenseRange = 1;
    public int recoilBufCount = 2;
    public int recoilBufCountSpeed = 3;
    public float length = 0.0f;
    public float radius = 0.0f;
    public float angle;
    public boolean displayMortarDistance = false;
    public boolean fixCameraPitch = false;
    public float cameraRotationSpeedPitch = 1.0f;
    public int target = 1;
    public int markTime;
    public float recoil = 0.0f;
    public String bulletModelName = "";
    public MCH_BulletModel bulletModel = null;
    public String bombletModelName = "";
    public MCH_BulletModel bombletModel = null;
    public MCH_DamageFactor damageFactor = null;
    public String group = "";
    public List<MuzzleFlash> listMuzzleFlash = null;
    public List<MuzzleFlash> listMuzzleFlashSmoke = null;
    public int flakParticlesCrack = 10;
    public int numParticlesFlak = 3;
    public float flakParticlesDiff = 0.3f;
    @NotNull
    public ResourceLocation fireSound;
    @Nullable
    public ResourceLocation hitSound;
    public ResourceLocation hitSoundIron = new ResourceLocation("mcheli", "hit_metal");
    public ResourceLocation railgunSound = new ResourceLocation("mcheli", "railgun");
    public float hitSoundRange = 100.0f;
    public boolean isHeatSeekerMissile = true;
    public boolean isRadarMissile = false;
    public int maxDegreeOfMissile = 60;
    public int tickEndHoming = -1;
    public int maxLockOnRange = 300;
    public int maxLockOnAngle = 10;
    public float pdHDNMaxDegree = 1000.0f;
    public int pdHDNMaxDegreeLockOutCount = 10;
    public int antiFlareCount = -1;
    public int lockMinHeight = 25;
    public boolean passiveRadar = false;
    public int passiveRadarLockOutCount = 20;
    public boolean laserGuidance = false;
    public boolean hasLaserGuidancePod = true;
    public boolean enableOffAxis = true;
    public double turningFactor = 0.5;
    public boolean enableChunkLoader = false;
    public boolean activeRadar = false;
    public int scanInterval = 20;
    public int weaponSwitchCount = 0;
    @Nullable
    public ResourceLocation weaponSwitchSound = null;
    public float recoilPitch = 0.0f;
    public float recoilYaw = 0.0f;
    public float recoilPitchRange = 0.0f;
    public float recoilYawRange = 0.0f;
    public float recoilRecoverFactor = 0.8f;
    public float speedFactor = 0.0f;
    public int speedFactorStartTick = 0;
    public int speedFactorEndTick = 0;
    public boolean speedDependsAircraft = false;
    public boolean canLockMissile = false;
    public boolean enableBVR = false;
    public int minRangeBVR = 300;
    public boolean predictTargetPos = true;
    public int numLockedChaffMax = 2;
    public float explosionDamageVsLiving = 1.0f;
    public float explosionDamageVsPlayer = 1.0f;
    public float explosionDamageVsPlane = 1.0f;
    public float explosionDamageVsVehicle = 1.0f;
    public float explosionDamageVsTank = 1.0f;
    public float explosionDamageVsHeli = 1.0f;
    public boolean disableDestroyBlock = true;
    public boolean canBeIntercepted = false;
    public boolean canAirburst = false;
    public int explosionAirburst;
    public int crossType = 0;
    public boolean hasMortarRadar = false;
    public double mortarRadarMaxDist = -1.0;
    public int markerRocketSpawnNum = 5;
    public int markerRocketSpawnDiff = 15;
    public int markerRocketSpawnHeight = 200;
    public int markerRocketSpawnSpeed = 5;

    public MCH_WeaponInfo(AddonResourceLocation location, String path) {
        super(location, path);
        this.displayName = this.name = location.func_110623_a();
        this.fireSound = new ResourceLocation("mcheli", MCH_WeaponInfo.jvmdowngrader$concat$$init$$1(this.name));
    }

    @Override
    public void onPostReload() {
        Item item;
        MCH_WeaponInfoManager.setRoundItems();
        if (this.dispenseItemLoc != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.dispenseItemLoc))) != null) {
            this.dispenseItem = item;
        }
        this.loadNTMFunctionality();
    }

    public void loadNTMFunctionality() {
        if (this.useHBM && ModCompatManager.isLoaded("hbm")) {
            if (this.vntSettingContainer != null) {
                this.vntSettingContainer.loadRuntimeInstances();
            }
            if (this.ntSettingContainer != null) {
                this.ntSettingContainer.loadRuntimeInstances();
            }
            if (this.mukeContainer != null) {
                this.mukeContainer.loadRuntimeInstances();
            }
        } else if (this.useHBM && !ModCompatManager.isLoaded("hbm")) {
            MCH_Logger.get().warn("Weapon:\"{}\" uses HBM capabilities, to use it please install HBM:NTM Community Edition", (Object)this.name);
        }
    }

    @Override
    public boolean validate() {
        if (this.explosionBlock < 0) {
            this.explosionBlock = this.explosion;
        }
        if (this.fixMode >= this.modeNum) {
            this.fixMode = 0;
        }
        if (this.round <= 0) {
            this.round = this.maxAmmo;
        }
        if (this.round > this.maxAmmo) {
            this.round = this.maxAmmo;
        }
        if (this.explosion <= 0) {
            this.isFAE = false;
        }
        if (this.delayFuse <= 0) {
            this.bound = 0.0f;
        }
        if (this.isFAE) {
            this.explosionInWater = 0;
        }
        if (this.bomblet > 0 && this.bombletSTime < 1) {
            this.bombletSTime = 1;
        }
        if (this.destruct) {
            this.delay = 1000000;
        }
        this.angle = (float)(Math.atan2(this.radius, this.length) * 180.0 / Math.PI);
        if (new ResourceLocation("mcheli", MCH_WeaponInfo.jvmdowngrader$concat$$init$$1(this.name)).equals((Object)this.hitSound)) {
            SoundRegistry.INSTANCE.parseSound(this.hitSound.func_110623_a());
        }
        return true;
    }

    public float getDamageFactor(Entity e) {
        return this.damageFactor != null ? this.damageFactor.getDamageFactor(e) : 1.0f;
    }

    public String getWeaponTypeName() {
        String string;
        switch (this.type.toLowerCase()) {
            case "machinegun1": 
            case "machinegun2": 
            case "railgun": {
                string = "MachineGun";
                break;
            }
            case "torpedo": {
                string = "Torpedo";
                break;
            }
            case "cas": {
                string = "CAS";
                break;
            }
            case "rocket": {
                string = "Rocket";
                break;
            }
            case "asmissile": {
                string = "AS Missile";
                break;
            }
            case "aamissile": {
                string = "AA Missile";
                break;
            }
            case "tvmissile": {
                string = "TV Missile";
                break;
            }
            case "atmissile": {
                string = "AT Missile";
                break;
            }
            case "bomb": {
                string = "Bomb";
                break;
            }
            case "mkrocket": {
                string = "Mk Rocket";
                break;
            }
            case "dummy": {
                string = "Dummy";
                break;
            }
            case "smoke": {
                string = "Smoke";
                break;
            }
            case "dispenser": {
                string = "Dispenser";
                break;
            }
            case "targetingpod": {
                string = "Targeting Pod";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public float getRecoilPitch() {
        return this.recoilPitch + rand.nextFloat() * this.recoilPitchRange;
    }

    public float getRecoilYaw() {
        return this.recoilYaw + (rand.nextFloat() - 0.5f) * this.recoilYawRange;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string) {
        return string + "_snd";
    }

    @NestHost(value=MCH_WeaponInfo.class)
    public static enum Payload {
        NONE,
        NTM_VNT,
        NTM_NT,
        NTM_MINI_NUKE,
        NTM_NUKE,
        NTM_CHEMICAL,
        NTM_MIST;

    }

    @NestHost(value=MCH_WeaponInfo.class)
    public static class MuzzleFlash {
        public final float dist;
        public final float size;
        public final float range;
        public final int age;
        public final float a;
        public final float r;
        public final float g;
        public final float b;
        public final int num;

        public MuzzleFlash(MuzzleFlashRaw raw) {
            this.dist = raw.getDistance();
            this.size = raw.getSize();
            this.range = raw.getRange();
            this.age = raw.getAge();
            this.num = raw.getCount();
            int color = YamlParser.parseHexColor(raw.getColor());
            this.a = (float)(color >> 24 & 0xFF) / 255.0f;
            this.r = (float)(color >> 16 & 0xFF) / 255.0f;
            this.g = (float)(color >> 8 & 0xFF) / 255.0f;
            this.b = (float)(color & 0xFF) / 255.0f;
        }

        @Deprecated
        public MuzzleFlash(float dist, float size, float range, int age, float a, float r, float g, float b, int num) {
            this.dist = dist;
            this.size = size;
            this.range = range;
            this.age = age;
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
            this.num = num;
        }
    }

    @NestHost(value=MCH_WeaponInfo.class)
    public static class MuzzleFlashRaw {
        float Distance;
        float Size;
        float Range;
        int Age;
        int Count;
        String Color;

        @Generated
        public float getDistance() {
            return this.Distance;
        }

        @Generated
        public float getSize() {
            return this.Size;
        }

        @Generated
        public float getRange() {
            return this.Range;
        }

        @Generated
        public int getAge() {
            return this.Age;
        }

        @Generated
        public int getCount() {
            return this.Count;
        }

        @Generated
        public String getColor() {
            return this.Color;
        }

        @Generated
        public void setDistance(float Distance) {
            this.Distance = Distance;
        }

        @Generated
        public void setSize(float Size) {
            this.Size = Size;
        }

        @Generated
        public void setRange(float Range2) {
            this.Range = Range2;
        }

        @Generated
        public void setAge(int Age) {
            this.Age = Age;
        }

        @Generated
        public void setCount(int Count) {
            this.Count = Count;
        }

        @Generated
        public void setColor(String Color) {
            this.Color = Color;
        }
    }

    @NestHost(value=MCH_WeaponInfo.class)
    public static class RoundItem {
        public final int num;
        public final ResourceLocation itemName;
        public final int damage;
        public ItemStack itemStack = ItemStack.field_190927_a;

        public RoundItem(int n, String name, int damage) {
            this.num = n;
            this.itemName = new ResourceLocation(name);
            this.damage = damage;
        }
    }
}

