/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.uav;

import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.helicopter.MCH_HeliInfoManager;
import com.norwood.mcheli.helicopter.MCH_ItemHeli;
import com.norwood.mcheli.networking.packet.PacketUavStatus;
import com.norwood.mcheli.plane.MCP_ItemPlane;
import com.norwood.mcheli.plane.MCP_PlaneInfoManager;
import com.norwood.mcheli.ship.MCH_ItemShip;
import com.norwood.mcheli.ship.MCH_ShipInfoManager;
import com.norwood.mcheli.tank.MCH_ItemTank;
import com.norwood.mcheli.tank.MCH_TankInfoManager;
import com.norwood.mcheli.uav.MCH_ContainerUavStation;
import com.norwood.mcheli.uav.MCH_EntityUavStation;
import com.norwood.mcheli.wrapper.W_GuiContainer;
import com.norwood.mcheli.wrapper.W_McClient;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MCH_GuiUavStation
extends W_GuiContainer {
    static final int BX = 20;
    static final int BY = 22;
    final MCH_EntityUavStation uavStation;
    private GuiButton buttonContinue;

    public MCH_GuiUavStation(InventoryPlayer inventoryPlayer, MCH_EntityUavStation uavStation) {
        super(new MCH_ContainerUavStation(inventoryPlayer, uavStation));
        this.uavStation = uavStation;
    }

    protected void func_146979_b(int param1, int param2) {
        if (this.uavStation != null) {
            ItemStack item = this.uavStation.func_70301_a(0);
            MCH_AircraftInfo info = null;
            if (!item.func_190926_b() && item.func_77973_b() instanceof MCP_ItemPlane) {
                info = MCP_PlaneInfoManager.getFromItem(item.func_77973_b());
            }
            if (!item.func_190926_b() && item.func_77973_b() instanceof MCH_ItemShip) {
                info = MCH_ShipInfoManager.getFromItem(item.func_77973_b());
            }
            if (!item.func_190926_b() && item.func_77973_b() instanceof MCH_ItemHeli) {
                info = MCH_HeliInfoManager.getFromItem(item.func_77973_b());
            }
            if (!item.func_190926_b() && item.func_77973_b() instanceof MCH_ItemTank) {
                info = MCH_TankInfoManager.getFromItem(item.func_77973_b());
            }
            if (item.func_190926_b() || info != null && info.isUAV) {
                if (this.uavStation.getKind() <= 1) {
                    this.drawString("UAV Station", 8, 6, 0xFFFFFF);
                } else if (!item.func_190926_b() && !info.isSmallUAV) {
                    this.drawString("Small UAV only", 8, 6, 0xFF0000);
                } else {
                    this.drawString("UAV Controller", 8, 6, 0xFFFFFF);
                }
            } else if (!item.func_190926_b()) {
                this.drawString("Not UAV", 8, 6, 0xFF0000);
            }
            this.drawString(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0xFFFFFF);
            this.drawString(String.format("X.%+2d", this.uavStation.posUavX), 58, 15, 0xFFFFFF);
            this.drawString(String.format("Y.%+2d", this.uavStation.posUavY), 58, 37, 0xFFFFFF);
            this.drawString(String.format("Z.%+2d", this.uavStation.posUavZ), 58, 59, 0xFFFFFF);
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        W_McClient.MOD_bindTexture("textures/gui/uav_station.png");
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(@NotNull GuiButton btn) {
        if (btn.field_146124_l) {
            if (btn.field_146127_k == 256) {
                if (this.uavStation != null && !this.uavStation.field_70128_L && this.uavStation.getLastControlAircraft() != null && !this.uavStation.getLastControlAircraft().field_70128_L) {
                    PacketUavStatus data = new PacketUavStatus();
                    data.posUavX = (byte)this.uavStation.posUavX;
                    data.posUavY = (byte)this.uavStation.posUavY;
                    data.posUavZ = (byte)this.uavStation.posUavZ;
                    data.continueControl = true;
                    data.sendToServer();
                }
                this.buttonContinue.field_146124_l = false;
            } else {
                int[] pos = new int[]{this.uavStation.posUavX, this.uavStation.posUavY, this.uavStation.posUavZ};
                int i = btn.field_146127_k >> 4 & 0xF;
                int j = (btn.field_146127_k & 0xF) - 1;
                int[] BTN = new int[]{-10, -1, 1, 10};
                int n = i;
                pos[n] = pos[n] + BTN[j];
                if (pos[i] < -50) {
                    pos[i] = -50;
                }
                if (pos[i] > 50) {
                    pos[i] = 50;
                }
                if (this.uavStation.posUavX != pos[0] || this.uavStation.posUavY != pos[1] || this.uavStation.posUavZ != pos[2]) {
                    PacketUavStatus data = new PacketUavStatus();
                    data.posUavX = (byte)pos[0];
                    data.posUavY = (byte)pos[1];
                    data.posUavZ = (byte)pos[2];
                    data.sendToServer();
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int x = this.field_146294_l / 2 - 5;
        int y = this.field_146295_m / 2 - 76;
        String[] BTN = new String[]{"-10", "-1", "+1", "+10"};
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                int id = row << 4 | col + 1;
                this.field_146292_n.add(new GuiButton(id, x + col * 20, y + row * 22, 20, 20, BTN[col]));
            }
        }
        this.buttonContinue = new GuiButton(256, x - 80 + 3, y + 44, 50, 20, "Continue");
        this.buttonContinue.field_146124_l = this.uavStation != null && !this.uavStation.field_70128_L && this.uavStation.getAndSearchLastControlAircraft() != null;
        this.field_146292_n.add(this.buttonContinue);
    }
}

