/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.sound;

import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.helper.info.parsers.yaml.YamlParser;
import com.norwood.mcheli.sound.ClientSoundRegistry;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={SoundSpec.class})
public class SoundRegistry {
    public static final String SND = "_snd";
    public static SoundRegistry INSTANCE = new SoundRegistry();
    public final Set<ResourceLocation> soundSet = new HashSet<ResourceLocation>();

    private static ResourceLocation rl(String path) {
        return new ResourceLocation("mcheli", path);
    }

    public SoundRegistry() {
        INSTANCE = this;
    }

    private static void add(ResourceLocation event) {
        SoundRegistry.INSTANCE.soundSet.add(event);
    }

    public static boolean validateSoundResource(ResourceLocation sound) {
        boolean bl;
        block8: {
            ResourceLocation resourcelocation = new ResourceLocation(sound.func_110624_b(), SoundRegistry.jvmdowngrader$concat$validateSoundResource$1(sound.func_110623_a()));
            IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourcelocation);
            try {
                iresource.func_110527_b();
                bl = true;
                if (iresource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iresource != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return false;
                }
            }
            iresource.close();
        }
        return bl;
    }

    public ResourceLocation parseSound(Map<String, Object> ymlEntry) {
        String eventName = (String)ymlEntry.get("Name");
        ResourceLocation id = new ResourceLocation("mcheli", eventName);
        this.soundSet.add(id);
        if (!MCH_MOD.proxy.isRemote()) {
            return id;
        }
        ClientSoundRegistry.INSTANCE.buildFromYML(id, ymlEntry);
        return id;
    }

    public ResourceLocation parseSound(String loc) {
        ResourceLocation id = new ResourceLocation("mcheli", loc.startsWith("mcheli:") ? loc.split(":")[1] : loc);
        this.soundSet.add(id);
        if (!MCH_MOD.proxy.isRemote()) {
            return id;
        }
        ClientSoundRegistry.INSTANCE.buildFromString(id, loc);
        return id;
    }

    static {
        SoundRegistry.add(SoundRegistry.rl("a-10_snd"));
        SoundRegistry.add(SoundRegistry.rl("a10gau8_snd"));
        SoundRegistry.add(SoundRegistry.rl("alert"));
        SoundRegistry.add(SoundRegistry.rl("boat"));
        SoundRegistry.add(SoundRegistry.rl("bomb_snd"));
        SoundRegistry.add(SoundRegistry.rl("cannon_1_snd"));
        SoundRegistry.add(SoundRegistry.rl("cannon_2_snd"));
        SoundRegistry.add(SoundRegistry.rl("cannon_3_snd"));
        SoundRegistry.add(SoundRegistry.rl("cannon_4_snd"));
        SoundRegistry.add(SoundRegistry.rl("chain"));
        SoundRegistry.add(SoundRegistry.rl("chain_ct"));
        SoundRegistry.add(SoundRegistry.rl("eject_seat"));
        SoundRegistry.add(SoundRegistry.rl("fim92_reload"));
        SoundRegistry.add(SoundRegistry.rl("fim92_snd"));
        SoundRegistry.add(SoundRegistry.rl("gau-8_snd"));
        SoundRegistry.add(SoundRegistry.rl("gltd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h1_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h2_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h3_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h4_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h5_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h6_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_h7_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_l1_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_l2_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_l3_snd"));
        SoundRegistry.add(SoundRegistry.rl("gun_l4_snd"));
        SoundRegistry.add(SoundRegistry.rl("hawk_snd"));
        SoundRegistry.add(SoundRegistry.rl("heli"));
        SoundRegistry.add(SoundRegistry.rl("helidmg"));
        SoundRegistry.add(SoundRegistry.rl("heli_k"));
        SoundRegistry.add(SoundRegistry.rl("hit"));
        SoundRegistry.add(SoundRegistry.rl("locked"));
        SoundRegistry.add(SoundRegistry.rl("lockon"));
        SoundRegistry.add(SoundRegistry.rl("mbtrun"));
        SoundRegistry.add(SoundRegistry.rl("mbt_run"));
        SoundRegistry.add(SoundRegistry.rl("missile_1_snd"));
        SoundRegistry.add(SoundRegistry.rl("missile_2_snd"));
        SoundRegistry.add(SoundRegistry.rl("missile_3_snd"));
        SoundRegistry.add(SoundRegistry.rl("missile_4_snd"));
        SoundRegistry.add(SoundRegistry.rl("mk19_l_snd"));
        SoundRegistry.add(SoundRegistry.rl("mk19_r_snd"));
        SoundRegistry.add(SoundRegistry.rl("mw-1_snd"));
        SoundRegistry.add(SoundRegistry.rl("ng"));
        SoundRegistry.add(SoundRegistry.rl("pi"));
        SoundRegistry.add(SoundRegistry.rl("plane"));
        SoundRegistry.add(SoundRegistry.rl("plane_cc"));
        SoundRegistry.add(SoundRegistry.rl("plane_cv"));
        SoundRegistry.add(SoundRegistry.rl("plastic_bomb_snd"));
        SoundRegistry.add(SoundRegistry.rl("prop"));
        SoundRegistry.add(SoundRegistry.rl("r44_heli"));
        SoundRegistry.add(SoundRegistry.rl("radicon_heli"));
        SoundRegistry.add(SoundRegistry.rl("rocket"));
        SoundRegistry.add(SoundRegistry.rl("rocket_snd"));
        SoundRegistry.add(SoundRegistry.rl("rr_griffon"));
        SoundRegistry.add(SoundRegistry.rl("rr_merlin"));
        SoundRegistry.add(SoundRegistry.rl("sa-2_snd"));
        SoundRegistry.add(SoundRegistry.rl("smoke_snd"));
        SoundRegistry.add(SoundRegistry.rl("tank"));
        SoundRegistry.add(SoundRegistry.rl("tank_gte"));
        SoundRegistry.add(SoundRegistry.rl("turboprop"));
        SoundRegistry.add(SoundRegistry.rl("vehicle_drive"));
        SoundRegistry.add(SoundRegistry.rl("vehicle_run"));
        SoundRegistry.add(SoundRegistry.rl("xm301_snd"));
        SoundRegistry.add(SoundRegistry.rl("zoom"));
        SoundRegistry.add(SoundRegistry.rl("wrench"));
    }

    private static /* synthetic */ String jvmdowngrader$concat$validateSoundResource$1(String string) {
        return "sounds/" + string + ".ogg";
    }

    @NestHost(value=SoundRegistry.class)
    protected static class SoundSpec {
        public String name;
        float volume = 1.0f;
        float pitch = 1.0f;
        int weight = 1;
        boolean streaming = false;

        public SoundSpec(String name) {
            this.name = name;
        }

        public static SoundSpec fromYML(Map<String, Object> map) {
            SoundSpec spec = new SoundSpec();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                switch (entry.getKey()) {
                    case "Name": {
                        spec.name = ((String)entry.getValue()).trim().toLowerCase();
                        break;
                    }
                    case "Vol": 
                    case "Volume": {
                        spec.volume = YamlParser.getClamped(1.0f, 0.0f, entry.getValue());
                        break;
                    }
                    case "Pitch": {
                        spec.pitch = YamlParser.getClamped(1.0f, 0.0f, entry.getValue());
                        break;
                    }
                    case "Weight": {
                        spec.weight = ((Number)entry.getValue()).intValue();
                        break;
                    }
                    case "isStreamed": 
                    case "Stream": {
                        spec.streaming = (Boolean)entry.getValue();
                    }
                }
            }
            return spec;
        }

        @Generated
        public SoundSpec() {
        }
    }
}

