/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.sound;

import com.norwood.mcheli.sound.SoundRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientSoundRegistry {
    public static final ClientSoundRegistry INSTANCE = new ClientSoundRegistry();
    public static final Map<ResourceLocation, SoundList> soundMap = new HashMap<ResourceLocation, SoundList>();

    private ClientSoundRegistry() {
    }

    private static SoundList entry(String ... paths) {
        ArrayList<Sound> entries = new ArrayList<Sound>();
        for (String path : paths) {
            entries.add(new Sound(path, 1.0f, 1.0f, 1, Sound.Type.FILE, false));
        }
        return new SoundList(entries, false, null);
    }

    private static void put(String event, SoundList list) {
        soundMap.put(new ResourceLocation(event), list);
    }

    private static void put(ResourceLocation event, SoundList list) {
        soundMap.put(event, list);
    }

    public void buildFromYML(ResourceLocation id, Map<String, Object> ymlEntry) {
        ArrayList<SoundRegistry.SoundSpec> specs = new ArrayList<SoundRegistry.SoundSpec>();
        Object sounds = ymlEntry.get("Sounds");
        if (sounds instanceof String) {
            String s = (String)sounds;
            specs.add(new SoundRegistry.SoundSpec(s));
        } else if (sounds instanceof List) {
            List list = (List)sounds;
            for (Object o : list) {
                if (o instanceof String) {
                    String s = (String)o;
                    specs.add(new SoundRegistry.SoundSpec(s));
                    continue;
                }
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                specs.add(SoundRegistry.SoundSpec.fromYML(map));
            }
        }
        List entries = specs.stream().map(spec -> new Sound(spec.name, spec.volume, spec.pitch, spec.weight, Sound.Type.FILE, spec.streaming)).collect(Collectors.toList());
        soundMap.put(id, new SoundList(entries, false, null));
    }

    public void buildFromString(ResourceLocation id, String loc) {
        StringBuilder snd = new StringBuilder(id.toString());
        if (!loc.endsWith("_snd") && !SoundRegistry.validateSoundResource(id)) {
            snd.append("_snd");
        }
        soundMap.put(id, ClientSoundRegistry.entry(snd.toString()));
    }

    public void commitChanges(SoundHandler handler) {
        for (Map.Entry<ResourceLocation, SoundList> e : soundMap.entrySet()) {
            handler.func_147693_a(e.getKey(), e.getValue());
        }
    }

    static {
        ClientSoundRegistry.put("mcheli:a-10_snd", ClientSoundRegistry.entry("mcheli:a-10_snd"));
        ClientSoundRegistry.put("mcheli:a10gau8_snd", ClientSoundRegistry.entry("mcheli:a10gau8_snd"));
        ClientSoundRegistry.put("mcheli:alert", ClientSoundRegistry.entry("mcheli:alert"));
        ClientSoundRegistry.put("mcheli:boat", ClientSoundRegistry.entry("mcheli:boat"));
        ClientSoundRegistry.put("mcheli:bomb_snd", ClientSoundRegistry.entry("mcheli:bomb_snd"));
        ClientSoundRegistry.put("mcheli:cannon_1_snd", ClientSoundRegistry.entry("mcheli:cannon_1_snd"));
        ClientSoundRegistry.put("mcheli:cannon_2_snd", ClientSoundRegistry.entry("mcheli:cannon_2_snd"));
        ClientSoundRegistry.put("mcheli:cannon_3_snd", ClientSoundRegistry.entry("mcheli:cannon_3_snd"));
        ClientSoundRegistry.put("mcheli:cannon_4_snd", ClientSoundRegistry.entry("mcheli:cannon_4_snd"));
        ClientSoundRegistry.put("mcheli:chain", ClientSoundRegistry.entry("mcheli:chain"));
        ClientSoundRegistry.put("mcheli:chain_ct", ClientSoundRegistry.entry("mcheli:chain_ct"));
        ClientSoundRegistry.put("mcheli:eject_seat", ClientSoundRegistry.entry("mcheli:eject_seat"));
        ClientSoundRegistry.put("mcheli:fim92_reload", ClientSoundRegistry.entry("mcheli:fim92_reload"));
        ClientSoundRegistry.put("mcheli:fim92_snd", ClientSoundRegistry.entry("mcheli:fim92_snd"));
        ClientSoundRegistry.put("mcheli:gau-8_snd", ClientSoundRegistry.entry("mcheli:gau-8_snd"));
        ClientSoundRegistry.put("mcheli:gltd", ClientSoundRegistry.entry("mcheli:gltd"));
        ClientSoundRegistry.put("mcheli:gun_h1_snd", ClientSoundRegistry.entry("mcheli:gun_h1_snd"));
        ClientSoundRegistry.put("mcheli:gun_h2_snd", ClientSoundRegistry.entry("mcheli:gun_h2_snd"));
        ClientSoundRegistry.put("mcheli:gun_h3_snd", ClientSoundRegistry.entry("mcheli:gun_h3_snd"));
        ClientSoundRegistry.put("mcheli:gun_h4_snd", ClientSoundRegistry.entry("mcheli:gun_h4_snd"));
        ClientSoundRegistry.put("mcheli:gun_h5_snd", ClientSoundRegistry.entry("mcheli:gun_h5_snd"));
        ClientSoundRegistry.put("mcheli:gun_h6_snd", ClientSoundRegistry.entry("mcheli:gun_h6_snd"));
        ClientSoundRegistry.put("mcheli:gun_h7_snd", ClientSoundRegistry.entry("mcheli:gun_h7_snd"));
        ClientSoundRegistry.put("mcheli:gun_l1_snd", ClientSoundRegistry.entry("mcheli:gun_l1_snd"));
        ClientSoundRegistry.put("mcheli:gun_l2_snd", ClientSoundRegistry.entry("mcheli:gun_l2_snd"));
        ClientSoundRegistry.put("mcheli:gun_l3_snd", ClientSoundRegistry.entry("mcheli:gun_l3_snd"));
        ClientSoundRegistry.put("mcheli:gun_l4_snd", ClientSoundRegistry.entry("mcheli:gun_l4_snd"));
        ClientSoundRegistry.put("mcheli:hawk_snd", ClientSoundRegistry.entry("mcheli:hawk_snd"));
        ClientSoundRegistry.put("mcheli:heli", ClientSoundRegistry.entry("mcheli:heli"));
        ClientSoundRegistry.put("mcheli:helidmg", ClientSoundRegistry.entry("mcheli:helidmg"));
        ClientSoundRegistry.put("mcheli:heli_k", ClientSoundRegistry.entry("mcheli:heli_k"));
        ClientSoundRegistry.put("mcheli:hit", ClientSoundRegistry.entry("mcheli:hit"));
        ClientSoundRegistry.put("mcheli:locked", ClientSoundRegistry.entry("mcheli:locked"));
        ClientSoundRegistry.put("mcheli:lockon", ClientSoundRegistry.entry("mcheli:lockon"));
        ClientSoundRegistry.put("mcheli:mbtrun", ClientSoundRegistry.entry("mcheli:mbtrun"));
        ClientSoundRegistry.put("mcheli:mbt_run", ClientSoundRegistry.entry("mcheli:mbt_run"));
        ClientSoundRegistry.put("mcheli:missile_1_snd", ClientSoundRegistry.entry("mcheli:missile_1_snd"));
        ClientSoundRegistry.put("mcheli:missile_2_snd", ClientSoundRegistry.entry("mcheli:missile_2_snd"));
        ClientSoundRegistry.put("mcheli:missile_3_snd", ClientSoundRegistry.entry("mcheli:missile_3_snd"));
        ClientSoundRegistry.put("mcheli:missile_4_snd", ClientSoundRegistry.entry("mcheli:missile_4_snd"));
        ClientSoundRegistry.put("mcheli:mk19_l_snd", ClientSoundRegistry.entry("mcheli:mk19_l_snd"));
        ClientSoundRegistry.put("mcheli:mk19_r_snd", ClientSoundRegistry.entry("mcheli:mk19_r_snd"));
        ClientSoundRegistry.put("mcheli:mw-1_snd", ClientSoundRegistry.entry("mcheli:mw-1_snd"));
        ClientSoundRegistry.put("mcheli:ng", ClientSoundRegistry.entry("mcheli:ng"));
        ClientSoundRegistry.put("mcheli:pi", ClientSoundRegistry.entry("mcheli:pi"));
        ClientSoundRegistry.put("mcheli:plane", ClientSoundRegistry.entry("mcheli:plane"));
        ClientSoundRegistry.put("mcheli:plane_cc", ClientSoundRegistry.entry("mcheli:plane_cc"));
        ClientSoundRegistry.put("mcheli:plane_cv", ClientSoundRegistry.entry("mcheli:plane_cv"));
        ClientSoundRegistry.put("mcheli:plastic_bomb_snd", ClientSoundRegistry.entry("mcheli:plastic_bomb_snd"));
        ClientSoundRegistry.put("mcheli:prop", ClientSoundRegistry.entry("mcheli:prop"));
        ClientSoundRegistry.put("mcheli:r44_heli", ClientSoundRegistry.entry("mcheli:r44_heli"));
        ClientSoundRegistry.put("mcheli:radicon_heli", ClientSoundRegistry.entry("mcheli:radicon_heli"));
        ClientSoundRegistry.put("mcheli:rocket", ClientSoundRegistry.entry("mcheli:rocket"));
        ClientSoundRegistry.put("mcheli:rocket_snd", ClientSoundRegistry.entry("mcheli:rocket_snd"));
        ClientSoundRegistry.put("mcheli:rr_griffon", ClientSoundRegistry.entry("mcheli:rr_griffon"));
        ClientSoundRegistry.put("mcheli:rr_merlin", ClientSoundRegistry.entry("mcheli:rr_merlin"));
        ClientSoundRegistry.put("mcheli:sa-2_snd", ClientSoundRegistry.entry("mcheli:sa-2_snd"));
        ClientSoundRegistry.put("mcheli:smoke_snd", ClientSoundRegistry.entry("mcheli:smoke_snd"));
        ClientSoundRegistry.put("mcheli:tank", ClientSoundRegistry.entry("mcheli:tank"));
        ClientSoundRegistry.put("mcheli:tank_gte", ClientSoundRegistry.entry("mcheli:tank_gte"));
        ClientSoundRegistry.put("mcheli:turboprop", ClientSoundRegistry.entry("mcheli:turboprop"));
        ClientSoundRegistry.put("mcheli:vehicle_drive", ClientSoundRegistry.entry("mcheli:vehicle_drive"));
        ClientSoundRegistry.put("mcheli:vehicle_run", ClientSoundRegistry.entry("mcheli:vehicle_run"));
        ClientSoundRegistry.put("mcheli:xm301_snd", ClientSoundRegistry.entry("mcheli:xm301_snd"));
        ClientSoundRegistry.put("mcheli:zoom", ClientSoundRegistry.entry("mcheli:zoom"));
        ClientSoundRegistry.put("mcheli:wrench", ClientSoundRegistry.entry("mcheli:wrench1", "mcheli:wrench2", "mcheli:wrench3"));
    }
}

