/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.ship;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.helper.addon.AddonResourceLocation;
import com.norwood.mcheli.ship.MCH_ItemShip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Wing.class, Rotor.class, Pylon.class, Blade.class})
public class MCH_ShipInfo
extends MCH_AircraftInfo {
    public MCH_ItemShip item = null;
    public final List<MCH_AircraftInfo.DrawnPart> nozzles = new ArrayList<MCH_AircraftInfo.DrawnPart>();
    public final List<Rotor> rotorList = new ArrayList<Rotor>();
    public final List<Wing> wingList = new ArrayList<Wing>();
    public boolean isEnableVtol = false;
    public boolean isDefaultVtol;
    public float vtolYaw = 0.3f;
    public float vtolPitch = 0.2f;
    public boolean isEnableAutoPilot = false;
    public boolean isVariableSweepWing = false;
    public float sweepWingSpeed = this.speed;

    public MCH_ShipInfo(AddonResourceLocation location, String path) {
        super(location, path);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public float getDefaultRotorSpeed() {
        return 47.94f;
    }

    public boolean haveNozzle() {
        return !this.nozzles.isEmpty();
    }

    public boolean haveRotor() {
        return !this.rotorList.isEmpty();
    }

    public boolean haveWing() {
        return !this.wingList.isEmpty();
    }

    @Override
    public float getMaxSpeed() {
        return 1.8f;
    }

    @Override
    public int getDefaultMaxZoom() {
        return 8;
    }

    @Override
    public String getDefaultHudName(int seatId) {
        if (seatId <= 0) {
            return "plane";
        }
        return seatId == 1 ? "plane" : "gunner";
    }

    @Override
    public boolean validate() throws Exception {
        if (this.haveHatch() && this.haveWing()) {
            this.wingList.clear();
            this.hatchList.clear();
        }
        this.speed = (float)((double)this.speed * MCH_Config.AllShipSpeed.prmDouble);
        this.sweepWingSpeed = (float)((double)this.sweepWingSpeed * MCH_Config.AllShipSpeed.prmDouble);
        return super.validate();
    }

    @Override
    public String getDirectoryName() {
        return "ships";
    }

    @Override
    public String getKindName() {
        return "ship";
    }

    @Override
    public void onPostReload() {
        this.item = (MCH_ItemShip)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mcheli", this.name));
        MCH_MOD.proxy.registerModelsShip(this, true);
    }

    @NestHost(value=MCH_ShipInfo.class)
    public static class Wing
    extends MCH_AircraftInfo.DrawnPart {
        public final float maxRotFactor;
        public final float maxRot;
        public List<Pylon> pylonList;

        public Wing(MCH_ShipInfo paramMCH_ShipInfo, float px, float py, float pz, float rx, float ry, float rz, float mr, String name) {
            super(paramMCH_ShipInfo, px, py, pz, rx, ry, rz, name);
            this.maxRot = mr;
            this.maxRotFactor = this.maxRot / 90.0f;
            this.pylonList = null;
        }

        public Wing(MCH_AircraftInfo.DrawnPart other, float maxRot) {
            super(other);
            this.maxRot = maxRot;
            this.maxRotFactor = this.maxRot / 90.0f;
            this.pylonList = null;
        }
    }

    @NestHost(value=MCH_ShipInfo.class)
    public static class Rotor
    extends MCH_AircraftInfo.DrawnPart {
        public final float maxRotFactor;
        public final List<Blade> blades = new ArrayList<Blade>();

        public Rotor(MCH_ShipInfo paramMCH_ShipInfo, float x, float y, float z, float rx, float ry, float rz, float mrf, String model) {
            super(paramMCH_ShipInfo, x, y, z, rx, ry, rz, model);
            this.maxRotFactor = mrf;
        }

        public Rotor(MCH_AircraftInfo.DrawnPart other, float maxRotFactor) {
            super(other);
            this.maxRotFactor = maxRotFactor;
        }
    }

    @NestHost(value=MCH_ShipInfo.class)
    public static class Pylon
    extends MCH_AircraftInfo.DrawnPart {
        public final float maxRotFactor;
        public final float maxRot;

        public Pylon(MCH_ShipInfo paramMCH_ShipInfo, float px, float py, float pz, float rx, float ry, float rz, float mr, String name) {
            super(paramMCH_ShipInfo, px, py, pz, rx, ry, rz, name);
            this.maxRot = mr;
            this.maxRotFactor = this.maxRot / 90.0f;
        }

        public Pylon(MCH_AircraftInfo.DrawnPart other, float maxRot) {
            super(other);
            this.maxRot = maxRot;
            this.maxRotFactor = this.maxRot / 90.0f;
        }
    }

    @NestHost(value=MCH_ShipInfo.class)
    public static class Blade
    extends MCH_AircraftInfo.DrawnPart {
        public final int numBlade;
        public final int rotBlade;

        public Blade(MCH_ShipInfo paramMCH_ShipInfo, int num, int r, float px, float py, float pz, float rx, float ry, float rz, String name) {
            super(paramMCH_ShipInfo, px, py, pz, rx, ry, rz, name);
            this.numBlade = num;
            this.rotBlade = r;
        }

        public Blade(MCH_AircraftInfo.DrawnPart other, int numBlade, int rotBlade) {
            super(other);
            this.numBlade = numBlade;
            this.rotBlade = rotBlade;
        }
    }
}

