/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.plane;

import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_RenderAircraft;
import com.norwood.mcheli.plane.MCH_EntityPlane;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MCP_RenderPlane
extends MCH_RenderAircraft<MCH_EntityPlane> {
    public static final IRenderFactory<MCH_EntityPlane> FACTORY = MCP_RenderPlane::new;

    public MCP_RenderPlane(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 2.0f;
    }

    @Override
    public void renderAircraft(MCH_EntityAircraft entity, double posX, double posY, double posZ, float yaw, float pitch, float roll, float tickTime) {
        MCH_EntityPlane plane;
        MCH_PlaneInfo planeInfo;
        if (entity instanceof MCH_EntityPlane && (planeInfo = (plane = (MCH_EntityPlane)entity).getPlaneInfo()) != null) {
            this.renderDebugHitBox(plane, posX, posY += (double)0.35f, posZ, yaw, pitch);
            this.renderDebugPilotSeat(plane, posX, posY, posZ, yaw, pitch, roll);
            GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
            this.bindTexture(MCP_RenderPlane.jvmdowngrader$concat$renderAircraft$1(plane.getTextureName()), plane);
            if (planeInfo.haveNozzle() && plane.partNozzle != null) {
                this.renderNozzle(plane, planeInfo, tickTime);
            }
            if (planeInfo.haveWing() && plane.partWing != null) {
                this.renderWing(plane, planeInfo, tickTime);
            }
            if (planeInfo.haveRotor() && plane.partNozzle != null) {
                this.renderRotor(plane, planeInfo, tickTime);
            }
            MCP_RenderPlane.renderBody(planeInfo.model);
        }
    }

    public void renderRotor(MCH_EntityPlane plane, MCH_PlaneInfo planeInfo, float tickTime) {
        float rot = plane.getNozzleRotation();
        float prevRot = plane.getPrevNozzleRotation();
        for (MCH_PlaneInfo.Rotor r : planeInfo.rotorList) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)r.pos.field_72450_a, (double)r.pos.field_72448_b, (double)r.pos.field_72449_c);
            GlStateManager.func_179114_b((float)((prevRot + (rot - prevRot) * tickTime) * r.maxRotFactor), (float)((float)r.rot.field_72450_a), (float)((float)r.rot.field_72448_b), (float)((float)r.rot.field_72449_c));
            GlStateManager.func_179137_b((double)(-r.pos.field_72450_a), (double)(-r.pos.field_72448_b), (double)(-r.pos.field_72449_c));
            MCP_RenderPlane.renderPart(r.model, planeInfo.model, r.modelName);
            for (MCH_PlaneInfo.Blade b : r.blades) {
                float br = plane.prevRotationRotor;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)b.pos.field_72450_a, (double)b.pos.field_72448_b, (double)b.pos.field_72449_c);
                GlStateManager.func_179114_b((float)(br += (plane.rotationRotor - plane.prevRotationRotor) * tickTime), (float)((float)b.rot.field_72450_a), (float)((float)b.rot.field_72448_b), (float)((float)b.rot.field_72449_c));
                GlStateManager.func_179137_b((double)(-b.pos.field_72450_a), (double)(-b.pos.field_72448_b), (double)(-b.pos.field_72449_c));
                for (int i = 0; i < b.numBlade; ++i) {
                    GlStateManager.func_179137_b((double)b.pos.field_72450_a, (double)b.pos.field_72448_b, (double)b.pos.field_72449_c);
                    GlStateManager.func_179114_b((float)b.rotBlade, (float)((float)b.rot.field_72450_a), (float)((float)b.rot.field_72448_b), (float)((float)b.rot.field_72449_c));
                    GlStateManager.func_179137_b((double)(-b.pos.field_72450_a), (double)(-b.pos.field_72448_b), (double)(-b.pos.field_72449_c));
                    MCP_RenderPlane.renderPart(b.model, planeInfo.model, b.modelName);
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    public void renderWing(MCH_EntityPlane plane, MCH_PlaneInfo planeInfo, float tickTime) {
        float rot = plane.getWingRotation();
        float prevRot = plane.getPrevWingRotation();
        for (MCH_PlaneInfo.Wing w : planeInfo.wingList) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)w.pos.field_72450_a, (double)w.pos.field_72448_b, (double)w.pos.field_72449_c);
            GlStateManager.func_179114_b((float)((prevRot + (rot - prevRot) * tickTime) * w.maxRotFactor), (float)((float)w.rot.field_72450_a), (float)((float)w.rot.field_72448_b), (float)((float)w.rot.field_72449_c));
            GlStateManager.func_179137_b((double)(-w.pos.field_72450_a), (double)(-w.pos.field_72448_b), (double)(-w.pos.field_72449_c));
            MCP_RenderPlane.renderPart(w.model, planeInfo.model, w.modelName);
            if (w.pylonList != null) {
                for (MCH_PlaneInfo.Pylon p : w.pylonList) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)p.pos.field_72450_a, (double)p.pos.field_72448_b, (double)p.pos.field_72449_c);
                    GlStateManager.func_179114_b((float)((prevRot + (rot - prevRot) * tickTime) * p.maxRotFactor), (float)((float)p.rot.field_72450_a), (float)((float)p.rot.field_72448_b), (float)((float)p.rot.field_72449_c));
                    GlStateManager.func_179137_b((double)(-p.pos.field_72450_a), (double)(-p.pos.field_72448_b), (double)(-p.pos.field_72449_c));
                    MCP_RenderPlane.renderPart(p.model, planeInfo.model, p.modelName);
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public void renderNozzle(MCH_EntityPlane plane, MCH_PlaneInfo planeInfo, float tickTime) {
        float rot = plane.getNozzleRotation();
        float prevRot = plane.getPrevNozzleRotation();
        for (MCH_AircraftInfo.DrawnPart n : planeInfo.nozzles) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)n.pos.field_72450_a, (double)n.pos.field_72448_b, (double)n.pos.field_72449_c);
            GlStateManager.func_179114_b((float)(prevRot + (rot - prevRot) * tickTime), (float)((float)n.rot.field_72450_a), (float)((float)n.rot.field_72448_b), (float)((float)n.rot.field_72449_c));
            GlStateManager.func_179137_b((double)(-n.pos.field_72450_a), (double)(-n.pos.field_72448_b), (double)(-n.pos.field_72449_c));
            MCP_RenderPlane.renderPart(n.model, planeInfo.model, n.modelName);
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(MCH_EntityPlane entity) {
        return TEX_DEFAULT;
    }

    private static /* synthetic */ String jvmdowngrader$concat$renderAircraft$1(String string) {
        return "textures/planes/" + string + ".png";
    }
}

