/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.plane;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_Key;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.MCH_ViewEntityDummy;
import com.norwood.mcheli.aircraft.MCH_AircraftClientTickHandler;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_EntitySeat;
import com.norwood.mcheli.aircraft.MCH_SeatInfo;
import com.norwood.mcheli.networking.data.DataPlayerControlAircraft;
import com.norwood.mcheli.networking.packet.control.PacketPlayerControlPlane;
import com.norwood.mcheli.plane.MCH_EntityPlane;
import com.norwood.mcheli.uav.MCH_EntityUavStation;
import com.norwood.mcheli.wrapper.W_Reflection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MCP_ClientPlaneTickHandler
extends MCH_AircraftClientTickHandler {
    public MCH_Key KeySwitchMode;
    public MCH_Key KeyEjectSeat;
    public MCH_Key KeyZoom;
    public MCH_Key[] Keys;

    public MCP_ClientPlaneTickHandler(Minecraft minecraft, MCH_Config config) {
        super(minecraft, config);
        this.updateKeybind(config);
    }

    @Override
    public void updateKeybind(MCH_Config config) {
        super.updateKeybind(config);
        this.KeySwitchMode = new MCH_Key(MCH_Config.KeySwitchMode.prmInt);
        this.KeyEjectSeat = new MCH_Key(MCH_Config.KeySwitchHovering.prmInt);
        this.KeyZoom = new MCH_Key(MCH_Config.KeyZoom.prmInt);
        this.Keys = new MCH_Key[]{this.KeyUp, this.KeyDown, this.KeyRight, this.KeyLeft, this.KeySwitchMode, this.KeyEjectSeat, this.KeyUseWeapon, this.KeySwWeaponMode, this.KeySwitchWeapon1, this.KeySwitchWeapon2, this.KeyZoom, this.KeyCameraMode, this.KeyUnmount, this.KeyUnmountForce, this.KeyFlare, this.KeyExtra, this.KeyFreeLook, this.KeyGUI, this.KeyGearUpDown, this.KeyPutToRack, this.KeyDownFromRack};
    }

    protected void update(EntityPlayer player, MCH_EntityPlane plane) {
        MCH_SeatInfo seatInfo;
        if (plane.getIsGunnerMode((Entity)player) && (seatInfo = plane.getSeatInfo((Entity)player)) != null) {
            MCP_ClientPlaneTickHandler.setRotLimitPitch(seatInfo.minPitch, seatInfo.maxPitch, (Entity)player);
        }
        plane.updateRadar(10);
        plane.updateCameraRotate(player.field_70177_z, player.field_70125_A);
    }

    @Override
    protected void onTick(boolean inGUI) {
        for (MCH_Key k : this.Keys) {
            k.update();
        }
        this.isBeforeRiding = this.isRiding;
        EntityPlayerSP player = this.mc.field_71439_g;
        MCH_EntityAircraft plane = null;
        boolean isPilot = true;
        if (player != null) {
            if (player.func_184187_bx() instanceof MCH_EntityPlane) {
                plane = (MCH_EntityPlane)player.func_184187_bx();
            } else {
                Entity entity = player.func_184187_bx();
                if (entity instanceof MCH_EntitySeat) {
                    MCH_EntitySeat seat = (MCH_EntitySeat)entity;
                    if (seat.getParent() instanceof MCH_EntityPlane) {
                        isPilot = false;
                        plane = (MCH_EntityPlane)seat.getParent();
                    }
                } else {
                    MCH_EntityUavStation uavStation;
                    entity = player.func_184187_bx();
                    if (entity instanceof MCH_EntityUavStation && (uavStation = (MCH_EntityUavStation)entity).getControlAircract() instanceof MCH_EntityPlane) {
                        plane = (MCH_EntityPlane)uavStation.getControlAircract();
                    }
                }
            }
        }
        if (plane != null && plane.getAcInfo() != null) {
            this.update((EntityPlayer)player, (MCH_EntityPlane)plane);
            MCH_ViewEntityDummy viewEntityDummy = MCH_ViewEntityDummy.getInstance((World)this.mc.field_71441_e);
            viewEntityDummy.update(((MCH_EntityPlane)plane).camera);
            if (!inGUI) {
                if (!plane.isDestroyed()) {
                    this.playerControl((EntityPlayer)player, (MCH_EntityPlane)plane, isPilot);
                }
            } else {
                this.playerControlInGUI((EntityPlayer)player, (MCH_EntityPlane)plane, isPilot);
            }
            boolean hideHand = true;
            if (!(isPilot && plane.isAlwaysCameraView() || plane.getIsGunnerMode((Entity)player) || plane.getCameraId() > 0)) {
                MCH_Lib.setRenderViewEntity((EntityLivingBase)player);
                if (!isPilot && plane.getCurrentWeaponID((Entity)player) < 0) {
                    hideHand = false;
                }
            } else {
                MCH_Lib.setRenderViewEntity((EntityLivingBase)viewEntityDummy);
            }
            if (hideHand) {
                MCH_Lib.disableFirstPersonItemRender(player.func_184614_ca());
            }
            this.isRiding = true;
        } else {
            this.isRiding = false;
        }
        if (!this.isBeforeRiding && this.isRiding) {
            W_Reflection.setThirdPersonDistance(((MCH_EntityPlane)plane).thirdPersonDist);
            MCH_ViewEntityDummy.getInstance((World)this.mc.field_71441_e).func_70107_b(((MCH_EntityPlane)plane).field_70165_t, ((MCH_EntityPlane)plane).field_70163_u + 0.5, ((MCH_EntityPlane)plane).field_70161_v);
        } else if (this.isBeforeRiding && !this.isRiding) {
            W_Reflection.restoreDefaultThirdPersonDistance();
            MCH_Lib.enableFirstPersonItemRender();
            MCH_Lib.setRenderViewEntity((EntityLivingBase)player);
            W_Reflection.setCameraRoll(0.0f);
        }
    }

    protected void playerControlInGUI(EntityPlayer player, MCH_EntityPlane plane, boolean isPilot) {
        this.commonPlayerControlInGUI(player, plane, isPilot, new PacketPlayerControlPlane(new DataPlayerControlAircraft()));
    }

    protected void playerControl(EntityPlayer player, MCH_EntityPlane plane, boolean isPilot) {
        DataPlayerControlAircraft pc = new DataPlayerControlAircraft();
        boolean send = this.commonPlayerControl(player, plane, isPilot, pc);
        if (isPilot) {
            if (this.KeySwitchMode.isKeyDown()) {
                if (plane.getIsGunnerMode((Entity)player) && plane.canSwitchCameraPos()) {
                    pc.switchMode = DataPlayerControlAircraft.ModeSwitch.GUNNER_OFF;
                    plane.switchGunnerMode(false);
                    plane.setCameraId(1);
                    send = true;
                } else if (plane.getCameraId() > 0) {
                    plane.setCameraId(plane.getCameraId() + 1);
                    if (plane.getCameraId() >= plane.getCameraPosNum()) {
                        plane.setCameraId(0);
                    }
                } else if (plane.canSwitchGunnerMode()) {
                    pc.switchMode = plane.getIsGunnerMode((Entity)player) ? DataPlayerControlAircraft.ModeSwitch.GUNNER_OFF : DataPlayerControlAircraft.ModeSwitch.GUNNER_ON;
                    plane.switchGunnerMode(!plane.getIsGunnerMode((Entity)player));
                    plane.setCameraId(0);
                    send = true;
                } else if (plane.canSwitchCameraPos()) {
                    plane.setCameraId(1);
                } else {
                    MCP_ClientPlaneTickHandler.playSoundNG();
                }
            }
            if (this.KeyExtra.isKeyDown()) {
                if (plane.canSwitchVtol()) {
                    boolean currentMode = plane.getNozzleStat();
                    pc.switchVtol = currentMode ? DataPlayerControlAircraft.VtolSwitch.VTOL_OFF : DataPlayerControlAircraft.VtolSwitch.VTOL_ON;
                    plane.swithVtolMode(!currentMode);
                    send = true;
                } else {
                    MCP_ClientPlaneTickHandler.playSoundNG();
                }
            }
        } else if (this.KeySwitchMode.isKeyDown()) {
            if (plane.canSwitchGunnerModeOtherSeat(player)) {
                plane.switchGunnerModeOtherSeat(player);
                send = true;
            } else {
                MCP_ClientPlaneTickHandler.playSoundNG();
            }
        }
        if (this.KeyZoom.isKeyDown()) {
            boolean isUav;
            boolean bl = isUav = plane.isUAV() && !plane.getAcInfo().haveHatch() && !plane.getPlaneInfo().haveWing();
            if (plane.getIsGunnerMode((Entity)player) || isUav) {
                plane.zoomCamera();
                MCP_ClientPlaneTickHandler.playSound("zoom", 0.5f, 1.0f);
            } else if (isPilot) {
                if (plane.getAcInfo().haveHatch()) {
                    if (plane.canFoldHatch()) {
                        pc.switchHatch = DataPlayerControlAircraft.HatchSwitch.UNFOLD;
                        send = true;
                    } else if (plane.canUnfoldHatch()) {
                        pc.switchHatch = DataPlayerControlAircraft.HatchSwitch.FOLD;
                        send = true;
                    }
                } else if (plane.canFoldWing()) {
                    pc.switchHatch = DataPlayerControlAircraft.HatchSwitch.UNFOLD;
                    send = true;
                } else if (plane.canUnfoldWing()) {
                    pc.switchHatch = DataPlayerControlAircraft.HatchSwitch.FOLD;
                    send = true;
                }
            }
        }
        if (this.KeyEjectSeat.isKeyDown() && plane.canEjectSeat((Entity)player)) {
            pc.setEjectSeat(true);
            send = true;
        }
        if (send) {
            new PacketPlayerControlPlane(pc).sendToServer();
        }
    }
}

