/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.particles;

import com.norwood.mcheli.particles.MCH_EntityBlockDustFX;
import com.norwood.mcheli.particles.MCH_EntityParticleBase;
import com.norwood.mcheli.particles.MCH_EntityParticleExplode;
import com.norwood.mcheli.particles.MCH_EntityParticleMarkPoint;
import com.norwood.mcheli.particles.MCH_EntityParticleSmoke;
import com.norwood.mcheli.particles.MCH_EntityParticleSplash;
import com.norwood.mcheli.particles.MCH_ParticleParam;
import com.norwood.mcheli.wrapper.W_Particle;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.particle.ParticleBubble;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.client.particle.ParticleCrit;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.client.particle.ParticleEnchantmentTable;
import net.minecraft.client.particle.ParticleExplosion;
import net.minecraft.client.particle.ParticleExplosionHuge;
import net.minecraft.client.particle.ParticleExplosionLarge;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleFootStep;
import net.minecraft.client.particle.ParticleHeart;
import net.minecraft.client.particle.ParticleLava;
import net.minecraft.client.particle.ParticleNote;
import net.minecraft.client.particle.ParticlePortal;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.client.particle.ParticleSmokeLarge;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.particle.ParticleSnowShovel;
import net.minecraft.client.particle.ParticleSpell;
import net.minecraft.client.particle.ParticleSplash;
import net.minecraft.client.particle.ParticleSuspend;
import net.minecraft.client.particle.ParticleSuspendedTown;
import net.minecraft.client.particle.ParticleWaterWake;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;

public class MCH_ParticlesUtil {
    public static MCH_EntityParticleMarkPoint markPoint = null;

    public static void spawnParticleMuzzleFlash(World w, double x, double y, double z, float size, float r, float g, float b, float a, int age) {
        MCH_EntityParticleExplode epe = new MCH_EntityParticleExplode(w, x, y, z, size, (double)age, 0.0);
        epe.setParticleMaxAge(age);
        epe.func_70538_b(r, g, b);
        epe.func_82338_g(a);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)epe);
    }

    public static void spawnParticleTileCrack(World w, int blockX, int blockY, int blockZ, double x, double y, double z, double mx, double my, double mz) {
        W_Particle.BlockParticleParam name = W_Particle.getParticleTileCrackName(w, blockX, blockY, blockZ);
        if (!name.isEmpty()) {
            MCH_ParticlesUtil.DEF_spawnParticle(name.name, x, y, z, mx, my, mz, 20.0f, name.stateId);
        }
    }

    public static boolean spawnParticleTileDust(World w, int blockX, int blockY, int blockZ, double x, double y, double z, double mx, double my, double mz, float scale) {
        int[][] offset;
        boolean ret = false;
        for (int[] ints : offset = new int[][]{{0, 0, 0}, {0, 0, -1}, {0, 0, 1}, {1, 0, 0}, {-1, 0, 0}}) {
            Particle e;
            W_Particle.BlockParticleParam name = W_Particle.getParticleTileDustName(w, blockX + ints[0], blockY + ints[1], blockZ + ints[2]);
            if (name.isEmpty() || !((e = MCH_ParticlesUtil.DEF_spawnParticle(name.name, x, y, z, mx, my, mz, 20.0f, name.stateId)) instanceof MCH_EntityBlockDustFX)) continue;
            ((MCH_EntityBlockDustFX)e).setScale(scale * 2.0f);
            ret = true;
            break;
        }
        return ret;
    }

    public static Particle DEF_spawnParticle(String s, double x, double y, double z, double mx, double my, double mz, float dist, int ... params) {
        Particle e = MCH_ParticlesUtil.doSpawnParticle(s, x, y, z, mx, my, mz, params);
        if (e != null) {
            // empty if block
        }
        return e;
    }

    public static Particle doSpawnParticle(String type, double x, double y, double z, double mx, double my, double mz, int ... params) {
        String key;
        double d9;
        double d8;
        double d7;
        double d6;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_175606_aa() == null || mc.field_71452_i == null) {
            return null;
        }
        int i = mc.field_71474_y.field_74362_aa;
        if (i == 1 && mc.field_71441_e.field_73012_v.nextInt(3) == 0) {
            i = 2;
        }
        if ((d6 = mc.func_175606_aa().field_70165_t - x) * d6 + (d7 = mc.func_175606_aa().field_70163_u - y) * d7 + (d8 = mc.func_175606_aa().field_70161_v - z) * d8 > (d9 = 300.0) * d9 || i > 1) {
            return null;
        }
        Particle entityfx = null;
        switch (key = type.toLowerCase(Locale.ROOT)) {
            case "hugeexplosion": {
                entityfx = MCH_ParticlesUtil.create(ParticleExplosionHuge.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "largeexplode": {
                entityfx = MCH_ParticlesUtil.create(ParticleExplosionLarge.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "fireworksspark": {
                entityfx = MCH_ParticlesUtil.create(ParticleFirework.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "bubble": {
                entityfx = MCH_ParticlesUtil.create(ParticleBubble.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "suspended": {
                entityfx = MCH_ParticlesUtil.create(ParticleSuspend.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "depthsuspend": 
            case "townaura": {
                entityfx = MCH_ParticlesUtil.create(ParticleSuspendedTown.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "crit": {
                entityfx = MCH_ParticlesUtil.create(ParticleCrit.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "magiccrit": {
                entityfx = MCH_ParticlesUtil.create(ParticleCrit.MagicFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "smoke": {
                entityfx = MCH_ParticlesUtil.create(ParticleSmokeNormal.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "mobspell": {
                entityfx = MCH_ParticlesUtil.create(ParticleSpell.MobFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "mobspellambient": {
                entityfx = MCH_ParticlesUtil.create(ParticleSpell.AmbientMobFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "spell": {
                entityfx = MCH_ParticlesUtil.create(ParticleSpell.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "instantspell": {
                entityfx = MCH_ParticlesUtil.create(ParticleSpell.InstantFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "witchmagic": {
                entityfx = MCH_ParticlesUtil.create(ParticleSpell.WitchFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "note": {
                entityfx = MCH_ParticlesUtil.create(ParticleNote.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "portal": {
                entityfx = MCH_ParticlesUtil.create(ParticlePortal.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "enchantmenttable": {
                entityfx = MCH_ParticlesUtil.create(ParticleEnchantmentTable.EnchantmentTable::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "explode": {
                entityfx = MCH_ParticlesUtil.create(ParticleExplosion.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "flame": {
                entityfx = MCH_ParticlesUtil.create(ParticleFlame.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "lava": {
                entityfx = MCH_ParticlesUtil.create(ParticleLava.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "footstep": {
                entityfx = MCH_ParticlesUtil.create(ParticleFootStep.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "splash": {
                entityfx = MCH_ParticlesUtil.create(ParticleSplash.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "wake": {
                entityfx = MCH_ParticlesUtil.create(ParticleWaterWake.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "largesmoke": {
                entityfx = MCH_ParticlesUtil.create(ParticleSmokeLarge.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "cloud": {
                entityfx = MCH_ParticlesUtil.create(ParticleCloud.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "reddust": {
                entityfx = MCH_ParticlesUtil.create(ParticleRedstone.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "snowballpoof": {
                entityfx = MCH_ParticlesUtil.create(ParticleBreaking.SnowballFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "dripwater": {
                entityfx = MCH_ParticlesUtil.create(ParticleDrip.WaterFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "driplava": {
                entityfx = MCH_ParticlesUtil.create(ParticleDrip.LavaFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "snowshovel": {
                entityfx = MCH_ParticlesUtil.create(ParticleSnowShovel.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "slime": {
                entityfx = MCH_ParticlesUtil.create(ParticleBreaking.SlimeFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "heart": {
                entityfx = MCH_ParticlesUtil.create(ParticleHeart.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "angryvillager": {
                entityfx = MCH_ParticlesUtil.create(ParticleHeart.AngryVillagerFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            case "happyvillager": {
                entityfx = MCH_ParticlesUtil.create(ParticleSuspendedTown.HappyVillagerFactory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, new int[0]);
                break;
            }
            default: {
                if (key.startsWith("iconcrack")) {
                    entityfx = MCH_ParticlesUtil.create(ParticleBreaking.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, params);
                    break;
                }
                if (key.startsWith("blockcrack")) {
                    entityfx = MCH_ParticlesUtil.create(ParticleDigging.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, params);
                    break;
                }
                if (!key.startsWith("blockdust")) break;
                entityfx = MCH_ParticlesUtil.create(MCH_EntityBlockDustFX.Factory::new, (World)mc.field_71441_e, x, y, z, mx, my, mz, params);
            }
        }
        if (entityfx != null) {
            mc.field_71452_i.func_78873_a(entityfx);
        }
        return entityfx;
    }

    public static void spawnParticle(MCH_ParticleParam p) {
        if (p.world.field_72995_K) {
            MCH_EntityParticleBase entityFX = p.name.equalsIgnoreCase("Splash") ? new MCH_EntityParticleSplash(p.world, p.posX, p.posY, p.posZ, p.motionX, p.motionY, p.motionZ) : new MCH_EntityParticleSmoke(p.world, p.posX, p.posY, p.posZ, p.motionX, p.motionY, p.motionZ);
            entityFX.func_70538_b(p.r, p.g, p.b);
            entityFX.func_82338_g(p.a);
            if (p.age > 0) {
                entityFX.setParticleMaxAge(p.age);
            }
            entityFX.moutionYUpAge = p.motionYUpAge;
            entityFX.gravity = p.gravity;
            entityFX.isEffectedWind = p.isEffectWind;
            entityFX.diffusible = p.diffusible;
            entityFX.toWhite = p.toWhite;
            if (p.diffusible) {
                entityFX.setParticleScale(p.size * 0.2f);
                entityFX.particleMaxScale = p.size * 2.0f;
            } else {
                entityFX.setParticleScale(p.size);
            }
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)entityFX);
        }
    }

    public static void spawnMarkPoint(EntityPlayer player, double x, double y, double z) {
        MCH_ParticlesUtil.clearMarkPoint();
        markPoint = new MCH_EntityParticleMarkPoint(player.field_70170_p, x, y, z, player.func_96124_cp());
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)markPoint);
    }

    public static void clearMarkPoint() {
        if (markPoint != null) {
            markPoint.func_187112_i();
            markPoint = null;
        }
    }

    private static Particle create(Supplier<IParticleFactory> factoryFunc, World world, double x, double y, double z, double mx, double my, double mz, int ... param) {
        return factoryFunc.get().func_178902_a(-1, world, x, y, z, mx, my, mz, param);
    }
}

