/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.parachute;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_ModelManager;
import com.norwood.mcheli.parachute.MCH_EntityParachute;
import com.norwood.mcheli.wrapper.W_Render;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class MCH_RenderParachute
extends W_Render<MCH_EntityParachute> {
    public static final IRenderFactory<MCH_EntityParachute> FACTORY = MCH_RenderParachute::new;
    public static final Random rand = new Random();

    public MCH_RenderParachute(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.5f;
    }

    public void doRender(@NotNull MCH_EntityParachute entity, double posX, double posY, double posZ, float par8, float tickTime) {
        int type = entity.getType();
        if (type > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
            float prevYaw = entity.field_70126_B;
            if (entity.field_70177_z - prevYaw < -180.0f) {
                prevYaw -= 360.0f;
            } else if (prevYaw - entity.field_70177_z < -180.0f) {
                prevYaw += 360.0f;
            }
            float yaw = prevYaw + (entity.field_70177_z - prevYaw) * tickTime;
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179131_c((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (MCH_Config.SmoothShading.prmBool) {
                GlStateManager.func_179103_j((int)7425);
            }
            switch (type) {
                case 1: {
                    this.bindTexture("textures/parachute1.png");
                    MCH_ModelManager.render("parachute1");
                    break;
                }
                case 2: {
                    this.bindTexture("textures/parachute2.png");
                    if (entity.isOpenParachute()) {
                        MCH_ModelManager.renderPart("parachute2", "$parachute");
                        break;
                    }
                    MCH_ModelManager.renderPart("parachute2", "$seat");
                    break;
                }
                case 3: {
                    this.bindTexture("textures/parachute2.png");
                    MCH_ModelManager.renderPart("parachute2", "$parachute");
                }
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(@NotNull MCH_EntityParachute entity) {
        return TEX_DEFAULT;
    }
}

