/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.networking.packet.control;

import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_EntitySeat;
import com.norwood.mcheli.chain.MCH_EntityChain;
import com.norwood.mcheli.container.MCH_EntityContainer;
import com.norwood.mcheli.helicopter.MCH_EntityHeli;
import com.norwood.mcheli.helper.MCH_CriteriaTriggers;
import com.norwood.mcheli.networking.data.DataPlayerControlAircraft;
import com.norwood.mcheli.networking.data.DataPlayerControlVehicle;
import com.norwood.mcheli.networking.packet.control.PacketPlayerControlBase;
import com.norwood.mcheli.uav.MCH_EntityUavStation;
import hohserg.elegant.networking.api.ElegantPacket;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@ElegantPacket
@NestMembers(value={1.class})
public class PacketPlayerControlHeli
extends PacketPlayerControlBase {
    public final DataPlayerControlVehicle controlBaseData;

    @Override
    protected void process(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (aircraft == null) {
            return;
        }
        this.handleUnmount(aircraft, data);
        this.handleEjectSeat(aircraft, data, (Entity)player);
        this.handleFold(aircraft, data);
        this.handleVtolSwitch(aircraft, data);
        this.handleModeSwitch(aircraft, data);
        this.handleSearchLight(aircraft, data);
        this.handleCameraMode(aircraft, data, player);
        this.handleWeaponSwitch(aircraft, data, player);
        this.handleUseWeapon(aircraft, data, player);
        this.handlePilotControls(aircraft, data, player);
        this.handleFlare(aircraft, data);
        this.handleChain(aircraft, data, player);
        this.handleGui(aircraft, data, player);
        this.handleHatch(aircraft, data);
        this.handleFreeLook(aircraft, data);
        this.handleGear(aircraft, data);
        this.handleRack(aircraft, data);
        this.handleGunnerStatus(aircraft, data);
    }

    public void onReceive(EntityPlayerMP player) {
        MCH_EntityHeli heli = null;
        if (player.func_184187_bx() instanceof MCH_EntityHeli) {
            heli = (MCH_EntityHeli)player.func_184187_bx();
        } else if (player.func_184187_bx() instanceof MCH_EntitySeat) {
            if (((MCH_EntitySeat)player.func_184187_bx()).getParent() instanceof MCH_EntityHeli) {
                heli = (MCH_EntityHeli)((MCH_EntitySeat)player.func_184187_bx()).getParent();
            }
        } else {
            MCH_EntityUavStation uavStation;
            Entity entity = player.func_184187_bx();
            if (entity instanceof MCH_EntityUavStation && (uavStation = (MCH_EntityUavStation)entity).getControlAircract() instanceof MCH_EntityHeli) {
                heli = (MCH_EntityHeli)uavStation.getControlAircract();
            }
        }
        this.process(heli, this.controlBaseData, (EntityPlayer)player);
    }

    protected void handleFold(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        DataPlayerControlVehicle heliData = (DataPlayerControlVehicle)data;
        switch (heliData.getBladeStatus()) {
            case UNFOLD: {
                ((MCH_EntityHeli)aircraft).setFoldBladeStat((byte)3);
                break;
            }
            case FOLD: {
                ((MCH_EntityHeli)aircraft).setFoldBladeStat((byte)1);
            }
        }
    }

    @Override
    protected void handleChain(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        Entity e;
        DataPlayerControlVehicle heliData = (DataPlayerControlVehicle)data;
        if (heliData.getUnhitchChainId() >= 0 && (e = player.field_70170_p.func_73045_a(heliData.getUnhitchChainId())) instanceof MCH_EntityChain) {
            if (((MCH_EntityChain)e).towedEntity instanceof MCH_EntityContainer && MCH_Lib.getBlockIdY(aircraft, 3, -20) == 0 && player instanceof EntityPlayerMP) {
                MCH_CriteriaTriggers.RELIEF_SUPPLIES.trigger((EntityPlayerMP)player);
            }
            e.func_70106_y();
        }
    }

    @Generated
    public PacketPlayerControlHeli(DataPlayerControlVehicle controlBaseData) {
        this.controlBaseData = controlBaseData;
    }
}

