/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.networking.packet.control;

import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.networking.data.DataPlayerControlAircraft;
import com.norwood.mcheli.networking.packet.PacketBase;
import com.norwood.mcheli.weapon.MCH_WeaponParam;
import hohserg.elegant.networking.api.ClientToServerPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public abstract class PacketPlayerControlBase
extends PacketBase
implements ClientToServerPacket {
    protected void process(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (aircraft == null) {
            return;
        }
        this.handleUnmount(aircraft, data);
        this.handleEjectSeat(aircraft, data, (Entity)player);
        this.handleVtolSwitch(aircraft, data);
        this.handleModeSwitch(aircraft, data);
        this.handleSearchLight(aircraft, data);
        this.handleCameraMode(aircraft, data, player);
        this.handleWeaponSwitch(aircraft, data, player);
        this.handleUseWeapon(aircraft, data, player);
        this.handlePilotControls(aircraft, data, player);
        this.handleFlare(aircraft, data);
        this.handleChain(aircraft, data, player);
        this.handleGui(aircraft, data, player);
        this.handleHatch(aircraft, data);
        this.handleFreeLook(aircraft, data);
        this.handleGear(aircraft, data);
        this.handleRack(aircraft, data);
        this.handleGunnerStatus(aircraft, data);
    }

    protected void handleChain(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
    }

    protected void handleUnmount(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        switch (data.isUnmount) {
            case UNMOUNT_SELF: {
                aircraft.unmountEntity();
                break;
            }
            case UNMOUNT_CREW: {
                aircraft.unmountCrew();
                break;
            }
            case UNMOUNT_AIRCRAFT: {
                aircraft.unmountAircraft();
            }
        }
    }

    protected void handleEjectSeat(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, Entity entity) {
        if (data.isEjectSeat()) {
            aircraft.ejectSeat(entity);
        }
    }

    protected void handleVtolSwitch(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
    }

    protected void handleModeSwitch(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        switch (data.switchMode) {
            case GUNNER_OFF: {
                aircraft.switchGunnerMode(false);
                break;
            }
            case GUNNER_ON: {
                aircraft.switchGunnerMode(true);
                break;
            }
            case HOVERING_OFF: {
                aircraft.switchHoveringMode(false);
                break;
            }
            case HOVERING_ON: {
                aircraft.switchHoveringMode(true);
            }
        }
    }

    protected void handleSearchLight(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        if (data.isSwitchSearchLight()) {
            aircraft.setSearchLight(!aircraft.isSearchLightON());
        }
    }

    protected void handleCameraMode(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (data.switchCameraMode != DataPlayerControlAircraft.CameraMode.NORMAL) {
            aircraft.switchCameraMode(player, data.getSwitchCameraMode().ordinal());
        }
    }

    protected void handleWeaponSwitch(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (data.switchWeapon >= 0) {
            aircraft.switchWeapon((Entity)player, data.switchWeapon);
        }
    }

    protected void handleUseWeapon(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (!data.getSwitches().isUseWeapon()) {
            return;
        }
        MCH_WeaponParam prm = new MCH_WeaponParam();
        prm.entity = aircraft;
        prm.user = player;
        prm.setPosAndRot(data.useWeaponPosX, data.useWeaponPosY, data.useWeaponPosZ, 0.0f, 0.0f);
        prm.option1 = data.useWeaponOption1;
        prm.option2 = data.useWeaponOption2;
        aircraft.useCurrentWeapon(prm);
    }

    protected void handlePilotControls(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (!aircraft.isPilot((Entity)player)) {
            return;
        }
        aircraft.throttleUp = data.isThrottleUp();
        aircraft.throttleDown = data.isThrottleDown();
        aircraft.moveLeft = data.isMoveLeft();
        aircraft.moveRight = data.isMoveRight();
    }

    protected void handleFlare(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        if (data.useFlareType > 0) {
            aircraft.useFlare(data.useFlareType);
        }
    }

    protected void handleGui(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data, EntityPlayer player) {
        if (data.isOpenGui()) {
            aircraft.openGui(player);
        }
    }

    protected void handleHatch(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        switch (data.switchHatch) {
            case FOLD: 
            case UNFOLD: {
                if (!aircraft.getAcInfo().haveHatch()) break;
                aircraft.foldHatch(data.switchHatch == DataPlayerControlAircraft.HatchSwitch.UNFOLD);
            }
        }
    }

    protected void handleFreeLook(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        if (data.switchFreeLook > 0) {
            aircraft.switchFreeLookMode(data.switchFreeLook == 1);
        }
    }

    protected void handleGear(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        switch (data.switchGear) {
            case FOLD: {
                aircraft.foldLandingGear();
                break;
            }
            case UNFOLD: {
                aircraft.unfoldLandingGear();
            }
        }
    }

    protected void handleRack(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        switch (data.putDownRack) {
            case MOUNT: {
                aircraft.mountEntityToRack();
                break;
            }
            case UNMOUNT: {
                aircraft.unmountEntityFromRack();
                break;
            }
            case RIDE: {
                aircraft.rideRack();
            }
        }
    }

    protected void handleGunnerStatus(MCH_EntityAircraft aircraft, DataPlayerControlAircraft data) {
        if (data.isSwitchGunnerStatus()) {
            aircraft.setGunnerStatus(!aircraft.getGunnerStatus());
        }
    }
}

