/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.networking.packet;

import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.networking.packet.PacketBase;
import com.norwood.mcheli.wrapper.W_Entity;
import hohserg.elegant.networking.api.ElegantPacket;
import hohserg.elegant.networking.api.ServerToClientPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

@ElegantPacket
public class PacketStatusResponse
extends PacketBase
implements ServerToClientPacket {
    public int entityID_AC = -1;
    public byte seatNum = (byte)-1;
    public byte[] weaponIDs = new byte[]{-1};

    public static void sendStatus(MCH_EntityAircraft ac, EntityPlayer player) {
        PacketStatusResponse packet = new PacketStatusResponse();
        packet.setParameter(ac);
        packet.sendToPlayer((EntityPlayerMP)player);
    }

    public void onReceive(Minecraft mc) {
        if (this.entityID_AC <= 0) {
            return;
        }
        Entity entity = mc.field_71439_g.field_70170_p.func_73045_a(this.entityID_AC);
        StringBuilder msg = new StringBuilder("onPacketStatusResponse:EID=").append(this.entityID_AC).append(":");
        if (!(entity instanceof MCH_EntityAircraft)) {
            msg.append("Not an aircraft");
            MCH_Lib.DbgLog(true, msg.toString(), new Object[0]);
            return;
        }
        MCH_EntityAircraft ac = (MCH_EntityAircraft)entity;
        if (this.seatNum <= 0 || this.weaponIDs == null || this.weaponIDs.length != this.seatNum) {
            msg.append("Error seatNum=").append(this.seatNum);
            MCH_Lib.DbgLog(true, msg.toString(), new Object[0]);
            return;
        }
        msg.append("seatNum=").append(this.seatNum).append(":");
        for (int i = 0; i < this.seatNum; ++i) {
            ac.updateWeaponID(i, this.weaponIDs[i]);
            msg.append("[").append(i).append(",").append(this.weaponIDs[i]).append("]");
        }
        MCH_Lib.DbgLog(true, msg.toString(), new Object[0]);
    }

    protected void setParameter(MCH_EntityAircraft ac) {
        if (ac != null) {
            this.entityID_AC = W_Entity.getEntityId(ac);
            this.seatNum = (byte)(ac.getSeatNum() + 1);
            if (this.seatNum > 0) {
                this.weaponIDs = new byte[this.seatNum];
                for (int i = 0; i < this.seatNum; ++i) {
                    this.weaponIDs[i] = (byte)ac.getWeaponIDBySeatID(i);
                }
            } else {
                this.weaponIDs = new byte[]{-1};
            }
        }
    }
}

