/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.networking.packet;

import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.networking.packet.PacketBase;
import com.norwood.mcheli.wrapper.W_Entity;
import hohserg.elegant.networking.api.ElegantPacket;
import hohserg.elegant.networking.api.ServerToClientPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

@ElegantPacket
public class PacketNotifyAmmoNum
extends PacketBase
implements ServerToClientPacket {
    public int entityID_Ac = -1;
    public boolean all = false;
    public byte weaponID = (byte)-1;
    public byte num = 0;
    public short[] ammo = new short[0];
    public short[] restAmmo = new short[0];

    public static void sendAllAmmoNum(MCH_EntityAircraft ac, EntityPlayer target) {
        PacketNotifyAmmoNum packet = new PacketNotifyAmmoNum();
        packet.entityID_Ac = W_Entity.getEntityId(ac);
        packet.all = true;
        packet.num = (byte)ac.getWeaponNum();
        packet.ammo = new short[packet.num];
        packet.restAmmo = new short[packet.num];
        for (int i = 0; i < packet.num; ++i) {
            packet.ammo[i] = (short)ac.getWeapon(i).getAmmoNum();
            packet.restAmmo[i] = (short)ac.getWeapon(i).getRestAllAmmoNum();
        }
        PacketNotifyAmmoNum.send(packet, ac, target);
    }

    public static void sendAmmoNum(MCH_EntityAircraft ac, EntityPlayer target, int wid) {
        PacketNotifyAmmoNum.sendAmmoNum(ac, target, wid, ac.getWeapon(wid).getAmmoNum(), ac.getWeapon(wid).getRestAllAmmoNum());
    }

    public static void sendAmmoNum(MCH_EntityAircraft ac, EntityPlayer target, int wid, int ammo, int rest_ammo) {
        PacketNotifyAmmoNum packet = new PacketNotifyAmmoNum();
        packet.entityID_Ac = W_Entity.getEntityId(ac);
        packet.all = false;
        packet.weaponID = (byte)wid;
        packet.ammo = new short[]{(short)ammo};
        packet.restAmmo = new short[]{(short)rest_ammo};
        PacketNotifyAmmoNum.send(packet, ac, target);
    }

    public static void send(PacketNotifyAmmoNum packet, MCH_EntityAircraft ac, EntityPlayer target) {
        if (target == null) {
            for (int i = 0; i < ac.getSeatNum() + 1; ++i) {
                Entity entity = ac.getEntityBySeatId(i);
                if (!(entity instanceof EntityPlayerMP)) continue;
                packet.sendToPlayer((EntityPlayerMP)entity);
            }
        } else {
            packet.sendToPlayer((EntityPlayerMP)target);
        }
    }

    public void onReceive(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || !player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.entityID_Ac <= 0) {
            return;
        }
        Entity entity = player.field_70170_p.func_73045_a(this.entityID_Ac);
        if (!(entity instanceof MCH_EntityAircraft)) {
            return;
        }
        MCH_EntityAircraft ac = (MCH_EntityAircraft)entity;
        StringBuilder msg = new StringBuilder("onPacketNotifyAmmoNum:");
        msg.append(ac.getAcInfo() != null ? ac.getAcInfo().displayName : "null").append(":");
        if (this.all) {
            msg.append("All=true, Num=").append(this.num);
            for (int i = 0; i < ac.getWeaponNum() && i < this.num; ++i) {
                ac.getWeapon(i).setAmmoNum(this.ammo[i]);
                ac.getWeapon(i).setRestAllAmmoNum(this.restAmmo[i]);
                msg.append(", [").append(this.ammo[i]).append("/").append(this.restAmmo[i]).append("]");
            }
        } else if (this.weaponID < ac.getWeaponNum()) {
            msg.append("All=false, WeaponID=").append(this.weaponID).append(", ").append(this.ammo[0]).append("/").append(this.restAmmo[0]);
            ac.getWeapon(this.weaponID).setAmmoNum(this.ammo[0]);
            ac.getWeapon(this.weaponID).setRestAllAmmoNum(this.restAmmo[0]);
        } else {
            msg.append("Error: WeaponID out of bounds: ").append(this.weaponID);
        }
        MCH_Lib.DbgLog(entity.field_70170_p, msg.toString(), new Object[0]);
    }
}

