/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.networking.packet;

import com.norwood.mcheli.multiplay.MultiplayerHandler;
import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.ElegantPacket;
import net.minecraft.entity.player.EntityPlayerMP;

@ElegantPacket
public class PacketImgDataChunk
implements ClientToServerPacket {
    public static final int PACKET_MAX_SIZE = 128;
    public int imageDataIndex = -1;
    public int imageDataSize = 0;
    public int imageDataTotalSize = 0;
    public byte[] buf;

    public void onReceive(EntityPlayerMP player) {
        try {
            double dataPercent;
            if (this.imageDataIndex < 0 || this.imageDataTotalSize <= 0) {
                return;
            }
            if (this.imageDataIndex == 0) {
                if (MultiplayerHandler.imageData != null && !MultiplayerHandler.lastPlayerName.isEmpty()) {
                    MultiplayerHandler.LogError("[mcheli]Err1: Saving the %s screenshot to server FAILED!!!", MultiplayerHandler.lastPlayerName);
                }
                MultiplayerHandler.imageData = new byte[this.imageDataTotalSize];
                MultiplayerHandler.lastPlayerName = player.func_145748_c_().func_150254_d();
                MultiplayerHandler.lastDataPercent = 0.0;
            }
            if (MultiplayerHandler.imageData == null) {
                MultiplayerHandler.resetState();
                return;
            }
            if (this.imageDataSize > 0) {
                System.arraycopy(this.buf, 0, MultiplayerHandler.imageData, this.imageDataIndex, this.imageDataSize);
            }
            if ((dataPercent = (double)(this.imageDataIndex + this.imageDataSize) / (double)this.imageDataTotalSize * 100.0) - MultiplayerHandler.lastDataPercent >= 10.0 || MultiplayerHandler.lastDataPercent == 0.0) {
                MultiplayerHandler.LogInfo("[mcheli]Saving %s screenshot to server. %.0f%% : %d / %d bytes", player.func_145748_c_(), dataPercent, this.imageDataIndex + this.imageDataSize, this.imageDataTotalSize);
                MultiplayerHandler.lastDataPercent = dataPercent;
            }
            if (this.imageDataIndex + this.imageDataSize >= this.imageDataTotalSize) {
                MultiplayerHandler.saveScreenshot(player.func_145748_c_().toString(), MultiplayerHandler.imageData);
                MultiplayerHandler.resetState();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MultiplayerHandler.resetState();
        }
    }
}

