/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.networking.packet;

import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.info.ContentRegistries;
import com.norwood.mcheli.networking.packet.PacketBase;
import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.ElegantPacket;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@ElegantPacket
@NestMembers(value={ReloadType.class})
public class PacketContentReload
extends PacketBase
implements ClientToServerPacket {
    public final ReloadType type;

    public PacketContentReload(ReloadType type) {
        this.type = type;
    }

    public void onReceive(EntityPlayerMP player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        switch (this.type.ordinal()) {
            case 0: {
                this.reloadRiddenAircraft(player);
                break;
            }
            case 1: {
                this.reloadAllWeapons();
            }
        }
    }

    private void reloadRiddenAircraft(EntityPlayerMP player) {
        MCH_EntityAircraft ridden = MCH_EntityAircraft.getAircraft_RiddenOrControl((Entity)player);
        if (ridden == null || ridden.getAcInfo() == null) {
            return;
        }
        String name = ridden.getAcInfo().name;
        for (WorldServer world : MCH_Utils.getServer().field_71305_c) {
            for (Entity entity : new ArrayList(world.field_72996_f)) {
                MCH_EntityAircraft ac;
                if (!(entity instanceof MCH_EntityAircraft) || (ac = (MCH_EntityAircraft)entity).getAcInfo() == null || !ac.getAcInfo().name.equals(name)) continue;
                ac.changeType(name);
                ac.createSeats(UUID.randomUUID().toString());
                ac.onAcInfoReloaded();
            }
        }
    }

    private void reloadAllWeapons() {
        ContentRegistries.weapon().reloadAll();
        for (WorldServer world : MCH_Utils.getServer().field_71305_c) {
            for (Entity entity : new ArrayList(world.field_72996_f)) {
                MCH_EntityAircraft ac;
                if (!(entity instanceof MCH_EntityAircraft) || (ac = (MCH_EntityAircraft)entity).getAcInfo() == null) continue;
                ac.changeType(ac.getAcInfo().name);
                ac.createSeats(UUID.randomUUID().toString());
            }
        }
    }

    @NestHost(value=PacketContentReload.class)
    public static enum ReloadType {
        VEHICLE,
        WEAPON;

    }
}

