/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.multiplay;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_FileSearch;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.MCH_OStream;
import com.norwood.mcheli.networking.packet.PacketImgDataChunk;
import com.norwood.mcheli.networking.packet.PacketSendModlist;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import mcheli-ce.xyz.wagyourtail.jvmdg.j18.stub.java_base.J_L_System;
import mcheli-ce.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class MCH_MultiplayClient {
    private static IntBuffer pixelBuffer;
    private static int[] pixelValues;
    private static MCH_OStream dataOutputStream;
    private static List<String> modList;
    private static int packetIndex;

    public static void startSendImageData() {
        Minecraft mc = Minecraft.func_71410_x();
        MCH_MultiplayClient.sendScreenShot(mc.field_71443_c, mc.field_71440_d, mc.func_147110_a());
    }

    public static void sendScreenShot(int displayWidth, int displayHeight, Framebuffer framebufferMc) {
        try {
            BufferedImage bufferedimage;
            if (OpenGlHelper.func_148822_b()) {
                displayWidth = framebufferMc.field_147622_a;
                displayHeight = framebufferMc.field_147620_b;
            }
            int k = displayWidth * displayHeight;
            if (pixelBuffer == null || pixelBuffer.capacity() < k) {
                pixelBuffer = BufferUtils.createIntBuffer((int)k);
                pixelValues = new int[k];
            }
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            IntBuffer cfr_ignored_0 = (IntBuffer)J_N_Buffer.clear(pixelBuffer);
            if (OpenGlHelper.func_148822_b()) {
                GL11.glBindTexture((int)3553, (int)framebufferMc.field_147617_g);
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
            } else {
                GL11.glReadPixels((int)0, (int)0, (int)displayWidth, (int)displayHeight, (int)32993, (int)33639, (IntBuffer)pixelBuffer);
            }
            pixelBuffer.get(pixelValues);
            TextureUtil.func_147953_a((int[])pixelValues, (int)displayWidth, (int)displayHeight);
            if (!OpenGlHelper.func_148822_b()) {
                bufferedimage = new BufferedImage(displayWidth, displayHeight, 1);
                bufferedimage.setRGB(0, 0, displayWidth, displayHeight, pixelValues, 0, displayWidth);
            } else {
                int l;
                bufferedimage = new BufferedImage(framebufferMc.field_147621_c, framebufferMc.field_147618_d, 1);
                for (int i1 = l = framebufferMc.field_147620_b - framebufferMc.field_147618_d; i1 < framebufferMc.field_147620_b; ++i1) {
                    for (int j1 = 0; j1 < framebufferMc.field_147621_c; ++j1) {
                        bufferedimage.setRGB(j1, i1 - l, pixelValues[i1 * framebufferMc.field_147622_a + j1]);
                    }
                }
            }
            dataOutputStream = new MCH_OStream();
            ImageIO.write((RenderedImage)bufferedimage, "png", dataOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void readImageData(DataOutputStream dos) {
        dataOutputStream.write(dos);
    }

    public static void sendImageData() {
        if (dataOutputStream != null) {
            byte[] buffer = dataOutputStream.toByteArray();
            int chunkSize = 128;
            int start = packetIndex * chunkSize;
            int totalSize = dataOutputStream.size();
            if (start < totalSize) {
                int length = Math.min(chunkSize, totalSize - start);
                PacketImgDataChunk packet = new PacketImgDataChunk();
                packet.imageDataIndex = start;
                packet.buf = Arrays.copyOfRange(buffer, start, start + length);
                packet.sendToServer();
                ++packetIndex;
            }
            if (packetIndex * chunkSize >= totalSize) {
                dataOutputStream = null;
                packetIndex = 0;
            }
        }
    }

    public static double getPerData() {
        return (double)MCH_MultiplayClient.dataOutputStream.index / (double)dataOutputStream.size();
    }

    public static void readModList(String playerName, String commandSenderName) {
        ZipEntry zipEntry;
        Enumeration<JarEntry> jarEntries;
        JarFile jarFile;
        String jarPath;
        modList = new ArrayList<String>();
        modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$1(String.valueOf(TextFormatting.RED), commandSenderName));
        modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$2(String.valueOf(TextFormatting.RED), playerName));
        String[] classFileNameList = J_L_System.getProperty("java.class.path").split(File.pathSeparator);
        for (String classFileName : classFileNameList) {
            File javaClassFile;
            MCH_Lib.DbgLog(true, MCH_MultiplayClient.jvmdowngrader$concat$readModList$1(classFileName), new Object[0]);
            if (classFileName.length() <= 1 || !(javaClassFile = new File(classFileName)).getAbsolutePath().toLowerCase().contains("versions")) continue;
            modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$1(String.valueOf(TextFormatting.AQUA), javaClassFile.getName(), javaClassFile.length()));
        }
        modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$2(String.valueOf(TextFormatting.YELLOW)));
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$1(String.valueOf(mod), mod.getModId(), mod.getName(), mod.getDisplayVersion(), mod.getSource().getName()));
        }
        if (!CoreModManager.getAccessTransformers().isEmpty()) {
            modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$3(String.valueOf(TextFormatting.YELLOW)));
            modList.addAll(CoreModManager.getAccessTransformers());
        }
        if (!CoreModManager.getIgnoredMods().isEmpty()) {
            modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$4(String.valueOf(TextFormatting.YELLOW)));
            modList.addAll(CoreModManager.getIgnoredMods());
        }
        if (!CoreModManager.getReparseableCoremods().isEmpty()) {
            modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$5(String.valueOf(TextFormatting.YELLOW)));
            modList.addAll(CoreModManager.getReparseableCoremods());
        }
        Minecraft mc = Minecraft.func_71410_x();
        MCH_FileSearch search = new MCH_FileSearch();
        File[] files = search.listFiles(new File(mc.field_71412_D, "mods").getAbsolutePath(), "*.jar");
        modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$6(String.valueOf(TextFormatting.YELLOW)));
        for (File file : files) {
            try {
                jarPath = file.getCanonicalPath();
                jarFile = new JarFile(jarPath);
                jarEntries = jarFile.entries();
                StringBuilder manifest = new StringBuilder();
                while (jarEntries.hasMoreElements()) {
                    zipEntry = jarEntries.nextElement();
                    if (!zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF") || zipEntry.isDirectory()) continue;
                    InputStream is = jarFile.getInputStream(zipEntry);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String line = br.readLine();
                    while (line != null) {
                        if (!(line = line.replace(" ", "").trim()).isEmpty()) {
                            manifest.append(" [").append(line).append("]");
                        }
                        line = br.readLine();
                    }
                    is.close();
                    break;
                }
                jarFile.close();
                if (manifest.length() <= 0) continue;
                modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$3(file.getName(), String.valueOf(manifest)));
            }
            catch (Exception var20) {
                modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$7(file.getName()));
            }
        }
        search = new MCH_FileSearch();
        files = search.listFiles(new File(mc.field_71412_D, "mods").getAbsolutePath(), "*.litemod");
        modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$8(String.valueOf(TextFormatting.LIGHT_PURPLE)));
        for (File file : files) {
            try {
                jarPath = file.getCanonicalPath();
                jarFile = new JarFile(jarPath);
                jarEntries = jarFile.entries();
                StringBuilder litemod_json = new StringBuilder();
                while (jarEntries.hasMoreElements()) {
                    zipEntry = jarEntries.nextElement();
                    String fname = zipEntry.getName().toLowerCase();
                    if (zipEntry.isDirectory()) continue;
                    if (fname.equals("litemod.json")) {
                        InputStream is = jarFile.getInputStream(zipEntry);
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String linex = br.readLine();
                        while (linex != null) {
                            if ((linex = linex.replace(" ", "").trim()).toLowerCase().contains("name")) {
                                litemod_json.append(" [").append(linex).append("]");
                                break;
                            }
                            linex = br.readLine();
                        }
                        is.close();
                        continue;
                    }
                    int index = fname.lastIndexOf("/");
                    if (index >= 0) {
                        fname = fname.substring(index + 1);
                    }
                    if (!fname.contains("litemod") || !fname.endsWith("class")) continue;
                    fname = zipEntry.getName();
                    if (index >= 0) {
                        fname = fname.substring(index + 1);
                    }
                    litemod_json.append(" [").append(fname).append("]");
                }
                jarFile.close();
                if (litemod_json.length() <= 0) continue;
                modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$3(file.getName(), String.valueOf(litemod_json)));
            }
            catch (Exception var19) {
                modList.add(MCH_MultiplayClient.jvmdowngrader$concat$readModList$9(file.getName()));
            }
        }
    }

    public static void sendModsInfo(String playerName, String commandSenderName, int id) {
        if (MCH_Config.DebugLog) {
            modList.clear();
            MCH_MultiplayClient.readModList(playerName, commandSenderName);
        }
        PacketSendModlist.send(modList, id);
    }

    static {
        modList = new ArrayList<String>();
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$1(String string, String string2) {
        return string + "###### Name:" + string2 + " ######";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$2(String string, String string2) {
        return string + "###### ID  :" + string2 + " ######";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$1(String string) {
        return "java.class.path=" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$1(String string, String string2, long l) {
        return string + "# Client class=" + string2 + " : file size= " + l;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$2(String string) {
        return string + "=== ActiveModList ===";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$1(String string, String string2, String string3, String string4, String string5) {
        return string + "  [" + string2 + "]  " + string3 + "[" + string4 + "]  " + string5;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$3(String string) {
        return string + "=== AccessTransformers ===";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$4(String string) {
        return string + "=== LoadedCoremods ===";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$5(String string) {
        return string + "=== ReparseableCoremods ===";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$6(String string) {
        return string + "=== Manifest ===";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$3(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$7(String string) {
        return string + " : Read Manifest failed.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$8(String string) {
        return string + "=== LiteLoader ===";
    }

    private static /* synthetic */ String jvmdowngrader$concat$readModList$9(String string) {
        return string + " : Read LiteLoader failed.";
    }
}

