/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.lweapon;

import com.norwood.mcheli.MCH_ClientTickHandlerBase;
import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_Key;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.gltd.MCH_EntityGLTD;
import com.norwood.mcheli.lweapon.MCH_ItemLightWeaponBase;
import com.norwood.mcheli.networking.packet.control.PacketPlayerLightWeaponControl;
import com.norwood.mcheli.weapon.MCH_WeaponBase;
import com.norwood.mcheli.weapon.MCH_WeaponCreator;
import com.norwood.mcheli.weapon.MCH_WeaponGuidanceSystem;
import com.norwood.mcheli.wrapper.W_Entity;
import com.norwood.mcheli.wrapper.W_EntityPlayer;
import com.norwood.mcheli.wrapper.W_McClient;
import com.norwood.mcheli.wrapper.W_Reflection;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class MCH_ClientLightWeaponTickHandler
extends MCH_ClientTickHandlerBase {
    public static int reloadCount;
    public static int lockonSoundCount;
    public static int weaponMode;
    public static int selectedZoom;
    public static Entity markEntity;
    public static Vec3d markPos;
    public static MCH_WeaponGuidanceSystem gs;
    public static double lockRange;
    protected static MCH_WeaponBase weapon;
    private static final FloatBuffer screenPos;
    private static final FloatBuffer screenPosBB;
    private static final FloatBuffer matModel;
    private static final FloatBuffer matProjection;
    private static final IntBuffer matViewport;
    public MCH_Key KeyAttack;
    public MCH_Key KeyUseWeapon;
    public MCH_Key KeySwWeaponMode;
    public MCH_Key KeyZoom;
    public MCH_Key KeyCameraMode;
    public MCH_Key[] Keys;
    protected boolean isHeldItem = false;
    protected boolean isBeforeHeldItem = false;
    protected EntityPlayer prevThePlayer = null;
    protected ItemStack prevItemStack = ItemStack.field_190927_a;

    public MCH_ClientLightWeaponTickHandler(Minecraft minecraft, MCH_Config config) {
        super(minecraft);
        this.updateKeybind(config);
        MCH_ClientLightWeaponTickHandler.gs.canLockInAir = false;
        MCH_ClientLightWeaponTickHandler.gs.canLockOnGround = false;
        MCH_ClientLightWeaponTickHandler.gs.canLockInWater = false;
        gs.setLockCountMax(40);
        MCH_ClientLightWeaponTickHandler.gs.lockRange = 120.0;
        lockonSoundCount = 0;
        this.initWeaponParam(null);
    }

    public static void markEntity(Entity entity, double x, double y, double z) {
        if (gs.getLockingEntity() == entity) {
            MCH_AircraftInfo i;
            GL11.glGetFloat((int)2982, (FloatBuffer)matModel);
            GL11.glGetFloat((int)2983, (FloatBuffer)matProjection);
            GL11.glGetInteger((int)2978, (IntBuffer)matViewport);
            GLU.gluProject((float)((float)x), (float)((float)y), (float)((float)z), (FloatBuffer)matModel, (FloatBuffer)matProjection, (IntBuffer)matViewport, (FloatBuffer)screenPos);
            MCH_AircraftInfo mCH_AircraftInfo = i = entity instanceof MCH_EntityAircraft ? ((MCH_EntityAircraft)entity).getAcInfo() : null;
            float w = entity.field_70130_N > entity.field_70131_O ? entity.field_70130_N : (i != null ? i.markerWidth : entity.field_70131_O);
            float h = i != null ? i.markerHeight : entity.field_70131_O;
            GLU.gluProject((float)((float)x + w), (float)((float)y + h), (float)((float)z + w), (FloatBuffer)matModel, (FloatBuffer)matProjection, (IntBuffer)matViewport, (FloatBuffer)screenPosBB);
            markEntity = entity;
        }
    }

    @Nullable
    public static Vec3d getMartEntityPos() {
        return gs.getLockingEntity() == markEntity && markEntity != null ? new Vec3d((double)screenPos.get(0), (double)screenPos.get(1), (double)screenPos.get(2)) : null;
    }

    @Nullable
    public static Vec3d getMartEntityBBPos() {
        return gs.getLockingEntity() == markEntity && markEntity != null ? new Vec3d((double)screenPosBB.get(0), (double)screenPosBB.get(1), (double)screenPosBB.get(2)) : null;
    }

    public static int getPotionNightVisionDuration(EntityPlayer player) {
        PotionEffect cpe = player.func_70660_b(MobEffects.field_76439_r);
        return cpe != null ? cpe.func_76459_b() : 0;
    }

    public void initWeaponParam(EntityPlayer player) {
        reloadCount = 0;
        weaponMode = 0;
        selectedZoom = 0;
    }

    @Override
    public void updateKeybind(MCH_Config config) {
        this.KeyAttack = new MCH_Key(MCH_Config.KeyAttack.prmInt);
        this.KeyUseWeapon = new MCH_Key(MCH_Config.KeyUseWeapon.prmInt);
        this.KeySwWeaponMode = new MCH_Key(MCH_Config.KeySwWeaponMode.prmInt);
        this.KeyZoom = new MCH_Key(MCH_Config.KeyZoom.prmInt);
        this.KeyCameraMode = new MCH_Key(MCH_Config.KeyCameraMode.prmInt);
        this.Keys = new MCH_Key[]{this.KeyAttack, this.KeyUseWeapon, this.KeySwWeaponMode, this.KeyZoom, this.KeyCameraMode};
    }

    @Override
    protected void onTick(boolean inGUI) {
        Item item;
        ItemStack is;
        for (MCH_Key k : this.Keys) {
            k.update();
        }
        this.isBeforeHeldItem = this.isHeldItem;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (this.prevThePlayer == null || this.prevThePlayer != player) {
            this.initWeaponParam((EntityPlayer)player);
            this.prevThePlayer = player;
        }
        ItemStack itemStack = is = player != null ? player.func_184614_ca() : ItemStack.field_190927_a;
        if (player == null || player.func_184187_bx() instanceof MCH_EntityGLTD || player.func_184187_bx() instanceof MCH_EntityAircraft) {
            is = ItemStack.field_190927_a;
        }
        if (gs.getLockingEntity() == null) {
            markEntity = null;
        }
        if (!is.func_190926_b() && (item = is.func_77973_b()) instanceof MCH_ItemLightWeaponBase) {
            MCH_ItemLightWeaponBase lweapon = (MCH_ItemLightWeaponBase)item;
            if (this.prevItemStack.func_190926_b() || !this.prevItemStack.func_77969_a(is) && !this.prevItemStack.func_77977_a().equals(is.func_77977_a())) {
                this.initWeaponParam((EntityPlayer)player);
                weapon = MCH_WeaponCreator.createWeapon(player.field_70170_p, MCH_ItemLightWeaponBase.getName(is), Vec3d.field_186680_a, 0.0f, 0.0f, null, false);
                if (weapon != null && weapon.getInfo() != null && weapon.getGuidanceSystem() != null) {
                    gs = weapon.getGuidanceSystem();
                }
            }
            if (weapon == null || gs == null) {
                return;
            }
            gs.setWorld(player.field_70170_p);
            MCH_ClientLightWeaponTickHandler.gs.lockRange = lockRange;
            if (player.func_184612_cw() > 10) {
                W_Reflection.setCameraZoom(MCH_ClientLightWeaponTickHandler.weapon.getInfo().zoom[selectedZoom %= MCH_ClientLightWeaponTickHandler.weapon.getInfo().zoom.length]);
            } else {
                W_Reflection.restoreCameraZoom();
            }
            if (is.func_77960_j() < is.func_77958_k()) {
                if (player.func_184612_cw() > 10) {
                    gs.lock((Entity)player);
                    if (gs.getLockCount() > 0) {
                        if (lockonSoundCount > 0) {
                            --lockonSoundCount;
                        } else {
                            lockonSoundCount = 7;
                            if ((lockonSoundCount = (int)((double)lockonSoundCount * (1.0 - (double)((float)gs.getLockCount() / (float)gs.getLockCountMax())))) < 3) {
                                lockonSoundCount = 2;
                            }
                            W_McClient.playSound("lockon", 1.0f, 1.0f);
                        }
                    }
                } else {
                    W_Reflection.restoreCameraZoom();
                    gs.clearLock();
                }
                reloadCount = 0;
            } else {
                lockonSoundCount = 0;
                if (W_EntityPlayer.hasItem((EntityPlayer)player, lweapon.bullet) && player.func_184605_cv() <= 0) {
                    if (reloadCount == 10) {
                        W_McClient.playSound("fim92_reload", 1.0f, 1.0f);
                    }
                    if (reloadCount < 40 && ++reloadCount == 40) {
                        this.onCompleteReload();
                    }
                } else {
                    reloadCount = 0;
                }
                gs.clearLock();
            }
            if (!inGUI) {
                this.playerControl((EntityPlayer)player, is, (MCH_ItemLightWeaponBase)is.func_77973_b());
            }
            this.isHeldItem = MCH_ItemLightWeaponBase.isHeld((EntityPlayer)player);
        } else {
            lockonSoundCount = 0;
            reloadCount = 0;
            this.isHeldItem = false;
        }
        if (this.isBeforeHeldItem != this.isHeldItem) {
            MCH_Lib.DbgLog(true, "LWeapon cancel", new Object[0]);
            if (!this.isHeldItem) {
                if (MCH_ClientLightWeaponTickHandler.getPotionNightVisionDuration((EntityPlayer)player) < 250) {
                    PacketPlayerLightWeaponControl packet = new PacketPlayerLightWeaponControl();
                    packet.camMode = 1;
                    packet.sendToServer();
                    player.func_184589_d(MobEffects.field_76439_r);
                }
                W_Reflection.restoreCameraZoom();
            }
        }
        this.prevItemStack = is;
        gs.update();
    }

    protected void onCompleteReload() {
        PacketPlayerLightWeaponControl packet = new PacketPlayerLightWeaponControl();
        packet.cmpReload = 1;
        packet.sendToServer();
    }

    protected void playerControl(EntityPlayer player, ItemStack is, MCH_ItemLightWeaponBase item) {
        int prevZoom;
        boolean autoShot;
        PacketPlayerLightWeaponControl packet = new PacketPlayerLightWeaponControl();
        boolean send = false;
        boolean bl = autoShot = MCH_Config.LWeaponAutoFire.prmBool && is.func_77960_j() < is.func_77958_k() && gs.isLockComplete();
        if (this.KeySwWeaponMode.isKeyDown() && MCH_ClientLightWeaponTickHandler.weapon.numMode > 1) {
            weaponMode = (weaponMode + 1) % MCH_ClientLightWeaponTickHandler.weapon.numMode;
            W_McClient.playSound("pi", 0.5f, 0.9f);
        }
        if (this.KeyAttack.isKeyPress() || autoShot) {
            boolean result = false;
            if (is.func_77960_j() < is.func_77958_k() && gs.isLockComplete()) {
                boolean canFire = true;
                if (weaponMode > 0 && gs.getTargetEntity() != null) {
                    double dx = MCH_ClientLightWeaponTickHandler.gs.getTargetEntity().field_70165_t - player.field_70165_t;
                    double dz = MCH_ClientLightWeaponTickHandler.gs.getTargetEntity().field_70161_v - player.field_70161_v;
                    boolean bl2 = canFire = Math.sqrt(dx * dx + dz * dz) >= 40.0;
                }
                if (canFire) {
                    packet.useWeapon = true;
                    packet.useWeaponOption1 = W_Entity.getEntityId(MCH_ClientLightWeaponTickHandler.gs.lastLockEntity);
                    packet.useWeaponOption2 = weaponMode;
                    packet.useWeaponPosX = player.field_70165_t;
                    packet.useWeaponPosY = player.field_70163_u + (double)player.func_70047_e();
                    packet.useWeaponPosZ = player.field_70161_v;
                    gs.clearLock();
                    send = true;
                    result = true;
                }
            }
            if (this.KeyAttack.isKeyDown() && !result && player.func_184612_cw() > 5) {
                MCH_ClientLightWeaponTickHandler.playSoundNG();
            }
        }
        if (this.KeyZoom.isKeyDown() && (prevZoom = selectedZoom) != (selectedZoom = (selectedZoom + 1) % MCH_ClientLightWeaponTickHandler.weapon.getInfo().zoom.length)) {
            MCH_ClientLightWeaponTickHandler.playSound("zoom", 0.5f, 1.0f);
        }
        if (this.KeyCameraMode.isKeyDown()) {
            PotionEffect pe = player.func_70660_b(MobEffects.field_76439_r);
            MCH_Lib.DbgLog(true, "LWeapon NV %s", pe != null ? "ON->OFF" : "OFF->ON");
            if (pe != null) {
                player.func_184589_d(MobEffects.field_76439_r);
                packet.camMode = 1;
                send = true;
                W_McClient.playSound("pi", 0.5f, 0.9f);
            } else if (player.func_184612_cw() > 60) {
                packet.camMode = 2;
                send = true;
                W_McClient.playSound("pi", 0.5f, 0.9f);
            } else {
                MCH_ClientLightWeaponTickHandler.playSoundNG();
            }
        }
        if (send) {
            packet.sendToServer();
        }
    }

    static {
        markEntity = null;
        markPos = Vec3d.field_186680_a;
        gs = new MCH_WeaponGuidanceSystem();
        lockRange = 120.0;
        screenPos = BufferUtils.createFloatBuffer((int)3);
        screenPosBB = BufferUtils.createFloatBuffer((int)3);
        matModel = BufferUtils.createFloatBuffer((int)16);
        matProjection = BufferUtils.createFloatBuffer((int)16);
        matViewport = BufferUtils.createIntBuffer((int)16);
    }
}

