/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud.direct_drawable;

import com.norwood.mcheli.EntityInfo;
import com.norwood.mcheli.MCH_EntityInfoClientTracker;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.helicopter.MCH_EntityHeli;
import com.norwood.mcheli.hud.direct_drawable.DirectDrawable;
import com.norwood.mcheli.plane.MCH_EntityPlane;
import com.norwood.mcheli.tank.MCH_EntityTank;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class, RWRResult.class})
public class HudRWR
implements DirectDrawable {
    public static HudRWR INSTANCE = new HudRWR();
    public static final ResourceLocation RWR = new ResourceLocation("mcheli", "textures/rwr.png");
    public static final ResourceLocation RWR_HELI = new ResourceLocation("mcheli", "textures/rwr_heli.png");
    public static final ResourceLocation RWR_TANK = new ResourceLocation("mcheli", "textures/rwr_tank.png");
    public static final ResourceLocation RWR_FAC = new ResourceLocation("mcheli", "textures/rwr_fac.png");
    private static final int _RWR_SIZE = 180;
    private static final int _RWR_CENTER_X = 100;
    private static final int _RWR_CENTER_Y = 280;
    private static final double SCREEN_HEIGHT_ADAPT_CONSTANT = 520.0;
    private static final double _MIN_DISTANCE = 50.0;
    private static final double _MAX_DISTANCE = 1000.0;
    private static final int _MIN_RADIUS = 30;

    @Override
    public void renderHud(RenderGameOverlayEvent.Post event, Tuple<EntityPlayer, MCH_EntityAircraft> ctx) {
        ResourceLocation rwr;
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        MCH_EntityAircraft ac = (MCH_EntityAircraft)ctx.func_76340_b();
        EntityPlayer player = (EntityPlayer)ctx.func_76341_a();
        ScaledResolution sc = new ScaledResolution(mc);
        int RWR_SIZE = 180;
        int RWR_CENTER_X = 100;
        int RWR_CENTER_Y = 280;
        double MIN_DISTANCE = 50.0;
        double MAX_DISTANCE = 1000.0;
        int MIN_RADIUS = 30;
        GlStateManager.func_179094_E();
        if (ac instanceof MCH_EntityPlane) {
            rwr = RWR;
            if (ac.getAcInfo().isFloat) {
                rwr = RWR_FAC;
                RWR_SIZE = 160;
                RWR_CENTER_X = 220;
                RWR_CENTER_Y = 370;
                MIN_DISTANCE = 15.0;
                MAX_DISTANCE = 800.0;
                MIN_RADIUS = 30;
            }
        } else if (ac instanceof MCH_EntityHeli) {
            rwr = RWR_HELI;
        } else if (ac instanceof MCH_EntityTank) {
            rwr = RWR_TANK;
            RWR_SIZE = 160;
            RWR_CENTER_X = 220;
            RWR_CENTER_Y = 370;
            MIN_DISTANCE = 15.0;
            MAX_DISTANCE = 800.0;
            MIN_RADIUS = 30;
        } else {
            rwr = RWR;
        }
        double sx = (double)sc.func_78328_b() * ((double)RWR_CENTER_X / 520.0);
        double sy = (double)sc.func_78328_b() * ((double)RWR_CENTER_Y / 520.0);
        this.drawRWRCircle(sx, sy, sc, rwr, RWR_SIZE);
        double circleRadius = (double)sc.func_78328_b() * ((double)RWR_SIZE / 520.0) / 2.0;
        for (EntityInfo entity : this.getServerLoadedEntity()) {
            if (!this.isValidEntity(entity, player, MIN_DISTANCE)) continue;
            double xPos = this.interpolate(entity.x, entity.prevX, event.getPartialTicks());
            double yPos = this.interpolate(entity.y, entity.prevY, event.getPartialTicks());
            double zPos = this.interpolate(entity.z, entity.prevZ, event.getPartialTicks());
            Vec3d playerInterp = new Vec3d(player.field_70165_t + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks(), player.field_70163_u + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks(), player.field_70161_v + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks());
            Vec3d delta = new Vec3d(xPos, yPos, zPos).func_178788_d(playerInterp);
            Vec3d lookVec = this.getDirection(ac, event.getPartialTicks());
            Vec3d deltaHorizontal = new Vec3d(delta.field_72450_a, 0.0, delta.field_72449_c).func_72432_b();
            Vec3d lookHorizontal = new Vec3d(lookVec.field_72450_a, 0.0, lookVec.field_72449_c).func_72432_b();
            double dot = lookHorizontal.func_72430_b(deltaHorizontal);
            double angle = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dot))));
            if (lookHorizontal.func_72431_c((Vec3d)deltaHorizontal).field_72448_b < 0.0) {
                angle = -angle;
            }
            double distance = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72448_b * delta.field_72448_b + delta.field_72449_c * delta.field_72449_c);
            double radiusRatio = Math.min(Math.max((distance - MIN_DISTANCE) / (MAX_DISTANCE - MIN_DISTANCE), 0.0), 1.0);
            double renderRadius = (double)MIN_RADIUS + (circleRadius - (double)MIN_RADIUS) * radiusRatio;
            double radian = Math.toRadians(angle);
            double markerX = sx + renderRadius * Math.sin(-radian);
            double markerY = sy - renderRadius * Math.cos(radian);
            RWRResult rwrResult = this.getTargetTypeOnRadar(entity, ac);
            String text = rwrResult.name;
            int color = rwrResult.color;
            int textWidth = mc.field_71466_p.func_78256_a(text);
            mc.field_71466_p.func_175065_a(text, (float)((int)(markerX - (double)textWidth / 2.0)), (float)((int)(markerY - 4.0)), color, true);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public DirectDrawable getInstance() {
        return INSTANCE;
    }

    public Vec3d getDirection(Entity e, float factor) {
        if (factor == 1.0f) {
            float f1 = MathHelper.func_76134_b((float)(-e.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-e.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-e.field_70125_A * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-e.field_70125_A * ((float)Math.PI / 180)));
            return new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        }
        float f1 = e.field_70127_C + (e.field_70125_A - e.field_70127_C) * factor;
        float f2 = e.field_70126_B + (e.field_70177_z - e.field_70126_B) * factor;
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        return new Vec3d((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }

    private boolean isValidEntity(EntityInfo entity, EntityPlayer player, double minDist) {
        if (entity.entityClassName.contains("MCH_EntityChaff") || entity.entityClassName.contains("MCH_EntityFlare") || entity.entityClassName.contains("EntityPlayer") || entity.entityClassName.contains("EntitySoldier")) {
            return false;
        }
        return !(entity.getDistanceSqToEntity((Entity)player) < minDist * minDist);
    }

    private RWRResult getTargetTypeOnRadar(EntityInfo entity, MCH_EntityAircraft ac) {
        int color = 65280;
        if (ac instanceof MCH_EntityTank || ac instanceof MCH_EntityPlane && ac.getAcInfo().isFloat) {
            color = 0xFFCC00;
        }
        switch (ac.getAcInfo().rwrType) {
            case DIGITAL: {
                if (entity.entityClassName.contains("MCH_EntityHeli") || entity.entityClassName.contains("MCP_EntityPlane") || entity.entityClassName.contains("MCH_EntityTank") || entity.entityClassName.contains("MCH_EntityVehicle")) {
                    return new RWRResult(ac.getNameOnMyRadar(entity), color);
                }
                return new RWRResult("MSL", 0xFF0000);
            }
        }
        return new RWRResult("?", 65280);
    }

    private void drawRWRCircle(double x, double y, ScaledResolution sc, ResourceLocation rwr, int size) {
        this.prepareRenderState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rwr);
        double halfSize = (double)sc.func_78328_b() * ((double)size / 520.0) / 2.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x - halfSize, y + halfSize, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + halfSize, y + halfSize, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + halfSize, y - halfSize, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x - halfSize, y - halfSize, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        this.restoreRenderState();
    }

    private void prepareRenderState() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private void restoreRenderState() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private double interpolate(double now, double old, float partialTicks) {
        return old + (now - old) * (double)partialTicks;
    }

    public List<EntityInfo> getServerLoadedEntity() {
        return new ArrayList<EntityInfo>(MCH_EntityInfoClientTracker.getAllTrackedEntities());
    }

    @NestHost(value=HudRWR.class)
    public static class RWRResult {
        public final String name;
        public final int color;

        @Generated
        public RWRResult(String name, int color) {
            this.name = name;
            this.color = color;
        }
    }
}

