/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud.direct_drawable;

import com.norwood.mcheli.EntityInfo;
import com.norwood.mcheli.MCH_EntityInfoClientTracker;
import com.norwood.mcheli.RWRType;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.hud.direct_drawable.DirectDrawable;
import com.norwood.mcheli.hud.direct_drawable.HudRWR;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import com.norwood.mcheli.weapon.MCH_WeaponSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HudMortarRadar
implements DirectDrawable {
    public static final HudMortarRadar INSTANCE = new HudMortarRadar();
    public static final ResourceLocation RADAR = new ResourceLocation("mcheli", "textures/mortar_radar.png");
    public static final ResourceLocation CROSS = new ResourceLocation("mcheli", "textures/mortar_cross.png");
    public static final ResourceLocation TARGET = new ResourceLocation("mcheli", "textures/mortar_target.png");
    private static final int RWR_SIZE = 250;
    private static final int RWR_CENTER_X = 150;
    private static final int RWR_CENTER_Y = 280;
    private static final double SCREEN_HEIGHT_ADAPT_CONSTANT = 520.0;
    private static final double MIN_DISTANCE = 20.0;
    private static final double MAX_DISTANCE = 300.0;
    private static final int MIN_RADIUS = 0;
    private static final int RWR_CROSS_SIZE = 21;

    @Override
    public void renderHud(RenderGameOverlayEvent.Post event, Tuple<EntityPlayer, MCH_EntityAircraft> ctx) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ctx.func_76341_a();
        MCH_EntityAircraft ac = (MCH_EntityAircraft)ctx.func_76340_b();
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sc = new ScaledResolution(mc);
        double maxDist = 300.0;
        double currentDist = -1.0;
        MCH_WeaponSet ws = ac.getCurrentWeapon((Entity)player);
        if (ws != null) {
            MCH_WeaponInfo wi = ws.getInfo();
            if (wi == null || !wi.hasMortarRadar) {
                return;
            }
            if (wi.mortarRadarMaxDist > 0.0) {
                maxDist = wi.mortarRadarMaxDist;
            }
            if (wi.displayMortarDistance) {
                currentDist = ac.getLandInDistance((Entity)player);
            }
        }
        GlStateManager.func_179094_E();
        double sx = sc.func_78324_d() * 0.28846153846153844;
        double sy = sc.func_78324_d() * 0.5384615384615384;
        this.drawRWRCircle(sx, sy, sc, RADAR);
        double circleRadius = sc.func_78324_d() * 0.4807692307692308 / 2.0;
        for (EntityInfo entity : this.getServerLoadedEntity()) {
            if (!this.isValidEntity(entity, player)) continue;
            double xPos = this.interpolate(entity.x, entity.prevX, event.getPartialTicks());
            double yPos = this.interpolate(entity.y, entity.prevY, event.getPartialTicks());
            double zPos = this.interpolate(entity.z, entity.prevZ, event.getPartialTicks());
            double px = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
            double py = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
            double pz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
            Vec3d delta = new Vec3d(xPos - px, yPos - py, zPos - pz);
            Vec3d lookVec = this.getDirection((Entity)player, event.getPartialTicks());
            Vec3d deltaH = new Vec3d(delta.field_72450_a, 0.0, delta.field_72449_c).func_72432_b();
            Vec3d lookH = new Vec3d(lookVec.field_72450_a, 0.0, lookVec.field_72449_c).func_72432_b();
            double dot = lookH.func_72430_b(deltaH);
            double angle = Math.toDegrees(Math.acos(MathHelper.func_151237_a((double)dot, (double)-1.0, (double)1.0)));
            if (lookH.func_72431_c((Vec3d)deltaH).field_72448_b < 0.0) {
                angle = -angle;
            }
            double distance = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c);
            double ratio = MathHelper.func_151237_a((double)((distance - 20.0) / (maxDist - 20.0)), (double)0.0, (double)1.0);
            double renderRadius = 0.0 + (circleRadius - 0.0) * ratio;
            double rad = Math.toRadians(angle);
            double markerX = sx + renderRadius * Math.sin(-rad);
            double markerY = sy - renderRadius * Math.cos(rad);
            this.drawMortarTarget(markerX, markerY, sc);
            HudRWR.RWRResult rwrResult = this.getTargetTypeOnRadar(entity, ac);
            String text = HudMortarRadar.jvmdowngrader$concat$renderHud$1(rwrResult.name, (int)distance);
            int color = rwrResult.color;
            int fw = mc.field_71466_p.func_78256_a(text);
            mc.field_71466_p.func_175065_a(text, (float)((int)(markerX - (double)fw / 2.0)), (float)((int)markerY), color, true);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (currentDist >= 20.0) {
            double ratio = MathHelper.func_151237_a((double)((currentDist - 20.0) / (maxDist - 20.0)), (double)0.0, (double)1.0);
            double circleR = sc.func_78324_d() * 0.4807692307692308 / 2.0;
            double renderR = 0.0 + (circleR - 0.0) * ratio;
            double markerX = sx;
            double markerY = sy - renderR;
            this.drawMortarCross(markerX, markerY, sc);
        }
        GlStateManager.func_179121_F();
    }

    private Vec3d getDirection(Entity e, float partialTicks) {
        float pitch = e.field_70127_C + (e.field_70125_A - e.field_70127_C) * partialTicks;
        float yaw = e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partialTicks;
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }

    private boolean isValidEntity(EntityInfo entity, EntityPlayer player) {
        if (entity.entityClassName.contains("MCH_EntityChaff") || entity.entityClassName.contains("MCH_EntityFlare")) {
            return false;
        }
        return entity.getDistanceSqToEntity((Entity)player) >= 400.0;
    }

    private HudRWR.RWRResult getTargetTypeOnRadar(EntityInfo entity, MCH_EntityAircraft ac) {
        if (ac.getAcInfo().rwrType == RWRType.DIGITAL) {
            if (entity.entityClassName.contains("MCH_EntityHeli") || entity.entityClassName.contains("MCP_EntityPlane") || entity.entityClassName.contains("MCH_EntityTank") || entity.entityClassName.contains("MCH_EntityVehicle")) {
                return new HudRWR.RWRResult(ac.getNameOnMyRadar(entity), 0xFFFFFF);
            }
            return new HudRWR.RWRResult("?", 0xFFFFFF);
        }
        return new HudRWR.RWRResult("?", 0xFFFFFF);
    }

    private void drawRWRCircle(double x, double y, ScaledResolution sc, ResourceLocation rwr) {
        this.prepareRenderState();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rwr);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        double half = sc.func_78324_d() * 0.4807692307692308 / 2.0;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(x - half, y + half, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y + half, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y - half, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(x - half, y - half, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        this.restoreRenderState();
    }

    private void drawMortarCross(double x, double y, ScaledResolution sc) {
        this.prepareRenderState();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CROSS);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        double half = sc.func_78324_d() * 0.04038461538461539 / 2.0;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(x - half, y + half, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y + half, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y - half, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(x - half, y - half, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        this.restoreRenderState();
    }

    private void drawMortarTarget(double x, double y, ScaledResolution sc) {
        this.prepareRenderState();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TARGET);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        double half = sc.func_78324_d() * 0.0038461538461538464 / 2.0;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(x - half, y + half, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y + half, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y - half, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(x - half, y - half, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        this.restoreRenderState();
    }

    private void prepareRenderState() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void restoreRenderState() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private double interpolate(double now, double old, float partialTicks) {
        return old + (now - old) * (double)partialTicks;
    }

    public List<EntityInfo> getServerLoadedEntity() {
        return new ArrayList<EntityInfo>(MCH_EntityInfoClientTracker.getAllTrackedEntities());
    }

    @Override
    public DirectDrawable getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ String jvmdowngrader$concat$renderHud$1(String string, int n) {
        return string + "[" + n + "]";
    }
}

