/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud.direct_drawable;

import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.hud.direct_drawable.DirectDrawable;
import com.norwood.mcheli.weapon.GPSPosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HudGPS
implements DirectDrawable {
    public static final ResourceLocation GPS_POS = new ResourceLocation("mcheli", "textures/gps_position.png");
    private static final int ICON_SIZE_PX = 24;
    public static HudGPS INSTANCE = new HudGPS();

    @Override
    public void renderHud(RenderGameOverlayEvent.Post event, Tuple<EntityPlayer, MCH_EntityAircraft> ctx) {
        float alpha;
        double pz;
        double py;
        GPSPosition gps = GPSPosition.currentClientGPSPosition;
        if (gps == null || !gps.isActive()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ctx.func_76341_a();
        double gx = gps.x;
        double gy = gps.y;
        double gz = gps.z;
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager rm = mc.func_175598_ae();
        double camX = rm.field_78730_l;
        double camY = rm.field_78731_m;
        double camZ = rm.field_78728_n;
        double x = gx - camX;
        double y = gy - camY;
        double z = gz - camZ;
        double px = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        Vec3d toTarget = new Vec3d(gx - px, gy - (py = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks() + (double)player.func_70047_e()), gz - (pz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks()));
        double vlen = toTarget.func_72433_c();
        if (vlen < 1.0E-4) {
            return;
        }
        Vec3d dir = toTarget.func_72432_b();
        Vec3d look = player.func_70676_i(event.getPartialTicks());
        double dot = Math.max(-1.0, Math.min(1.0, dir.field_72450_a * look.field_72450_a + dir.field_72448_b * look.field_72448_b + dir.field_72449_c * look.field_72449_c));
        double angleDeg = Math.toDegrees(Math.acos(dot));
        boolean inLock = false;
        if (angleDeg <= 1.5) {
            alpha = 1.0f;
            inLock = true;
        } else {
            alpha = angleDeg <= 3.0 ? 1.0f : (angleDeg <= 6.0 ? 0.8f : (angleDeg <= 9.0 ? 0.6f : 0.4f));
        }
        ScaledResolution sc = new ScaledResolution(mc);
        double dist = toTarget.func_72433_c();
        double fovDeg = mc.field_71474_y.field_74334_X;
        double fovRad = Math.toRadians(fovDeg);
        float sPerPixel = (float)(2.0 * dist * Math.tan(fovRad * 0.5) / sc.func_78324_d());
        float rollDeg = this.getViewRollDeg(mc, (MCH_EntityAircraft)ctx.func_76340_b(), event.getPartialTicks());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + 0.2), (double)z);
        GlStateManager.func_179114_b((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-rollDeg), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)(-sPerPixel), (float)(-sPerPixel), (float)sPerPixel);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (inLock) {
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)alpha);
        }
        mc.func_110434_K().func_110577_a(GPS_POS);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float half = 12.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(-half), (double)half, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)half, (double)half, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)half, (double)(-half), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(-half), (double)(-half), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        String text = String.format("[GPS %.1fm]", player.func_70011_f((double)((float)gx), (double)((float)gy), (double)((float)gz)));
        int color = inLock ? 0xFF0000 : 65280;
        GlStateManager.func_179109_b((float)0.0f, (float)20.0f, (float)0.0f);
        int fw = mc.field_71466_p.func_78256_a(text);
        mc.field_71466_p.func_175065_a(text, (float)(-fw) / 2.0f, 0.0f, color, false);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private float getViewRollDeg(Minecraft mc, MCH_EntityAircraft ac, float partialTicks) {
        return -ac.rotationRoll;
    }

    @Override
    public DirectDrawable getInstance() {
        return INSTANCE;
    }
}

