/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud.direct_drawable;

import com.norwood.mcheli.EntityInfo;
import com.norwood.mcheli.MCH_EntityInfoClientTracker;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.hud.direct_drawable.DirectDrawable;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HudBVRLock
implements DirectDrawable {
    public static final Map<Integer, EntityInfo> currentLockedEntities = new HashMap<Integer, EntityInfo>();
    public static final ResourceLocation FRAME = new ResourceLocation("mcheli", "textures/bvr_lock_box.png");
    public static final ResourceLocation MSL = new ResourceLocation("mcheli", "textures/msl.png");
    private static final int BOX_SIZE = 24;
    public static final HudBVRLock INSTANCE = new HudBVRLock();

    @Override
    public void renderHud(RenderGameOverlayEvent.Post event, Tuple<EntityPlayer, MCH_EntityAircraft> ctx) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = (EntityPlayerSP)ctx.func_76341_a();
        MCH_EntityAircraft ac = (MCH_EntityAircraft)ctx.func_76340_b();
        ScaledResolution sc = new ScaledResolution(mc);
        if (mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        if (ac.getCurrentWeapon((Entity)player) == null || ac.getCurrentWeapon((Entity)player).getCurrentWeapon() == null) {
            return;
        }
        MCH_WeaponInfo wi = ac.getCurrentWeapon((Entity)player).getCurrentWeapon().getInfo();
        if (wi == null || !wi.enableBVR) {
            return;
        }
        GlStateManager.func_179094_E();
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>(this.getServerLoadedEntity());
        for (EntityInfo entity : entities) {
            if (!this.canRenderEntity(entity, (EntityPlayer)player, wi)) continue;
            double x = this.interpolate(entity.x, entity.prevX, event.getPartialTicks());
            double y = this.interpolate(entity.y, entity.prevY, event.getPartialTicks()) + 1.0;
            double z = this.interpolate(entity.z, entity.prevZ, event.getPartialTicks());
            Vec3d entityPos = new Vec3d(x, y, z);
            double[] screenPos = this.worldToScreen(entityPos);
            double sx = screenPos[0];
            double sy = screenPos[1];
            if (sx <= 0.0 || sy <= 0.0) continue;
            boolean lock = false;
            float alpha = 0.1f;
            double ox = screenPos[2];
            double oy = screenPos[3];
            double distScreen = ox * ox + oy * oy;
            if (distScreen < Math.pow(0.038 * (double)sc.func_78328_b(), 2.0)) {
                alpha = 1.0f;
                currentLockedEntities.put(entity.entityId, entity);
                lock = true;
            } else if (distScreen < Math.pow(0.076 * (double)sc.func_78328_b(), 2.0)) {
                alpha = 1.0f;
            } else if (distScreen < Math.pow(0.152 * (double)sc.func_78328_b(), 2.0)) {
                alpha = 0.8f;
            } else if (distScreen < Math.pow(0.228 * (double)sc.func_78328_b(), 2.0)) {
                alpha = 0.6f;
            } else if (distScreen < Math.pow(0.288 * (double)sc.func_78328_b(), 2.0)) {
                alpha = 0.4f;
            } else if (distScreen > Math.pow(0.384 * (double)sc.func_78328_b(), 2.0)) {
                double distance = Math.sqrt(distScreen);
                double ratio = 200.0 / distance;
                sx = (double)sc.func_78326_a() / 2.0 + ox * ratio;
                sy = (double)sc.func_78328_b() / 2.0 + oy * ratio;
                alpha = 0.2f;
            }
            if (entity.entityClassName.contains("MCH_EntityAAMissile")) {
                if (player.func_70092_e(x, y, z) < 1000000.0 && (double)alpha > 0.4) {
                    this.drawMSLMarker(sx, sy, true, alpha);
                    mc.field_71466_p.func_175065_a(String.format("[MSL %.1fm]", player.func_70011_f(x, y, z)), (float)((int)(sx - 20.0)), (float)((int)(sy + 12.0)), 0xFF0000, false);
                }
            } else {
                this.drawEntityMarker(sx, sy, lock, alpha);
                if (alpha >= 0.6f) {
                    mc.field_71466_p.func_175065_a(String.format("[%s %.1fm]", ac.getNameOnMyRadar(entity), player.func_70011_f(x, y, z)), (float)((int)(sx - 20.0)), (float)((int)(sy + 12.0)), lock ? 0xFF0000 : 65280, false);
                }
            }
            if (lock) continue;
            currentLockedEntities.clear();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public DirectDrawable getInstance() {
        return INSTANCE;
    }

    private List<EntityInfo> getServerLoadedEntity() {
        return new ArrayList<EntityInfo>(MCH_EntityInfoClientTracker.getAllTrackedEntities());
    }

    private boolean canRenderEntity(EntityInfo entity, EntityPlayer player, MCH_WeaponInfo wi) {
        double distSq = entity.getDistanceSqToEntity((Entity)player);
        if (entity.entityClassName.contains("MCP_EntityPlane") || entity.entityClassName.contains("MCH_EntityHeli")) {
            return distSq > (double)(wi.minRangeBVR * wi.minRangeBVR);
        }
        if (entity.entityClassName.contains("MCH_EntityChaff") && wi.isRadarMissile) {
            return distSq > (double)(wi.minRangeBVR * wi.minRangeBVR);
        }
        if (entity.entityClassName.contains("MCH_EntityAAMissile")) {
            return distSq > 10000.0;
        }
        return false;
    }

    private double[] worldToScreen(Vec3d pos) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        RenderManager renderMan = mc.func_175598_ae();
        Vec3d camPos = new Vec3d(renderMan.field_78730_l, renderMan.field_78731_m, renderMan.field_78728_n);
        Vec3d relPos = pos.func_178788_d(camPos);
        Vec3d lookVec = player.func_70040_Z();
        double angle = Math.toDegrees(Math.acos(relPos.func_72432_b().func_72430_b(lookVec)));
        if (angle > 45.0) {
            return new double[]{-1.0, -1.0, -1.0, -1.0};
        }
        Vec3d worldUp = new Vec3d(0.0, 1.0, 0.0);
        Vec3d right = lookVec.func_72431_c(worldUp);
        if (right.func_189985_c() < 1.0E-5) {
            double yawRad = Math.toRadians(player.field_70177_z + 90.0f);
            right = new Vec3d(Math.cos(yawRad), 0.0, -Math.sin(yawRad));
        }
        right = right.func_72432_b();
        Vec3d up = right.func_72431_c(lookVec).func_72432_b();
        double dx = relPos.func_72430_b(right);
        double dy = relPos.func_72430_b(up);
        double dz = relPos.func_72430_b(lookVec);
        if (dz <= 0.0) {
            return new double[]{-1.0, -1.0, -1.0, -1.0};
        }
        ScaledResolution sc = new ScaledResolution(mc);
        double fov = mc.field_71474_y.field_74334_X;
        double tanHalfFov = Math.tan(Math.toRadians(fov) * 0.5);
        double aspect = (double)sc.func_78326_a() / (double)sc.func_78328_b();
        double xProj = dx / dz / (aspect * tanHalfFov);
        double yProj = dy / dz / tanHalfFov;
        double screenX = (double)sc.func_78326_a() / 2.0 + xProj * ((double)sc.func_78326_a() / 2.0);
        double screenY = (double)sc.func_78328_b() / 2.0 - yProj * ((double)sc.func_78328_b() / 2.0);
        return new double[]{screenX, screenY, screenX - (double)sc.func_78326_a() / 2.0, screenY - (double)sc.func_78328_b() / 2.0};
    }

    private void drawEntityMarker(double x, double y, boolean lock, float alpha) {
        this.prepareRenderState(lock, alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FRAME);
        this.drawQuad(x, y, 24.0);
        this.restoreRenderState();
    }

    private void drawMSLMarker(double x, double y, boolean lock, float alpha) {
        this.prepareRenderState(lock, alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(MSL);
        this.drawQuad(x, y, 24.0);
        this.restoreRenderState();
    }

    private void drawQuad(double x, double y, double size) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        double half = size / 2.0;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(x - half, y + half, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y + half, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(x + half, y - half, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(x - half, y - half, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
    }

    private void prepareRenderState(boolean lock, float alpha) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)(lock ? 1.0f : 0.0f), (float)(lock ? 0.0f : 1.0f), (float)0.0f, (float)alpha);
    }

    private void restoreRenderState() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private double interpolate(double now, double old, float partialTicks) {
        return old + (now - old) * (double)partialTicks;
    }
}

