/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_KeyName;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.hud.MCH_HudItem;
import com.norwood.mcheli.hud.MCH_HudItemStringArgs;
import java.util.Date;
import lombok.Generated;
import net.minecraft.util.math.MathHelper;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class MCH_HudItemString
extends MCH_HudItem {
    private final String posX;
    private final String posY;
    private final String format;
    private final MCH_HudItemStringArgs[] args;
    private final boolean isCenteredString;
    private final Object[] prm;

    public MCH_HudItemString(int fileLine, String posx, String posy, String fmt, String[] arg, boolean centered) {
        super(fileLine);
        this.posX = MCH_HudItemString.toFormula(posx);
        this.posY = MCH_HudItemString.toFormula(posy);
        this.format = fmt;
        int len = arg.length < 3 ? 0 : arg.length - 3;
        this.args = new MCH_HudItemStringArgs[len];
        this.prm = new Object[this.args.length];
        for (int i = 0; i < len; ++i) {
            this.args[i] = MCH_HudItemStringArgs.toArgs(arg[3 + i]);
        }
        this.isCenteredString = centered;
    }

    @Override
    public void execute() {
        int x = (int)(centerX + MCH_HudItemString.calc(this.posX));
        int y = (int)(centerY + MCH_HudItemString.calc(this.posY));
        int worldTime = (int)((MCH_HudItemString.ac.field_70170_p.func_72820_D() + 6000L) % 24000L);
        Date date = new Date();
        double hp_per = ac.getMaxHP() > 0 ? (double)ac.getHP() / (double)ac.getMaxHP() : 0.0;
        block40: for (int i = 0; i < this.prm.length; ++i) {
            switch (this.args[i]) {
                case NAME: {
                    this.prm[i] = MCH_HudItemString.ac.getAcInfo().displayName;
                    continue block40;
                }
                case ALTITUDE: {
                    this.prm[i] = Altitude;
                    continue block40;
                }
                case DATE: {
                    this.prm[i] = date;
                    continue block40;
                }
                case MC_THOR: {
                    this.prm[i] = worldTime / 1000;
                    continue block40;
                }
                case MC_TMIN: {
                    this.prm[i] = worldTime % 1000 * 36 / 10 / 60;
                    continue block40;
                }
                case MC_TSEC: {
                    this.prm[i] = worldTime % 1000 * 36 / 10 % 60;
                    continue block40;
                }
                case MAX_HP: {
                    this.prm[i] = ac.getMaxHP();
                    continue block40;
                }
                case HP: {
                    this.prm[i] = ac.getHP();
                    continue block40;
                }
                case HP_PER: {
                    this.prm[i] = hp_per * 100.0;
                    continue block40;
                }
                case POS_X: {
                    this.prm[i] = MCH_HudItemString.ac.field_70165_t;
                    continue block40;
                }
                case POS_Y: {
                    this.prm[i] = MCH_HudItemString.ac.field_70163_u;
                    continue block40;
                }
                case POS_Z: {
                    this.prm[i] = MCH_HudItemString.ac.field_70161_v;
                    continue block40;
                }
                case MOTION_X: {
                    this.prm[i] = MCH_HudItemString.ac.field_70159_w;
                    continue block40;
                }
                case MOTION_Y: {
                    this.prm[i] = MCH_HudItemString.ac.field_70181_x;
                    continue block40;
                }
                case MOTION_Z: {
                    this.prm[i] = MCH_HudItemString.ac.field_70179_y;
                    continue block40;
                }
                case INVENTORY: {
                    this.prm[i] = ac.func_70302_i_();
                    continue block40;
                }
                case WPN_NAME: {
                    this.prm[i] = WeaponName;
                    if (CurrentWeapon != null) continue block40;
                    return;
                }
                case WPN_AMMO: {
                    this.prm[i] = WeaponAmmo;
                    if (CurrentWeapon == null) {
                        return;
                    }
                    if (CurrentWeapon.getAmmoNumMax() > 0) continue block40;
                    return;
                }
                case WPN_RM_AMMO: {
                    this.prm[i] = WeaponAllAmmo;
                    if (CurrentWeapon == null) {
                        return;
                    }
                    if (CurrentWeapon.getAmmoNumMax() > 0) continue block40;
                    return;
                }
                case RELOAD_PER: {
                    this.prm[i] = Float.valueOf(ReloadPer);
                    if (CurrentWeapon != null) continue block40;
                    return;
                }
                case RELOAD_SEC: {
                    this.prm[i] = Float.valueOf(ReloadSec);
                    if (CurrentWeapon != null) continue block40;
                    return;
                }
                case MORTAR_DIST: {
                    this.prm[i] = Float.valueOf(MortarDist);
                    if (CurrentWeapon != null) continue block40;
                    return;
                }
                case MC_VER: {
                    this.prm[i] = "1.12.2";
                    continue block40;
                }
                case MOD_VER: {
                    this.prm[i] = MCH_MOD.VER;
                    continue block40;
                }
                case MOD_NAME: {
                    this.prm[i] = "MC Helicopter MOD";
                    continue block40;
                }
                case YAW: {
                    this.prm[i] = MCH_Lib.getRotate360(ac.getRotYaw() + 180.0f);
                    continue block40;
                }
                case PITCH: {
                    this.prm[i] = Float.valueOf(-ac.getRotPitch());
                    continue block40;
                }
                case ROLL: {
                    this.prm[i] = Float.valueOf(MathHelper.func_76142_g((float)ac.getRotRoll()));
                    continue block40;
                }
                case PLYR_YAW: {
                    this.prm[i] = MCH_Lib.getRotate360(MCH_HudItemString.player.field_70177_z + 180.0f);
                    continue block40;
                }
                case PLYR_PITCH: {
                    this.prm[i] = Float.valueOf(-MCH_HudItemString.player.field_70125_A);
                    continue block40;
                }
                case TVM_POS_X: {
                    this.prm[i] = TVM_PosX;
                    continue block40;
                }
                case TVM_POS_Y: {
                    this.prm[i] = TVM_PosY;
                    continue block40;
                }
                case TVM_POS_Z: {
                    this.prm[i] = TVM_PosZ;
                    continue block40;
                }
                case TVM_DIFF: {
                    this.prm[i] = TVM_Diff;
                    continue block40;
                }
                case CAM_ZOOM: {
                    this.prm[i] = Float.valueOf(MCH_HudItemString.ac.camera.getCameraZoom());
                    continue block40;
                }
                case UAV_DIST: {
                    this.prm[i] = UAV_Dist;
                    continue block40;
                }
                case KEY_GUI: {
                    this.prm[i] = MCH_KeyName.getDescOrName(MCH_Config.KeyGUI.prmInt);
                    continue block40;
                }
                case THROTTLE: {
                    this.prm[i] = ac.getCurrentThrottle() * 100.0;
                }
            }
        }
        if (this.isCenteredString) {
            this.drawCenteredString(String.format(this.format, this.prm), x, y, colorSetting);
        } else {
            this.drawString(String.format(this.format, this.prm), x, y, colorSetting);
        }
    }

    @Generated
    public String getPosX() {
        return this.posX;
    }

    @Generated
    public String getPosY() {
        return this.posY;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public MCH_HudItemStringArgs[] getArgs() {
        return this.args;
    }

    @Generated
    public boolean isCenteredString() {
        return this.isCenteredString;
    }

    @Generated
    public Object[] getPrm() {
        return this.prm;
    }
}

