/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud;

import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.MCH_Vector2;
import com.norwood.mcheli.hud.MCH_HudItem;
import java.util.ArrayList;
import lombok.Generated;

public class MCH_HudItemRadar
extends MCH_HudItem {
    private final String rot;
    private final String left;
    private final String top;
    private final String width;
    private final String height;
    private final boolean isEntityRadar;

    public MCH_HudItemRadar(int fileLine, boolean isEntityRadar, String rot, String left, String top, String width, String height) {
        super(fileLine);
        this.isEntityRadar = isEntityRadar;
        this.rot = MCH_HudItemRadar.toFormula(rot);
        this.left = MCH_HudItemRadar.toFormula(left);
        this.top = MCH_HudItemRadar.toFormula(top);
        this.width = MCH_HudItemRadar.toFormula(width);
        this.height = MCH_HudItemRadar.toFormula(height);
    }

    @Override
    public void execute() {
        if (this.isEntityRadar) {
            if (EntityList != null && !EntityList.isEmpty()) {
                this.drawEntityList(EntityList, (float)MCH_HudItemRadar.calc(this.rot), centerX + MCH_HudItemRadar.calc(this.left), centerY + MCH_HudItemRadar.calc(this.top), MCH_HudItemRadar.calc(this.width), MCH_HudItemRadar.calc(this.height));
            }
        } else if (EnemyList != null && !EnemyList.isEmpty()) {
            this.drawEntityList(EnemyList, (float)MCH_HudItemRadar.calc(this.rot), centerX + MCH_HudItemRadar.calc(this.left), centerY + MCH_HudItemRadar.calc(this.top), MCH_HudItemRadar.calc(this.width), MCH_HudItemRadar.calc(this.height));
        }
    }

    protected void drawEntityList(ArrayList<MCH_Vector2> src, float r, double left, double top, double w, double h) {
        double w1 = -w / 2.0;
        double w2 = w / 2.0;
        double h1 = -h / 2.0;
        double h2 = h / 2.0;
        double w_factor = w / 64.0;
        double h_factor = h / 64.0;
        double[] list = new double[src.size() * 2];
        int idx = 0;
        for (MCH_Vector2 v : src) {
            list[idx] = v.x / 2.0 * w_factor;
            list[idx + 1] = v.y / 2.0 * h_factor;
            idx += 2;
        }
        MCH_Lib.rotatePoints(list, r);
        ArrayList<Double> drawList = new ArrayList<Double>();
        int i = 0;
        while (i + 1 < list.length) {
            if (list[i] > w1 && list[i] < w2 && list[i + 1] > h1 && list[i + 1] < h2) {
                drawList.add(list[i] + left + w / 2.0);
                drawList.add(list[i + 1] + top + h / 2.0);
            }
            i += 2;
        }
        this.drawPoints(drawList, colorSetting, scaleFactor * 2);
    }

    @Generated
    public String getRot() {
        return this.rot;
    }

    @Generated
    public String getLeft() {
        return this.left;
    }

    @Generated
    public String getTop() {
        return this.top;
    }

    @Generated
    public String getWidth() {
        return this.width;
    }

    @Generated
    public String getHeight() {
        return this.height;
    }

    @Generated
    public boolean isEntityRadar() {
        return this.isEntityRadar;
    }
}

