/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.hud;

import com.norwood.mcheli.MCH_BaseInfo;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.addon.AddonResourceLocation;
import com.norwood.mcheli.hud.MCH_HudItem;
import com.norwood.mcheli.wrapper.W_ScaledResolution;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class MCH_Hud
extends MCH_BaseInfo {
    public static final MCH_Hud NoDisp = new MCH_Hud(MCH_Utils.buildinAddon("none"), "none");
    public final String name;
    public final String fileName;
    public boolean isWaitEndif;
    public boolean isIfFalse;
    public boolean exit;
    public final List<MCH_HudItem> list;
    private boolean isDrawing;

    public MCH_Hud(AddonResourceLocation location, String filePath) {
        super(location, filePath);
        this.name = location.func_110623_a();
        this.fileName = filePath;
        this.list = new ArrayList<MCH_HudItem>();
        this.isDrawing = false;
        this.isIfFalse = false;
        this.exit = false;
    }

    @Override
    public boolean validate() {
        for (MCH_HudItem hud : this.list) {
            hud.parent = this;
        }
        if (this.isWaitEndif) {
            throw new RuntimeException("Endif not found!");
        }
        return true;
    }

    @Override
    public void onPostReload() {
    }

    public void draw(MCH_EntityAircraft ac, EntityPlayer player, float partialTicks) {
        if (MCH_HudItem.mc == null) {
            MCH_HudItem.mc = Minecraft.func_71410_x();
        }
        MCH_HudItem.ac = ac;
        MCH_HudItem.player = player;
        MCH_HudItem.partialTicks = partialTicks;
        W_ScaledResolution scaledresolution = new W_ScaledResolution(MCH_HudItem.mc, MCH_HudItem.mc.field_71443_c, MCH_HudItem.mc.field_71440_d);
        MCH_HudItem.scaleFactor = scaledresolution.func_78325_e();
        if (MCH_HudItem.scaleFactor <= 0) {
            MCH_HudItem.scaleFactor = 1;
        }
        MCH_HudItem.width = (double)MCH_HudItem.mc.field_71443_c / (double)MCH_HudItem.scaleFactor;
        MCH_HudItem.height = (double)MCH_HudItem.mc.field_71440_d / (double)MCH_HudItem.scaleFactor;
        MCH_HudItem.centerX = MCH_HudItem.width / 2.0;
        MCH_HudItem.centerY = MCH_HudItem.height / 2.0;
        this.isIfFalse = false;
        this.isDrawing = false;
        this.exit = false;
        if (ac != null && ac.getAcInfo() != null && player != null) {
            MCH_HudItem.update();
            this.drawItems();
            MCH_HudItem.drawVarMap();
        }
    }

    protected void drawItems() {
        if (!this.isDrawing) {
            this.isDrawing = true;
            for (MCH_HudItem hud : this.list) {
                int line = -1;
                try {
                    line = hud.fileLine;
                    if (!hud.canExecute()) continue;
                    hud.execute();
                    if (!this.exit) continue;
                    break;
                }
                catch (Exception var5) {
                    MCH_Lib.Log("#### Draw HUD Error!!!: line=%d, file=%s", line, this.fileName);
                    var5.printStackTrace();
                    throw new RuntimeException(var5);
                }
            }
            this.exit = false;
            this.isIfFalse = false;
            this.isDrawing = false;
        }
    }

    public String toString() {
        return MCH_Hud.jvmdowngrader$concat$toString$1(this.name, this.fileName, this.isWaitEndif, this.isIfFalse, this.exit, String.valueOf(this.list), this.isDrawing, this.filePath, String.valueOf((Object)this.location));
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, boolean bl4, String string4, String string5) {
        return "MCH_Hud{name='" + string + "', fileName='" + string2 + "', isWaitEndif=" + bl + ", isIfFalse=" + bl2 + ", exit=" + bl3 + ", list=" + string3 + ", isDrawing=" + bl4 + ", filePath='" + string4 + "', location=" + string5 + "}";
    }
}

