/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info.parsers.yaml;

import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.RWRType;
import com.norwood.mcheli.RadarType;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_BoundingBox;
import com.norwood.mcheli.aircraft.MCH_SeatInfo;
import com.norwood.mcheli.aircraft.MCH_SeatRackInfo;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import com.norwood.mcheli.helper.MCH_Logger;
import com.norwood.mcheli.helper.addon.AddonResourceLocation;
import com.norwood.mcheli.helper.info.ContentParsers;
import com.norwood.mcheli.helper.info.parsers.IParser;
import com.norwood.mcheli.helper.info.parsers.yaml.ComponentParser;
import com.norwood.mcheli.helper.info.parsers.yaml.HUDParser;
import com.norwood.mcheli.helper.info.parsers.yaml.ThrowableParser;
import com.norwood.mcheli.helper.info.parsers.yaml.WeaponParser;
import com.norwood.mcheli.hud.MCH_Hud;
import com.norwood.mcheli.hud.MCH_HudManager;
import com.norwood.mcheli.item.MCH_ItemInfo;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import com.norwood.mcheli.ship.MCH_ShipInfo;
import com.norwood.mcheli.sound.SoundRegistry;
import com.norwood.mcheli.tank.MCH_TankInfo;
import com.norwood.mcheli.throwable.MCH_ThrowableInfo;
import com.norwood.mcheli.vehicle.MCH_VehicleInfo;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import com.norwood.mcheli.weapon.MCH_WeaponInfoManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={FlareType.class, TankWeight.class})
public class YamlParser
implements IParser {
    public static final Yaml YAML_INSTANCE = new Yaml();
    public static final YamlParser INSTANCE = new YamlParser();
    public static final Set<String> DRAWN_PART_ARGS = new HashSet<String>(Arrays.asList("Type", "Position", "Rotation", "PartName", "Rot", "Pos"));

    private YamlParser() {
    }

    public static void register() {
        ContentParsers.register("yml", INSTANCE);
    }

    public static void logUnkownEntry(Map.Entry<String, Object> entry, String caller) {
        MCH_Logger.get().warn(YamlParser.jvmdowngrader$concat$logUnkownEntry$1(entry.getKey(), caller));
    }

    public static int parseHexColor(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Color string is empty");
        }
        String t = s.trim();
        if (t.startsWith("#")) {
            t = YamlParser.jvmdowngrader$concat$parseHexColor$1(t.substring(1));
        }
        if (!t.startsWith("0x") && !t.startsWith("0X")) {
            t = YamlParser.jvmdowngrader$concat$parseHexColor$1(t);
        }
        return (int)Long.decode(t).longValue();
    }

    public static float getClamped(float min, float max, Object value) {
        return Math.max(min, Math.min(max, ((Number)value).floatValue()));
    }

    public static int getClamped(int min, int max, Object value) {
        return Math.max(min, Math.min(max, ((Number)value).intValue()));
    }

    public static double getClamped(double min, double max, Number value) {
        return Math.max(min, Math.min(max, value.doubleValue()));
    }

    public static float getClamped(float max, Object value) {
        return YamlParser.getClamped(0.0f, max, value);
    }

    public static int getClamped(int max, Object value) {
        return YamlParser.getClamped(0, max, value);
    }

    public static double getClamped(double max, Number value) {
        return YamlParser.getClamped(0.0, max, value);
    }

    public static Vec3d parseVector(Object vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Vector value is null");
        }
        if (vector instanceof List) {
            List list = (List)vector;
            if (list.size() != 3) {
                throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseVector$1(list.size()));
            }
            return new Vec3d(YamlParser.asDouble(list.get(0)), YamlParser.asDouble(list.get(1)), YamlParser.asDouble(list.get(2)));
        }
        throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseVector$1(String.valueOf(vector.getClass())));
    }

    private static double asDouble(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.doubleValue();
        }
        if (o instanceof String) {
            String s = (String)o;
            return Double.parseDouble(s.trim());
        }
        throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$asDouble$1(String.valueOf(o.getClass())));
    }

    @Override
    @Nullable
    public MCH_HeliInfo parseHelicopter(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_HeliInfo info = new MCH_HeliInfo(location, filepath);
        this.mapToAircraft(info, root);
        for (Map.Entry entry : root.entrySet()) {
            switch ((String)entry.getKey()) {
                case "HeliFeatures": {
                    this.parseHeliFeatures((Map)entry.getValue(), info);
                    break;
                }
                case "Components": {
                    Map components = (Map)entry.getValue();
                    ComponentParser.parseComponentsHeli(components, info);
                }
            }
        }
        info.validate();
        return info;
    }

    private void parseHeliFeatures(Map<String, Object> heliFeat, MCH_HeliInfo info) {
        block6: for (Map.Entry<String, Object> mobEntry : heliFeat.entrySet()) {
            switch (mobEntry.getKey()) {
                case "IsFoldableBlade": {
                    info.isEnableFoldBlade = (Boolean)mobEntry.getValue();
                    continue block6;
                }
            }
            YamlParser.logUnkownEntry(mobEntry, "HeliFeatures");
        }
    }

    @Override
    @Nullable
    public MCH_PlaneInfo parsePlane(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_PlaneInfo info = new MCH_PlaneInfo(location, filepath);
        this.mapToAircraft(info, root);
        for (Map.Entry entry : root.entrySet()) {
            switch ((String)entry.getKey()) {
                case "PlaneFeatures": {
                    this.parsePlaneFeatures((Map)entry.getValue(), info);
                    break;
                }
                case "Components": {
                    Map components = (Map)entry.getValue();
                    ComponentParser.parseComponentsPlane(components, info);
                }
            }
        }
        info.validate();
        return info;
    }

    @Override
    @Nullable
    public MCH_ShipInfo parseShip(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_ShipInfo info = new MCH_ShipInfo(location, filepath);
        this.mapToAircraft(info, root);
        for (Map.Entry entry : root.entrySet()) {
            switch ((String)entry.getKey()) {
                case "ShipFeatures": {
                    this.parseShipFeatures((Map)entry.getValue(), info);
                    break;
                }
                case "Components": {
                    Map components = (Map)entry.getValue();
                    ComponentParser.parseComponentsShip(components, info);
                }
            }
        }
        info.validate();
        return info;
    }

    @Override
    @Nullable
    public MCH_TankInfo parseTank(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_TankInfo info = new MCH_TankInfo(location, filepath);
        this.mapToAircraft(info, root);
        if (root.containsKey("TankFeatures")) {
            this.parseTankFeat((Map)root.get("TankFeatures"), info);
        }
        info.validate();
        return info;
    }

    private void parseTankFeat(Map<String, Object> tankFeatures, MCH_TankInfo info) {
        block11: for (Map.Entry<String, Object> entry : tankFeatures.entrySet()) {
            switch (entry.getKey()) {
                case "WeightType": {
                    try {
                        info.weightType = TankWeight.valueOf(((String)entry.getValue()).toUpperCase(Locale.ROOT).trim()).ordinal();
                        continue block11;
                    }
                    catch (RuntimeException e) {
                        throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseTankFeat$1(String.valueOf(entry.getValue()), Arrays.stream(TankWeight.values()).map(Enum::name).collect(Collectors.joining(", "))));
                    }
                }
                case "WeightedCenterZ": 
                case "CenterZ": {
                    YamlParser.getClamped(-1000.0f, 1000.0f, entry.getValue());
                    continue block11;
                }
            }
            YamlParser.logUnkownEntry(entry, "TankFeatures");
        }
    }

    @Override
    @Nullable
    public MCH_VehicleInfo parseVehicle(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_VehicleInfo info = new MCH_VehicleInfo(location, filepath);
        this.mapToAircraft(info, root);
        for (Map.Entry entry : root.entrySet()) {
            switch ((String)entry.getKey()) {
                case "VehicleFeatures": {
                    this.parseVehicleFeatures((Map)entry.getValue(), info);
                    break;
                }
                case "Components": {
                    Map components = (Map)entry.getValue();
                    ComponentParser.parseComponentVehicle(components, info);
                }
            }
        }
        return info;
    }

    private void parseVehicleFeatures(Map<String, Object> value, MCH_VehicleInfo info) {
        block8: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "CanMove": {
                    info.isEnableMove = (Boolean)entry.getValue();
                    continue block8;
                }
                case "CanRotate": {
                    info.isEnableRot = (Boolean)entry.getValue();
                    continue block8;
                }
            }
            YamlParser.logUnkownEntry(entry, "VehicleFeatures");
        }
    }

    @Override
    @Nullable
    public MCH_WeaponInfo parseWeapon(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_WeaponInfo info = new MCH_WeaponInfo(location, filepath);
        WeaponParser.parse(info, root);
        info.validate();
        return info;
    }

    @Override
    @Nullable
    public MCH_ThrowableInfo parseThrowable(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Map root = (Map)YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_ThrowableInfo throwable = new MCH_ThrowableInfo(location, filepath);
        ThrowableParser.parse(throwable, root);
        throwable.validate();
        return throwable;
    }

    @Override
    @Nullable
    public MCH_Hud parseHud(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        Object root = YAML_INSTANCE.load(lines.stream().collect(Collectors.joining("\n")));
        MCH_Hud info = new MCH_Hud(location, filepath);
        HUDParser.parse(info, root);
        info.validate();
        return info;
    }

    @Override
    @Nullable
    public MCH_ItemInfo parseItem(AddonResourceLocation location, String filepath, List<String> lines, boolean reload) throws Exception {
        return null;
    }

    private void parsePlaneFeatures(Map<String, Object> map, MCH_PlaneInfo info) {
        block22: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "VariableSweepWing": {
                    info.isVariableSweepWing = (Boolean)entry.getValue();
                    break;
                }
                case "SweepWingSpeed": {
                    info.sweepWingSpeed = YamlParser.getClamped(5.0f, entry.getValue());
                    break;
                }
                case "EnableVtol": {
                    Object vtol = entry.getValue();
                    if (vtol instanceof Boolean) {
                        info.isEnableVtol = (Boolean)entry.getValue();
                        break;
                    }
                    if (!(vtol instanceof Map)) continue block22;
                    info.isEnableVtol = true;
                    for (Map.Entry<String, Object> vtolEntry : map.entrySet()) {
                        switch (vtolEntry.getKey()) {
                            case "IsDefault": {
                                info.isDefaultVtol = (Boolean)entry.getValue();
                                break;
                            }
                            case "Yaw": {
                                info.vtolYaw = YamlParser.getClamped(1.0f, entry.getValue());
                                break;
                            }
                            case "Pitch": {
                                info.vtolPitch = YamlParser.getClamped(0.01f, 1.0f, entry.getValue());
                            }
                        }
                    }
                    continue block22;
                }
                case "EnableAutoPilot": {
                    info.isEnableAutoPilot = (Boolean)entry.getValue();
                    break;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "PlaneFeatures");
                }
            }
        }
    }

    private void parseShipFeatures(Map<String, Object> map, MCH_ShipInfo info) {
        block22: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "VariableSweepWing": {
                    info.isVariableSweepWing = (Boolean)entry.getValue();
                    break;
                }
                case "SweepWingSpeed": {
                    info.sweepWingSpeed = YamlParser.getClamped(5.0f, entry.getValue());
                    break;
                }
                case "EnableVtol": {
                    Object vtol = entry.getValue();
                    if (vtol instanceof Boolean) {
                        info.isEnableVtol = (Boolean)entry.getValue();
                        break;
                    }
                    if (!(vtol instanceof Map)) continue block22;
                    info.isEnableVtol = true;
                    for (Map.Entry<String, Object> vtolEntry : map.entrySet()) {
                        switch (vtolEntry.getKey()) {
                            case "IsDefault": {
                                info.isDefaultVtol = (Boolean)entry.getValue();
                                break;
                            }
                            case "Yaw": {
                                info.vtolYaw = YamlParser.getClamped(1.0f, entry.getValue());
                                break;
                            }
                            case "Pitch": {
                                info.vtolPitch = YamlParser.getClamped(0.01f, 1.0f, entry.getValue());
                            }
                        }
                    }
                    continue block22;
                }
                case "EnableAutoPilot": {
                    info.isEnableAutoPilot = (Boolean)entry.getValue();
                    break;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "ShipFeatures");
                }
            }
        }
    }

    private void mapToAircraft(MCH_AircraftInfo info, Map<String, Object> root) {
        block106: for (Map.Entry<String, Object> entry : root.entrySet()) {
            switch (entry.getKey()) {
                case "DisplayName": {
                    Object nameObject = entry.getValue();
                    if (nameObject instanceof String) {
                        String name = (String)nameObject;
                        info.displayName = name.trim();
                        break;
                    }
                    if (nameObject instanceof Map) {
                        Map translationNames = (Map)nameObject;
                        Object userNameMap = translationNames;
                        if (userNameMap.containsKey("DEFAULT")) {
                            info.displayName = (String)userNameMap.get("DEFAULT");
                            userNameMap.remove("DEFAULT");
                        }
                        info.displayNameLang = (HashMap)userNameMap;
                        break;
                    }
                    throw new ClassCastException();
                }
                case "Author": {
                    break;
                }
                case "ItemID": {
                    info.itemID = (Integer)entry.getValue();
                    break;
                }
                case "Category": {
                    Object name = entry.getValue();
                    if (name instanceof String) {
                        String category = (String)name;
                        info.category = category.toUpperCase(Locale.ROOT).trim();
                        break;
                    }
                    name = entry.getValue();
                    if (name instanceof List) {
                        List categories;
                        List list = categories = (List)name;
                        info.category = list.stream().map(String::trim).map(String::toUpperCase).collect(Collectors.joining(","));
                        break;
                    }
                    throw new RuntimeException();
                }
                case "Recepie": {
                    Map map2 = (Map)entry.getValue();
                    for (Map.Entry recMapEntry : map2.entrySet()) {
                        switch ((String)recMapEntry.getKey()) {
                            case "isShaped": {
                                info.isShapedRecipe = (Boolean)recMapEntry.getValue();
                                break;
                            }
                            case "Pattern": {
                                info.recipeString = ((List)recMapEntry.getValue()).stream().map(String::toUpperCase).map(String::trim).collect(Collectors.toList());
                            }
                        }
                    }
                    continue block106;
                }
                case "CanRide": {
                    info.canRide = (Boolean)entry.getValue();
                    break;
                }
                case "RotorSpeed": {
                    info.rotorSpeed = YamlParser.getClamped(-10000.0f, 10000.0f, entry.getValue());
                    if (info.rotorSpeed > 0.01f) {
                        info.rotorSpeed -= 0.01f;
                    }
                    if (!(info.rotorSpeed < -0.01f)) continue block106;
                    info.rotorSpeed += 0.01f;
                    break;
                }
                case "TurretPosition": {
                    info.turretPosition = YamlParser.parseVector(entry.getValue());
                    break;
                }
                case "CreativeOnly": {
                    info.creativeOnly = (Boolean)entry.getValue();
                    break;
                }
                case "Regeneration": {
                    info.regeneration = (Boolean)entry.getValue();
                    break;
                }
                case "Invulnerable": {
                    info.invulnerable = (Boolean)entry.getValue();
                    break;
                }
                case "MaxFuel": {
                    info.maxFuel = YamlParser.getClamped(100000000, entry.getValue());
                    break;
                }
                case "MaxHP": {
                    info.maxHp = YamlParser.getClamped(1, 1000000000, entry.getValue());
                    break;
                }
                case "Stealth": {
                    info.stealth = YamlParser.getClamped(1.0f, entry.getValue());
                    break;
                }
                case "FuelConsumption": {
                    info.fuelConsumption = YamlParser.getClamped(10000.0f, entry.getValue());
                    break;
                }
                case "FuelSupplyRange": {
                    info.fuelSupplyRange = YamlParser.getClamped(1000.0f, entry.getValue());
                    break;
                }
                case "AmmoSupplyRange": {
                    info.ammoSupplyRange = YamlParser.getClamped(1000, entry.getValue());
                    break;
                }
                case "RepairOtherVehicles": {
                    HashMap repairMap = (HashMap)entry.getValue();
                    if (repairMap.containsKey("Range")) {
                        info.repairOtherVehiclesRange = YamlParser.getClamped(1000.0f, repairMap.get("Range"));
                    }
                    if (!repairMap.containsKey("Value")) continue block106;
                    info.repairOtherVehiclesValue = YamlParser.getClamped(10000000, repairMap.get("Value"));
                    break;
                }
                case "RadarType": {
                    Object category = entry.getValue();
                    if (!(category instanceof String)) continue block106;
                    String data = (String)category;
                    try {
                        info.radarType = RadarType.valueOf(data);
                    }
                    catch (IllegalArgumentException e) {
                        info.radarType = RadarType.MODERN_AA;
                    }
                    break;
                }
                case "RWRType": {
                    Object e = entry.getValue();
                    if (!(e instanceof String)) continue block106;
                    String data = (String)e;
                    try {
                        info.rwrType = RWRType.valueOf(data);
                    }
                    catch (IllegalArgumentException e2) {
                        info.rwrType = RWRType.DIGITAL;
                    }
                    break;
                }
                case "NameOnModernAARadar": {
                    info.nameOnModernAARadar = ((String)entry.getValue()).trim();
                    break;
                }
                case "NameOnEarlyAARadar": {
                    info.nameOnEarlyAARadar = ((String)entry.getValue()).trim();
                    break;
                }
                case "NameOnModernASRadar": {
                    info.nameOnModernASRadar = ((String)entry.getValue()).trim();
                    break;
                }
                case "NameOnEarlyASRadar": {
                    info.nameOnEarlyASRadar = ((String)entry.getValue()).trim();
                    break;
                }
                case "ExplosionSizeByCrash": {
                    info.explosionSizeByCrash = YamlParser.getClamped(100, entry.getValue());
                    break;
                }
                case "ThrottleDownFactor": {
                    info.throttleDownFactor = YamlParser.getClamped(10.0f, entry.getValue());
                    break;
                }
                case "HUDType": 
                case "WeaponGroupType": {
                    break;
                }
                case "Weapons": {
                    List weapons = (List)entry.getValue();
                    weapons.forEach(map -> this.parseWeapon((Map<String, Object>)map, info));
                    break;
                }
                case "GlobalUnmountPos": {
                    info.unmountPosition = YamlParser.parseVector(entry.getValue());
                    break;
                }
                case "PhysicalProperties": {
                    Map physicalProperties = (Map)entry.getValue();
                    physicalProperties.entrySet().forEach(physEntry -> this.parsePhisProperties((Map.Entry<String, Object>)physEntry, info));
                    break;
                }
                case "Render": {
                    Map renderProperties = (Map)entry.getValue();
                    this.parseRender(renderProperties, info);
                    break;
                }
                case "Armor": {
                    Map armorSettings = (Map)entry.getValue();
                    armorSettings.entrySet().forEach(armorEntry -> this.parseArmor((Map.Entry<String, Object>)armorEntry, info));
                    break;
                }
                case "Camera": {
                    Map cameraSettings = (Map)entry.getValue();
                    cameraSettings.entrySet().forEach(camEntry -> this.parseGlobalCamera(info, (Map.Entry<String, Object>)camEntry));
                    break;
                }
                case "AircraftFeatures": {
                    Map feats = (Map)entry.getValue();
                    this.parseAircraftFeatures(feats, info);
                    break;
                }
                case "Racks": {
                    int seatCount = 0;
                    if (root.containsKey("Seats")) {
                        seatCount = ((List)root.get("Seats")).size();
                    }
                    List racks = (List)entry.getValue();
                    for (Map rack : racks) {
                        this.parseSeatRackInfo(rack, info, seatCount, racks.size());
                    }
                    continue block106;
                }
                case "RideRack": {
                    this.parseRideRacks((Map)entry.getValue(), info);
                    break;
                }
                case "Wheels": {
                    Map wheel = (Map)entry.getValue();
                    this.parseWheels(wheel, info);
                    break;
                }
                case "Components": {
                    Map components = (Map)entry.getValue();
                    ComponentParser.parseComponents(components, info);
                    break;
                }
                case "Sound": {
                    Map soundSettings = (Map)entry.getValue();
                    this.parseSound(soundSettings, info);
                    break;
                }
                case "Seats": {
                    List seatList = (List)entry.getValue();
                    seatList.stream().forEachOrdered(seat -> this.parseSeatInfo((Map<String, Object>)seat, info, seatList.size()));
                    break;
                }
                case "Uav": {
                    Map uav = (Map)entry.getValue();
                    this.parseUAV(uav, info);
                    break;
                }
                case "BoundingBoxes": {
                    List boxList = (List)entry.getValue();
                    boxList.stream().forEachOrdered(box -> this.parseBoxes((Map<String, Object>)box, info));
                    float maxY = Float.NEGATIVE_INFINITY;
                    float maxAbsXZ = 0.0f;
                    float zMin = Float.POSITIVE_INFINITY;
                    float zMax = Float.NEGATIVE_INFINITY;
                    for (MCH_BoundingBox box2 : info.extraBoundingBox) {
                        AxisAlignedBB aabb = box2.boundingBox;
                        maxY = Math.max(maxY, (float)aabb.field_72337_e);
                        maxAbsXZ = Math.max(maxAbsXZ, Math.max(Math.max(Math.abs((float)aabb.field_72336_d), Math.abs((float)aabb.field_72340_a)), Math.max(Math.abs((float)aabb.field_72334_f), Math.abs((float)aabb.field_72339_c))));
                        zMin = Math.min(zMin, (float)aabb.field_72339_c);
                        zMax = Math.max(zMax, (float)aabb.field_72334_f);
                    }
                    info.markerHeight = maxY;
                    info.markerWidth = maxAbsXZ / 2.0f;
                    info.bbZmin = zMin;
                    info.bbZmax = zMax;
                    break;
                }
                case "PlaneFeatures": 
                case "TankFeatures": 
                case "HeliFeatures": 
                case "VehicleFeatures": {
                    break;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "AircraftInfo");
                }
            }
        }
    }

    private void parseWheels(Map<String, Object> wheel, MCH_AircraftInfo info) {
        block10: for (Map.Entry<String, Object> entry : wheel.entrySet()) {
            switch (entry.getKey()) {
                case "Hitboxes": {
                    List wheels = (List)entry.getValue();
                    info.wheels.clear();
                    info.wheels.addAll(wheels.stream().map(this::parseWheel).sorted((o1, o2) -> o1.pos.field_72449_c > o2.pos.field_72449_c ? -1 : 1).collect(Collectors.toList()));
                    continue block10;
                }
                case "WheelRotation": {
                    info.partWheelRot = YamlParser.getClamped(-10000.0f, 10000.0f, entry.getValue());
                    continue block10;
                }
                case "TrackRotation": {
                    info.trackRollerRot = YamlParser.getClamped(-10000.0f, 10000.0f, entry.getValue());
                    continue block10;
                }
            }
            YamlParser.logUnkownEntry(entry, "Wheels");
        }
    }

    private void parseUAV(Map<String, Object> uav, MCH_AircraftInfo info) {
        block12: for (Map.Entry<String, Object> entry : uav.entrySet()) {
            switch (entry.getKey()) {
                case "IsUav": {
                    info.isUAV = (Boolean)entry.getValue();
                    continue block12;
                }
                case "IsSmallUav": {
                    info.isSmallUAV = (Boolean)entry.getValue();
                    continue block12;
                }
                case "IsNewUav": {
                    info.isNewUAV = (Boolean)entry.getValue();
                    continue block12;
                }
                case "IsTargetDrone": {
                    info.isTargetDrone = (Boolean)entry.getValue();
                    continue block12;
                }
            }
            YamlParser.logUnkownEntry(entry, "Uav");
        }
    }

    private void parseBoxes(Map<String, Object> box, MCH_AircraftInfo info) {
        Vec3d pos = null;
        Vec3d size = null;
        float damageFact = 1.0f;
        String name = "";
        MCH_BoundingBox.EnumBoundingBoxType type = MCH_BoundingBox.EnumBoundingBoxType.DEFAULT;
        block18: for (Map.Entry<String, Object> entry : box.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    pos = YamlParser.parseVector(entry.getValue());
                    continue block18;
                }
                case "Size": {
                    size = YamlParser.parseVector(entry.getValue());
                    continue block18;
                }
                case "DamageFactor": 
                case "DmgFact": {
                    damageFact = ((Number)entry.getValue()).floatValue();
                    continue block18;
                }
                case "Name": {
                    name = name.trim();
                    continue block18;
                }
                case "Type": {
                    try {
                        type = MCH_BoundingBox.EnumBoundingBoxType.valueOf(((String)entry.getValue()).toUpperCase(Locale.ROOT).trim());
                        continue block18;
                    }
                    catch (RuntimeException r) {
                        throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseBoxes$1(String.valueOf(entry.getValue()), Arrays.stream(MCH_BoundingBox.EnumBoundingBoxType.values()).map(Enum::name).collect(Collectors.joining(", "))));
                    }
                }
            }
            YamlParser.logUnkownEntry(entry, "BoundingBox");
        }
        if (pos == null) {
            throw new IllegalArgumentException("Bounding box must have a position!");
        }
        if (size == null) {
            throw new IllegalArgumentException("Bounding box must have a size!");
        }
        MCH_BoundingBox parsedBox = new MCH_BoundingBox(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (float)size.field_72450_a, (float)size.field_72448_b, (float)size.field_72449_c, damageFact);
        parsedBox.setBoundingBoxType(type);
        info.extraBoundingBox.add(parsedBox);
    }

    private void parseSound(Map<String, Object> soundSettings, MCH_AircraftInfo info) {
        for (Map.Entry<String, Object> entry : soundSettings.entrySet()) {
            switch (entry.getKey()) {
                case "MoveSound": {
                    info.soundMove = this.parseSoundEffect(entry.getValue());
                    break;
                }
                case "Volume": 
                case "Vol": {
                    info.soundVolume = YamlParser.getClamped(10.0f, entry.getValue());
                    break;
                }
                case "Pitch": {
                    info.soundPitch = YamlParser.getClamped(1.0f, 10.0f, entry.getValue());
                    break;
                }
                case "Range": {
                    info.soundRange = YamlParser.getClamped(1.0f, 1000.0f, entry.getValue());
                }
            }
        }
    }

    public ResourceLocation parseSoundEffect(Object sound) {
        if (sound instanceof String) {
            String string = (String)sound;
            return SoundRegistry.INSTANCE.parseSound(string);
        }
        if (sound instanceof Map) {
            Map map = (Map)sound;
            return SoundRegistry.INSTANCE.parseSound(map);
        }
        throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseSoundEffect$1(String.valueOf(sound.getClass())));
    }

    private void parseRender(Map<String, Object> renderProperties, MCH_AircraftInfo info) {
        block26: for (Map.Entry<String, Object> entry : renderProperties.entrySet()) {
            switch (entry.getKey()) {
                case "Textures": {
                    List textures = (List)entry.getValue();
                    textures.stream().map(String::trim).forEach(info::addTextureName);
                    continue block26;
                }
                case "SmoothShading": {
                    info.smoothShading = (Boolean)entry.getValue();
                    continue block26;
                }
                case "HideRiders": {
                    info.hideEntity = (Boolean)entry.getValue();
                    continue block26;
                }
                case "ModelWidth": {
                    info.entityWidth = ((Number)entry.getValue()).floatValue();
                    continue block26;
                }
                case "ModelHeight": {
                    info.entityHeight = ((Number)entry.getValue()).floatValue();
                    continue block26;
                }
                case "ModelPitch": {
                    info.entityPitch = ((Number)entry.getValue()).floatValue();
                    continue block26;
                }
                case "ModelRoll": {
                    info.entityRoll = ((Number)entry.getValue()).floatValue();
                    continue block26;
                }
                case "ParticleScale": {
                    info.particlesScale = YamlParser.getClamped(50.0f, entry.getValue());
                    continue block26;
                }
                case "OneProbeScale": {
                    info.oneProbeScale = ((Number)entry.getValue()).floatValue();
                    continue block26;
                }
                case "EnableSeaSurfaceParticle": {
                    info.enableSeaSurfaceParticle = (Boolean)entry.getValue();
                    continue block26;
                }
                case "SplashParticles": {
                    List splashParticles = (List)entry.getValue();
                    splashParticles.stream().map(this::parseParticleSplash).forEach(info.particleSplashs::add);
                    continue block26;
                }
            }
            YamlParser.logUnkownEntry(entry, "Render");
        }
    }

    private void parsePhisProperties(Map.Entry<String, Object> entry, MCH_AircraftInfo info) {
        switch (entry.getKey()) {
            case "Speed": {
                info.speed = YamlParser.getClamped(info.getMaxSpeed(), entry.getValue());
                break;
            }
            case "CanFloat": {
                info.isFloat = (Boolean)entry.getValue();
                break;
            }
            case "FloatOffset": {
                info.floatOffset = -((Number)entry.getValue()).floatValue();
                break;
            }
            case "MotionFactor": {
                info.motionFactor = YamlParser.getClamped(1.0f, entry.getValue());
                break;
            }
            case "Gravity": {
                info.gravity = YamlParser.getClamped(-50.0f, 50.0f, entry.getValue());
                break;
            }
            case "RotationSnapValue": {
                info.autoPilotRot = YamlParser.getClamped(-5.0f, 5.0f, entry.getValue());
                break;
            }
            case "GravityInWater": {
                info.gravityInWater = YamlParser.getClamped(-50.0f, 50.0f, entry.getValue());
                break;
            }
            case "StepHeight": {
                info.stepHeight = YamlParser.getClamped(0.0f, 1000.0f, entry.getValue());
                break;
            }
            case "CanRotOnGround": {
                info.canRotOnGround = (Boolean)entry.getValue();
                break;
            }
            case "CanMoveOnGround": {
                info.canMoveOnGround = (Boolean)entry.getValue();
                break;
            }
            case "OnGroundPitch": {
                info.onGroundPitch = -YamlParser.getClamped(-90.0f, 90.0f, entry.getValue());
                break;
            }
            case "PivotTurnThrottle": {
                info.pivotTurnThrottle = YamlParser.getClamped(1.0f, entry.getValue());
                break;
            }
            case "Mobility": {
                Map mob = (Map)entry.getValue();
                block72: for (Map.Entry<String, Object> entry2 : mob.entrySet()) {
                    switch ((String)entry2.getKey()) {
                        case "Yaw": {
                            info.mobilityYaw = YamlParser.getClamped(100.0f, entry2.getValue());
                            continue block72;
                        }
                        case "Pitch": {
                            info.mobilityPitch = YamlParser.getClamped(100.0f, entry2.getValue());
                            continue block72;
                        }
                        case "Roll": {
                            info.mobilityRoll = YamlParser.getClamped(100.0f, entry2.getValue());
                            continue block72;
                        }
                        case "YawOnGround": {
                            info.mobilityYawOnGround = YamlParser.getClamped(100.0f, entry2.getValue());
                            continue block72;
                        }
                    }
                    YamlParser.logUnkownEntry(entry2, "Mobility");
                }
                break;
            }
            case "GroundPitchFactors": {
                Map factors = (Map)entry.getValue();
                block73: for (Map.Entry<String, Object> entry3 : factors.entrySet()) {
                    switch ((String)entry3.getKey()) {
                        case "Pitch": {
                            info.onGroundPitchFactor = YamlParser.getClamped(0.0f, 180.0f, entry3.getValue());
                            continue block73;
                        }
                        case "Roll": {
                            info.onGroundRollFactor = YamlParser.getClamped(0.0f, 180.0f, entry3.getValue());
                            continue block73;
                        }
                    }
                    YamlParser.logUnkownEntry(entry3, "GroundPitchFactors");
                }
                break;
            }
            case "BodySize": {
                Map factors = (Map)entry.getValue();
                block74: for (Map.Entry<String, Object> entry4 : factors.entrySet()) {
                    switch ((String)entry4.getKey()) {
                        case "Height": {
                            info.bodyHeight = YamlParser.getClamped(0.1f, 1000.0f, entry4.getValue());
                            continue block74;
                        }
                        case "Width": {
                            info.bodyWidth = YamlParser.getClamped(0.1f, 1000.0f, entry4.getValue());
                            continue block74;
                        }
                    }
                    YamlParser.logUnkownEntry(entry4, "GroundPitchFactors");
                }
                break;
            }
            case "RotationLimits": {
                info.limitRotation = true;
                Map rotationLimits = (Map)entry.getValue();
                block75: for (Map.Entry<String, Object> entry5 : rotationLimits.entrySet()) {
                    switch ((String)entry5.getKey()) {
                        case "Pitch": {
                            Map pitchMap = (Map)entry5.getValue();
                            if (pitchMap.containsKey("Min")) {
                                info.minRotationPitch = YamlParser.getClamped(info.getMinRotationPitch(), 0.0f, pitchMap.get("Min"));
                            }
                            if (!pitchMap.containsKey("Max")) continue block75;
                            info.maxRotationPitch = YamlParser.getClamped(0.0f, info.getMaxRotationPitch(), pitchMap.get("Max"));
                            break;
                        }
                        case "Roll": {
                            Map rollMap = (Map)entry5.getValue();
                            if (rollMap.containsKey("Min")) {
                                info.minRotationRoll = YamlParser.getClamped(info.getMinRotationRoll(), 0.0f, rollMap.get("Min"));
                            }
                            if (!rollMap.containsKey("Max")) continue block75;
                            info.maxRotationRoll = YamlParser.getClamped(0.0f, info.getMaxRotationRoll(), rollMap.get("Max"));
                            break;
                        }
                        default: {
                            YamlParser.logUnkownEntry(entry5, "RotationLimits");
                        }
                    }
                }
                break;
            }
            default: {
                YamlParser.logUnkownEntry(entry, "PhysicalProperties");
            }
        }
    }

    private void parseArmor(Map.Entry<String, Object> entry, MCH_AircraftInfo info) {
        switch (entry.getKey()) {
            case "ArmorDamageFactor": {
                info.armorDamageFactor = YamlParser.getClamped(10000.0f, entry.getValue());
                break;
            }
            case "ArmorMinDamage": {
                info.armorMinDamage = YamlParser.getClamped(1000000.0f, entry.getValue());
                break;
            }
            case "ArmorMaxDamage": {
                info.armorMaxDamage = YamlParser.getClamped(1000000.0f, entry.getValue());
                break;
            }
            case "DamageFactor": {
                info.damageFactor = YamlParser.getClamped(1.0f, entry.getValue());
                break;
            }
            case "SubmergedDamageHeight": {
                info.submergedDamageHeight = YamlParser.getClamped(-1000.0f, 1000.0f, entry.getValue());
                break;
            }
            default: {
                YamlParser.logUnkownEntry(entry, "Armor");
            }
        }
    }

    private void parseAircraftFeatures(Map<String, Object> map, MCH_AircraftInfo info) {
        block29: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "GunnerMode": {
                    info.isEnableGunnerMode = (Boolean)entry.getValue();
                    continue block29;
                }
                case "InventorySize": {
                    info.inventorySize = YamlParser.getClamped(54, entry.getValue());
                    continue block29;
                }
                case "NightVision": {
                    info.isEnableNightVision = (Boolean)entry.getValue();
                    continue block29;
                }
                case "EntityRadar": {
                    info.isEnableEntityRadar = (Boolean)entry.getValue();
                    continue block29;
                }
                case "CanReverse": {
                    info.enableBack = (Boolean)entry.getValue();
                    continue block29;
                }
                case "CanRotateOnGround": 
                case "CanRotOnGround": {
                    info.canRotOnGround = (Boolean)entry.getValue();
                    continue block29;
                }
                case "ConcurrentGunner": {
                    info.isEnableConcurrentGunnerMode = (Boolean)entry.getValue();
                    continue block29;
                }
                case "EjectionSeat": {
                    info.isEnableEjectionSeat = (Boolean)entry.getValue();
                    continue block29;
                }
                case "ThrottleUpDown": {
                    info.throttleUpDown = YamlParser.getClamped(3.0f, entry.getValue());
                    continue block29;
                }
                case "ThrottleUpDownEntity": {
                    info.throttleUpDownOnEntity = YamlParser.getClamped(100000.0f, entry.getValue());
                    continue block29;
                }
                case "Parachuting": {
                    this.parseParachuting(entry, info);
                    continue block29;
                }
                case "Flare": {
                    info.flare = this.parseFlare((Map)entry.getValue());
                    continue block29;
                }
            }
            YamlParser.logUnkownEntry(entry, "AircraftFeatures");
        }
    }

    private void parseParachuting(Map.Entry<String, Object> entry, MCH_AircraftInfo info) {
        Object value = entry.getValue();
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            info.isEnableParachuting = bool;
            return;
        }
        if (value instanceof Map) {
            Map parachuteMapRaw = (Map)value;
            info.isEnableParachuting = true;
            block9: for (Map.Entry<String, Object> entry2 : parachuteMapRaw.entrySet()) {
                switch ((String)entry2.getKey()) {
                    case "Pos": 
                    case "Position": {
                        info.mobDropOption.pos = YamlParser.parseVector(entry2.getValue());
                        continue block9;
                    }
                    case "Interval": {
                        info.mobDropOption.interval = ((Number)entry2.getValue()).intValue();
                        continue block9;
                    }
                }
                YamlParser.logUnkownEntry(entry2, "Parachuting");
            }
            return;
        }
        throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseParachuting$1(String.valueOf(value.getClass())));
    }

    private MCH_AircraftInfo.Flare parseFlare(Map<String, Object> value) {
        Vec3d pos = Vec3d.field_186680_a;
        ArrayList<FlareType> flareTypes = new ArrayList<FlareType>();
        block12: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Positions": {
                    pos = YamlParser.parseVector(entry.getValue());
                    break;
                }
                case "Type": 
                case "Types": {
                    ArrayList<String> typeStrings = new ArrayList<String>();
                    Object object = entry.getValue();
                    if (object instanceof String) {
                        String singleType = (String)object;
                        typeStrings.add(singleType);
                    } else {
                        object = entry.getValue();
                        if (object instanceof String[]) {
                            String[] typeArray = (String[])object;
                            typeStrings.addAll(Arrays.asList(typeArray));
                        } else {
                            object = entry.getValue();
                            if (object instanceof List) {
                                List typeList = (List)object;
                                for (Object obj : typeList) {
                                    if (obj instanceof String) {
                                        String s = (String)obj;
                                        typeStrings.add(s);
                                        continue;
                                    }
                                    throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseFlare$1(String.valueOf(obj.getClass())));
                                }
                            } else {
                                throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseFlare$2(String.valueOf(entry.getValue().getClass())));
                            }
                        }
                    }
                    for (String typeRaw : typeStrings) {
                        try {
                            FlareType type = FlareType.valueOf(typeRaw.trim().toUpperCase(Locale.ROOT));
                            flareTypes.add(type);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseFlare$1(typeRaw, Arrays.stream(FlareType.values()).map(Enum::name).collect(Collectors.joining(", "))));
                        }
                    }
                    continue block12;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "Flare");
                }
            }
        }
        if (flareTypes.isEmpty()) {
            flareTypes.add(FlareType.NONE);
        }
        return new MCH_AircraftInfo.Flare(pos, flareTypes.stream().map(FlareType::getLegacyMapping).mapToInt(Integer::intValue).toArray());
    }

    private void parseGlobalCamera(MCH_AircraftInfo info, Map.Entry<String, Object> entry) {
        switch (entry.getKey()) {
            case "ThirdPersonDist": {
                info.thirdPersonDist = YamlParser.getClamped(4.0f, 100.0f, entry.getValue());
                break;
            }
            case "Zoom": 
            case "CameraZoom": {
                info.cameraZoom = YamlParser.getClamped(1, 10, entry.getValue());
                break;
            }
            case "DefaultFreeLook": {
                info.defaultFreelook = (Boolean)entry.getValue();
                break;
            }
            case "RotationSpeed": {
                info.cameraRotationSpeed = YamlParser.getClamped(10000.0f, entry.getValue());
                break;
            }
            case "AlwaysCameraView": {
                info.alwaysCameraView = (Boolean)entry.getValue();
                break;
            }
            case "Pos": 
            case "Positons": {
                List cameraList = (List)entry.getValue();
                info.cameraPosition.addAll(cameraList.stream().map(camera -> this.parseCameraPosition((Map<String, Object>)camera, info)).collect(Collectors.toList()));
                break;
            }
            default: {
                YamlParser.logUnkownEntry(entry, "Camera");
            }
        }
    }

    private MCH_AircraftInfo.Wheel parseWheel(Map<String, Object> map) {
        Vec3d wheelPos = null;
        float scale = 1.0f;
        block9: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    wheelPos = YamlParser.parseVector(entry.getValue());
                    continue block9;
                }
                case "Scale": {
                    scale = ((Number)entry.getValue()).floatValue();
                    continue block9;
                }
            }
            YamlParser.logUnkownEntry(entry, "Wheels");
        }
        if (wheelPos == null) {
            throw new IllegalArgumentException("Wheel must have a position!");
        }
        return new MCH_AircraftInfo.Wheel(wheelPos, scale);
    }

    private void parseRideRacks(Map<String, Integer> map, MCH_AircraftInfo info) {
        map.entrySet().forEach(stringIntegerEntry -> {
            if (((String)stringIntegerEntry.getKey()).isEmpty()) {
                throw new IllegalArgumentException("RideRack vehicle entry cannot be empty!");
            }
            if ((Integer)stringIntegerEntry.getValue() < 0) {
                throw new IllegalArgumentException("RideRack rackID cannot be negative!");
            }
            info.rideRacks.add(new MCH_AircraftInfo.RideRack((String)stringIntegerEntry.getKey(), (Integer)stringIntegerEntry.getValue()));
        });
    }

    private void parseSeatRackInfo(Map<String, Object> map, MCH_AircraftInfo info, int seatCount, int rackCount) {
        Vec3d position = null;
        MCH_AircraftInfo.CameraPosition cameraPos = null;
        String[] entityNames = new String[]{};
        float range = 0.0f;
        float openParaAlt = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        boolean rotSeat = false;
        ArrayList<Integer> exclusionList = null;
        block25: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    position = YamlParser.parseVector(entry.getValue());
                    break;
                }
                case "Camera": 
                case "Cam": {
                    cameraPos = this.parseCameraPosition((Map)entry.getValue());
                    break;
                }
                case "Names": 
                case "Name": {
                    Object values2 = entry.getValue();
                    if (values2 instanceof List) {
                        List list = (List)values2;
                        entityNames = list.toArray(new String[0]);
                        break;
                    }
                    if (values2 instanceof String[]) {
                        String[] array = (String[])values2;
                        entityNames = array;
                        break;
                    }
                    if (values2 instanceof String) {
                        String name = (String)values2;
                        entityNames = new String[]{name};
                        break;
                    }
                    throw new IllegalArgumentException("Rack name must be a string, array or list!");
                }
                case "Range": {
                    range = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "OpenParaAlt": {
                    openParaAlt = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Yaw": {
                    yaw = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Pitch": {
                    pitch = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "RotSeat": {
                    rotSeat = (Boolean)entry.getValue();
                    break;
                }
                case "ExcludeWith": {
                    List rackYaml;
                    exclusionList = new ArrayList<Integer>();
                    Map exclusionMap = (Map)entry.getValue();
                    List seatYaml = (List)exclusionMap.get("Seats");
                    if (seatYaml != null) {
                        for (Integer n : seatYaml) {
                            int idx0;
                            if (n == null || (idx0 = n - 1) < 0) continue;
                            exclusionList.add(idx0);
                        }
                    }
                    if ((rackYaml = (List)exclusionMap.get("Racks")) == null) continue block25;
                    for (Integer n : rackYaml) {
                        int idx0;
                        if (n == null || (idx0 = seatCount + (n - 1)) < seatCount) continue;
                        exclusionList.add(idx0);
                    }
                    continue block25;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "Racks");
                }
            }
        }
        if (position == null) {
            throw new IllegalArgumentException("Seat rack must have a position!");
        }
        if (cameraPos == null) {
            throw new IllegalArgumentException("Seat rack must have a camera position!");
        }
        info.entityRackList.add(new MCH_SeatRackInfo(entityNames, position.field_72450_a, position.field_72448_b, position.field_72449_c, cameraPos, range, openParaAlt, yaw, pitch, rotSeat));
        int rackIndex0 = info.entityRackList.size() - 1;
        if (exclusionList != null) {
            for (Integer t : exclusionList) {
                if (t == null) continue;
                info.exclusionSeatList.add(new Integer[]{seatCount + rackIndex0, t});
            }
        }
    }

    private MCH_AircraftInfo.ParticleSplash parseParticleSplash(Map<String, Object> map) {
        Vec3d pos = null;
        int num = 2;
        float acceleration = 1.0f;
        float size = 2.0f;
        int age = 80;
        float motionY = 0.01f;
        float gravity = 0.0f;
        block20: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    pos = YamlParser.parseVector(entry.getValue());
                    continue block20;
                }
                case "Count": {
                    num = YamlParser.getClamped(1, 100, entry.getValue());
                    continue block20;
                }
                case "Size": {
                    size = ((Number)entry.getValue()).floatValue();
                    continue block20;
                }
                case "Accel": 
                case "Acceleration": {
                    acceleration = ((Number)entry.getValue()).floatValue();
                    continue block20;
                }
                case "Age": {
                    age = YamlParser.getClamped(1, 100000, entry.getValue());
                    continue block20;
                }
                case "Motion": {
                    motionY = ((Number)entry.getValue()).floatValue();
                    continue block20;
                }
                case "Gravity": {
                    gravity = ((Number)entry.getValue()).floatValue();
                    continue block20;
                }
            }
            YamlParser.logUnkownEntry(entry, "SplashParticles");
        }
        if (pos == null) {
            throw new IllegalArgumentException("Splash particle must have a position!");
        }
        return new MCH_AircraftInfo.ParticleSplash(num, acceleration, size, pos, age, motionY, gravity);
    }

    private MCH_AircraftInfo.CameraPosition parseCameraPosition(Map<String, Object> map, MCH_AircraftInfo info) {
        Vec3d pos = Vec3d.field_186680_a;
        boolean fixRot = false;
        float yaw = 0.0f;
        float pitch = 0.0f;
        block13: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    pos = YamlParser.parseVector(entry.getValue());
                    continue block13;
                }
                case "FixedRot": {
                    fixRot = (Boolean)entry.getValue();
                    continue block13;
                }
                case "Yaw": {
                    yaw = ((Number)entry.getValue()).floatValue();
                    continue block13;
                }
                case "Pitch": {
                    pitch = ((Number)entry.getValue()).floatValue();
                    continue block13;
                }
            }
            YamlParser.logUnkownEntry(entry, "CameraPosition");
        }
        return new MCH_AircraftInfo.CameraPosition(pos, fixRot, yaw, pitch);
    }

    private MCH_AircraftInfo.CameraPosition parseCameraPosition(Map<String, Object> map) {
        return this.parseCameraPosition(map, null);
    }

    private void parseWeapon(Map<String, Object> map, MCH_AircraftInfo info) {
        String type = null;
        Vec3d pos = Vec3d.field_186680_a;
        float yaw = 0.0f;
        float pitch = 0.0f;
        boolean canUsePilot = true;
        int seatID = 0;
        float dfy = 0.0f;
        float mny = 0.0f;
        float mxy = 0.0f;
        float mnp = 0.0f;
        float mxp = 0.0f;
        boolean turret = false;
        block30: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Type": 
                case "WeaponType": {
                    type = ((String)entry.getValue()).toLowerCase();
                    continue block30;
                }
                case "Pos": 
                case "Position": {
                    pos = YamlParser.parseVector(entry.getValue());
                    continue block30;
                }
                case "Yaw": {
                    yaw = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "Pitch": {
                    pitch = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "CanUsePilot": {
                    canUsePilot = (Boolean)entry.getValue();
                    continue block30;
                }
                case "SeatID": {
                    seatID = ((Number)entry.getValue()).intValue();
                    continue block30;
                }
                case "DefaultYaw": {
                    dfy = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "MinYaw": {
                    mny = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "MaxYaw": {
                    mxy = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "MinPitch": {
                    mnp = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "MaxPitch": {
                    mxp = ((Number)entry.getValue()).floatValue();
                    continue block30;
                }
                case "Turret": {
                    turret = (Boolean)entry.getValue();
                    continue block30;
                }
            }
            YamlParser.logUnkownEntry(entry, "Weapon");
        }
        if (type == null || !MCH_WeaponInfoManager.contains(type)) {
            throw new IllegalArgumentException(YamlParser.jvmdowngrader$concat$parseWeapon$1(type));
        }
        if (seatID <= 0) {
            canUsePilot = true;
        }
        dfy = MathHelper.func_76142_g((float)dfy);
        seatID = Math.max(0, seatID - 1);
        MCH_AircraftInfo.Weapon weapon = new MCH_AircraftInfo.Weapon(info, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, yaw, pitch, canUsePilot, seatID, dfy, mny, mxy, mnp, mxp, turret);
        MCH_AircraftInfo.WeaponSet set = info.getOrCreateWeaponSet(type);
        set.weapons.add(weapon);
    }

    private void parseSeatInfo(Map<String, Object> map, MCH_AircraftInfo info, int seatCount) {
        Vec3d position = null;
        boolean isGunner = false;
        boolean canSwitchGunner = false;
        boolean hasFixedRotation = false;
        float fixedYaw = 0.0f;
        float fixedPitch = 0.0f;
        float minPitch = -30.0f;
        float maxPitch = 70.0f;
        boolean rotatableSeat = false;
        boolean invertCameraPos = false;
        MCH_AircraftInfo.CameraPosition cameraPos = null;
        String hudName = "none";
        ArrayList<Integer> exclusionList = null;
        block32: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    position = YamlParser.parseVector(entry.getValue());
                    break;
                }
                case "Gunner": {
                    isGunner = (Boolean)entry.getValue();
                    break;
                }
                case "SwitchGunner": {
                    canSwitchGunner = (Boolean)entry.getValue();
                    break;
                }
                case "FixRot": {
                    hasFixedRotation = (Boolean)entry.getValue();
                    break;
                }
                case "FixYaw": {
                    fixedYaw = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "FixPitch": {
                    fixedPitch = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "MinPitch": {
                    minPitch = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "MaxPitch": {
                    maxPitch = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "RotSeat": {
                    rotatableSeat = (Boolean)entry.getValue();
                    break;
                }
                case "InvCamPos": {
                    invertCameraPos = (Boolean)entry.getValue();
                    break;
                }
                case "Hud": {
                    hudName = ((String)entry.getValue()).toLowerCase(Locale.ROOT).trim();
                    break;
                }
                case "Camera": 
                case "Cam": {
                    cameraPos = this.parseCameraPosition((Map)entry.getValue());
                    break;
                }
                case "ExcludeWith": {
                    List rackYaml;
                    exclusionList = new ArrayList<Integer>();
                    Map exclusionMap = (Map)entry.getValue();
                    List seatYaml = (List)exclusionMap.get("Seats");
                    if (seatYaml != null) {
                        for (Integer n : seatYaml) {
                            int idx0;
                            if (n == null || (idx0 = n - 1) < 0) continue;
                            exclusionList.add(idx0);
                        }
                    }
                    if ((rackYaml = (List)exclusionMap.get("Racks")) == null) continue block32;
                    for (Integer n : rackYaml) {
                        int idx0;
                        if (n == null || (idx0 = seatCount + (n - 1)) < seatCount) continue;
                        exclusionList.add(idx0);
                    }
                    continue block32;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "Seats");
                }
            }
        }
        if (position == null) {
            throw new IllegalArgumentException("Seat must have a position!");
        }
        info.seatList.add(new MCH_SeatInfo(position, isGunner, cameraPos, invertCameraPos, canSwitchGunner, hasFixedRotation, fixedYaw, fixedPitch, minPitch, maxPitch, rotatableSeat));
        if (MCH_MOD.proxy.isRemote()) {
            info.hudList.add(MCH_HudManager.get(hudName) != null ? MCH_HudManager.get(hudName) : MCH_Hud.NoDisp);
        }
        int seatIndex0 = info.seatList.size() - 1;
        if (exclusionList != null) {
            for (Integer t : exclusionList) {
                if (t == null) continue;
                info.exclusionSeatList.add(new Integer[]{seatIndex0, t});
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$logUnkownEntry$1(String string, String string2) {
        return "Uknown argument:" + string + " for " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseHexColor$1(String string) {
        return "0x" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseVector$1(int n) {
        return "Vector list must have exactly 3 elements, got " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseVector$1(String string) {
        return "Unsupported vector value type: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$asDouble$1(String string) {
        return "Vector component must be numeric, got: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseTankFeat$1(String string, String string2) {
        return "Invalid Weight type: " + string + ". Allowed values: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseBoxes$1(String string, String string2) {
        return "Invalid bounding box type: " + string + ". Allowed values: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseSoundEffect$1(String string) {
        return "Unsupported sound effect type: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseParachuting$1(String string) {
        return "Parachuting type must be a boolean or map, got: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseFlare$1(String string) {
        return "Flare type must be a string, got: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseFlare$2(String string) {
        return "Unsupported type value: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseFlare$1(String string, String string2) {
        return "Invalid flare type: " + string + ". Allowed values: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseWeapon$1(String string) {
        return "Weapon " + string + " type is unknown or missing!";
    }

    @NestHost(value=YamlParser.class)
    public static enum TankWeight {
        UNKNOWN,
        CAR,
        TANK;

    }

    @NestHost(value=YamlParser.class)
    public static enum FlareType {
        NONE(0),
        NORMAL(1),
        LARGE_AIRCRAFT(2),
        SIDE(3),
        FRONT(4),
        DOWN(5),
        SMOKE_LAUNCHER(10);

        final byte legacyMapping;

        private FlareType(int legacyMapping) {
            this.legacyMapping = (byte)legacyMapping;
        }

        public int getLegacyMapping() {
            return this.legacyMapping;
        }
    }
}

