/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info.parsers.yaml;

import com.norwood.mcheli.MCH_Color;
import com.norwood.mcheli.MCH_DamageFactor;
import com.norwood.mcheli.compat.hbm.MistContainer;
import com.norwood.mcheli.compat.hbm.MukeContainer;
import com.norwood.mcheli.compat.hbm.NTSettingContainer;
import com.norwood.mcheli.compat.hbm.VNTSettingContainer;
import com.norwood.mcheli.helicopter.MCH_EntityHeli;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.info.parsers.yaml.YamlParser;
import com.norwood.mcheli.plane.MCH_EntityPlane;
import com.norwood.mcheli.ship.MCH_EntityShip;
import com.norwood.mcheli.tank.MCH_EntityTank;
import com.norwood.mcheli.vehicle.MCH_EntityVehicle;
import com.norwood.mcheli.weapon.MCH_Cartridge;
import com.norwood.mcheli.weapon.MCH_SightType;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class WeaponParser {
    private WeaponParser() {
    }

    private static MCH_WeaponInfo.Payload parsePayload(String s) {
        MCH_WeaponInfo.Payload payload;
        if (s == null || s.isEmpty()) {
            return MCH_WeaponInfo.Payload.NONE;
        }
        switch (s.trim().toUpperCase(Locale.ROOT)) {
            case "NTM_VNT": 
            case "VNT": {
                payload = MCH_WeaponInfo.Payload.NTM_VNT;
                break;
            }
            case "NTM_NT": 
            case "NT": {
                payload = MCH_WeaponInfo.Payload.NTM_NT;
                break;
            }
            case "NTM_NUKE": 
            case "NUKE": {
                payload = MCH_WeaponInfo.Payload.NTM_NUKE;
                break;
            }
            case "NTM_MININUKE": 
            case "MININUKE": {
                payload = MCH_WeaponInfo.Payload.NTM_MINI_NUKE;
                break;
            }
            case "CHEMICAL": 
            case "NTM_CHEMICAL": {
                payload = MCH_WeaponInfo.Payload.NTM_CHEMICAL;
                break;
            }
            case "NTM_MIST": 
            case "MIST": {
                payload = MCH_WeaponInfo.Payload.NTM_MIST;
                break;
            }
            default: {
                payload = MCH_WeaponInfo.Payload.NONE;
            }
        }
        return payload;
    }

    @Nullable
    private static Class<? extends Entity> tryLoadClass(String fullClassName) {
        try {
            Class<?> clazz = Class.forName(fullClassName);
            if (Entity.class.isAssignableFrom(clazz)) {
                return clazz.asSubclass(Entity.class);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static MCH_WeaponInfo parse(MCH_WeaponInfo info, Map<String, Object> root) {
        block65: for (Map.Entry<String, Object> entry : root.entrySet()) {
            switch (entry.getKey()) {
                case "DisplayName": {
                    info.displayName = ((String)entry.getValue()).trim();
                    continue block65;
                }
                case "BaseDamage": {
                    info.power = ((Number)entry.getValue()).intValue();
                    continue block65;
                }
                case "Ballistics": {
                    WeaponParser.parseBallisitcs(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Camera": {
                    WeaponParser.parseCam(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Missile": {
                    WeaponParser.parseMissile(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Sound": {
                    WeaponParser.parseSound(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Type": {
                    info.type = ((String)entry.getValue()).trim().toLowerCase(Locale.ROOT);
                    continue block65;
                }
                case "Recoil": {
                    WeaponParser.parseRecoil(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Submunition": 
                case "Bomblet": {
                    WeaponParser.parseBomblet(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Damage": {
                    WeaponParser.parseDamage(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Ammo": {
                    WeaponParser.parseAmmo(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Render": {
                    WeaponParser.parseRender(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Explosion": {
                    WeaponParser.parseExplosion(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Mode": {
                    info.modeNum = YamlParser.getClamped(1000, entry.getValue());
                    continue block65;
                }
                case "FixMode": {
                    info.fixMode = YamlParser.getClamped(10, entry.getValue());
                    continue block65;
                }
                case "Group": {
                    info.group = ((String)entry.getValue()).toLowerCase(Locale.ROOT).trim();
                    continue block65;
                }
                case "FireCooldown": {
                    info.delay = ((Number)entry.getValue()).intValue();
                    continue block65;
                }
                case "CanLoadChunks": {
                    info.enableChunkLoader = (Boolean)entry.getValue();
                    continue block65;
                }
                case "SwitchCooldown": {
                    info.weaponSwitchCount = ((Number)entry.getValue()).intValue();
                    continue block65;
                }
                case "CrossType": {
                    info.crossType = ((Number)entry.getValue()).intValue();
                    continue block65;
                }
                case "RidableOnly": {
                    info.ridableOnly = (Boolean)entry.getValue();
                    continue block65;
                }
                case "Accuracy": {
                    info.accuracy = YamlParser.getClamped(0.0f, 1000.0f, entry.getValue());
                    continue block65;
                }
                case "SelfDestruct": {
                    info.destruct = (Boolean)entry.getValue();
                    continue block65;
                }
                case "DispenseItem": {
                    WeaponParser.parseDispenseItem(info, (Map)entry.getValue());
                    continue block65;
                }
                case "Length": {
                    info.length = YamlParser.getClamped(1, 300, entry.getValue());
                    continue block65;
                }
                case "Radius": {
                    info.radius = YamlParser.getClamped(1, 1000, entry.getValue());
                    continue block65;
                }
                case "Target": {
                    info.target = WeaponParser.parseTarget((String)entry.getValue());
                    continue block65;
                }
                case "MarkTime": {
                    info.markTime = YamlParser.getClamped(1, 30000, entry.getValue()) + 1;
                    continue block65;
                }
                case "DamageFactor": {
                    WeaponParser.parseDamageFactor(info, (Map)entry.getValue());
                    continue block65;
                }
                case "NTM": {
                    WeaponParser.parseHBM(info, (Map)entry.getValue());
                    continue block65;
                }
            }
            YamlParser.logUnkownEntry(entry, "Weapon");
        }
        return info;
    }

    private static void parseAmmo(MCH_WeaponInfo info, Map<String, Object> map) {
        block14: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "ReloadTime": {
                    info.reloadTime = YamlParser.getClamped(3, 1000, entry.getValue());
                    continue block14;
                }
                case "MagSize": {
                    info.round = YamlParser.getClamped(1, 30000, entry.getValue());
                    continue block14;
                }
                case "MaxAmmo": {
                    info.maxAmmo = YamlParser.getClamped(30000, entry.getValue());
                    continue block14;
                }
                case "ResupplyCount": {
                    info.suppliedNum = YamlParser.getClamped(1, 30000, entry.getValue());
                    continue block14;
                }
                case "AmmoItems": {
                    info.roundItems = ((List)entry.getValue()).stream().map(WeaponParser::parseRoundMap).collect(Collectors.toList());
                    continue block14;
                }
            }
            YamlParser.logUnkownEntry(entry, "Ammo");
        }
    }

    private static void parseRadar(MCH_WeaponInfo info, Map<String, Object> map) {
        block10: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "IsRadarMissile": {
                    info.isRadarMissile = (Boolean)entry.getValue();
                    continue block10;
                }
                case "ActiveRadar": {
                    info.activeRadar = (Boolean)entry.getValue();
                    continue block10;
                }
                case "PassiveRadar": {
                    info.passiveRadar = (Boolean)entry.getValue();
                    continue block10;
                }
            }
            YamlParser.logUnkownEntry(entry, "Radar");
        }
    }

    private static void parseMissile(MCH_WeaponInfo info, Map<String, Object> map) {
        block40: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "MarkerRocket": {
                    WeaponParser.parseMarkerRocket(info, (Map)entry.getValue());
                    continue block40;
                }
                case "LaserGuidance": {
                    info.laserGuidance = (Boolean)entry.getValue();
                    continue block40;
                }
                case "HasLaserGuidancePod": {
                    info.hasLaserGuidancePod = (Boolean)entry.getValue();
                    continue block40;
                }
                case "IsOffAxis": {
                    info.enableOffAxis = (Boolean)entry.getValue();
                    continue block40;
                }
                case "GuidedTorpedo": {
                    info.isGuidedTorpedo = (Boolean)entry.getValue();
                    continue block40;
                }
                case "PredictTargetPos": {
                    info.predictTargetPos = (Boolean)entry.getValue();
                    continue block40;
                }
                case "EnableBVR": {
                    info.enableBVR = (Boolean)entry.getValue();
                    continue block40;
                }
                case "MinRangeBVR": {
                    info.minRangeBVR = ((Number)entry.getValue()).intValue();
                    continue block40;
                }
                case "ScanInterval": {
                    info.scanInterval = ((Number)entry.getValue()).intValue();
                    continue block40;
                }
                case "TickEndHoming": {
                    info.tickEndHoming = YamlParser.getClamped(-1, 100000, entry.getValue());
                    continue block40;
                }
                case "PDHDNMaxDegree": {
                    info.pdHDNMaxDegree = YamlParser.getClamped(-1.0f, 90.0f, entry.getValue());
                    continue block40;
                }
                case "PDHDNMaxDegreeLockOutCount": {
                    info.pdHDNMaxDegreeLockOutCount = YamlParser.getClamped(200, entry.getValue());
                    continue block40;
                }
                case "TurningFactor": {
                    info.turningFactor = ((Number)entry.getValue()).doubleValue();
                    continue block40;
                }
                case "MaxDegreeOfMissile": {
                    info.maxDegreeOfMissile = YamlParser.getClamped(100000, entry.getValue());
                    continue block40;
                }
                case "Heat": {
                    WeaponParser.parseHeat(info, (Map)entry.getValue());
                    continue block40;
                }
                case "CanBeIntercepted": {
                    info.canBeIntercepted = (Boolean)entry.getValue();
                    continue block40;
                }
                case "LockOn": {
                    WeaponParser.parseLockOn(info, (Map)entry.getValue());
                    continue block40;
                }
                case "Radar": {
                    WeaponParser.parseRadar(info, (Map)entry.getValue());
                    continue block40;
                }
            }
            YamlParser.logUnkownEntry(entry, "Missile");
        }
    }

    private static void parseLockOn(MCH_WeaponInfo info, Map<String, Object> map) {
        block20: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "CanLockMissile": {
                    info.canLockMissile = (Boolean)entry.getValue();
                    continue block20;
                }
                case "Time": {
                    info.lockTime = YamlParser.getClamped(0, 1000, entry.getValue());
                    continue block20;
                }
                case "Delay": {
                    info.rigidityTime = YamlParser.getClamped(0, 1000000, entry.getValue());
                    continue block20;
                }
                case "MaxRange": {
                    info.maxLockOnRange = YamlParser.getClamped(2000, entry.getValue());
                    continue block20;
                }
                case "MaxAngle": {
                    info.maxLockOnAngle = YamlParser.getClamped(200, entry.getValue());
                    continue block20;
                }
                case "MinHeight": {
                    info.lockMinHeight = YamlParser.getClamped(-1, 100, entry.getValue());
                    continue block20;
                }
                case "PassiveRadarLockOutCount": {
                    info.passiveRadarLockOutCount = YamlParser.getClamped(200, entry.getValue());
                    continue block20;
                }
                case "LockedChaffMax": {
                    info.numLockedChaffMax = ((Number)entry.getValue()).intValue();
                    continue block20;
                }
            }
            YamlParser.logUnkownEntry(entry, "LockOn");
        }
    }

    private static void parseHeat(MCH_WeaponInfo info, Map<String, Object> map) {
        block12: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "isHeatMissile": {
                    info.isHeatSeekerMissile = (Boolean)entry.getValue();
                    continue block12;
                }
                case "HeatCount": {
                    info.heatCount = YamlParser.getClamped(100000, entry.getValue());
                    continue block12;
                }
                case "MaxHeatCount": {
                    info.maxHeatCount = YamlParser.getClamped(100000, entry.getValue());
                    continue block12;
                }
                case "AntiFlareCount": {
                    info.antiFlareCount = YamlParser.getClamped(-1, 200, entry.getValue());
                    continue block12;
                }
            }
            YamlParser.logUnkownEntry(entry, "Heat");
        }
    }

    private static void parseExplosion(MCH_WeaponInfo info, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Power": {
                    info.explosion = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "Type": {
                    info.explosionType = (String)entry.getValue();
                    break;
                }
                case "ProximityFuseDist": {
                    info.proximityFuseDist = YamlParser.getClamped(0.0f, 2000.0f, entry.getValue());
                    break;
                }
                case "DestructionPower": {
                    info.explosionBlock = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "PowerUnderwater": {
                    info.explosionInWater = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "ExplosionAltitude": {
                    info.explosionAltitude = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "FuseRebound": {
                    info.bound = YamlParser.getClamped(0.0f, 100000.0f, entry.getValue());
                    break;
                }
                case "FuseTime": {
                    info.timeFuse = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "FuseDelay": {
                    info.delayFuse = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "CanAirburst": {
                    info.canAirburst = (Boolean)entry.getValue();
                    break;
                }
                case "ExplosionAirburst": {
                    info.explosionAirburst = YamlParser.getClamped(50, entry.getValue());
                    break;
                }
                case "Flaming": {
                    info.flaming = (Boolean)entry.getValue();
                    break;
                }
                case "FAE": 
                case "FuelAir": {
                    info.isFAE = (Boolean)entry.getValue();
                    break;
                }
                case "CanDestroyBlocks": {
                    info.disableDestroyBlock = (Boolean)entry.getValue() == false;
                }
            }
        }
    }

    private static void parseDispenseItem(MCH_WeaponInfo info, Map<String, Object> value) {
        String loc = ((String)MCH_Utils.getAny(value, Arrays.asList("Location", "Loc", "Name"), null)).toLowerCase().trim();
        if (loc == null || !loc.isEmpty()) {
            // empty if block
        }
        info.dispenseItemLoc = loc;
        info.dispenseDamege = ((Number)MCH_Utils.getAny(value, Arrays.asList("Meta", "Damage"), 0)).intValue();
        if (value.containsKey("DispenseRange")) {
            info.dispenseRange = YamlParser.getClamped(1, 100, value.get("DispenseRange"));
        }
    }

    private static void parseBomblet(MCH_WeaponInfo info, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Count": {
                    info.bomblet = YamlParser.getClamped(0, 1000, entry.getValue());
                    break;
                }
                case "DeployTime": {
                    info.bombletSTime = YamlParser.getClamped(0, 1000, entry.getValue());
                    break;
                }
                case "Spread": {
                    info.bombletDiff = YamlParser.getClamped(0.0f, 1000.0f, entry.getValue());
                }
            }
        }
    }

    private static void parseCam(MCH_WeaponInfo info, Map<String, Object> value) {
        block18: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "EnableMortarRadar": {
                    info.hasMortarRadar = (Boolean)entry.getValue();
                    break;
                }
                case "MortarRadarMaxDist": {
                    info.mortarRadarMaxDist = ((Number)entry.getValue()).doubleValue();
                    break;
                }
                case "DisplayMortarDistance": {
                    info.displayMortarDistance = (Boolean)entry.getValue();
                    break;
                }
                case "FixPitch": {
                    info.fixCameraPitch = (Boolean)entry.getValue();
                    break;
                }
                case "RotationSpeedPitch": {
                    info.cameraRotationSpeedPitch = YamlParser.getClamped(0.0f, 100.0f, entry.getValue());
                    break;
                }
                case "Sight": {
                    String sight = ((String)entry.getValue()).toLowerCase(Locale.ROOT);
                    if (sight.equals("movesight")) {
                        info.sight = MCH_SightType.ROCKET;
                        break;
                    }
                    if (!sight.equals("missilesight")) continue block18;
                    info.sight = MCH_SightType.LOCK;
                    break;
                }
                case "Zoom": {
                    List list;
                    Object val = entry.getValue();
                    if (val instanceof List && !(list = (List)val).isEmpty()) {
                        float[] zoomArray = new float[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            zoomArray[i] = YamlParser.getClamped(10.0f, list.get(i));
                        }
                        info.zoom = zoomArray;
                        break;
                    }
                    if (val instanceof Number) {
                        Number num = (Number)val;
                        info.zoom = new float[]{num.floatValue()};
                        break;
                    }
                    throw new IllegalArgumentException("Zoom must be either a number or a list of numbers!");
                }
            }
        }
    }

    private static int parseTarget(String str) {
        str = str.toLowerCase(Locale.ROOT);
        int flags = 0;
        if (str.contains("block")) {
            return 64;
        }
        if (str.contains("planes")) {
            flags |= 0x20;
        }
        if (str.contains("helicopters")) {
            flags |= 0x10;
        }
        if (str.contains("vehicles") || str.contains("tanks")) {
            flags |= 8;
        }
        if (str.contains("players")) {
            flags |= 4;
        }
        if (str.contains("monsters")) {
            flags |= 2;
        }
        if (str.contains("others")) {
            flags |= 1;
        }
        return flags;
    }

    private static void parseDamageFactor(MCH_WeaponInfo info, Map<String, Number> map) {
        HashMap<Class, Integer> damageFactorMap = new HashMap<Class, Integer>();
        for (Map.Entry<String, Number> entry : map.entrySet()) {
            Class clazz;
            switch (entry.getKey()) {
                case "Player": {
                    Class clazz2 = EntityPlayer.class;
                    break;
                }
                case "Heli": 
                case "Helicopter": {
                    Class clazz2 = MCH_EntityHeli.class;
                    break;
                }
                case "Plane": {
                    Class clazz2 = MCH_EntityPlane.class;
                    break;
                }
                case "Ship": {
                    Class clazz2 = MCH_EntityShip.class;
                    break;
                }
                case "Tank": {
                    Class clazz2 = MCH_EntityTank.class;
                    break;
                }
                case "Vehicle": {
                    Class clazz2 = MCH_EntityVehicle.class;
                    break;
                }
                default: {
                    Class clazz2 = clazz = WeaponParser.tryLoadClass(entry.getKey());
                }
            }
            if (clazz == null) continue;
            damageFactorMap.put(clazz, entry.getValue().intValue());
        }
        if (!damageFactorMap.isEmpty()) {
            info.damageFactor = new MCH_DamageFactor();
            damageFactorMap.forEach(info.damageFactor::add);
        }
    }

    private static MCH_Cartridge parseCardridge(Map<String, Object> map) {
        String name = null;
        float accel = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        float gravity = -0.04f;
        float bound = 0.5f;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Name": {
                    name = ((String)entry.getValue()).toLowerCase();
                    break;
                }
                case "Accel": 
                case "Acceleration": {
                    accel = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Yaw": {
                    yaw = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Pitch": {
                    pitch = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Scale": {
                    scale = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Gravity": {
                    gravity = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Bound": {
                    bound = ((Number)entry.getValue()).floatValue();
                }
            }
        }
        return new MCH_Cartridge(name, accel, yaw, pitch, bound, gravity, scale);
    }

    private static void parseRender(MCH_WeaponInfo info, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "MuzzleFlashes": {
                    info.listMuzzleFlash = WeaponParser.parseMuzzleFlashes((List)entry.getValue());
                    break;
                }
                case "MuzzleSmoke": {
                    info.listMuzzleFlashSmoke = WeaponParser.parseMuzzleFlashes((List)entry.getValue());
                    break;
                }
                case "BulletModel": {
                    info.bulletModelName = ((String)entry.getValue()).trim().toLowerCase();
                    break;
                }
                case "BombletModel": {
                    info.bombletModelName = ((String)entry.getValue()).trim().toLowerCase();
                    break;
                }
                case "TrajectoryParticle": {
                    String rawString = ((String)entry.getValue()).trim().toLowerCase();
                    info.trajectoryParticleName = "none".equals(rawString) ? "" : rawString;
                    break;
                }
                case "Smoke": {
                    WeaponParser.parseSmoke(info, (Map)entry.getValue());
                    break;
                }
                case "TrajectoryParticleStartTick": {
                    info.trajectoryParticleStartTick = YamlParser.getClamped(10000, entry.getValue());
                    break;
                }
                case "FlakParticlesCrack": {
                    info.flakParticlesCrack = YamlParser.getClamped(300, entry.getValue());
                    break;
                }
                case "ParticlesFlak": {
                    info.numParticlesFlak = YamlParser.getClamped(100, entry.getValue());
                    break;
                }
                case "SpentCasings": {
                    info.cartridge = WeaponParser.parseCardridge((Map)entry.getValue());
                }
            }
        }
    }

    private static void parseSmoke(MCH_WeaponInfo info, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "DisableSmoke": {
                    info.disableSmoke = (Boolean)entry.getValue();
                    break;
                }
                case "SmokeSize": {
                    info.smokeSize = YamlParser.getClamped(0.0f, 100.0f, entry.getValue());
                    break;
                }
                case "SmokeNum": {
                    info.smokeNum = YamlParser.getClamped(1, 100, entry.getValue());
                    break;
                }
                case "SmokeMaxAge": {
                    info.smokeMaxAge = YamlParser.getClamped(2, 1000, entry.getValue());
                    break;
                }
                case "BulletColorInWater": {
                    info.colorInWater = new MCH_Color(YamlParser.parseHexColor((String)entry.getValue()));
                    break;
                }
                case "BulletColor": {
                    info.color = new MCH_Color(YamlParser.parseHexColor((String)entry.getValue()));
                }
            }
        }
    }

    private static List<MCH_WeaponInfo.MuzzleFlash> parseMuzzleFlashes(List<Map<String, Object>> rawList) {
        if (rawList == null) {
            return Collections.emptyList();
        }
        return rawList.stream().map(map -> {
            MCH_WeaponInfo.MuzzleFlashRaw rawFlash = new MCH_WeaponInfo.MuzzleFlashRaw();
            rawFlash.setDistance(((Number)map.get("Distance")).floatValue());
            rawFlash.setSize(((Number)map.get("Size")).floatValue());
            rawFlash.setRange(((Number)map.get("Range")).floatValue());
            rawFlash.setAge(((Number)map.get("Age")).intValue());
            rawFlash.setCount(((Number)map.get("Count")).intValue());
            rawFlash.setColor((String)map.get("Color"));
            return rawFlash;
        }).map(MCH_WeaponInfo.MuzzleFlash::new).collect(Collectors.toList());
    }

    private static void parseHBM(MCH_WeaponInfo info, Map<String, Object> map) {
        info.useHBM = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            block10 : switch (entry.getKey()) {
                case "PayloadType": 
                case "Type": {
                    info.payloadNTM = WeaponParser.parsePayload((String)entry.getValue());
                    break;
                }
                case "EffectOnly": {
                    info.effectOnly = (Boolean)entry.getValue();
                    break;
                }
                case "Mist": {
                    WeaponParser.parseMist(info, (Map)entry.getValue());
                    break;
                }
                case "MiniNuke": 
                case "Muke": {
                    Object muke = entry.getValue();
                    if (muke instanceof String) {
                        String mukeString = (String)muke;
                        switch (mukeString.toUpperCase().trim()) {
                            case "SAFE": {
                                info.mukeContainer = MukeContainer.PARAMS_SAFE;
                                break block10;
                            }
                            case "TOTS": {
                                info.mukeContainer = MukeContainer.PARAMS_TOTS;
                                break block10;
                            }
                            case "LOW": {
                                info.mukeContainer = MukeContainer.PARAMS_LOW;
                                break block10;
                            }
                            case "MEDIUM": {
                                info.mukeContainer = MukeContainer.PARAMS_MEDIUM;
                                break block10;
                            }
                            case "HIGH": {
                                info.mukeContainer = MukeContainer.PARAMS_HIGH;
                                break block10;
                            }
                        }
                        throw new IllegalArgumentException(WeaponParser.jvmdowngrader$concat$parseHBM$1(mukeString));
                    }
                    if (muke instanceof Map) {
                        Map mukeMap = (Map)muke;
                        WeaponParser.parseMukeContainer(info, mukeMap);
                        break;
                    }
                    throw new IllegalArgumentException(WeaponParser.jvmdowngrader$concat$parseHBM$2(muke.getClass().getName()));
                }
                case "VNT": {
                    WeaponParser.parseVNT(info, (Map)entry.getValue());
                    break;
                }
                case "NT": {
                    WeaponParser.parseNTExplosion(info, (Map)entry.getValue());
                    break;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "NTM");
                }
            }
        }
    }

    private static void parseVNT(MCH_WeaponInfo info, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Attributes": {
                    info.vntSettingContainer = new VNTSettingContainer((Map)entry.getValue());
                    break;
                }
                case "Effect": {
                    Map vntMapRaw;
                    Object object = entry.getValue();
                    if (object instanceof String) {
                        VNTSettingContainer.ExplosionEffect explosionEffect;
                        String str = (String)object;
                        VNTSettingContainer vNTSettingContainer = info.vntSettingContainer;
                        switch (str.toUpperCase(Locale.ROOT)) {
                            case "LARGE": {
                                explosionEffect = VNTSettingContainer.ExplosionEffect.large();
                                break;
                            }
                            case "STANDARD": {
                                explosionEffect = VNTSettingContainer.ExplosionEffect.standard();
                                break;
                            }
                            case "MEDIUM": 
                            case "LOW": {
                                explosionEffect = VNTSettingContainer.ExplosionEffect.medium();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(WeaponParser.jvmdowngrader$concat$parseVNT$1(str));
                            }
                        }
                        vNTSettingContainer.explosionEffect = explosionEffect;
                        break;
                    }
                    object = entry.getValue();
                    if (!(object instanceof Map)) break;
                    Map vntMap = vntMapRaw = (Map)object;
                    VNTSettingContainer.ExplosionEffect effect = VNTSettingContainer.ExplosionEffect.standard();
                    block48: for (Map.Entry vntEntry : vntMap.entrySet()) {
                        Object value = vntEntry.getValue();
                        switch ((String)vntEntry.getKey()) {
                            case "IsSmall": {
                                effect.isSmall = (Boolean)value;
                                continue block48;
                            }
                            case "CloudCount": {
                                effect.cloudCount = ((Number)value).intValue();
                                continue block48;
                            }
                            case "CloudScale": {
                                effect.cloudScale = ((Number)value).floatValue();
                                continue block48;
                            }
                            case "CloudSpeedMult": {
                                effect.cloudSpeedMult = ((Number)value).floatValue();
                                continue block48;
                            }
                            case "WaveScale": {
                                effect.waveScale = ((Number)value).floatValue();
                                continue block48;
                            }
                            case "DebrisCount": {
                                effect.debrisCount = ((Number)value).intValue();
                                continue block48;
                            }
                            case "DebrisSize": {
                                effect.debrisSize = ((Number)value).intValue();
                                continue block48;
                            }
                            case "DebrisRetry": {
                                effect.debrisRetry = ((Number)value).intValue();
                                continue block48;
                            }
                            case "DebrisVelocity": {
                                effect.debrisVelocity = ((Number)value).floatValue();
                                continue block48;
                            }
                            case "DebrisHorizontalDeviation": {
                                effect.debrisHorizontalDeviation = ((Number)value).floatValue();
                                continue block48;
                            }
                            case "DebrisVerticalOffset": {
                                effect.debrisVerticalOffset = ((Number)value).floatValue();
                                continue block48;
                            }
                            case "SoundRange": {
                                effect.soundRange = ((Number)value).floatValue();
                                continue block48;
                            }
                        }
                        YamlParser.logUnkownEntry(entry, "VNTEffect");
                    }
                    info.vntSettingContainer.explosionEffect = effect;
                }
            }
        }
    }

    private static void parseMist(MCH_WeaponInfo info, Map<String, Object> map) {
        MistContainer container = new MistContainer();
        block21: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "FluidType": 
                case "Fluid": {
                    container.fluidType = ((String)entry.getValue()).toUpperCase(Locale.ROOT).trim();
                    continue block21;
                }
                case "CloudCount": 
                case "Count": {
                    container.cloudCount = ((Number)entry.getValue()).intValue();
                    continue block21;
                }
                case "Width": {
                    container.width = ((Number)entry.getValue()).floatValue();
                    continue block21;
                }
                case "Height": {
                    container.height = ((Number)entry.getValue()).floatValue();
                    continue block21;
                }
                case "AreaSpread": 
                case "Spread": {
                    container.areaSpread = ((Number)entry.getValue()).intValue();
                    continue block21;
                }
                case "Lifetime": {
                    container.lifetime = ((Number)entry.getValue()).intValue();
                    continue block21;
                }
                case "LifetimeVariance": {
                    container.lifetimeVariance = ((Number)entry.getValue()).intValue();
                    continue block21;
                }
            }
            YamlParser.logUnkownEntry(entry, "Mist");
        }
        info.mistContainer = container;
    }

    private static void parseMukeContainer(MCH_WeaponInfo info, Map<String, Object> map) {
        MukeContainer container = new MukeContainer();
        block24: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "UseTorex": {
                    container.miniNuke = (Boolean)entry.getValue() == false;
                    break;
                }
                case "Safe": {
                    container.safe = (Boolean)entry.getValue();
                    break;
                }
                case "BlastRadius": {
                    container.blastRadius = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "KillRadius": {
                    container.killRadius = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "RadiationLevel": {
                    container.radiationLevel = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Particle": {
                    container.particle = (String)entry.getValue();
                    break;
                }
                case "ShrapnelCount": {
                    container.shrapnelCount = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "Resolution": 
                case "Res": {
                    container.resolution = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "Attributes": 
                case "Attrib": {
                    Object val = entry.getValue();
                    if (!(val instanceof List)) continue block24;
                    List list = (List)val;
                    container.attributes = list.stream().map(Object::toString).collect(Collectors.toList());
                    break;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "MiniNuke");
                }
            }
        }
        info.mukeContainer = container;
    }

    private static void parseNTExplosion(MCH_WeaponInfo info, Map<String, Object> map) {
        int res = 16;
        List attribs = null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Resolution": 
                case "Res": {
                    res = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "Attributes": 
                case "Attrib": {
                    attribs = (List)entry.getValue();
                }
            }
        }
        info.ntSettingContainer = new NTSettingContainer(attribs, res);
    }

    private static void parseMarkerRocket(MCH_WeaponInfo info, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Count": {
                    info.markerRocketSpawnNum = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "Spread": {
                    info.markerRocketSpawnDiff = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "SpawnHeight": {
                    info.markerRocketSpawnHeight = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "Acceleration": {
                    info.markerRocketSpawnSpeed = ((Number)entry.getValue()).intValue();
                }
            }
        }
    }

    static MCH_WeaponInfo.RoundItem parseRoundMap(Map<String, Object> roundMap) {
        int count = YamlParser.getClamped(1, 64, (Object)MCH_Utils.getAny(roundMap, Arrays.asList("Count", "Num"), 1));
        String loc = ((String)MCH_Utils.getAny(roundMap, Arrays.asList("Loc", "Name"), null)).toLowerCase(Locale.ROOT).trim();
        int meta = YamlParser.getClamped(Short.MAX_VALUE, (Object)MCH_Utils.getAny(roundMap, Arrays.asList("Meta", "Damage"), 1));
        if (loc == null) {
            throw new IllegalArgumentException("Ammo item must have a resource path!");
        }
        return new MCH_WeaponInfo.RoundItem(count, loc, meta);
    }

    private static void parseBallisitcs(MCH_WeaponInfo info, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Acceleration": 
                case "Accel": {
                    info.acceleration = YamlParser.getClamped(0.0f, 100.0f, entry.getValue());
                    break;
                }
                case "AccelerationInWater": {
                    info.accelerationInWater = YamlParser.getClamped(0.0f, 100.0f, entry.getValue());
                    break;
                }
                case "Gravity": {
                    info.gravity = YamlParser.getClamped(-50.0f, 50.0f, entry.getValue());
                    break;
                }
                case "GravityInWater": {
                    info.gravityInWater = YamlParser.getClamped(-50.0f, 50.0f, entry.getValue());
                    break;
                }
                case "VelocityInWater": {
                    info.velocityInWater = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "SpeedFactor": {
                    info.speedFactor = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "SpeedFactorStartTick": {
                    info.speedFactorStartTick = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "SpeedFactorEndTick": {
                    info.speedFactorEndTick = ((Number)entry.getValue()).intValue();
                    break;
                }
                case "SpeedDependsAircraft": {
                    info.speedDependsAircraft = (Boolean)entry.getValue();
                    break;
                }
                case "Piercing": {
                    info.piercing = YamlParser.getClamped(1000, entry.getValue());
                    break;
                }
                case "FlakSpread": {
                    info.flakParticlesDiff = ((Number)entry.getValue()).floatValue();
                }
            }
        }
    }

    private static void parseRecoil(MCH_WeaponInfo info, Map<String, Object> map) {
        info.recoilBufCount = 1;
        info.recoilBufCountSpeed = 1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "Power": {
                    info.recoil = YamlParser.getClamped(100.0f, entry.getValue());
                    break;
                }
                case "Pitch": {
                    info.recoilPitch = ((Number)value).floatValue();
                    break;
                }
                case "Yaw": {
                    info.recoilYaw = ((Number)value).floatValue();
                    break;
                }
                case "PitchRange": {
                    info.recoilPitchRange = ((Number)value).floatValue();
                    break;
                }
                case "YawRange": {
                    info.recoilYawRange = ((Number)value).floatValue();
                    break;
                }
                case "RecoverFactor": {
                    info.recoilRecoverFactor = ((Number)value).floatValue();
                    break;
                }
                case "BufferCount": {
                    info.recoilBufCount = ((Number)value).intValue();
                    break;
                }
                case "BufferSpeed": {
                    info.recoilBufCountSpeed = ((Number)value).intValue();
                }
            }
        }
        if (info.recoilBufCountSpeed > info.recoilBufCount / 2) {
            info.recoilBufCountSpeed = info.recoilBufCount / 2;
        }
    }

    private static void parseSound(MCH_WeaponInfo info, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Locations": {
                    WeaponParser.parseSoundLoc(info, (Map)entry.getValue());
                    break;
                }
                case "Delay": {
                    info.soundDelay = YamlParser.getClamped(0, 1000, entry.getValue());
                    break;
                }
                case "Volume": {
                    info.soundVolume = YamlParser.getClamped(0.0f, 1000.0f, entry.getValue());
                    break;
                }
                case "Pitch": {
                    info.soundPitch = YamlParser.getClamped(0.0f, 1.0f, entry.getValue());
                    break;
                }
                case "PitchRandom": {
                    info.soundPitchRandom = YamlParser.getClamped(0.0f, 1.0f, entry.getValue());
                    break;
                }
                case "HitSoundRange": {
                    info.hitSoundRange = ((Number)entry.getValue()).intValue();
                }
            }
        }
    }

    private static void parseSoundLoc(MCH_WeaponInfo info, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Hit": {
                    info.hitSound = YamlParser.INSTANCE.parseSoundEffect(entry.getValue());
                    break;
                }
                case "Fire": {
                    info.fireSound = YamlParser.INSTANCE.parseSoundEffect(entry.getValue());
                    break;
                }
                case "HitMetal": {
                    info.hitSoundIron = YamlParser.INSTANCE.parseSoundEffect(entry.getValue());
                    break;
                }
                case "Railgun": {
                    info.railgunSound = YamlParser.INSTANCE.parseSoundEffect(entry.getValue());
                    break;
                }
                case "WeaponSwitch": {
                    info.weaponSwitchSound = YamlParser.INSTANCE.parseSoundEffect(entry.getValue());
                }
            }
        }
    }

    private static void parseDamage(MCH_WeaponInfo info, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "ExplosionDamageVsLiving": {
                    info.explosionDamageVsLiving = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "ExplosionDamageVsPlayer": {
                    info.explosionDamageVsPlayer = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "ExplosionDamageVsPlane": {
                    info.explosionDamageVsPlane = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "ExplosionDamageVsVehicle": {
                    info.explosionDamageVsVehicle = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "ExplosionDamageVsTank": {
                    info.explosionDamageVsTank = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "ExplosionDamageVsHeli": {
                    info.explosionDamageVsHeli = ((Number)entry.getValue()).floatValue();
                }
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseHBM$1(String string) {
        return "Unknown Muke type string: '" + string + "'. Expected one of: SAFE, TOTS, LOW, MEDIUM, HIGH.";
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseHBM$2(String string) {
        return "Invalid Muke type: expected a String or Map, but got: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseVNT$1(String string) {
        return "Unknown Muke type string: '" + string + "'. Expected one of: LARGE, STANDARD, MEDIUM, LOW.";
    }
}

