/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info.parsers.yaml;

import com.norwood.mcheli.MCH_Color;
import com.norwood.mcheli.helper.info.parsers.yaml.YamlParser;
import com.norwood.mcheli.throwable.MCH_ThrowableInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ThrowableParser {
    private ThrowableParser() {
    }

    public static void parse(MCH_ThrowableInfo info, Map<String, Object> root) {
        block60: for (Map.Entry<String, Object> entry : root.entrySet()) {
            switch (entry.getKey()) {
                case "DisplayName": {
                    Object nameObject = entry.getValue();
                    if (nameObject instanceof String) {
                        String name = (String)nameObject;
                        info.displayName = name.trim();
                        break;
                    }
                    if (nameObject instanceof Map) {
                        Map translationNames = (Map)nameObject;
                        Map userNameMap = translationNames;
                        if (userNameMap.containsKey("DEFAULT")) {
                            info.displayName = (String)userNameMap.get("DEFAULT");
                            userNameMap.remove("DEFAULT");
                        }
                        info.displayNameLang.putAll(userNameMap);
                        break;
                    }
                    throw new ClassCastException();
                }
                case "Author": {
                    break;
                }
                case "ItemID": {
                    info.itemID = (Integer)entry.getValue();
                    break;
                }
                case "Sound": {
                    Map soundSettings = (Map)entry.getValue();
                    ThrowableParser.parseSound(soundSettings, info);
                    break;
                }
                case "Recepie": {
                    Map map = (Map)entry.getValue();
                    for (Map.Entry recMapEntry : map.entrySet()) {
                        switch ((String)recMapEntry.getKey()) {
                            case "isShaped": {
                                info.isShapedRecipe = (Boolean)recMapEntry.getValue();
                                break;
                            }
                            case "Pattern": {
                                info.recipeString = ((List)recMapEntry.getValue()).stream().map(String::toUpperCase).map(String::trim).collect(Collectors.toList());
                            }
                        }
                    }
                    continue block60;
                }
                case "Power": {
                    info.power = YamlParser.getClamped(0, Integer.MAX_VALUE, entry.getValue());
                    break;
                }
                case "Acceleration": {
                    info.acceleration = YamlParser.getClamped(100.0f, entry.getValue());
                    break;
                }
                case "AccelerationInWater": {
                    info.accelerationInWater = YamlParser.getClamped(100.0f, entry.getValue());
                    break;
                }
                case "DispenseAcceleration": {
                    info.dispenseAcceleration = YamlParser.getClamped(1000.0f, entry.getValue());
                    break;
                }
                case "Explosion": {
                    info.explosion = YamlParser.getClamped(0, 50, entry.getValue());
                    break;
                }
                case "DelayFuse": {
                    info.delayFuse = YamlParser.getClamped(0, 100000, entry.getValue());
                    break;
                }
                case "Bound": {
                    info.bound = YamlParser.getClamped(100000.0f, entry.getValue());
                    break;
                }
                case "TimeFuse": {
                    info.timeFuse = YamlParser.getClamped(0, 100000, entry.getValue());
                    break;
                }
                case "Flaming": {
                    info.flaming = (Boolean)entry.getValue();
                    break;
                }
                case "StackSize": {
                    info.stackSize = YamlParser.getClamped(1, 64, entry.getValue());
                    break;
                }
                case "ProximityFuseDist": {
                    info.proximityFuseDist = YamlParser.getClamped(20.0f, entry.getValue());
                    break;
                }
                case "Accuracy": {
                    info.accuracy = YamlParser.getClamped(1000.0f, entry.getValue());
                    break;
                }
                case "AliveTime": {
                    info.aliveTime = YamlParser.getClamped(0, 1000000, entry.getValue());
                    break;
                }
                case "Bomblet": {
                    info.bomblet = YamlParser.getClamped(0, 1000, entry.getValue());
                    break;
                }
                case "BombletSpread": {
                    info.bombletDiff = YamlParser.getClamped(1000.0f, entry.getValue());
                    break;
                }
                case "Gravity": {
                    info.gravity = YamlParser.getClamped(-50.0f, 50.0f, entry.getValue());
                    break;
                }
                case "GravityInWater": {
                    info.gravityInWater = YamlParser.getClamped(-50.0f, 50.0f, entry.getValue());
                    break;
                }
                case "Particle": {
                    info.particleName = ((String)entry.getValue()).trim().toLowerCase();
                    break;
                }
                case "Smoke": {
                    ThrowableParser.parseSmoke(info, (Map)entry.getValue());
                    break;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "ThrowableInfo");
                }
            }
        }
    }

    private static void parseSmoke(MCH_ThrowableInfo info, Map<String, Object> soundSettings) {
        block24: for (Map.Entry<String, Object> entry : soundSettings.entrySet()) {
            switch (entry.getKey()) {
                case "DisableSmoke": {
                    info.disableSmoke = (Boolean)entry.getValue();
                    break;
                }
                case "Size": {
                    info.smokeSize = YamlParser.getClamped(1000.0f, entry.getValue());
                    break;
                }
                case "Count": {
                    info.smokeNum = YamlParser.getClamped(0, 1000, entry.getValue());
                    break;
                }
                case "Color": {
                    info.smokeColor = new MCH_Color(YamlParser.parseHexColor(((String)entry.getValue()).trim()));
                    break;
                }
                case "Velocity": {
                    Map velMap = (Map)entry.getValue();
                    for (Map.Entry velEntry : velMap.entrySet()) {
                        switch (entry.getKey()) {
                            case "Vertical": 
                            case "Y": {
                                info.smokeVelocityVertical = YamlParser.getClamped(-100.0f, 100.0f, velEntry.getValue());
                                break;
                            }
                            case "Horizontal": 
                            case "X": {
                                info.smokeVelocityHorizontal = YamlParser.getClamped(1000.0f, velEntry.getValue());
                            }
                        }
                    }
                    continue block24;
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "Smoke");
                }
            }
        }
    }

    private static void parseSound(Map<String, Object> soundSettings, MCH_ThrowableInfo info) {
        block9: for (Map.Entry<String, Object> entry : soundSettings.entrySet()) {
            switch (entry.getKey()) {
                case "Volume": 
                case "Vol": {
                    info.soundVolume = YamlParser.getClamped(10.0f, entry.getValue());
                    continue block9;
                }
                case "Pitch": {
                    info.soundPitch = YamlParser.getClamped(1.0f, 10.0f, entry.getValue());
                    continue block9;
                }
            }
            YamlParser.logUnkownEntry(entry, "Sound");
        }
    }
}

