/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info.parsers.yaml;

import com.norwood.mcheli.helper.MCH_Logger;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.info.parsers.yaml.YamlParser;
import com.norwood.mcheli.hud.MCH_Hud;
import com.norwood.mcheli.hud.MCH_HudItem;
import com.norwood.mcheli.hud.MCH_HudItemCall;
import com.norwood.mcheli.hud.MCH_HudItemCameraRot;
import com.norwood.mcheli.hud.MCH_HudItemColor;
import com.norwood.mcheli.hud.MCH_HudItemConditional;
import com.norwood.mcheli.hud.MCH_HudItemExit;
import com.norwood.mcheli.hud.MCH_HudItemGraduation;
import com.norwood.mcheli.hud.MCH_HudItemLine;
import com.norwood.mcheli.hud.MCH_HudItemLineStipple;
import com.norwood.mcheli.hud.MCH_HudItemRadar;
import com.norwood.mcheli.hud.MCH_HudItemRect;
import com.norwood.mcheli.hud.MCH_HudItemString;
import com.norwood.mcheli.hud.MCH_HudItemTexture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={GraduationType.class})
public class HUDParser {
    private HUDParser() {
    }

    public static Tuple<String, String> setTuple(List<String> mapKeys, Object object) {
        if (object instanceof List) {
            List tupleList = (List)object;
            if (tupleList.size() != 2) {
                throw new IllegalArgumentException("Tuple list must have exactly 2 variables");
            }
            List<String> tupleListTyped = HUDParser.toStringList(tupleList);
            return new Tuple((Object)tupleListTyped.get(0), (Object)tupleListTyped.get(1));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Map<String, String> tupleMapTyped = HUDParser.toStringMap(map);
            return new Tuple((Object)tupleMapTyped.get(mapKeys.get(0)), (Object)tupleMapTyped.get(mapKeys.get(1)));
        }
        throw new IllegalArgumentException("Tuple parsing failed, the values must be either string or a number!");
    }

    public static List<String> toStringList(List<?> list) {
        if (list.get(0) instanceof String) {
            return list;
        }
        if (list.get(0) instanceof Number) {
            return list.stream().map(Object::toString).collect(Collectors.toList());
        }
        throw new ClassCastException();
    }

    public static Map<String, String> toStringMap(Map<String, ?> map) {
        if (map.isEmpty()) {
            return new HashMap<String, String>();
        }
        Object firstValue = map.values().iterator().next();
        if (firstValue instanceof String) {
            return map;
        }
        if (firstValue instanceof Number) {
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Number)e.getValue()).toString()));
        }
        throw new ClassCastException("Map values are not String or Number");
    }

    public static void parse(MCH_Hud info, Object rootObj) {
        if (rootObj instanceof List) {
            for (Object item : (List)rootObj) {
                HUDParser.parseHudItem(info, item);
            }
        } else {
            throw new IllegalArgumentException("Root object must be a List");
        }
    }

    private static MCH_HudItem parseHUDCommands(Map.Entry<String, Object> entry) {
        switch (entry.getKey()) {
            case "Exit": {
                return new MCH_HudItemExit(0);
            }
            case "Color": {
                return new MCH_HudItemColor(0, MCH_HudItem.toFormula((String)entry.getValue()));
            }
            case "DrawTexture": {
                return HUDParser.parseDrawTexture((Map)entry.getValue());
            }
            case "DrawString": {
                return HUDParser.parseDrawString((Map)entry.getValue());
            }
            case "CameraRot": 
            case "CameraRotation": {
                return HUDParser.parseCameraRot((Map)entry.getValue());
            }
            case "DrawRectangle": 
            case "DrawRect": {
                return HUDParser.parseRact((Map)entry.getValue());
            }
            case "DrawLine": {
                return HUDParser.parseLine((Map)entry.getValue());
            }
            case "Call": {
                return new MCH_HudItemCall(0, (String)entry.getValue());
            }
            case "DrawRadar": {
                return HUDParser.parseRadar((Map)entry.getValue());
            }
            case "DrawGraduation": {
                return HUDParser.parseGraduation((Map)entry.getValue());
            }
        }
        return null;
    }

    private static MCH_HudItem parseGraduation(Map<String, Object> value) {
        Enum type = null;
        String xCoord = null;
        String yCoord = null;
        String rot = "0";
        String roll = "0";
        block14: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Type": {
                    type = GraduationType.valueOf(((String)entry.getValue()).toUpperCase(Locale.ROOT).trim());
                    continue block14;
                }
                case "Pos": 
                case "Position": {
                    Tuple<String, String> pos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    xCoord = MCH_HudItem.toFormula((String)pos.func_76341_a());
                    yCoord = MCH_HudItem.toFormula((String)pos.func_76340_b());
                    continue block14;
                }
                case "Rotation": 
                case "Rot": {
                    rot = (String)entry.getValue();
                    continue block14;
                }
                case "Roll": {
                    roll = (String)entry.getValue();
                    continue block14;
                }
            }
            YamlParser.logUnkownEntry(entry, "VehicleFeatures");
        }
        if (xCoord == null || yCoord == null) {
            throw new IllegalArgumentException("Texture, Pos fields are required for drawTexture element.");
        }
        return new MCH_HudItemGraduation(0, type == null ? -1 : type.ordinal(), rot, roll, xCoord, yCoord);
    }

    private static MCH_HudItemRadar parseRadar(Map<String, Object> value) {
        boolean isEntityRadar = false;
        String xCoord = null;
        String yCoord = null;
        String width = null;
        String height = null;
        String rot = "0";
        block14: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "EntityRadar": {
                    isEntityRadar = (Boolean)entry.getValue();
                    continue block14;
                }
                case "Pos": 
                case "Position": {
                    Tuple<String, String> pos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    xCoord = MCH_HudItem.toFormula((String)pos.func_76341_a());
                    yCoord = MCH_HudItem.toFormula((String)pos.func_76340_b());
                    continue block14;
                }
                case "Size": {
                    Tuple<String, String> size = HUDParser.setTuple(Arrays.asList("width", "height"), entry.getValue());
                    width = MCH_HudItem.toFormula((String)size.func_76341_a());
                    height = MCH_HudItem.toFormula((String)size.func_76340_b());
                    continue block14;
                }
                case "Rotation": 
                case "Rot": {
                    rot = MCH_HudItem.toFormula((String)entry.getValue());
                    continue block14;
                }
            }
            YamlParser.logUnkownEntry(entry, "VehicleFeatures");
        }
        if (xCoord == null || yCoord == null) {
            throw new IllegalArgumentException("Texture, Pos fields are required for drawTexture element.");
        }
        return new MCH_HudItemRadar(0, isEntityRadar, rot, xCoord, yCoord, width, height);
    }

    private static MCH_HudItem parseLine(Map<String, Object> value) {
        boolean isStriped = false;
        String pattern = "0";
        String factor = "0";
        ArrayList<List<String>> positions = new ArrayList<List<String>>();
        block16: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Striped": {
                    isStriped = (Boolean)entry.getValue();
                    break;
                }
                case "Fac": 
                case "Factor": {
                    factor = MCH_HudItem.toFormula((String)entry.getValue());
                    break;
                }
                case "Pat": 
                case "Pattern": {
                    pattern = MCH_HudItem.toFormula((String)entry.getValue());
                    break;
                }
                case "StartPos": 
                case "Position": 
                case "Start": {
                    Object raw = entry.getValue();
                    if (raw instanceof List) {
                        List rawList = (List)raw;
                        for (Object pairObj : rawList) {
                            List pair;
                            if (pairObj instanceof List && (pair = (List)pairObj).size() == 2) {
                                String x = MCH_HudItem.toFormula(pair.get(0).toString());
                                String y = MCH_HudItem.toFormula(pair.get(1).toString());
                                positions.add(Arrays.asList(x, y));
                                continue;
                            }
                            throw new IllegalArgumentException("Each position must be a list of exactly 2 elements.");
                        }
                        continue block16;
                    }
                    throw new IllegalArgumentException("Position field must be a list of lists.");
                }
                default: {
                    YamlParser.logUnkownEntry(entry, "Line");
                }
            }
        }
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("At least one position is required for Line element.");
        }
        String[] coordsArr = (String[])positions.stream().flatMap(Collection::stream).toArray(String[]::new);
        return isStriped ? new MCH_HudItemLineStipple(0, pattern, factor, coordsArr) : new MCH_HudItemLine(0, coordsArr);
    }

    private static MCH_HudItem parseCameraRot(Map<String, Object> value) {
        String xCoord = null;
        String yCoord = null;
        block7: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    Tuple<String, String> pos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    xCoord = MCH_HudItem.toFormula((String)pos.func_76341_a());
                    yCoord = MCH_HudItem.toFormula((String)pos.func_76340_b());
                    continue block7;
                }
            }
            YamlParser.logUnkownEntry(entry, "VehicleFeatures");
        }
        if (xCoord == null || yCoord == null) {
            throw new IllegalArgumentException("Pos fields are required for drawTexture element.");
        }
        return new MCH_HudItemCameraRot(0, xCoord, yCoord);
    }

    private static MCH_HudItemRect parseRact(Map<String, Object> value) {
        String xCoord = null;
        String yCoord = null;
        String width = null;
        String height = null;
        block9: for (Map.Entry<String, Object> entry : value.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    Tuple<String, String> pos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    xCoord = MCH_HudItem.toFormula((String)pos.func_76341_a());
                    yCoord = MCH_HudItem.toFormula((String)pos.func_76340_b());
                    continue block9;
                }
                case "Size": {
                    Tuple<String, String> size = HUDParser.setTuple(Arrays.asList("width", "height"), entry.getValue());
                    width = MCH_HudItem.toFormula((String)size.func_76341_a());
                    height = MCH_HudItem.toFormula((String)size.func_76340_b());
                    continue block9;
                }
            }
            YamlParser.logUnkownEntry(entry, "VehicleFeatures");
        }
        if (xCoord == null || yCoord == null) {
            throw new IllegalArgumentException("Pos fields are required for drawTexture element.");
        }
        return new MCH_HudItemRect(0, xCoord, yCoord, width, height);
    }

    private static MCH_HudItemString parseDrawString(Map<String, Object> map) {
        String text = null;
        Collection varSubstitute = null;
        String xCoord = null;
        String yCoord = null;
        boolean center = false;
        block11: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Text": {
                    Map formatEntry = (Map)entry.getValue();
                    text = MCH_Utils.getAny(formatEntry, Arrays.asList("Fmt", "Format"), null);
                    varSubstitute = MCH_Utils.getAny(formatEntry, Arrays.asList("Vars", "Variables"), null);
                    continue block11;
                }
                case "Center": {
                    center = (Boolean)entry.getValue();
                    continue block11;
                }
                case "Pos": 
                case "Position": {
                    Tuple<String, String> pos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    xCoord = (String)pos.func_76341_a();
                    yCoord = (String)pos.func_76340_b();
                    continue block11;
                }
            }
            YamlParser.logUnkownEntry(entry, "DrawString");
        }
        if (xCoord == null || yCoord == null || text == null) {
            throw new IllegalArgumentException("Pos, Format, fields are required for drawTexture element.");
        }
        String[] args2 = (String[])Stream.concat(Stream.of(xCoord, yCoord, text), varSubstitute != null ? varSubstitute.stream() : Stream.empty()).toArray(String[]::new);
        return new MCH_HudItemString(0, xCoord, yCoord, text, args2, center);
    }

    private static MCH_HudItemTexture parseDrawTexture(Map<String, Object> map) {
        String name = null;
        String xCoord = null;
        String yCoord = null;
        String width = null;
        String height = null;
        String uLeft = null;
        String vTop = null;
        String uWidth = null;
        String vHeight = null;
        String rot = "0";
        block19: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Texture": 
                case "Name": {
                    name = (String)entry.getValue();
                    continue block19;
                }
                case "Pos": 
                case "Position": {
                    Tuple<String, String> pos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    xCoord = MCH_HudItem.toFormula((String)pos.func_76341_a());
                    yCoord = MCH_HudItem.toFormula((String)pos.func_76340_b());
                    continue block19;
                }
                case "Size": {
                    Tuple<String, String> size = HUDParser.setTuple(Arrays.asList("width", "height"), entry.getValue());
                    width = MCH_HudItem.toFormula((String)size.func_76341_a());
                    height = MCH_HudItem.toFormula((String)size.func_76340_b());
                    continue block19;
                }
                case "UVPos": {
                    Tuple<String, String> uvPos = HUDParser.setTuple(Arrays.asList("x", "y"), entry.getValue());
                    uLeft = MCH_HudItem.toFormula((String)uvPos.func_76341_a());
                    vTop = MCH_HudItem.toFormula((String)uvPos.func_76340_b());
                    continue block19;
                }
                case "UVSize": {
                    Tuple<String, String> uvSize = HUDParser.setTuple(Arrays.asList("width", "height"), entry.getValue());
                    uWidth = MCH_HudItem.toFormula((String)uvSize.func_76341_a());
                    vHeight = MCH_HudItem.toFormula((String)uvSize.func_76340_b());
                    continue block19;
                }
                case "Rotation": 
                case "Rot": {
                    rot = MCH_HudItem.toFormula((String)entry.getValue());
                    continue block19;
                }
            }
            YamlParser.logUnkownEntry(entry, "DrawTexture");
        }
        if (name == null || xCoord == null || yCoord == null) {
            throw new IllegalArgumentException("Texture, Pos fields are required for drawTexture element.");
        }
        return new MCH_HudItemTexture(0, name, xCoord, yCoord, width, height, uLeft, vTop, uWidth, vHeight, rot);
    }

    private static void parseHudItem(MCH_Hud info, Object obj) {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.containsKey("If")) {
                HUDParser.parseConditional(info, (LinkedHashMap)map);
            } else {
                Map.Entry<String, Object> entry = map.entrySet().iterator().next();
                MCH_HudItem element = HUDParser.parseHUDCommands(entry);
                if (element == null) {
                    YamlParser.logUnkownEntry(entry, "Hud");
                } else {
                    info.list.add(element);
                }
            }
        } else {
            throw new IllegalArgumentException("Each HUD item must be a Map");
        }
    }

    private static void parseConditional(MCH_Hud info, Map<String, Object> map) {
        String condition = ((String)map.get("If")).trim();
        if (condition == null || condition.isEmpty()) {
            throw new IllegalArgumentException("Condition cannot be blank!");
        }
        MCH_HudItemConditional conditional = new MCH_HudItemConditional(0, false, condition);
        info.list.add(conditional);
        List doBlock = (List)map.get("Do");
        if (doBlock.isEmpty()) {
            MCH_Logger.get().warn(HUDParser.jvmdowngrader$concat$parseConditional$1(info.getLocation().func_110623_a()));
        }
        for (Object obj : doBlock) {
            if (obj instanceof Map) {
                Map objMap = (Map)obj;
                for (Map.Entry<String, Object> entry : objMap.entrySet()) {
                    MCH_HudItem element = HUDParser.parseHUDCommands(entry);
                    if (element != null) {
                        info.list.add(element);
                        continue;
                    }
                    YamlParser.logUnkownEntry(entry, "Hud");
                }
                continue;
            }
            throw new IllegalArgumentException("Each Do block item must be a Map");
        }
        info.list.add(new MCH_HudItemConditional(0, true, null));
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseConditional$1(String string) {
        return "Hud " + string + " contains empty conditionals!";
    }

    @NestHost(value=HUDParser.class)
    public static enum GraduationType {
        YAW,
        PITCH,
        PITCH_ROLL,
        PITCH_ROLL_ALT;

    }
}

