/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info.parsers.yaml;

import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.info.parsers.yaml.YamlParser;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import com.norwood.mcheli.ship.MCH_ShipInfo;
import com.norwood.mcheli.vehicle.MCH_VehicleInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.math.Vec3d;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={VpartType.class})
public class ComponentParser {
    private ComponentParser() {
    }

    public static void parseComponentsHeli(Map<String, List<Map<String, Object>>> components, MCH_HeliInfo info) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : components.entrySet()) {
            String type = entry.getKey();
            List<Map<String, Object>> componentList = entry.getValue();
            switch (type) {
                case "HeliRotor": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("blade", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        int bladeNum = 1;
                        int bladeRot = 0;
                        boolean haveFoldFunc = false;
                        boolean oldRenderMethod = false;
                        for (Map.Entry bladeEntry : component.entrySet()) {
                            switch ((String)bladeEntry.getKey()) {
                                case "Count": 
                                case "BladeCount": {
                                    bladeNum = ((Number)bladeEntry.getValue()).intValue();
                                    break;
                                }
                                case "BladeRotation": 
                                case "BladeRot": {
                                    bladeRot = ((Number)bladeEntry.getValue()).intValue();
                                    break;
                                }
                                case "CanFold": {
                                    haveFoldFunc = (Boolean)bladeEntry.getValue();
                                    break;
                                }
                                case "OldRenderer": {
                                    oldRenderMethod = (Boolean)bladeEntry.getValue();
                                }
                            }
                        }
                        return new MCH_HeliInfo.Rotor((MCH_AircraftInfo.DrawnPart)drawnPart, bladeNum, bladeRot, haveFoldFunc, oldRenderMethod);
                    }, info.rotorList, new HashSet<String>(Arrays.asList("Count", "BladeCount", "BladeRotation", "BladeRot", "CanFold", "OldRenderer")))).forEachOrdered(info.rotorList::add);
                }
            }
        }
    }

    public static void parseComponents(Map<String, List<Map<String, Object>>> components, MCH_AircraftInfo info) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : components.entrySet()) {
            String type = entry.getKey();
            List<Map<String, Object>> componentList = entry.getValue();
            switch (type) {
                case "Camera": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart(MCH_AircraftInfo.Camera.class, (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.Camera((MCH_AircraftInfo.DrawnPart)drawnPart, component.getOrDefault("YawSync", true), component.getOrDefault("PitchSync", false)), info.cameraList, new HashSet<String>(Arrays.asList("YawSync", "PitchSync")))).forEachOrdered(info.cameraList::add);
                    break;
                }
                case "Canopy": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart(MCH_AircraftInfo.Canopy.class, (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.Canopy((MCH_AircraftInfo.DrawnPart)drawnPart, YamlParser.getClamped(-180.0f, 180.0f, (Object)component.getOrDefault("MaxRotation", Float.valueOf(90.0f))), component.getOrDefault("IsSliding", false)), info.canopyList, new HashSet<String>(Arrays.asList("MaxRotation", "IsSliding")))).forEachOrdered(info.canopyList::add);
                    break;
                }
                case "Hatch": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart(MCH_AircraftInfo.Hatch.class, (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.Hatch((MCH_AircraftInfo.DrawnPart)drawnPart, YamlParser.getClamped(-180.0f, 180.0f, (Object)component.getOrDefault("MaxRotation", Float.valueOf(90.0f))), component.getOrDefault("IsSliding", false)), info.hatchList, new HashSet<String>(Arrays.asList("MaxRotation", "IsSliding")))).forEachOrdered(info.hatchList::add);
                    break;
                }
                case "LightHatch": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("light_hatch", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.Hatch((MCH_AircraftInfo.DrawnPart)drawnPart, YamlParser.getClamped(-180.0f, 180.0f, (Object)component.getOrDefault("MaxRotation", Float.valueOf(90.0f))), component.getOrDefault("IsSliding", false)), info.hatchList, new HashSet<String>(Arrays.asList("MaxRotation", "IsSliding")))).forEachOrdered(info.lightHatchList::add);
                    break;
                }
                case "WeaponBay": {
                    componentList.stream().map(component -> {
                        String weaponName = ((String)component.get("WeaponName")).trim();
                        if (weaponName == null) {
                            throw new IllegalArgumentException("WeaponName is required!");
                        }
                        return ComponentParser.parseDrawnPart("wb", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.WeaponBay((MCH_AircraftInfo.DrawnPart)drawnPart, YamlParser.getClamped(-180.0f, 180.0f, (Object)component.getOrDefault("MaxRotation", Float.valueOf(90.0f))), component.getOrDefault("IsSliding", false), weaponName), info.partWeaponBay, new HashSet<String>(Arrays.asList("MaxRotation", "IsSliding", "WeaponName")));
                    }).forEachOrdered(info.partWeaponBay::add);
                    break;
                }
                case "RepelHook": {
                    componentList.stream().map(ComponentParser::parseHook).forEachOrdered(info.repellingHooks::add);
                    break;
                }
                case "Rotation": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart(MCH_AircraftInfo.RotPart.class, (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.RotPart((MCH_AircraftInfo.DrawnPart)drawnPart, ((Number)component.getOrDefault("Speed", 0)).floatValue(), component.getOrDefault("AlwaysRotate", false)), info.partRotPart, new HashSet<String>(Arrays.asList("Speed", "AlwaysRotate")))).forEachOrdered(info.partRotPart::add);
                    break;
                }
                case "SteeringWheel": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("steering_wheel", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> new MCH_AircraftInfo.PartWheel((MCH_AircraftInfo.DrawnPart)drawnPart, ((Number)component.getOrDefault("Direction", Float.valueOf(0.0f))).floatValue(), component.containsKey("Pivot") ? YamlParser.parseVector(component.get("Pivot")) : Vec3d.field_186680_a), info.partSteeringWheel, new HashSet<String>(Arrays.asList("Direction", "Pivot")))).forEachOrdered(info.partSteeringWheel::add);
                    break;
                }
                case "Wheel": {
                    componentList.stream().map(component -> {
                        Vec3d pos = null;
                        Vec3d rot = new Vec3d(0.0, 1.0, 0.0);
                        Vec3d pivot = Vec3d.field_186680_a;
                        String name = ComponentParser.jvmdowngrader$concat$lambda$parseComponents$14$1(info.partWheel.size());
                        float dir = 0.0f;
                        block14: for (Map.Entry<String, Object> entry : component.entrySet()) {
                            switch ((String)entry.getKey()) {
                                case "Position": {
                                    pos = YamlParser.parseVector(entry.getValue());
                                    continue block14;
                                }
                                case "Rotation": {
                                    rot = YamlParser.parseVector(entry.getValue());
                                    continue block14;
                                }
                                case "Direction": {
                                    dir = YamlParser.getClamped(-1800.0f, 1800.0f, entry.getValue());
                                    continue block14;
                                }
                                case "Pivot": {
                                    pivot = YamlParser.parseVector(entry.getValue());
                                    continue block14;
                                }
                                case "PartName": {
                                    name = ((String)entry.getValue()).toLowerCase(Locale.ROOT).trim();
                                    continue block14;
                                }
                            }
                            YamlParser.logUnkownEntry(entry, "PartWheel");
                        }
                        if (pos == null) {
                            throw new IllegalArgumentException("Part wheel must have a Position!");
                        }
                        return new MCH_AircraftInfo.PartWheel(new MCH_AircraftInfo.DrawnPart(pos, rot, name), dir, pivot);
                    }).forEachOrdered(info.partWheel::add);
                    break;
                }
                case "LandingGear": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("lg", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        float maxRot = YamlParser.getClamped(-180.0f, 180.0f, (Object)component.getOrDefault("MaxRotation", Float.valueOf(90.0f))) / 90.0f;
                        boolean reverse = component.getOrDefault("IsReverse", false);
                        boolean hatch = component.getOrDefault("IsHatch", false);
                        MCH_AircraftInfo.LandingGear gear = new MCH_AircraftInfo.LandingGear((MCH_AircraftInfo.DrawnPart)drawnPart, maxRot, reverse, hatch);
                        if (component.containsKey("ArticulatedRotation")) {
                            gear.enableRot2 = true;
                            gear.rot2 = YamlParser.parseVector(component.get("ArticulatedRotation"));
                            gear.maxRotFactor2 = YamlParser.getClamped(-180.0f, 180.0f, (Object)component.getOrDefault("MaxArticulatedRotation", Float.valueOf(90.0f))) / 90.0f;
                        }
                        if (component.containsKey("SlideVec")) {
                            gear.slide = YamlParser.parseVector(component.get("SlideVec"));
                        }
                        return gear;
                    }, info.landingGear, new HashSet<String>(Arrays.asList("MaxRotation", "IsReverse", "IsHatch", "ArticulatedRotation", "MaxArticulatedRotation", "SlideVec")))).forEachOrdered(info.landingGear::add);
                    break;
                }
                case "Weapon": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("weapon", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        String[] stringArray;
                        if (component.containsKey("WeaponNames")) {
                            stringArray = info.splitParamSlash(((String)component.get("WeaponNames")).toLowerCase().trim());
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = "unnamed";
                        }
                        String[] weaponNames = stringArray;
                        boolean isRotatingWeapon = component.getOrDefault("BarrelRot", false);
                        boolean isMissile = component.getOrDefault("IsMissile", false);
                        boolean hideGM = component.getOrDefault("HideGM", false);
                        boolean yaw = component.getOrDefault("Yaw", false);
                        boolean pitch = component.getOrDefault("Pitch", false);
                        float recoilBuf = component.containsKey("RecoilBuf") ? ((Number)component.get("RecoilBuf")).floatValue() : 0.0f;
                        boolean turret = component.getOrDefault("Turret", false);
                        MCH_AircraftInfo.PartWeapon weapon = new MCH_AircraftInfo.PartWeapon((MCH_AircraftInfo.DrawnPart)drawnPart, weaponNames, isRotatingWeapon, isMissile, hideGM, yaw, pitch, recoilBuf, turret);
                        if (component.containsKey("Children") && component.get("Children") instanceof List) {
                            List children = (List)component.get("Children");
                            for (Map childPart : children) {
                                boolean childYaw = Boolean.TRUE.equals(childPart.getOrDefault("Yaw", false));
                                boolean childPitch = Boolean.TRUE.equals(childPart.getOrDefault("Pitch", false));
                                Vec3d childPos = childPart.containsKey("Position") ? YamlParser.parseVector(childPart.get("Position")) : Vec3d.field_186680_a;
                                Vec3d childRot = childPart.containsKey("Rotation") ? YamlParser.parseVector(childPart.get("Rotation")) : Vec3d.field_186680_a;
                                float childRecoil = childPart.containsKey("RecoilBuf") ? ((Number)childPart.get("RecoilBuf")).floatValue() : 0.0f;
                                MCH_AircraftInfo.PartWeaponChild child = new MCH_AircraftInfo.PartWeaponChild(childPos, childRot, ComponentParser.jvmdowngrader$concat$lambda$parseComponents$18$1(weapon.modelName, weapon.child.size()), weapon.name, childYaw, childPitch, childRecoil);
                                weapon.child.add(child);
                                for (Map.Entry<String, Object> entry : childPart.entrySet()) {
                                    if (Arrays.asList("Position", "Yaw", "Pitch", "RecoilBuf", "Rotation").contains(entry.getKey())) continue;
                                    YamlParser.logUnkownEntry(entry, "PartWeaponChild");
                                }
                            }
                        }
                        return weapon;
                    }, info.partWeapon, new HashSet<String>(Arrays.asList("HideGM", "WeaponNames", "RotBarrel", "IsMissile", "Yaw", "Pitch", "RecoilBuf", "Turret", "Children", "BarrelRot")))).forEachOrdered(info.partWeapon::add);
                    break;
                }
                case "SearchLight": {
                    componentList.stream().map(component -> ComponentParser.parseSearchLights(component)).forEach(info.searchLights::add);
                    break;
                }
                case "TrackRoller": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("track_roller", (Map<String, Object>)component, MCH_AircraftInfo.TrackRoller::new, info.partTrackRoller, new HashSet<String>())).forEachOrdered(info.partTrackRoller::add);
                    break;
                }
                case "Throttle": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart(MCH_AircraftInfo.Throttle.class, (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        Vec3d slidePos = component.containsKey("SlidePos") ? YamlParser.parseVector(component.get("SlidePos")) : Vec3d.field_186680_a;
                        float animAngle = component.containsKey("MaxAngle") ? ((Number)component.get("MaxAngle")).floatValue() : 0.0f;
                        return new MCH_AircraftInfo.Throttle((MCH_AircraftInfo.DrawnPart)drawnPart, slidePos, animAngle);
                    }, info.partThrottle, new HashSet<String>(Arrays.asList("MaxAngle", "SlidePos")))).forEachOrdered(info.partThrottle::add);
                    break;
                }
                case "CrawlerTrack": {
                    componentList.stream().map(component -> ComponentParser.parseCrawlerTrack(component, info)).forEachOrdered(info.partCrawlerTrack::add);
                }
            }
        }
    }

    public static MCH_AircraftInfo.CrawlerTrack parseCrawlerTrack(Map<String, Object> component, MCH_AircraftInfo info) {
        int trackCount;
        Iterator iterator2;
        boolean isReverse = (Boolean)component.getOrDefault("IsReverse", false);
        float segmentLength = component.containsKey("SegmentLength") ? ((Number)component.get("SegmentLength")).floatValue() : 1.0f;
        float zOffset = component.containsKey("ZOffset") ? ((Number)component.get("ZOffset")).floatValue() : 0.0f;
        ArrayList<float[]> trackList = new ArrayList<float[]>();
        if (component.containsKey("TrackList") && (iterator2 = component.get("TrackList")) instanceof List) {
            List list = (List)((Object)iterator2);
            for (Object elem : list) {
                List pair;
                if (!(elem instanceof List) || (pair = (List)elem).size() != 2) {
                    throw new IllegalArgumentException("Each TrackList entry must be a 2-element list!");
                }
                float x = ((Number)pair.get(0)).floatValue();
                float y = ((Number)pair.get(1)).floatValue();
                trackList.add(new float[]{x, y});
            }
        }
        if ((trackCount = trackList.size()) < 4) {
            throw new IllegalArgumentException("CrawlerTrack must have at least 4 track coordinates");
        }
        double[] cx = new double[trackCount];
        double[] cy = new double[trackCount];
        for (int i = 0; i < trackCount; ++i) {
            int idx = !isReverse ? i : trackCount - i - 1;
            float[] pair = (float[])trackList.get(idx);
            cx[i] = pair[0];
            cy[i] = pair[1];
        }
        ArrayList<MCH_AircraftInfo.CrawlerTrackPrm> trackParams = new ArrayList<MCH_AircraftInfo.CrawlerTrackPrm>();
        trackParams.add(new MCH_AircraftInfo.CrawlerTrackPrm((float)cx[0], (float)cy[0]));
        double carry = 0.0;
        float len = segmentLength * 0.9f;
        for (int i = 0; i < trackCount; ++i) {
            double left;
            int j = (i + 1) % trackCount;
            double dx = cx[j] - cx[i];
            double dy = cy[j] - cy[i];
            double dist = Math.hypot(dx, dy);
            double ux = dx / dist;
            double uy = dy / dist;
            double px = cx[i];
            double py = cy[i];
            double need = (double)len - carry;
            for (left = dist; left >= need; left -= need) {
                trackParams.add(new MCH_AircraftInfo.CrawlerTrackPrm((float)(px += ux * need), (float)(py += uy * need)));
                need = len;
            }
            carry = left;
        }
        int n = trackParams.size();
        for (int i = 0; i < n; ++i) {
            float ppr;
            MCH_AircraftInfo.CrawlerTrackPrm prev = (MCH_AircraftInfo.CrawlerTrackPrm)trackParams.get((i + n - 1) % n);
            MCH_AircraftInfo.CrawlerTrackPrm curr = (MCH_AircraftInfo.CrawlerTrackPrm)trackParams.get(i);
            MCH_AircraftInfo.CrawlerTrackPrm next = (MCH_AircraftInfo.CrawlerTrackPrm)trackParams.get((i + 1) % n);
            float rotPrev = (float)Math.toDegrees(Math.atan2(prev.x - curr.x, prev.y - curr.y));
            float rotNext = (float)Math.toDegrees(Math.atan2(next.x - curr.x, next.y - curr.y));
            float nextAdj = rotNext + 180.0f;
            if ((nextAdj < (ppr = (rotPrev + 360.0f) % 360.0f) - 0.3f || nextAdj > ppr + 0.3f) && nextAdj - ppr < 100.0f && nextAdj - ppr > -100.0f) {
                nextAdj = (nextAdj + ppr) / 2.0f;
            }
            curr.r = nextAdj;
        }
        MCH_AircraftInfo.CrawlerTrack crawlerTrack = new MCH_AircraftInfo.CrawlerTrack(ComponentParser.jvmdowngrader$concat$parseCrawlerTrack$1(info.partCrawlerTrack.size()));
        crawlerTrack.len = len;
        crawlerTrack.cx = cx;
        crawlerTrack.cy = cy;
        crawlerTrack.lp = trackParams;
        crawlerTrack.z = zOffset;
        crawlerTrack.side = zOffset >= 0.0f ? 1 : 0;
        return crawlerTrack;
    }

    private static <Y extends MCH_AircraftInfo.DrawnPart> Y parseDrawnPart(String defaultName, Map<String, Object> map, Function<MCH_AircraftInfo.DrawnPart, Y> fillChildFields, List<Y> partList, Set<String> knownKeys) {
        Vec3d rot;
        Vec3d pos = map.containsKey("Position") ? YamlParser.parseVector(map.get("Position")) : null;
        Vec3d vec3d = rot = map.containsKey("Rotation") ? YamlParser.parseVector(map.get("Rotation")) : Vec3d.field_186680_a;
        if (pos == null) {
            Vec3d vec3d2 = pos = map.containsKey("Pos") ? YamlParser.parseVector(map.get("Pos")) : null;
        }
        if (rot == Vec3d.field_186680_a) {
            rot = map.containsKey("Rot") ? YamlParser.parseVector(map.get("Rot")) : Vec3d.field_186680_a;
        }
        String modelName = (String)map.getOrDefault("PartName", ComponentParser.jvmdowngrader$concat$parseDrawnPart$1(defaultName, partList.size()));
        if (pos == null) {
            throw new IllegalArgumentException("Part Position must be set!");
        }
        MCH_AircraftInfo.DrawnPart base = new MCH_AircraftInfo.DrawnPart(pos, rot, modelName);
        MCH_AircraftInfo.DrawnPart built = (MCH_AircraftInfo.DrawnPart)fillChildFields.apply(base);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (YamlParser.DRAWN_PART_ARGS.contains(key) || knownKeys.contains(key)) continue;
            YamlParser.logUnkownEntry(entry, built.getClass().getSimpleName());
        }
        return (Y)built;
    }

    private static <Y extends MCH_AircraftInfo.DrawnPart> Y parseDrawnPart(Class<? extends MCH_AircraftInfo.DrawnPart> clazz, Map<String, Object> map, Function<MCH_AircraftInfo.DrawnPart, Y> fillChildFields, List<Y> partList, Set<String> knownKeys) {
        return ComponentParser.parseDrawnPart(clazz.getSimpleName().toLowerCase(Locale.ROOT).trim(), map, fillChildFields, partList, knownKeys);
    }

    private static MCH_AircraftInfo.RepellingHook parseHook(Map<String, Object> map) {
        Vec3d pos = null;
        int interval = 0;
        block9: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "Pos": 
                case "Position": {
                    pos = YamlParser.parseVector(entry.getValue());
                    continue block9;
                }
                case "Interval": {
                    interval = ((Number)entry.getValue()).intValue();
                    continue block9;
                }
            }
            YamlParser.logUnkownEntry(entry, "RepellingHooks");
        }
        if (pos == null) {
            throw new IllegalArgumentException("Repelling hook must have a position!");
        }
        return new MCH_AircraftInfo.RepellingHook(pos, interval);
    }

    private static MCH_AircraftInfo.SearchLight parseSearchLights(Map<String, Object> map) {
        Vec3d pos = null;
        int colorStart = 0xFFFFFF;
        int colorEnd = 0xFFFFFF;
        float height = 1.0f;
        float width = 1.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        float stRot = 0.0f;
        boolean fixedDirection = false;
        boolean steering = false;
        block29: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "type": {
                    continue block29;
                }
                case "FixedDirection": {
                    fixedDirection = (Boolean)entry.getValue();
                    continue block29;
                }
                case "Steering": {
                    steering = (Boolean)entry.getValue();
                    continue block29;
                }
                case "Pos": 
                case "Position": {
                    pos = YamlParser.parseVector(entry.getValue());
                    continue block29;
                }
                case "ColorStart": {
                    colorStart = YamlParser.parseHexColor((String)entry.getValue());
                    continue block29;
                }
                case "ColorEnd": {
                    colorEnd = YamlParser.parseHexColor((String)entry.getValue());
                    continue block29;
                }
                case "Height": {
                    height = ((Number)entry.getValue()).floatValue();
                    continue block29;
                }
                case "Width": {
                    width = ((Number)entry.getValue()).floatValue();
                    continue block29;
                }
                case "Yaw": {
                    yaw = ((Number)entry.getValue()).floatValue();
                    continue block29;
                }
                case "Pitch": {
                    pitch = ((Number)entry.getValue()).floatValue();
                    continue block29;
                }
                case "StRot": {
                    stRot = ((Number)entry.getValue()).floatValue();
                    continue block29;
                }
                case "Type": {
                    continue block29;
                }
            }
            YamlParser.logUnkownEntry(entry, "SearchLights");
        }
        if (pos == null) {
            throw new IllegalArgumentException("SearchLight must have a position!");
        }
        return new MCH_AircraftInfo.SearchLight(pos, colorStart, colorEnd, height, width, fixedDirection, yaw, pitch, steering, stRot);
    }

    public static void parseComponentsShip(Map<String, List<Map<String, Object>>> components, MCH_ShipInfo info) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : components.entrySet()) {
            String type = entry.getKey();
            List<Map<String, Object>> componentList = entry.getValue();
            switch (type) {
                case "ShipRotor": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("rotor", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        float rotFactor = component.containsKey("RotFactor") ? YamlParser.getClamped(-180.0f, 180.0f, component.get("RotFactor")) / 90.0f : 1.0f;
                        MCH_ShipInfo.Rotor rotor = new MCH_ShipInfo.Rotor((MCH_AircraftInfo.DrawnPart)drawnPart, rotFactor);
                        if (component.containsKey("Blades")) {
                            List rawBladeList = (List)component.get("Blades");
                            rawBladeList.stream().map(partBlade -> ComponentParser.parseDrawnPart("blade", (Map<String, Object>)partBlade, (MCH_AircraftInfo.DrawnPart drawnPartBlade) -> {
                                int bladeNum = 1;
                                Integer bladeRot = null;
                                for (Map.Entry partBladeEntry : partBlade.entrySet()) {
                                    switch ((String)partBladeEntry.getKey()) {
                                        case "BladeNum": {
                                            bladeNum = ((Number)partBladeEntry.getValue()).intValue();
                                            break;
                                        }
                                        case "BladeRot": {
                                            bladeRot = ((Number)partBladeEntry.getValue()).intValue();
                                        }
                                    }
                                }
                                if (bladeRot != null) {
                                    return new MCH_ShipInfo.Blade((MCH_AircraftInfo.DrawnPart)drawnPartBlade, bladeNum, bladeRot);
                                }
                                return null;
                            }, rotor.blades, new HashSet<String>(Arrays.asList("BladeNum", "BladeRot")))).forEach(rotor.blades::add);
                        }
                        return rotor;
                    }, info.rotorList, new HashSet<String>())).forEachOrdered(info.rotorList::add);
                    break;
                }
                case "Wing": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("wing", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        float maxRot = 0.0f;
                        ArrayList<MCH_ShipInfo.Pylon> pylons = new ArrayList<MCH_ShipInfo.Pylon>();
                        for (Map.Entry entryWing : component.entrySet()) {
                            switch ((String)entryWing.getKey()) {
                                case "MaxRotation": 
                                case "MaxRot": {
                                    maxRot = YamlParser.getClamped(-180.0f, 180.0f, entryWing.getValue());
                                    break;
                                }
                                case "Pylons": {
                                    List pylonList = (List)entryWing.getValue();
                                    pylonList.stream().map(pylonMap -> ComponentParser.parseDrawnPart(ComponentParser.jvmdowngrader$concat$lambda$parseComponentsPlane$6$1(info.wingList.size()), (Map<String, Object>)pylonMap, (MCH_AircraftInfo.DrawnPart drawnPylon) -> new MCH_ShipInfo.Pylon((MCH_AircraftInfo.DrawnPart)drawnPylon, MCH_Utils.getAny(pylonMap, Arrays.asList("MaxRot", "MaxRotation"), Float.valueOf(0.0f)).floatValue()), pylons, new HashSet<String>(Arrays.asList("MaxRotation", "MaxRot")))).forEach(pylons::add);
                                }
                            }
                        }
                        MCH_ShipInfo.Wing wing = new MCH_ShipInfo.Wing((MCH_AircraftInfo.DrawnPart)drawnPart, maxRot);
                        if (!pylons.isEmpty()) {
                            wing.pylonList = pylons;
                        }
                        return wing;
                    }, info.wingList, new HashSet<String>(Arrays.asList("MaxRotation", "MaxRot")))).forEach(info.wingList::add);
                    break;
                }
                case "Nozzle": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("nozzle", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> drawnPart, info.nozzles, new HashSet<String>())).forEach(info.nozzles::add);
                }
            }
        }
    }

    public static void parseComponentsPlane(Map<String, List<Map<String, Object>>> components, MCH_PlaneInfo info) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : components.entrySet()) {
            String type = entry.getKey();
            List<Map<String, Object>> componentList = entry.getValue();
            switch (type) {
                case "PlaneRotor": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("rotor", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        float rotFactor = component.containsKey("RotFactor") ? YamlParser.getClamped(-180.0f, 180.0f, component.get("RotFactor")) / 90.0f : 1.0f;
                        MCH_PlaneInfo.Rotor rotor = new MCH_PlaneInfo.Rotor((MCH_AircraftInfo.DrawnPart)drawnPart, rotFactor);
                        if (component.containsKey("Blades")) {
                            List rawBladeList = (List)component.get("Blades");
                            rawBladeList.stream().map(partBlade -> ComponentParser.parseDrawnPart("blade", (Map<String, Object>)partBlade, (MCH_AircraftInfo.DrawnPart drawnPartBlade) -> {
                                int bladeNum = 1;
                                Integer bladeRot = null;
                                for (Map.Entry partBladeEntry : partBlade.entrySet()) {
                                    switch ((String)partBladeEntry.getKey()) {
                                        case "BladeNum": {
                                            bladeNum = ((Number)partBladeEntry.getValue()).intValue();
                                            break;
                                        }
                                        case "BladeRot": {
                                            bladeRot = ((Number)partBladeEntry.getValue()).intValue();
                                        }
                                    }
                                }
                                if (bladeRot != null) {
                                    return new MCH_PlaneInfo.Blade((MCH_AircraftInfo.DrawnPart)drawnPartBlade, bladeNum, bladeRot);
                                }
                                return null;
                            }, rotor.blades, new HashSet<String>(Arrays.asList("BladeNum", "BladeRot", "RotFactor")))).filter(Objects::nonNull).forEach(rotor.blades::add);
                        }
                        return rotor;
                    }, info.rotorList, new HashSet<String>(Arrays.asList("Blades", "RotFactor")))).filter(Objects::nonNull).forEachOrdered(info.rotorList::add);
                    break;
                }
                case "Wing": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("wing", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> {
                        float maxRot = 0.0f;
                        ArrayList<MCH_PlaneInfo.Pylon> pylons = new ArrayList<MCH_PlaneInfo.Pylon>();
                        for (Map.Entry entryWing : component.entrySet()) {
                            switch ((String)entryWing.getKey()) {
                                case "MaxRotation": 
                                case "MaxRot": {
                                    maxRot = YamlParser.getClamped(-180.0f, 180.0f, entryWing.getValue());
                                    break;
                                }
                                case "Pylons": {
                                    List pylonList = (List)entryWing.getValue();
                                    pylonList.stream().map(pylonMap -> ComponentParser.parseDrawnPart(ComponentParser.jvmdowngrader$concat$lambda$parseComponentsPlane$6$1(info.wingList.size()), (Map<String, Object>)pylonMap, (MCH_AircraftInfo.DrawnPart drawnPylon) -> new MCH_PlaneInfo.Pylon((MCH_AircraftInfo.DrawnPart)drawnPylon, ((Number)MCH_Utils.getAny(pylonMap, Arrays.asList("MaxRot", "MaxRotation"), Float.valueOf(0.0f))).floatValue()), pylons, new HashSet<String>(Arrays.asList("MaxRotation", "MaxRot")))).forEach(pylons::add);
                                }
                            }
                        }
                        MCH_PlaneInfo.Wing wing = new MCH_PlaneInfo.Wing((MCH_AircraftInfo.DrawnPart)drawnPart, maxRot);
                        if (!pylons.isEmpty()) {
                            wing.pylonList = pylons;
                        }
                        return wing;
                    }, info.wingList, new HashSet<String>(Arrays.asList("MaxRotation", "MaxRot", "Pylons")))).forEach(info.wingList::add);
                    break;
                }
                case "Nozzle": {
                    componentList.stream().map(component -> ComponentParser.parseDrawnPart("nozzle", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> drawnPart, info.nozzles, new HashSet<String>())).forEach(info.nozzles::add);
                }
            }
        }
    }

    public static void parseComponentVehicle(Map<String, List<Map<String, Object>>> components, MCH_VehicleInfo info) {
        if (!components.containsKey("Vpart")) {
            return;
        }
        List<Map<String, Object>> vparts = components.get("Vpart");
        vparts.stream().map(component -> ComponentParser.parseDrawnPart("part", (Map<String, Object>)component, (MCH_AircraftInfo.DrawnPart drawnPart) -> ComponentParser.parseVPart(component, drawnPart, info), info.partList, new HashSet<String>(Arrays.asList("DrawFP", "DrawFirstPerson", "UnlockYaw", "CanYaw", "UnlockPitch", "CanPitch", "Type", "RecoilBuff", "Children")))).forEach(info.partList::add);
    }

    private static MCH_VehicleInfo.VPart parseVPart(Map<String, Object> component, Object drawnPart, MCH_VehicleInfo info) {
        boolean drawFP = true;
        boolean yaw = false;
        boolean pitch = false;
        VpartType type = VpartType.NORMAL;
        float recoilBuff = 0.0f;
        ArrayList<MCH_VehicleInfo.VPart> childList = new ArrayList<MCH_VehicleInfo.VPart>();
        block21: for (Map.Entry<String, Object> entry : component.entrySet()) {
            switch (entry.getKey()) {
                case "DrawFP": 
                case "DrawFirstPerson": {
                    drawFP = (Boolean)entry.getValue();
                    break;
                }
                case "UnlockYaw": 
                case "CanYaw": {
                    yaw = (Boolean)entry.getValue();
                    break;
                }
                case "UnlockPitch": 
                case "CanPitch": {
                    pitch = (Boolean)entry.getValue();
                    break;
                }
                case "Type": {
                    try {
                        type = VpartType.valueOf(((String)entry.getValue()).toUpperCase(Locale.ROOT).trim());
                        break;
                    }
                    catch (RuntimeException s) {
                        throw new IllegalArgumentException(ComponentParser.jvmdowngrader$concat$parseVPart$1(String.valueOf(entry.getValue()), Arrays.stream(VpartType.values()).map(Enum::name).collect(Collectors.joining(", "))));
                    }
                }
                case "RecoilBuff": {
                    recoilBuff = ((Number)entry.getValue()).floatValue();
                    break;
                }
                case "Children": {
                    List children = (List)entry.getValue();
                    for (Map childComponent : children) {
                        MCH_VehicleInfo.VPart childPart = ComponentParser.parseDrawnPart("child", (Map<String, Object>)childComponent, (MCH_AircraftInfo.DrawnPart childDrawn) -> ComponentParser.parseVPart(childComponent, childDrawn, info), info.partList, new HashSet<String>(Arrays.asList("DrawFP", "DrawFirstPerson", "UnlockYaw", "CanYaw", "UnlockPitch", "CanPitch", "Type", "RecoilBuff", "Children")));
                        childList.add(childPart);
                    }
                    continue block21;
                }
            }
        }
        MCH_VehicleInfo.VPart vpart = new MCH_VehicleInfo.VPart((MCH_AircraftInfo.DrawnPart)drawnPart, pitch, yaw, type.ordinal(), drawFP, recoilBuff);
        vpart.child = childList;
        return vpart;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseCrawlerTrack$1(int n) {
        return "crawler_track" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseDrawnPart$1(String string, int n) {
        return string + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$parseVPart$1(String string, String string2) {
        return "Invalid Vpart type: " + string + ". Allowed values: " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseComponentsPlane$6$1(int n) {
        return "wing" + n + "_pylon";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseComponents$18$1(String string, int n) {
        return string + "_" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$parseComponents$14$1(int n) {
        return "wheel" + n;
    }

    @NestHost(value=ComponentParser.class)
    public static enum VpartType {
        NORMAL,
        ROTATES_WEAPON,
        RECOILS_WEAPON,
        TYPE_3;

    }
}

