/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info.emitters;

import com.google.common.base.Predicates;
import com.google.common.primitives.Floats;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_BoundingBox;
import com.norwood.mcheli.aircraft.MCH_SeatInfo;
import com.norwood.mcheli.aircraft.MCH_SeatRackInfo;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import com.norwood.mcheli.helper.info.emitters.IEmitter;
import com.norwood.mcheli.helper.info.parsers.yaml.ComponentParser;
import com.norwood.mcheli.helper.info.parsers.yaml.HUDParser;
import com.norwood.mcheli.hud.MCH_Hud;
import com.norwood.mcheli.hud.MCH_HudItem;
import com.norwood.mcheli.hud.MCH_HudItemCall;
import com.norwood.mcheli.hud.MCH_HudItemCameraRot;
import com.norwood.mcheli.hud.MCH_HudItemColor;
import com.norwood.mcheli.hud.MCH_HudItemConditional;
import com.norwood.mcheli.hud.MCH_HudItemExit;
import com.norwood.mcheli.hud.MCH_HudItemGraduation;
import com.norwood.mcheli.hud.MCH_HudItemLine;
import com.norwood.mcheli.hud.MCH_HudItemLineStipple;
import com.norwood.mcheli.hud.MCH_HudItemRadar;
import com.norwood.mcheli.hud.MCH_HudItemRect;
import com.norwood.mcheli.hud.MCH_HudItemString;
import com.norwood.mcheli.hud.MCH_HudItemTexture;
import com.norwood.mcheli.item.MCH_ItemInfo;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import com.norwood.mcheli.ship.MCH_ShipInfo;
import com.norwood.mcheli.tank.MCH_TankInfo;
import com.norwood.mcheli.throwable.MCH_ThrowableInfo;
import com.norwood.mcheli.vehicle.MCH_VehicleInfo;
import com.norwood.mcheli.weapon.MCH_Cartridge;
import com.norwood.mcheli.weapon.MCH_SightType;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class, InlineAwareRepresenter.class, InlineSeq.class, ExAgg.class})
public class YamlEmitter
implements IEmitter {
    private static final Yaml YAML;

    public static void writeTo(Path out, CharSequence content) throws IOException {
        if (out.getParent() != null) {
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
        }
        Files.write(out, content.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static boolean notBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }

    private static boolean notBlank(ResourceLocation s) {
        return s != null;
    }

    private static <T> InlineSeq<T> inlineSeq(Collection<T> vals) {
        InlineSeq<T> seq = new InlineSeq<T>(vals.size());
        seq.addAll(vals);
        return seq;
    }

    private static double round3(double value) {
        return (double)Math.round(value * 1000.0) / 1000.0;
    }

    private static float round3(float value) {
        return (float)Math.round(value * 1000.0f) / 1000.0f;
    }

    private static InlineSeq<Double> inline(double ... values2) {
        InlineSeq<Double> seq = new InlineSeq<Double>(values2.length);
        for (double v : values2) {
            seq.add(YamlEmitter.round3(v));
        }
        return seq;
    }

    private static InlineSeq<String> inline(String ... values2) {
        InlineSeq<String> seq = new InlineSeq<String>(values2.length);
        Collections.addAll(seq, values2);
        return seq;
    }

    private static InlineSeq<Double> vec(Vec3d v) {
        return YamlEmitter.inline(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    private static InlineSeq<Double> vecMinusYOffset(Vec3d v) {
        return YamlEmitter.inline(v.field_72450_a, v.field_72448_b - (double)0.35f, v.field_72449_c);
    }

    private static String tankWeight(int ordinal) {
        return ordinal == 1 ? "CAR" : (ordinal == 2 ? "TANK" : "UNKNOWN");
    }

    @Nullable
    private static String sightToString(MCH_SightType sight) {
        String string;
        if (sight == null) {
            return null;
        }
        switch (sight) {
            case LOCK: {
                string = "missilesight";
                break;
            }
            case ROCKET: {
                string = "movesight";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static String flareTypeFromInt(int v) {
        String string;
        switch (v) {
            case 0: {
                string = "NONE";
                break;
            }
            case 1: {
                string = "NORMAL";
                break;
            }
            case 2: {
                string = "LARGE_AIRCRAFT";
                break;
            }
            case 3: {
                string = "SIDE";
                break;
            }
            case 4: {
                string = "FRONT";
                break;
            }
            case 5: {
                string = "DOWN";
                break;
            }
            case 10: {
                string = "SMOKE_LAUNCHER";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    private static String toHexRGB(int color) {
        int rgb = color & 0xFFFFFF;
        return String.format("#%06X", rgb);
    }

    private static String targetToString(int flags) {
        if ((flags & 0x40) != 0) {
            return "Block";
        }
        ArrayList<String> parts = new ArrayList<String>();
        if ((flags & 0x20) != 0) {
            parts.add("Planes");
        }
        if ((flags & 0x10) != 0) {
            parts.add("Helicopters");
        }
        if ((flags & 8) != 0) {
            parts.add("Vehicles");
        }
        if ((flags & 4) != 0) {
            parts.add("Players");
        }
        if ((flags & 2) != 0) {
            parts.add("Monsters");
        }
        if ((flags & 1) != 0) {
            parts.add("Others");
        }
        return String.join((CharSequence)",", parts);
    }

    @Override
    public String emitHelicopter(MCH_HeliInfo info) {
        MCH_HeliInfo dummyInfo = new MCH_HeliInfo(info.getLocation(), info.getContentPath());
        Map<String, Object> root = this.baseAircraft(info, dummyInfo);
        LinkedHashMap<String, Boolean> heli = new LinkedHashMap<String, Boolean>();
        heli.put("IsFoldableBlade", info.isEnableFoldBlade);
        root.put("HeliFeatures", heli);
        LinkedHashMap<String, List<Map<String, Object>>> components = new LinkedHashMap<String, List<Map<String, Object>>>();
        this.addCommonComponents(components, info);
        if (!components.isEmpty()) {
            root.put("Components", components);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitPlane(MCH_PlaneInfo info) {
        ArrayList<Map<String, Object>> list;
        MCH_PlaneInfo dummyInfo = new MCH_PlaneInfo(info.getLocation(), info.getContentPath());
        Map<String, Object> root = this.baseAircraft(info, dummyInfo);
        LinkedHashMap<String, Object> plane = new LinkedHashMap<String, Object>();
        plane.put("VariableSweepWing", info.isVariableSweepWing);
        plane.put("SweepWingSpeed", Float.valueOf(info.sweepWingSpeed));
        if (info.isEnableVtol) {
            LinkedHashMap<String, Comparable<Boolean>> vtol = new LinkedHashMap<String, Comparable<Boolean>>();
            vtol.put("IsDefault", Boolean.valueOf(info.isDefaultVtol));
            if (info.vtolYaw != 0.3f) {
                vtol.put("Yaw", Float.valueOf(info.vtolYaw));
            }
            if (info.vtolPitch != 0.2f) {
                vtol.put("Pitch", Float.valueOf(info.vtolPitch));
            }
            plane.put("EnableVtol", vtol);
        } else {
            plane.put("EnableVtol", false);
        }
        plane.put("EnableAutoPilot", info.isEnableAutoPilot);
        root.put("PlaneFeatures", plane);
        LinkedHashMap<String, List<Map<String, Object>>> components = new LinkedHashMap<String, List<Map<String, Object>>>();
        this.addCommonComponents(components, info);
        if (!info.rotorList.isEmpty()) {
            list = new ArrayList<Map<String, Object>>();
            for (MCH_PlaneInfo.Rotor rotor : info.rotorList) {
                Map<String, Object> rotMap = this.drawnPart(rotor);
                if (rotor.maxRotFactor != 0.0f) {
                    rotMap.put("RotFactor", Float.valueOf(rotor.maxRotFactor * 90.0f));
                }
                if (!rotor.blades.isEmpty()) {
                    ArrayList<Map<String, Object>> blades = new ArrayList<Map<String, Object>>();
                    for (MCH_PlaneInfo.Blade blade : rotor.blades) {
                        Map<String, Object> bladeMap = this.drawnPart(blade);
                        bladeMap.put("BladeNum", blade.numBlade);
                        bladeMap.put("BladeRot", blade.rotBlade);
                        blades.add(bladeMap);
                    }
                    rotMap.put("Blades", blades);
                }
                list.add(rotMap);
            }
            components.put("PlaneRotor", list);
        }
        if (!info.wingList.isEmpty()) {
            list = new ArrayList();
            for (MCH_PlaneInfo.Wing w : info.wingList) {
                Map<String, Object> m = this.drawnPart(w);
                m.put("MaxRotation", Float.valueOf(w.maxRot));
                if (w.pylonList != null && !w.pylonList.isEmpty()) {
                    ArrayList<Map<String, Object>> pylons = new ArrayList<Map<String, Object>>();
                    for (MCH_PlaneInfo.Pylon p : w.pylonList) {
                        Map<String, Object> pm = this.drawnPart(p);
                        pm.put("MaxRotation", Float.valueOf(p.maxRot));
                        pylons.add(pm);
                    }
                    m.put("Pylons", pylons);
                }
                list.add(m);
            }
            components.put("Wing", list);
        }
        if (!info.nozzles.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.DrawnPart np : info.nozzles) {
                list.add(this.drawnPart(np));
            }
            components.put("Nozzle", list);
        }
        if (!components.isEmpty()) {
            root.put("Components", components);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitShip(MCH_ShipInfo info) {
        MCH_ShipInfo dummyInfo = new MCH_ShipInfo(info.getLocation(), info.getContentPath());
        Map<String, Object> root = this.baseAircraft(info, dummyInfo);
        LinkedHashMap<String, List<Map<String, Object>>> components = new LinkedHashMap<String, List<Map<String, Object>>>();
        this.addCommonComponents(components, info);
        if (!components.isEmpty()) {
            root.put("Components", components);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitTank(MCH_TankInfo info) {
        MCH_TankInfo dummyInfo = new MCH_TankInfo(info.getLocation(), info.getContentPath());
        Map<String, Object> root = this.baseAircraft(info, dummyInfo);
        LinkedHashMap<String, Object> tank = new LinkedHashMap<String, Object>();
        tank.put("WeightType", YamlEmitter.tankWeight(info.weightType));
        tank.put("WeightedCenterZ", Float.valueOf(info.weightedCenterZ));
        root.put("TankFeatures", tank);
        LinkedHashMap<String, List<Map<String, Object>>> components = new LinkedHashMap<String, List<Map<String, Object>>>();
        this.addCommonComponents(components, info);
        if (!components.isEmpty()) {
            root.put("Components", components);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitVehicle(MCH_VehicleInfo info) {
        MCH_VehicleInfo dummyInfo = new MCH_VehicleInfo(info.getLocation(), info.getContentPath());
        Map<String, Object> root = this.baseAircraft(info, dummyInfo);
        LinkedHashMap<String, Boolean> veh = new LinkedHashMap<String, Boolean>();
        if (info.isEnableMove != dummyInfo.isEnableMove) {
            veh.put("CanMove", info.isEnableMove);
        }
        if (info.isEnableRot != dummyInfo.isEnableRot) {
            veh.put("CanRotate", info.isEnableRot);
        }
        if (!veh.isEmpty()) {
            root.put("VehicleFeatures", veh);
        }
        LinkedHashMap<String, List<Map<String, Object>>> components = new LinkedHashMap<String, List<Map<String, Object>>>();
        this.addCommonComponents(components, info);
        if (!info.partList.isEmpty()) {
            ArrayList<Map<String, Object>> vparts = new ArrayList<Map<String, Object>>();
            for (MCH_VehicleInfo.VPart vp : info.partList) {
                Map<String, Object> m = this.drawnPart(vp);
                m.put("DrawFP", vp.drawFP);
                m.put("CanYaw", vp.rotYaw);
                m.put("CanPitch", vp.rotPitch);
                m.put("Type", ComponentParser.VpartType.values()[vp.type].name());
                if (vp.recoilBuf != 0.0f) {
                    m.put("RecoilBuff", Float.valueOf(vp.recoilBuf));
                }
                if (vp.child != null && !vp.child.isEmpty()) {
                    ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
                    for (MCH_VehicleInfo.VPart cp : vp.child) {
                        Map<String, Object> cm = this.drawnPart(cp);
                        cm.put("DrawFP", cp.drawFP);
                        cm.put("CanYaw", cp.rotYaw);
                        cm.put("CanPitch", cp.rotPitch);
                        cm.put("Type", ComponentParser.VpartType.values()[cp.type].name());
                        if (cp.recoilBuf != 0.0f) {
                            cm.put("RecoilBuff", Float.valueOf(cp.recoilBuf));
                        }
                        children.add(cm);
                    }
                    m.put("Children", children);
                }
                vparts.add(m);
            }
            components.put("Vpart", vparts);
        }
        if (!components.isEmpty()) {
            root.put("Components", components);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitWeapon(MCH_WeaponInfo info) {
        int rgba1;
        int argb;
        int b;
        int g;
        int r;
        int a;
        LinkedHashMap<String, Object> mm;
        ArrayList flashes;
        String sight;
        MCH_WeaponInfo dummy = new MCH_WeaponInfo(info.location, info.filePath);
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        if (YamlEmitter.notBlank(info.displayName)) {
            root.put("DisplayName", info.displayName);
        }
        if (YamlEmitter.notBlank(info.type)) {
            root.put("Type", info.type);
        }
        if (YamlEmitter.notBlank(info.group)) {
            root.put("Group", info.group);
        }
        if (info.power != dummy.power) {
            root.put("BaseDamage", info.power);
        }
        LinkedHashMap<String, Serializable> ball = new LinkedHashMap<String, Serializable>();
        ball.put("Acceleration", Float.valueOf(info.acceleration));
        ball.put("AccelerationInWater", Float.valueOf(info.accelerationInWater));
        ball.put("Gravity", Float.valueOf(info.gravity));
        ball.put("GravityInWater", Float.valueOf(info.gravityInWater));
        ball.put("VelocityInWater", Float.valueOf(info.velocityInWater));
        if (info.speedFactor != dummy.speedFactor) {
            ball.put("SpeedFactor", Float.valueOf(info.speedFactor));
        }
        if (info.speedFactorStartTick != dummy.speedFactorStartTick) {
            ball.put("SpeedFactorStartTick", Integer.valueOf(info.speedFactorStartTick));
        }
        if (info.speedFactorEndTick != dummy.speedFactorEndTick) {
            ball.put("SpeedFactorEndTick", Integer.valueOf(info.speedFactorEndTick));
        }
        if (info.speedDependsAircraft != dummy.speedDependsAircraft) {
            ball.put("SpeedDependsAircraft", Boolean.valueOf(true));
        }
        if (info.piercing != dummy.piercing) {
            ball.put("Piercing", Integer.valueOf(info.piercing));
        }
        if (info.flakParticlesDiff != dummy.flakParticlesDiff) {
            ball.put("FlakSpread", Float.valueOf(info.flakParticlesDiff));
        }
        root.put("Ballistics", ball);
        LinkedHashMap<String, Serializable> snd = new LinkedHashMap<String, Serializable>();
        if (info.soundDelay != dummy.soundDelay) {
            snd.put("Delay", Integer.valueOf(info.soundDelay));
        }
        if (info.soundVolume != dummy.soundVolume) {
            snd.put("Volume", Float.valueOf(info.soundVolume));
        }
        if (info.soundPitch != dummy.soundPitch) {
            snd.put("Pitch", Float.valueOf(info.soundPitch));
        }
        if (info.soundPitchRandom != dummy.soundPitchRandom) {
            snd.put("PitchRandom", Float.valueOf(info.soundPitchRandom));
        }
        if (info.hitSoundRange != dummy.hitSoundRange) {
            snd.put("HitSoundRange", Float.valueOf(info.hitSoundRange));
        }
        LinkedHashMap<String, String> sndLoc = new LinkedHashMap<String, String>();
        if (YamlEmitter.notBlank(info.fireSound)) {
            sndLoc.put("Fire", info.fireSound.toString());
        }
        if (YamlEmitter.notBlank(info.hitSound)) {
            sndLoc.put("Hit", info.hitSound.toString());
        }
        if (YamlEmitter.notBlank(info.hitSoundIron) && !info.hitSoundIron.equals((Object)dummy.hitSoundIron)) {
            sndLoc.put("HitMetal", info.hitSoundIron.toString());
        }
        if (YamlEmitter.notBlank(info.railgunSound) && !info.railgunSound.equals((Object)dummy.railgunSound)) {
            sndLoc.put("Railgun", info.railgunSound.toString());
        }
        if (YamlEmitter.notBlank(info.weaponSwitchSound)) {
            sndLoc.put("WeaponSwitch", info.weaponSwitchSound.toString());
        }
        if (!sndLoc.isEmpty()) {
            snd.put("Locations", sndLoc);
        }
        if (!snd.isEmpty()) {
            root.put("Sound", snd);
        }
        LinkedHashMap<String, Number> recoil = new LinkedHashMap<String, Number>();
        if (info.recoil != dummy.recoil) {
            recoil.put("Power", Float.valueOf(info.recoil));
        }
        if (info.recoilPitch != dummy.recoilPitch) {
            recoil.put("Pitch", Float.valueOf(info.recoilPitch));
        }
        if (info.recoilYaw != dummy.recoilYaw) {
            recoil.put("Yaw", Float.valueOf(info.recoilYaw));
        }
        if (info.recoilPitchRange != dummy.recoilPitchRange) {
            recoil.put("PitchRange", Float.valueOf(info.recoilPitchRange));
        }
        if (info.recoilYawRange != dummy.recoilYawRange) {
            recoil.put("YawRange", Float.valueOf(info.recoilYawRange));
        }
        if (info.recoilRecoverFactor != dummy.recoilRecoverFactor) {
            recoil.put("RecoverFactor", Float.valueOf(info.recoilRecoverFactor));
        }
        if (info.recoilBufCount != dummy.recoilBufCount) {
            recoil.put("BufferCount", info.recoilBufCount);
        }
        if (info.recoilBufCountSpeed != dummy.recoilBufCountSpeed) {
            recoil.put("BufferSpeed", info.recoilBufCountSpeed);
        }
        if (!recoil.isEmpty()) {
            root.put("Recoil", recoil);
        }
        LinkedHashMap<String, Object> expl = new LinkedHashMap<String, Object>();
        if (info.explosion != dummy.explosion) {
            expl.put("Power", info.explosion);
        }
        if (!Objects.equals(info.explosionType, dummy.explosionType)) {
            expl.put("Type", info.explosionType);
        }
        if (info.explosionBlock != dummy.explosionBlock) {
            expl.put("DestructionPower", info.explosionBlock);
        }
        if (info.explosionInWater != dummy.explosionInWater) {
            expl.put("PowerUnderwater", info.explosionInWater);
        }
        if (info.explosionAltitude != dummy.explosionAltitude) {
            expl.put("ExplosionAltitude", info.explosionAltitude);
        }
        if (info.timeFuse != dummy.timeFuse) {
            expl.put("FuseTime", info.timeFuse);
        }
        if (info.delayFuse != dummy.delayFuse) {
            expl.put("FuseDelay", info.delayFuse);
        }
        if (info.bound != dummy.bound) {
            expl.put("FuseRebound", Float.valueOf(info.bound));
        }
        if (info.flaming != dummy.flaming) {
            expl.put("Flaming", info.flaming);
        }
        if (info.canAirburst != dummy.canAirburst) {
            expl.put("CanAirburst", info.canAirburst);
        }
        if (info.explosionAirburst != dummy.explosionAirburst) {
            expl.put("ExplosionAirburst", info.explosionAirburst);
        }
        if (info.proximityFuseDist != dummy.proximityFuseDist) {
            expl.put("ProximityFuseDist", Float.valueOf(info.proximityFuseDist));
        }
        if (info.disableDestroyBlock != dummy.disableDestroyBlock) {
            expl.put("CanDestroyBlocks", !info.disableDestroyBlock);
        }
        if (!expl.isEmpty()) {
            root.put("Explosion", expl);
        }
        LinkedHashMap<String, Object> cam = new LinkedHashMap<String, Object>();
        if (info.hasMortarRadar != dummy.hasMortarRadar) {
            cam.put("EnableMortarRadar", info.hasMortarRadar);
        }
        if (info.mortarRadarMaxDist != dummy.mortarRadarMaxDist) {
            cam.put("MortarRadarMaxDist", info.mortarRadarMaxDist);
        }
        if (info.displayMortarDistance != dummy.displayMortarDistance) {
            cam.put("DisplayMortarDistance", info.displayMortarDistance);
        }
        if (info.fixCameraPitch != dummy.fixCameraPitch) {
            cam.put("FixPitch", info.fixCameraPitch);
        }
        if (info.cameraRotationSpeedPitch != dummy.cameraRotationSpeedPitch) {
            cam.put("RotationSpeedPitch", Float.valueOf(info.cameraRotationSpeedPitch));
        }
        if (!Objects.equals(sight = YamlEmitter.sightToString(info.sight), YamlEmitter.sightToString(dummy.sight))) {
            cam.put("Sight", sight);
        }
        if (!Arrays.equals(info.zoom, dummy.zoom) && info.zoom != null && info.zoom.length > 0) {
            cam.put("Zoom", Floats.asList((float[])info.zoom));
        }
        if (!cam.isEmpty()) {
            root.put("Camera", cam);
        }
        LinkedHashMap<String, Object> missile = new LinkedHashMap<String, Object>();
        if (info.laserGuidance != dummy.laserGuidance) {
            missile.put("LaserGuidance", info.laserGuidance);
        }
        if (info.hasLaserGuidancePod != dummy.hasLaserGuidancePod) {
            missile.put("HasLaserGuidancePod", info.hasLaserGuidancePod);
        }
        if (info.enableOffAxis != dummy.enableOffAxis) {
            missile.put("IsOffAxis", info.enableOffAxis);
        }
        if (info.isGuidedTorpedo != dummy.isGuidedTorpedo) {
            missile.put("GuidedTorpedo", info.isGuidedTorpedo);
        }
        if (info.predictTargetPos != dummy.predictTargetPos) {
            missile.put("PredictTargetPos", info.predictTargetPos);
        }
        if (info.enableBVR != dummy.enableBVR) {
            missile.put("EnableBVR", info.enableBVR);
        }
        if (info.minRangeBVR != dummy.minRangeBVR) {
            missile.put("MinRangeBVR", info.minRangeBVR);
        }
        if (info.scanInterval != dummy.scanInterval) {
            missile.put("ScanInterval", info.scanInterval);
        }
        if (info.tickEndHoming != dummy.tickEndHoming) {
            missile.put("TickEndHoming", info.tickEndHoming);
        }
        if (info.pdHDNMaxDegree != dummy.pdHDNMaxDegree) {
            missile.put("PDHDNMaxDegree", Float.valueOf(info.pdHDNMaxDegree));
        }
        if (info.pdHDNMaxDegreeLockOutCount != dummy.pdHDNMaxDegreeLockOutCount) {
            missile.put("PDHDNMaxDegreeLockOutCount", info.pdHDNMaxDegreeLockOutCount);
        }
        if (info.turningFactor != dummy.turningFactor) {
            missile.put("TurningFactor", info.turningFactor);
        }
        if (info.maxDegreeOfMissile != dummy.maxDegreeOfMissile) {
            missile.put("MaxDegreeOfMissile", info.maxDegreeOfMissile);
        }
        if (info.canBeIntercepted != dummy.canBeIntercepted) {
            missile.put("CanBeIntercepted", info.canBeIntercepted);
        }
        if (!missile.isEmpty()) {
            root.put("Missile", missile);
        }
        LinkedHashMap<String, Comparable<Boolean>> lockOn = new LinkedHashMap<String, Comparable<Boolean>>();
        if (info.canLockMissile != dummy.canLockMissile) {
            lockOn.put("CanLockMissile", Boolean.valueOf(info.canLockMissile));
        }
        if (info.lockTime != dummy.lockTime) {
            lockOn.put("Time", Integer.valueOf(info.lockTime));
        }
        if (info.rigidityTime != dummy.rigidityTime) {
            lockOn.put("Delay", Integer.valueOf(info.rigidityTime));
        }
        if (info.maxLockOnRange != dummy.maxLockOnRange) {
            lockOn.put("MaxRange", Integer.valueOf(info.maxLockOnRange));
        }
        if (info.maxLockOnAngle != dummy.maxLockOnAngle) {
            lockOn.put("MaxAngle", Integer.valueOf(info.maxLockOnAngle));
        }
        if (info.lockMinHeight != dummy.lockMinHeight) {
            lockOn.put("MinHeight", Integer.valueOf(info.lockMinHeight));
        }
        if (info.passiveRadarLockOutCount != dummy.passiveRadarLockOutCount) {
            lockOn.put("PassiveRadarLockOutCount", Integer.valueOf(info.passiveRadarLockOutCount));
        }
        if (info.numLockedChaffMax != dummy.numLockedChaffMax) {
            lockOn.put("LockedChaffMax", Integer.valueOf(info.numLockedChaffMax));
        }
        if (!lockOn.isEmpty()) {
            missile.put("LockOn", lockOn);
        }
        LinkedHashMap<String, Boolean> radar = new LinkedHashMap<String, Boolean>();
        if (info.isRadarMissile != dummy.isRadarMissile) {
            radar.put("IsRadarMissile", info.isRadarMissile);
        }
        if (info.activeRadar != dummy.activeRadar) {
            radar.put("ActiveRadar", info.activeRadar);
        }
        if (info.passiveRadar != dummy.passiveRadar) {
            radar.put("PassiveRadar", info.passiveRadar);
        }
        if (!radar.isEmpty()) {
            missile.put("Radar", radar);
        }
        LinkedHashMap<String, Comparable<Boolean>> heat = new LinkedHashMap<String, Comparable<Boolean>>();
        if (info.isHeatSeekerMissile != dummy.isHeatSeekerMissile) {
            heat.put("isHeatMissile", Boolean.valueOf(info.isHeatSeekerMissile));
        }
        if (info.heatCount != dummy.heatCount) {
            heat.put("HeatCount", Integer.valueOf(info.heatCount));
        }
        if (info.maxHeatCount != dummy.maxHeatCount) {
            heat.put("MaxHeatCount", Integer.valueOf(info.maxHeatCount));
        }
        if (info.antiFlareCount != dummy.antiFlareCount) {
            heat.put("AntiFlareCount", Integer.valueOf(info.antiFlareCount));
        }
        if (!heat.isEmpty()) {
            missile.put("Heat", heat);
        }
        LinkedHashMap<String, Integer> marker = new LinkedHashMap<String, Integer>();
        if (info.markerRocketSpawnNum != dummy.markerRocketSpawnNum) {
            marker.put("Count", info.markerRocketSpawnNum);
        }
        if (info.markerRocketSpawnDiff != dummy.markerRocketSpawnDiff) {
            marker.put("Spread", info.markerRocketSpawnDiff);
        }
        if (info.markerRocketSpawnHeight != dummy.markerRocketSpawnHeight) {
            marker.put("SpawnHeight", info.markerRocketSpawnHeight);
        }
        if (info.markerRocketSpawnSpeed != dummy.markerRocketSpawnSpeed) {
            marker.put("Acceleration", info.markerRocketSpawnSpeed);
        }
        if (!marker.isEmpty()) {
            missile.put("MarkerRocket", marker);
        }
        if (!missile.isEmpty()) {
            root.put("Missile", missile);
        }
        LinkedHashMap<String, Serializable> ammo = new LinkedHashMap<String, Serializable>();
        if (info.reloadTime != dummy.reloadTime) {
            ammo.put("ReloadTime", Integer.valueOf(info.reloadTime));
        }
        if (info.round != dummy.round) {
            ammo.put("MagSize", Integer.valueOf(info.round));
        }
        if (info.maxAmmo != dummy.maxAmmo) {
            ammo.put("MaxAmmo", Integer.valueOf(info.maxAmmo));
        }
        if (info.suppliedNum != dummy.suppliedNum) {
            ammo.put("ResupplyCount", Integer.valueOf(info.suppliedNum));
        }
        if (info.roundItems != null && !info.roundItems.isEmpty()) {
            ArrayList rounds = new ArrayList();
            for (MCH_WeaponInfo.RoundItem ri : info.roundItems) {
                Iterator<MCH_WeaponInfo.MuzzleFlash> rm = new LinkedHashMap<String, Object>();
                rm.put("Count", ri.num);
                rm.put("Name", ri.itemName.toString().toLowerCase(Locale.ROOT));
                rm.put("Meta", ri.damage);
                rounds.add(rm);
            }
            ammo.put("AmmoItems", rounds);
        }
        if (!ammo.isEmpty()) {
            root.put("Ammo", ammo);
        }
        if (info.delay != dummy.delay) {
            root.put("FireCooldown", info.delay);
        }
        if (info.target != dummy.target) {
            root.put("Target", YamlEmitter.targetToString(info.target));
        }
        if (info.modeNum != dummy.modeNum) {
            root.put("Mode", info.modeNum);
        }
        if (info.fixMode != dummy.fixMode) {
            root.put("FixMode", info.fixMode);
        }
        if (info.ridableOnly != dummy.ridableOnly) {
            root.put("RidableOnly", info.ridableOnly);
        }
        if (info.accuracy != dummy.accuracy) {
            root.put("Accuracy", Float.valueOf(info.accuracy));
        }
        if (info.destruct != dummy.destruct) {
            root.put("SelfDestruct", info.destruct);
        }
        if (info.enableChunkLoader != dummy.enableChunkLoader) {
            root.put("CanLoadChunks", info.enableChunkLoader);
        }
        if (info.weaponSwitchCount != dummy.weaponSwitchCount) {
            root.put("SwitchCooldown", info.weaponSwitchCount);
        }
        if (info.crossType != dummy.crossType) {
            root.put("CrossType", info.crossType);
        }
        LinkedHashMap<String, Float> dmg = new LinkedHashMap<String, Float>();
        if (info.explosionDamageVsLiving != dummy.explosionDamageVsLiving) {
            dmg.put("ExplosionDamageVsLiving", Float.valueOf(info.explosionDamageVsLiving));
        }
        if (info.explosionDamageVsPlayer != dummy.explosionDamageVsPlayer) {
            dmg.put("ExplosionDamageVsPlayer", Float.valueOf(info.explosionDamageVsPlayer));
        }
        if (info.explosionDamageVsPlane != dummy.explosionDamageVsPlane) {
            dmg.put("ExplosionDamageVsPlane", Float.valueOf(info.explosionDamageVsPlane));
        }
        if (info.explosionDamageVsVehicle != dummy.explosionDamageVsVehicle) {
            dmg.put("ExplosionDamageVsVehicle", Float.valueOf(info.explosionDamageVsVehicle));
        }
        if (info.explosionDamageVsTank != dummy.explosionDamageVsTank) {
            dmg.put("ExplosionDamageVsTank", Float.valueOf(info.explosionDamageVsTank));
        }
        if (info.explosionDamageVsHeli != dummy.explosionDamageVsHeli) {
            dmg.put("ExplosionDamageVsHeli", Float.valueOf(info.explosionDamageVsHeli));
        }
        if (!dmg.isEmpty()) {
            root.put("Damage", dmg);
        }
        LinkedHashMap<String, Object> render = new LinkedHashMap<String, Object>();
        if (info.listMuzzleFlash != null && !info.listMuzzleFlash.isEmpty()) {
            flashes = new ArrayList();
            for (MCH_WeaponInfo.MuzzleFlash mf : info.listMuzzleFlash) {
                mm = new LinkedHashMap<String, Object>();
                mm.put("Distance", Float.valueOf(mf.dist));
                mm.put("Size", Float.valueOf(mf.size));
                mm.put("Range", Float.valueOf(mf.range));
                mm.put("Age", mf.age);
                mm.put("Count", mf.num);
                a = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.a)) * 255.0);
                r = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.r)) * 255.0);
                g = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.g)) * 255.0);
                b = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.b)) * 255.0);
                argb = a << 24 | r << 16 | g << 8 | b;
                mm.put("Color", String.format("#%06X", argb));
                flashes.add(mm);
            }
            render.put("MuzzleFlashes", flashes);
        }
        if (info.listMuzzleFlashSmoke != null && !info.listMuzzleFlashSmoke.isEmpty()) {
            flashes = new ArrayList();
            for (MCH_WeaponInfo.MuzzleFlash mf : info.listMuzzleFlashSmoke) {
                mm = new LinkedHashMap();
                mm.put("Distance", Float.valueOf(mf.dist));
                mm.put("Size", Float.valueOf(mf.size));
                mm.put("Range", Float.valueOf(mf.range));
                mm.put("Age", mf.age);
                mm.put("Count", mf.num);
                a = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.a)) * 255.0);
                r = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.r)) * 255.0);
                g = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.g)) * 255.0);
                b = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, mf.b)) * 255.0);
                argb = a << 24 | r << 16 | g << 8 | b;
                mm.put("Color", String.format("#%06X", argb));
                flashes.add(mm);
            }
            render.put("MuzzleSmoke", flashes);
        }
        if (info.cartridge != null) {
            MCH_Cartridge casing = info.cartridge;
            LinkedHashMap<String, Object> casingMap = new LinkedHashMap<String, Object>();
            casingMap.put("Name", casing.name);
            casingMap.put("Acceleration", Float.valueOf(casing.acceleration));
            casingMap.put("Yaw", Float.valueOf(casing.yaw));
            casingMap.put("Pitch", Float.valueOf(casing.pitch));
            casingMap.put("Scale", Float.valueOf(casing.scale));
            casingMap.put("Gravity", Float.valueOf(casing.gravity));
            casingMap.put("Bound", Float.valueOf(casing.bound));
            render.put("SpentCasings", casingMap);
        }
        if (!Objects.equals(info.bulletModelName, dummy.bulletModelName) && YamlEmitter.notBlank(info.bulletModelName)) {
            render.put("BulletModel", info.bulletModelName);
        }
        if (!Objects.equals(info.bombletModelName, dummy.bombletModelName) && YamlEmitter.notBlank(info.bombletModelName)) {
            render.put("BombletModel", info.bombletModelName);
        }
        if (!Objects.equals(info.trajectoryParticleName, dummy.trajectoryParticleName) && YamlEmitter.notBlank(info.trajectoryParticleName)) {
            render.put("TrajectoryParticle", info.trajectoryParticleName);
        }
        if (info.trajectoryParticleStartTick != dummy.trajectoryParticleStartTick) {
            render.put("TrajectoryParticleStartTick", info.trajectoryParticleStartTick);
        }
        if (info.flakParticlesCrack != dummy.flakParticlesCrack) {
            render.put("FlakParticlesCrack", info.flakParticlesCrack);
        }
        if (info.numParticlesFlak != dummy.numParticlesFlak) {
            render.put("ParticlesFlak", info.numParticlesFlak);
        }
        LinkedHashMap<String, Object> smoke = new LinkedHashMap<String, Object>();
        if (info.disableSmoke != dummy.disableSmoke) {
            smoke.put("DisableSmoke", info.disableSmoke);
        }
        if (info.smokeSize != dummy.smokeSize) {
            smoke.put("SmokeSize", Float.valueOf(info.smokeSize));
        }
        if (info.smokeNum != dummy.smokeNum) {
            smoke.put("SmokeNum", info.smokeNum);
        }
        if (info.smokeMaxAge != dummy.smokeMaxAge) {
            smoke.put("SmokeMaxAge", info.smokeMaxAge);
        }
        if (!Objects.equals(info.colorInWater, dummy.colorInWater) && info.colorInWater != null) {
            int a2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.colorInWater.a)) * 255.0);
            int r2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.colorInWater.r)) * 255.0);
            int g2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.colorInWater.g)) * 255.0);
            int b2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.colorInWater.b)) * 255.0);
            rgba1 = a2 << 24 | r2 << 16 | g2 << 8 | b2;
            smoke.put("BulletColorInWater", String.format("#%06X", rgba1));
        }
        if (!Objects.equals(info.color, dummy.color) && info.color != null) {
            int a2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.color.a)) * 255.0);
            int r2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.color.r)) * 255.0);
            int g2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.color.g)) * 255.0);
            int b2 = (int)Math.round((double)Math.max(0.0f, Math.min(1.0f, info.color.b)) * 255.0);
            rgba1 = a2 << 24 | r2 << 16 | g2 << 8 | b2;
            smoke.put("BulletColor", String.format("#%06X", rgba1));
        }
        if (!smoke.isEmpty()) {
            render.put("Smoke", smoke);
        }
        if (!render.isEmpty()) {
            root.put("Render", render);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitThrowable(MCH_ThrowableInfo info) {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        MCH_ThrowableInfo dummy = new MCH_ThrowableInfo(info.location, info.filePath);
        if (!Objects.equals(info.displayName, dummy.displayName) || !info.displayNameLang.isEmpty()) {
            if (info.displayNameLang.isEmpty()) {
                root.put("DisplayName", info.displayName);
            } else {
                LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>(info.displayNameLang);
                nameMap.put("DEFAULT", info.displayName);
                root.put("DisplayName", nameMap);
            }
        }
        if (info.itemID != dummy.itemID) {
            root.put("ItemID", info.itemID);
        }
        LinkedHashMap<String, Float> soundMap = new LinkedHashMap<String, Float>();
        if (info.soundVolume != dummy.soundVolume) {
            soundMap.put("Volume", Float.valueOf(info.soundVolume));
        }
        if (info.soundPitch != dummy.soundPitch) {
            soundMap.put("Pitch", Float.valueOf(info.soundPitch));
        }
        if (!soundMap.isEmpty()) {
            root.put("Sound", soundMap);
        }
        if (info.isShapedRecipe != dummy.isShapedRecipe || info.recipeString != null && !info.recipeString.isEmpty()) {
            LinkedHashMap<String, Serializable> recipeMap = new LinkedHashMap<String, Serializable>();
            recipeMap.put("isShaped", Boolean.valueOf(info.isShapedRecipe));
            if (info.recipeString != null && !info.recipeString.isEmpty()) {
                ArrayList<String> pattern = new ArrayList<String>();
                for (String s : info.recipeString) {
                    pattern.add(s.trim().toUpperCase());
                }
                recipeMap.put("Pattern", pattern);
            }
            root.put("Recepie", recipeMap);
        }
        if (info.power != dummy.power) {
            root.put("Power", info.power);
        }
        if (info.acceleration != dummy.acceleration) {
            root.put("Acceleration", Float.valueOf(info.acceleration));
        }
        if (info.accelerationInWater != dummy.accelerationInWater) {
            root.put("AccelerationInWater", Float.valueOf(info.accelerationInWater));
        }
        if (info.dispenseAcceleration != dummy.dispenseAcceleration) {
            root.put("DispenseAcceleration", Float.valueOf(info.dispenseAcceleration));
        }
        if (info.explosion != dummy.explosion) {
            root.put("Explosion", info.explosion);
        }
        if (info.delayFuse != dummy.delayFuse) {
            root.put("DelayFuse", info.delayFuse);
        }
        if (info.bound != dummy.bound) {
            root.put("Bound", Float.valueOf(info.bound));
        }
        if (info.timeFuse != dummy.timeFuse) {
            root.put("TimeFuse", info.timeFuse);
        }
        if (info.flaming != dummy.flaming) {
            root.put("Flaming", info.flaming);
        }
        if (info.stackSize != dummy.stackSize) {
            root.put("StackSize", info.stackSize);
        }
        if (info.proximityFuseDist != dummy.proximityFuseDist) {
            root.put("ProximityFuseDist", Float.valueOf(info.proximityFuseDist));
        }
        if (info.accuracy != dummy.accuracy) {
            root.put("Accuracy", Float.valueOf(info.accuracy));
        }
        if (info.aliveTime != dummy.aliveTime) {
            root.put("AliveTime", info.aliveTime);
        }
        if (info.bomblet != dummy.bomblet) {
            root.put("Bomblet", info.bomblet);
        }
        if (info.bombletDiff != dummy.bombletDiff) {
            root.put("BombletSpread", Float.valueOf(info.bombletDiff));
        }
        if (info.gravity != dummy.gravity) {
            root.put("Gravity", Float.valueOf(info.gravity));
        }
        if (info.gravityInWater != dummy.gravityInWater) {
            root.put("GravityInWater", Float.valueOf(info.gravityInWater));
        }
        if (!Objects.equals(info.particleName, dummy.particleName)) {
            root.put("Particle", info.particleName);
        }
        if (info.disableSmoke != dummy.disableSmoke || info.smokeSize != dummy.smokeSize || info.smokeNum != dummy.smokeNum || info.smokeColor != null || info.smokeVelocityHorizontal != dummy.smokeVelocityHorizontal || info.smokeVelocityVertical != dummy.smokeVelocityVertical) {
            LinkedHashMap<String, Object> smokeMap = new LinkedHashMap<String, Object>();
            if (info.disableSmoke != dummy.disableSmoke) {
                smokeMap.put("DisableSmoke", info.disableSmoke);
            }
            if (info.smokeSize != dummy.smokeSize) {
                smokeMap.put("Size", Float.valueOf(info.smokeSize));
            }
            if (info.smokeNum != dummy.smokeNum) {
                smokeMap.put("Count", info.smokeNum);
            }
            if (info.smokeColor != null) {
                smokeMap.put("Color", info.smokeColor.toHexString());
            }
            LinkedHashMap<String, Float> velMap = new LinkedHashMap<String, Float>();
            if (info.smokeVelocityVertical != dummy.smokeVelocityVertical) {
                velMap.put("Vertical", Float.valueOf(info.smokeVelocityVertical));
            }
            if (info.smokeVelocityHorizontal != dummy.smokeVelocityHorizontal) {
                velMap.put("Horizontal", Float.valueOf(info.smokeVelocityHorizontal));
            }
            if (!velMap.isEmpty()) {
                smokeMap.put("Velocity", velMap);
            }
            root.put("Smoke", smokeMap);
        }
        return YAML.dump(root);
    }

    @Override
    public String emitHud(MCH_Hud hud) {
        ArrayList rootList = new ArrayList();
        ListIterator<MCH_HudItem> iterator2 = hud.list.listIterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Object> entry;
            MCH_HudItemConditional conditional;
            MCH_HudItem item = iterator2.next();
            if (item instanceof MCH_HudItemConditional && !(conditional = (MCH_HudItemConditional)item).isEndif()) {
                LinkedHashMap<String, Object> conditionalMap = new LinkedHashMap<String, Object>();
                conditionalMap.put("If", conditional.getConditional());
                conditionalMap.put("Do", this.collectConditionalList(iterator2));
                rootList.add(conditionalMap);
                continue;
            }
            if (item instanceof MCH_HudItemConditional || (entry = this.getHudEntry(item)) == null) continue;
            LinkedHashMap<String, Object> itemMap = new LinkedHashMap<String, Object>();
            itemMap.put(entry.getKey(), entry.getValue());
            rootList.add(itemMap);
        }
        return YAML.dump(rootList);
    }

    private List<Object> collectConditionalList(Iterator<MCH_HudItem> iterator2) {
        MCH_HudItemConditional conditional;
        MCH_HudItem item;
        ArrayList<Object> list = new ArrayList<Object>();
        while (!(!iterator2.hasNext() || (item = iterator2.next()) instanceof MCH_HudItemConditional && (conditional = (MCH_HudItemConditional)item).isEndif())) {
            if (item instanceof MCH_HudItemConditional) {
                MCH_HudItemConditional nested = (MCH_HudItemConditional)item;
                LinkedHashMap<String, Object> nestedMap = new LinkedHashMap<String, Object>();
                nestedMap.put("If", nested.getConditional());
                nestedMap.put("Do", this.collectConditionalList(iterator2));
                list.add(nestedMap);
                continue;
            }
            Map.Entry<String, Object> entry = this.getHudEntry(item);
            if (entry == null) continue;
            LinkedHashMap<String, Object> itemMap = new LinkedHashMap<String, Object>();
            itemMap.put(entry.getKey(), entry.getValue());
            list.add(itemMap);
        }
        return list;
    }

    public Map.Entry<String, Object> getHudEntry(MCH_HudItem hudItem) {
        if (hudItem instanceof MCH_HudItemColor) {
            MCH_HudItemColor color = (MCH_HudItemColor)hudItem;
            return new AbstractMap.SimpleEntry<String, Object>("Color", color.getUpdateColor());
        }
        if (hudItem instanceof MCH_HudItemExit) {
            return new AbstractMap.SimpleEntry<String, Object>("Exit", "exit");
        }
        if (hudItem instanceof MCH_HudItemTexture) {
            MCH_HudItemTexture texture = (MCH_HudItemTexture)hudItem;
            LinkedHashMap<String, Object> textureSettings = new LinkedHashMap<String, Object>();
            textureSettings.put("Name", texture.getName());
            textureSettings.put("Position", YamlEmitter.inline(texture.getLeft(), texture.getTop()));
            textureSettings.put("Size", YamlEmitter.inline(texture.getWidth(), texture.getHeight()));
            textureSettings.put("UVPos", YamlEmitter.inline(texture.getULeft(), texture.getVTop()));
            textureSettings.put("UVSize", YamlEmitter.inline(texture.getUWidth(), texture.getVHeight()));
            textureSettings.put("Rotation", texture.getRot());
            return new AbstractMap.SimpleEntry<String, Object>("DrawTexture", textureSettings);
        }
        if (hudItem instanceof MCH_HudItemString) {
            MCH_HudItemString string = (MCH_HudItemString)hudItem;
            LinkedHashMap<String, Object> stringSettings = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> textMap = new LinkedHashMap<String, Object>();
            textMap.put("Fmt", string.getFormat());
            textMap.put("Vars", YamlEmitter.inline((String[])Arrays.stream(string.getArgs()).map(Enum::name).toArray(String[]::new)));
            stringSettings.put("Text", textMap);
            stringSettings.put("Position", YamlEmitter.inline(string.getPosX(), string.getPosY()));
            stringSettings.put("Center", string.isCenteredString());
            return new AbstractMap.SimpleEntry<String, Object>("DrawString", stringSettings);
        }
        if (hudItem instanceof MCH_HudItemCameraRot) {
            MCH_HudItemCameraRot cameraRot = (MCH_HudItemCameraRot)hudItem;
            LinkedHashMap<String, InlineSeq<String>> rotSettings = new LinkedHashMap<String, InlineSeq<String>>();
            rotSettings.put("Position", YamlEmitter.inline(cameraRot.getDrawPosX(), cameraRot.getDrawPosY()));
            return new AbstractMap.SimpleEntry<String, Object>("CameraRotation", rotSettings);
        }
        if (hudItem instanceof MCH_HudItemRect) {
            MCH_HudItemRect rect = (MCH_HudItemRect)hudItem;
            LinkedHashMap<String, InlineSeq<String>> rectSettings = new LinkedHashMap<String, InlineSeq<String>>();
            rectSettings.put("Position", YamlEmitter.inline(rect.getLeft(), rect.getTop()));
            rectSettings.put("Size", YamlEmitter.inline(rect.getWidth(), rect.getHeight()));
            return new AbstractMap.SimpleEntry<String, Object>("DrawRectangle", rectSettings);
        }
        if (hudItem instanceof MCH_HudItemLine) {
            MCH_HudItemLine line = (MCH_HudItemLine)hudItem;
            LinkedHashMap<String, Serializable> lineSettings = new LinkedHashMap<String, Serializable>();
            String[] posArray = line.getPos();
            ArrayList<InlineSeq<String>> positions = new ArrayList<InlineSeq<String>>();
            for (int i = 0; i < posArray.length; i += 2) {
                positions.add(YamlEmitter.inline(posArray[i], posArray[i + 1]));
            }
            lineSettings.put("Position", positions);
            lineSettings.put("Striped", Boolean.valueOf(false));
            return new AbstractMap.SimpleEntry<String, Object>("DrawLine", lineSettings);
        }
        if (hudItem instanceof MCH_HudItemLineStipple) {
            MCH_HudItemLineStipple line = (MCH_HudItemLineStipple)hudItem;
            LinkedHashMap<String, Object> lineSettings = new LinkedHashMap<String, Object>();
            String[] posArray = line.getPos();
            ArrayList<InlineSeq<String>> positions = new ArrayList<InlineSeq<String>>();
            for (int i = 0; i < posArray.length; i += 2) {
                positions.add(YamlEmitter.inline(posArray[i], posArray[i + 1]));
            }
            lineSettings.put("Position", positions);
            lineSettings.put("Factor", line.getFac());
            lineSettings.put("Pattern", line.getPat());
            lineSettings.put("Striped", true);
            return new AbstractMap.SimpleEntry<String, Object>("DrawLine", lineSettings);
        }
        if (hudItem instanceof MCH_HudItemCall) {
            MCH_HudItemCall call = (MCH_HudItemCall)hudItem;
            return new AbstractMap.SimpleEntry<String, Object>("Call", call.getHudName());
        }
        if (hudItem instanceof MCH_HudItemRadar) {
            MCH_HudItemRadar radar = (MCH_HudItemRadar)hudItem;
            LinkedHashMap<String, Object> radarSettings = new LinkedHashMap<String, Object>();
            radarSettings.put("Position", YamlEmitter.inline(radar.getLeft(), radar.getTop()));
            radarSettings.put("Size", YamlEmitter.inline(radar.getWidth(), radar.getHeight()));
            radarSettings.put("Rotation", radar.getRot());
            radarSettings.put("EntityRadar", radar.isEntityRadar());
            return new AbstractMap.SimpleEntry<String, Object>("DrawRadar", radarSettings);
        }
        if (hudItem instanceof MCH_HudItemGraduation) {
            HUDParser.GraduationType typeEnum;
            MCH_HudItemGraduation grad = (MCH_HudItemGraduation)hudItem;
            LinkedHashMap<String, Object> gradSettings = new LinkedHashMap<String, Object>();
            HUDParser.GraduationType graduationType = typeEnum = grad.getType() >= 0 ? HUDParser.GraduationType.values()[grad.getType()] : null;
            if (typeEnum != null) {
                gradSettings.put("Type", typeEnum.name());
            }
            gradSettings.put("Position", YamlEmitter.inline(grad.getDrawPosX(), grad.getDrawPosY()));
            gradSettings.put("Rotation", grad.getDrawRot());
            gradSettings.put("Roll", grad.getDrawRoll());
            return new AbstractMap.SimpleEntry<String, Object>("DrawGraduation", gradSettings);
        }
        return null;
    }

    @Override
    public String emitItem(MCH_ItemInfo info) {
        LinkedHashMap<String, String> root = new LinkedHashMap<String, String>();
        root.put("DisplayName", info.displayName);
        return YAML.dump(root);
    }

    private float convertRotorSpeed(float speed) {
        float rounded = YamlEmitter.round3(speed);
        if (rounded > 0.01f) {
            rounded -= 0.01f;
        }
        if (rounded < -0.01f) {
            rounded += 0.01f;
        }
        return rounded;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> baseAircraft(MCH_AircraftInfo info, MCH_AircraftInfo dummyInfo) {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        if (info.displayNameLang != null && !info.displayNameLang.isEmpty()) {
            LinkedHashMap<String, String> dn = new LinkedHashMap<String, String>();
            dn.put("DEFAULT", info.displayName);
            dn.putAll(info.displayNameLang);
            root.put("DisplayName", dn);
        } else {
            root.put("DisplayName", info.displayName);
        }
        if (info.itemID > 0) {
            root.put("ItemID", info.itemID);
        }
        if (YamlEmitter.notBlank(info.category)) {
            root.put("Category", info.category.toUpperCase(Locale.ROOT));
        }
        if (info.recipeString != null && !info.recipeString.isEmpty()) {
            LinkedHashMap<String, Object> rec = new LinkedHashMap<String, Object>();
            rec.put("isShaped", info.isShapedRecipe);
            rec.put("Pattern", info.recipeString);
            root.put("Recepie", rec);
        }
        if (info.canRide != dummyInfo.canRide) {
            root.put("CanRide", info.canRide);
        }
        if (info.rotorSpeed != dummyInfo.rotorSpeed) {
            root.put("RotorSpeed", Float.valueOf(this.convertRotorSpeed(info.rotorSpeed)));
        }
        if (!info.turretPosition.equals((Object)Vec3d.field_186680_a)) {
            root.put("TurretPosition", YamlEmitter.vec(info.turretPosition));
        }
        if (info.unmountPosition != null) {
            root.put("GlobalUnmountPos", YamlEmitter.vec(info.unmountPosition));
        }
        if (info.creativeOnly != dummyInfo.creativeOnly) {
            root.put("CreativeOnly", info.creativeOnly);
        }
        if (info.regeneration != dummyInfo.regeneration) {
            root.put("Regeneration", info.regeneration);
        }
        if (info.invulnerable != dummyInfo.invulnerable) {
            root.put("Invulnerable", info.invulnerable);
        }
        if (info.maxFuel != dummyInfo.maxFuel) {
            root.put("MaxFuel", info.maxFuel);
        }
        if (info.maxHp != dummyInfo.maxHp) {
            root.put("MaxHP", info.maxHp);
        }
        if (info.stealth != dummyInfo.stealth) {
            root.put("Stealth", Float.valueOf(info.stealth));
        }
        if (info.fuelConsumption != dummyInfo.fuelConsumption) {
            root.put("FuelConsumption", Float.valueOf(info.fuelConsumption));
        }
        if (info.fuelSupplyRange != dummyInfo.fuelSupplyRange) {
            root.put("FuelSupplyRange", Float.valueOf(info.fuelSupplyRange));
        }
        if (info.ammoSupplyRange != dummyInfo.ammoSupplyRange) {
            root.put("AmmoSupplyRange", Float.valueOf(info.ammoSupplyRange));
        }
        if (info.repairOtherVehiclesRange != 0.0f || info.repairOtherVehiclesValue != 0) {
            LinkedHashMap<String, Number> repair = new LinkedHashMap<String, Number>();
            repair.put("Range", Float.valueOf(info.repairOtherVehiclesRange));
            repair.put("Value", info.repairOtherVehiclesValue);
            root.put("RepairOtherVehicles", repair);
        }
        if (YamlEmitter.notBlank(info.nameOnModernAARadar) && !info.nameOnModernAARadar.equals(dummyInfo.nameOnModernAARadar)) {
            root.put("NameOnModernAARadar", info.nameOnModernAARadar);
        }
        if (YamlEmitter.notBlank(info.nameOnEarlyAARadar) && !info.nameOnEarlyAARadar.equals(dummyInfo.nameOnEarlyAARadar)) {
            root.put("NameOnEarlyAARadar", info.nameOnEarlyAARadar);
        }
        if (YamlEmitter.notBlank(info.nameOnModernASRadar) && !info.nameOnModernASRadar.equals(dummyInfo.nameOnModernASRadar)) {
            root.put("NameOnModernASRadar", info.nameOnModernASRadar);
        }
        if (YamlEmitter.notBlank(info.nameOnEarlyASRadar) && !info.nameOnEarlyASRadar.equals(dummyInfo.nameOnEarlyASRadar)) {
            root.put("NameOnEarlyASRadar", info.nameOnEarlyASRadar);
        }
        if (info.explosionSizeByCrash != dummyInfo.explosionSizeByCrash) {
            root.put("ExplosionSizeByCrash", (int)info.explosionSizeByCrash);
        }
        if (info.throttleDownFactor != dummyInfo.explosionSizeByCrash) {
            root.put("ThrottleDownFactor", Float.valueOf(info.throttleDownFactor));
        }
        LinkedHashMap<String, Object> camera = new LinkedHashMap<String, Object>();
        if (info.thirdPersonDist != dummyInfo.thirdPersonDist) {
            camera.put("ThirdPersonDist", Float.valueOf(info.thirdPersonDist));
        }
        if (info.alwaysCameraView != dummyInfo.alwaysCameraView) {
            camera.put("AlwaysCameraView", true);
        }
        if (info.cameraZoom != dummyInfo.cameraZoom) {
            camera.put("Zoom", info.cameraZoom);
        }
        if (info.defaultFreelook != dummyInfo.defaultFreelook) {
            camera.put("DefaultFreeLook", info.defaultFreelook);
        }
        if (info.cameraRotationSpeed != dummyInfo.cameraRotationSpeed) {
            camera.put("RotationSpeed", Float.valueOf(info.cameraRotationSpeed));
        }
        if (!info.cameraPosition.isEmpty()) {
            ArrayList camList = new ArrayList();
            for (MCH_AircraftInfo.CameraPosition cp : info.cameraPosition) {
                LinkedHashMap<String, Serializable> cm = new LinkedHashMap<String, Serializable>();
                cm.put("Pos", YamlEmitter.vecMinusYOffset(cp.pos));
                if (cp.fixRot) {
                    cm.put("FixedRot", Boolean.valueOf(true));
                }
                if (cp.yaw != 0.0f) {
                    cm.put("Yaw", Float.valueOf(cp.yaw));
                }
                if (cp.pitch != 0.0f) {
                    cm.put("Pitch", Float.valueOf(cp.pitch));
                }
                camList.add(cm);
            }
            camera.put("Pos", camList);
        }
        if (!camera.isEmpty()) {
            root.put("Camera", camera);
        }
        LinkedHashMap<String, Object> sound = new LinkedHashMap<String, Object>();
        if (YamlEmitter.notBlank(info.soundMove)) {
            sound.put("MoveSound", info.soundMove.toString());
        }
        if (info.soundVolume != dummyInfo.soundVolume) {
            sound.put("Vol", Float.valueOf(info.soundVolume));
        }
        if (info.soundPitch != dummyInfo.soundPitch) {
            sound.put("Pitch", Float.valueOf(info.soundPitch));
        }
        if (info.soundRange != dummyInfo.soundRange) {
            sound.put("Range", Float.valueOf(info.soundRange));
        }
        if (!sound.isEmpty()) {
            root.put("Sound", sound);
        }
        LinkedHashMap<String, Object> phys = new LinkedHashMap<String, Object>();
        if (info.speed != dummyInfo.speed) {
            phys.put("Speed", Float.valueOf(info.speed));
        }
        if (info.isFloat != dummyInfo.isFloat) {
            phys.put("CanFloat", info.isFloat);
        }
        if (info.floatOffset != dummyInfo.floatOffset) {
            phys.put("FloatOffset", Float.valueOf(-info.floatOffset));
        }
        if (info.motionFactor != dummyInfo.motionFactor) {
            phys.put("MotionFactor", Float.valueOf(info.motionFactor));
        }
        if (info.gravity != dummyInfo.gravity) {
            phys.put("Gravity", Float.valueOf(info.gravity));
        }
        if (info.autoPilotRot != dummyInfo.autoPilotRot) {
            phys.put("RotationSnapValue", Float.valueOf(info.autoPilotRot));
        }
        if (info.gravityInWater != dummyInfo.gravityInWater) {
            phys.put("GravityInWater", Float.valueOf(info.gravityInWater));
        }
        if (info.stepHeight != dummyInfo.stepHeight) {
            phys.put("StepHeight", Float.valueOf(info.stepHeight));
        }
        if (info.canRotOnGround != dummyInfo.canRotOnGround) {
            phys.put("CanRotOnGround", info.canRotOnGround);
        }
        if (info.canMoveOnGround != dummyInfo.canMoveOnGround) {
            phys.put("CanMoveOnGround", info.canMoveOnGround);
        }
        if (info.onGroundPitch != dummyInfo.onGroundPitch) {
            phys.put("OnGroundPitch", Float.valueOf(info.onGroundPitch));
        }
        if (info.pivotTurnThrottle != dummyInfo.pivotTurnThrottle) {
            phys.put("PivotTurnThrottle", Float.valueOf(info.pivotTurnThrottle));
        }
        LinkedHashMap<String, Float> mobility = new LinkedHashMap<String, Float>();
        if (info.mobilityYaw != dummyInfo.mobilityYaw) {
            mobility.put("Yaw", Float.valueOf(info.mobilityYaw));
        }
        if (info.mobilityPitch != dummyInfo.mobilityPitch) {
            mobility.put("Pitch", Float.valueOf(info.mobilityPitch));
        }
        if (info.mobilityRoll != dummyInfo.mobilityRoll) {
            mobility.put("Roll", Float.valueOf(info.mobilityRoll));
        }
        if (info.mobilityYawOnGround != dummyInfo.mobilityYawOnGround) {
            mobility.put("YawOnGround", Float.valueOf(info.mobilityYawOnGround));
        }
        if (!mobility.isEmpty()) {
            phys.put("Mobility", mobility);
        }
        LinkedHashMap<String, Float> gpf = new LinkedHashMap<String, Float>();
        if (info.onGroundPitchFactor != dummyInfo.onGroundPitchFactor) {
            gpf.put("Pitch", Float.valueOf(info.onGroundPitchFactor));
        }
        if (info.onGroundRollFactor != dummyInfo.onGroundRollFactor) {
            gpf.put("Roll", Float.valueOf(info.onGroundRollFactor));
        }
        if (!gpf.isEmpty()) {
            phys.put("GroundPitchFactors", gpf);
        }
        LinkedHashMap<String, Float> bodySize = new LinkedHashMap<String, Float>();
        if (info.bodyHeight != dummyInfo.bodyHeight) {
            bodySize.put("Height", Float.valueOf(info.bodyHeight));
        }
        if (info.bodyWidth != dummyInfo.bodyWidth) {
            bodySize.put("Width", Float.valueOf(info.bodyWidth));
        }
        if (!bodySize.isEmpty()) {
            phys.put("BodySize", bodySize);
        }
        if (info.limitRotation) {
            LinkedHashMap rotLimits = new LinkedHashMap();
            LinkedHashMap<String, Float> pitch = new LinkedHashMap<String, Float>();
            if (info.minRotationPitch != dummyInfo.minRotationPitch) {
                pitch.put("Min", Float.valueOf(info.minRotationPitch));
            }
            if (info.maxRotationPitch != dummyInfo.maxRotationPitch) {
                pitch.put("Max", Float.valueOf(info.maxRotationPitch));
            }
            if (!pitch.isEmpty()) {
                rotLimits.put("Pitch", pitch);
            }
            LinkedHashMap<String, Float> roll = new LinkedHashMap<String, Float>();
            if (info.minRotationRoll != dummyInfo.minRotationRoll) {
                roll.put("Min", Float.valueOf(info.minRotationRoll));
            }
            if (info.maxRotationRoll != dummyInfo.maxRotationRoll) {
                roll.put("Max", Float.valueOf(info.maxRotationRoll));
            }
            if (!roll.isEmpty()) {
                rotLimits.put("Roll", roll);
            }
            if (!rotLimits.isEmpty()) {
                phys.put("RotationLimits", rotLimits);
            }
        }
        if (!phys.isEmpty()) {
            root.put("PhysicalProperties", phys);
        }
        LinkedHashMap<String, Object> render = new LinkedHashMap<String, Object>();
        if (info.smoothShading != dummyInfo.smoothShading) {
            render.put("SmoothShading", info.smoothShading);
        }
        if (info.hideEntity != dummyInfo.hideEntity) {
            render.put("HideRiders", info.hideEntity);
        }
        if (info.entityWidth != dummyInfo.entityWidth) {
            render.put("ModelWidth", Float.valueOf(info.entityWidth));
        }
        if (info.entityHeight != dummyInfo.entityHeight) {
            render.put("ModelHeight", Float.valueOf(info.entityHeight));
        }
        if (info.entityPitch != dummyInfo.entityPitch) {
            render.put("ModelPitch", Float.valueOf(info.entityPitch));
        }
        if (info.entityRoll != dummyInfo.entityRoll) {
            render.put("ModelRoll", Float.valueOf(info.entityRoll));
        }
        if (info.particlesScale != dummyInfo.particlesScale) {
            render.put("ParticleScale", Float.valueOf(info.particlesScale));
        }
        if (info.oneProbeScale != dummyInfo.oneProbeScale) {
            render.put("OneProbeScale", Float.valueOf(info.oneProbeScale));
        }
        if (info.enableSeaSurfaceParticle != dummyInfo.enableSeaSurfaceParticle) {
            render.put("EnableSeaSurfaceParticle", info.enableSeaSurfaceParticle);
        }
        if (!info.particleSplashs.isEmpty()) {
            ArrayList splash = new ArrayList();
            for (MCH_AircraftInfo.ParticleSplash particleSplash : info.particleSplashs) {
                Object dummyPs;
                LinkedHashMap<String, Serializable> linkedHashMap = new LinkedHashMap<String, Serializable>();
                Object object = dummyPs = dummyInfo.particleSplashs.size() > splash.size() ? dummyInfo.particleSplashs.get(splash.size()) : null;
                if (dummyPs == null || !particleSplash.pos.equals((Object)((MCH_AircraftInfo.ParticleSplash)dummyPs).pos)) {
                    linkedHashMap.put("Position", YamlEmitter.vec(particleSplash.pos));
                }
                if (dummyPs == null || particleSplash.num != ((MCH_AircraftInfo.ParticleSplash)dummyPs).num) {
                    linkedHashMap.put("Count", Integer.valueOf(particleSplash.num));
                }
                if (dummyPs == null || particleSplash.size != ((MCH_AircraftInfo.ParticleSplash)dummyPs).size) {
                    linkedHashMap.put("Size", Float.valueOf(particleSplash.size));
                }
                if (dummyPs == null || particleSplash.acceleration != ((MCH_AircraftInfo.ParticleSplash)dummyPs).acceleration) {
                    linkedHashMap.put("Acceleration", Float.valueOf(particleSplash.acceleration));
                }
                if (dummyPs == null || particleSplash.age != ((MCH_AircraftInfo.ParticleSplash)dummyPs).age) {
                    linkedHashMap.put("Age", Integer.valueOf(particleSplash.age));
                }
                if (dummyPs == null || particleSplash.motionY != ((MCH_AircraftInfo.ParticleSplash)dummyPs).motionY) {
                    linkedHashMap.put("Motion", Float.valueOf(particleSplash.motionY));
                }
                if (dummyPs == null || particleSplash.gravity != ((MCH_AircraftInfo.ParticleSplash)dummyPs).gravity) {
                    linkedHashMap.put("Gravity", Float.valueOf(particleSplash.gravity));
                }
                if (linkedHashMap.isEmpty()) continue;
                splash.add(linkedHashMap);
            }
            if (!splash.isEmpty()) {
                render.put("SplashParticles", splash);
            }
        }
        if (!render.isEmpty()) {
            root.put("Render", render);
        }
        LinkedHashMap<String, Float> armor = new LinkedHashMap<String, Float>();
        if (info.armorDamageFactor != dummyInfo.armorDamageFactor) {
            armor.put("ArmorDamageFactor", Float.valueOf(info.armorDamageFactor));
        }
        if (info.armorMinDamage != dummyInfo.armorMinDamage) {
            armor.put("ArmorMinDamage", Float.valueOf(info.armorMinDamage));
        }
        if (info.armorMaxDamage != dummyInfo.armorMaxDamage) {
            armor.put("ArmorMaxDamage", Float.valueOf(info.armorMaxDamage));
        }
        if (info.damageFactor != dummyInfo.damageFactor) {
            armor.put("DamageFactor", Float.valueOf(info.damageFactor));
        }
        if (info.submergedDamageHeight != dummyInfo.submergedDamageHeight) {
            armor.put("SubmergedDamageHeight", Float.valueOf(info.submergedDamageHeight));
        }
        if (!armor.isEmpty()) {
            root.put("Armor", armor);
        }
        ArrayList weapons = new ArrayList();
        for (MCH_AircraftInfo.WeaponSet weaponSet : info.weaponSetList) {
            for (MCH_AircraftInfo.Weapon w : weaponSet.weapons) {
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                m.put("Type", weaponSet.type);
                m.put("Position", YamlEmitter.vecMinusYOffset(w.pos));
                if (w.yaw != 0.0f || dummyInfo.weaponSetList.contains(weaponSet) && w.yaw != dummyInfo.weaponSetList.get((int)dummyInfo.weaponSetList.indexOf((Object)weaponSet)).weapons.get((int)weaponSet.weapons.indexOf((Object)w)).yaw) {
                    m.put("Yaw", Float.valueOf(w.yaw));
                }
                if (w.pitch != 0.0f || dummyInfo.weaponSetList.contains(weaponSet) && w.pitch != dummyInfo.weaponSetList.get((int)dummyInfo.weaponSetList.indexOf((Object)weaponSet)).weapons.get((int)weaponSet.weapons.indexOf((Object)w)).pitch) {
                    m.put("Pitch", Float.valueOf(w.pitch));
                }
                if (w.seatID > 0) {
                    m.put("SeatID", w.seatID + 1);
                }
                if (!w.canUsePilot) {
                    m.put("CanUsePilot", false);
                }
                if (w.defaultYaw != 0.0f) {
                    m.put("DefaultYaw", Float.valueOf(w.defaultYaw));
                }
                if (w.minYaw != 0.0f) {
                    m.put("MinYaw", Float.valueOf(w.minYaw));
                }
                if (w.maxYaw != 0.0f) {
                    m.put("MaxYaw", Float.valueOf(w.maxYaw));
                }
                if (w.minPitch != 0.0f) {
                    m.put("MinPitch", Float.valueOf(w.minPitch));
                }
                if (w.maxPitch != 0.0f) {
                    m.put("MaxPitch", Float.valueOf(w.maxPitch));
                }
                if (w.turret) {
                    m.put("Turret", true);
                }
                if (m.isEmpty()) continue;
                weapons.add(m);
            }
        }
        if (!weapons.isEmpty()) {
            root.put("Weapons", weapons);
        }
        if (!info.seatList.isEmpty()) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (MCH_SeatInfo seatInfo : info.seatList) {
                if (seatInfo instanceof MCH_SeatRackInfo) continue;
                LinkedHashMap<String, Serializable> sm = new LinkedHashMap<String, Serializable>();
                sm.put("Position", YamlEmitter.vec(seatInfo.pos));
                if (seatInfo.gunner) {
                    sm.put("Gunner", Boolean.valueOf(true));
                }
                if (seatInfo.switchgunner) {
                    sm.put("SwitchGunner", Boolean.valueOf(true));
                }
                if (seatInfo.fixRot) {
                    sm.put("FixRot", Boolean.valueOf(true));
                }
                if (seatInfo.fixYaw != 0.0f) {
                    sm.put("FixYaw", Float.valueOf(seatInfo.fixYaw));
                }
                if (seatInfo.fixPitch != 0.0f) {
                    sm.put("FixPitch", Float.valueOf(seatInfo.fixPitch));
                }
                if (seatInfo.minPitch != -30.0f) {
                    sm.put("MinPitch", Float.valueOf(seatInfo.minPitch));
                }
                if (seatInfo.maxPitch != 70.0f) {
                    sm.put("MaxPitch", Float.valueOf(seatInfo.maxPitch));
                }
                if (seatInfo.rotSeat) {
                    sm.put("RotSeat", Boolean.valueOf(true));
                }
                if (seatInfo.invCamPos) {
                    sm.put("InvCamPos", Boolean.valueOf(true));
                }
                if (seatInfo.getCamPos() != null) {
                    LinkedHashMap<String, Serializable> cm = new LinkedHashMap<String, Serializable>();
                    cm.put("Pos", YamlEmitter.vecMinusYOffset(seatInfo.getCamPos().pos));
                    if (seatInfo.getCamPos().fixRot) {
                        cm.put("FixedRot", Boolean.valueOf(true));
                    }
                    if (seatInfo.getCamPos().yaw != 0.0f) {
                        cm.put("Yaw", Float.valueOf(seatInfo.getCamPos().yaw));
                    }
                    if (seatInfo.getCamPos().pitch != 0.0f) {
                        cm.put("Pitch", Float.valueOf(seatInfo.getCamPos().pitch));
                    }
                    sm.put("Camera", cm);
                }
                arrayList.add(sm);
            }
            if (!info.hudList.isEmpty()) {
                void var14_32;
                int seatSize;
                int hudSize = info.hudList.size();
                if (hudSize > (seatSize = info.getNumSeat()) || hudSize == seatSize) {
                    int n = seatSize;
                } else {
                    int n = hudSize;
                }
                for (int index = 0; index < var14_32; ++index) {
                    String name;
                    MCH_Hud hud = info.hudList.get(index);
                    if (hud == null || "none".equals(name = hud.name)) continue;
                    ((Map)arrayList.get(index)).put("Hud", name);
                }
            }
            if (!info.exclusionSeatList.isEmpty()) {
                this.appendExlusionEntries(arrayList, info, false);
            }
            root.put("Seats", arrayList);
        }
        if (info.getNumSeat() < info.getNumSeatAndRack()) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            List list = info.seatList.stream().filter(Predicates.instanceOf(MCH_SeatRackInfo.class)).map(MCH_SeatRackInfo.class::cast).collect(Collectors.toList());
            for (MCH_SeatRackInfo r : list) {
                LinkedHashMap<String, Object> rm = new LinkedHashMap<String, Object>();
                rm.put("Position", YamlEmitter.vec(r.pos));
                if (r.getCamPos() != null) {
                    LinkedHashMap<String, Serializable> cm = new LinkedHashMap<String, Serializable>();
                    cm.put("Pos", YamlEmitter.vecMinusYOffset(r.getCamPos().pos));
                    if (r.getCamPos().fixRot) {
                        cm.put("FixedRot", Boolean.valueOf(true));
                    }
                    arrayList.add(rm);
                    rm.put("Camera", cm);
                } else {
                    arrayList.add(rm);
                }
                if (r.names != null && r.names.length > 0) {
                    if (r.names.length == 1) {
                        rm.put("Name", r.names[0]);
                    } else {
                        rm.put("Names", Arrays.asList(r.names));
                    }
                }
                if (r.range != 0.0f) {
                    rm.put("Range", Float.valueOf(r.range));
                }
                if (r.openParaAlt == 0.0f) continue;
                rm.put("OpenParaAlt", Float.valueOf(r.openParaAlt));
            }
            if (!info.exclusionSeatList.isEmpty()) {
                this.appendExlusionEntries(arrayList, info, true);
            }
            root.put("Racks", arrayList);
        }
        if (!info.rideRacks.isEmpty()) {
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
            for (MCH_AircraftInfo.RideRack rr : info.rideRacks) {
                linkedHashMap.put(rr.name, rr.rackID);
            }
            root.put("RideRack", linkedHashMap);
        }
        if (!info.extraBoundingBox.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            for (MCH_BoundingBox bb : info.extraBoundingBox) {
                LinkedHashMap<String, Object> bm = new LinkedHashMap<String, Object>();
                if (bb.boundingBoxType != null) {
                    bm.put("Type", bb.boundingBoxType.name());
                }
                bm.put("Position", YamlEmitter.inline(bb.offsetX, bb.offsetY, bb.offsetZ));
                bm.put("Size", YamlEmitter.inline(bb.width, bb.height, bb.widthZ));
                if (bb.getDamageFactor() != 1.0f) {
                    bm.put("DamageFactor", Float.valueOf(bb.getDamageFactor()));
                }
                if (bb.name != null && !bb.name.isEmpty()) {
                    bm.put("Name", bb.name);
                }
                arrayList.add(bm);
            }
            root.put("BoundingBoxes", arrayList);
        }
        if (info.wheels != null && !info.wheels.isEmpty()) {
            LinkedHashMap<String, Serializable> linkedHashMap = new LinkedHashMap<String, Serializable>();
            ArrayList arrayList = new ArrayList();
            for (MCH_AircraftInfo.Wheel w : info.wheels) {
                LinkedHashMap<String, Serializable> wm = new LinkedHashMap<String, Serializable>();
                wm.put("Position", YamlEmitter.vec(w.pos));
                if (w.size != 1.0f) {
                    wm.put("Scale", Float.valueOf(w.size));
                }
                arrayList.add(wm);
            }
            linkedHashMap.put("Hitboxes", arrayList);
            if (info.partWheelRot != dummyInfo.partWheelRot) {
                linkedHashMap.put("WheelRotation", Float.valueOf(info.partWheelRot));
            }
            if (info.trackRollerRot != dummyInfo.trackRollerRot) {
                linkedHashMap.put("TrackRotation", Float.valueOf(info.trackRollerRot));
            }
            root.put("Wheels", linkedHashMap);
        }
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        if (info.isUAV != dummyInfo.isUAV) {
            linkedHashMap.put("IsUav", info.isUAV);
        }
        if (info.isSmallUAV != dummyInfo.isSmallUAV) {
            linkedHashMap.put("IsSmallUav", info.isSmallUAV);
        }
        if (info.isNewUAV != dummyInfo.isNewUAV) {
            linkedHashMap.put("IsNewUav", info.isNewUAV);
        }
        if (info.isTargetDrone != dummyInfo.isTargetDrone) {
            linkedHashMap.put("IsTargetDrone", info.isTargetDrone);
        }
        if (!linkedHashMap.isEmpty()) {
            root.put("Uav", linkedHashMap);
        }
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        if (info.isEnableGunnerMode != dummyInfo.isEnableGunnerMode) {
            linkedHashMap2.put("GunnerMode", info.isEnableGunnerMode);
        }
        if (info.inventorySize != dummyInfo.inventorySize) {
            linkedHashMap2.put("InventorySize", info.inventorySize);
        }
        if (info.isEnableNightVision != dummyInfo.isEnableNightVision) {
            linkedHashMap2.put("NightVision", info.isEnableNightVision);
        }
        if (info.isEnableEntityRadar != dummyInfo.isEnableEntityRadar) {
            linkedHashMap2.put("EntityRadar", info.isEnableEntityRadar);
        }
        if (info.enableBack != dummyInfo.enableBack) {
            linkedHashMap2.put("CanReverse", info.enableBack);
        }
        if (info.canRotOnGround != dummyInfo.canRotOnGround) {
            linkedHashMap2.put("CanRotateOnGround", info.canRotOnGround);
        }
        if (info.isEnableConcurrentGunnerMode != dummyInfo.isEnableConcurrentGunnerMode) {
            linkedHashMap2.put("ConcurrentGunner", info.isEnableConcurrentGunnerMode);
        }
        if (info.isEnableEjectionSeat != dummyInfo.isEnableEjectionSeat) {
            linkedHashMap2.put("EjectionSeat", info.isEnableEjectionSeat);
        }
        if (info.throttleUpDown != dummyInfo.throttleUpDown) {
            linkedHashMap2.put("ThrottleUpDown", Float.valueOf(info.throttleUpDown));
        }
        if (info.throttleUpDownOnEntity != dummyInfo.throttleUpDownOnEntity) {
            linkedHashMap2.put("ThrottleUpDownEntity", Float.valueOf(info.throttleUpDownOnEntity));
        }
        if (info.isEnableParachuting) {
            LinkedHashMap<String, Serializable> parachute = new LinkedHashMap<String, Serializable>();
            if (info.mobDropOption.pos != null) {
                parachute.put("Pos", YamlEmitter.vec(info.mobDropOption.pos));
            }
            if (info.mobDropOption.interval != 0) {
                parachute.put("Interval", Integer.valueOf(info.mobDropOption.interval));
            }
            linkedHashMap2.put("Parachuting", parachute.isEmpty() ? Boolean.valueOf(true) : parachute);
        }
        if (info.flare.types.length != 0) {
            LinkedHashMap flare = new LinkedHashMap();
            flare.put("Pos", YamlEmitter.vec(info.flare.pos));
            if (info.flare.types != null && info.flare.types.length > 0) {
                ArrayList<String> types = new ArrayList<String>();
                for (int t : info.flare.types) {
                    String ft = YamlEmitter.flareTypeFromInt(t);
                    if (ft == null) continue;
                    types.add(ft);
                }
                if (!types.isEmpty()) {
                    flare.put("Types", types);
                }
            }
            linkedHashMap2.put("Flare", flare);
        }
        if (!linkedHashMap2.isEmpty()) {
            root.put("AircraftFeatures", linkedHashMap2);
        }
        return root;
    }

    private Map<String, Object> drawnPart(MCH_AircraftInfo.DrawnPart p) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("Position", YamlEmitter.vec(p.pos));
        if (p.rot != Vec3d.field_186680_a) {
            m.put("Rotation", YamlEmitter.vec(p.rot));
        }
        if (YamlEmitter.notBlank(p.modelName)) {
            m.put("PartName", p.modelName);
        }
        return m;
    }

    private void appendExlusionEntries(List<Map<String, Object>> targetList, MCH_AircraftInfo info, boolean isRackList) {
        Object boxed;
        if (info.exclusionSeatList.isEmpty()) {
            return;
        }
        int seatCount = info.getNumSeat();
        int rackCount = info.getNumRack();
        int total = seatCount + rackCount;
        LinkedHashMap<Integer, ExAgg> agg = new LinkedHashMap<Integer, ExAgg>();
        for (Integer[] integerArray : info.exclusionSeatList) {
            int ownerZ;
            Integer ownerBoxed;
            if (integerArray == null || integerArray.length < 2 || (ownerBoxed = integerArray[0]) == null || (ownerZ = ownerBoxed.intValue()) < 0 || ownerZ >= total) continue;
            ExAgg ex = agg.computeIfAbsent(ownerZ, k -> new ExAgg());
            for (int i = 1; i < integerArray.length; ++i) {
                int tZ;
                boxed = integerArray[i];
                if (boxed == null || (tZ = ((Integer)boxed).intValue()) < 0 || tZ >= total || tZ == ownerZ) continue;
                if (tZ < seatCount) {
                    ex.seats.add(tZ);
                    continue;
                }
                ex.racks.add(tZ - seatCount);
            }
        }
        for (Map.Entry entry : agg.entrySet()) {
            int ownerIndexInTarget;
            int ownerZ = (Integer)entry.getKey();
            boolean ownerIsRack = ownerZ >= seatCount;
            if (ownerIsRack != isRackList || (ownerIndexInTarget = ownerIsRack ? ownerZ - seatCount : ownerZ) < 0 || ownerIndexInTarget >= targetList.size()) continue;
            ArrayList<Integer> seats1 = new ArrayList<Integer>();
            boxed = ((ExAgg)entry.getValue()).seats.iterator();
            while (boxed.hasNext()) {
                int s = (Integer)boxed.next();
                seats1.add(s + 1);
            }
            ArrayList<Integer> racks1 = new ArrayList<Integer>();
            for (int r : ((ExAgg)entry.getValue()).racks) {
                racks1.add(r + 1);
            }
            Collections.sort(seats1);
            Collections.sort(racks1);
            if (seats1.isEmpty() && racks1.isEmpty()) continue;
            LinkedHashMap exMap = new LinkedHashMap();
            if (!seats1.isEmpty()) {
                exMap.put("Seats", YamlEmitter.inlineSeq(seats1));
            }
            if (!racks1.isEmpty()) {
                exMap.put("Racks", YamlEmitter.inlineSeq(racks1));
            }
            targetList.get(ownerIndexInTarget).put("ExcludeWith", exMap);
        }
    }

    private void addCommonComponents(Map<String, List<Map<String, Object>>> components, MCH_AircraftInfo info) {
        Map<String, Object> m;
        Map<String, Object> m2;
        ArrayList<Map<String, Object>> list;
        if (!info.cameraList.isEmpty()) {
            list = new ArrayList<Map<String, Object>>();
            for (MCH_AircraftInfo.Camera camera : info.cameraList) {
                Map<String, Object> m22 = this.drawnPart(camera);
                if (!camera.yawSync) {
                    m22.put("YawSync", false);
                }
                if (camera.pitchSync) {
                    m22.put("PitchSync", true);
                }
                list.add(m22);
            }
            components.put("Camera", list);
        }
        if (!info.canopyList.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.Canopy canopy : info.canopyList) {
                m2 = this.drawnPart(canopy);
                m2.put("MaxRotation", Float.valueOf(canopy.maxRotFactor));
                if (canopy.isSlide) {
                    m2.put("IsSliding", true);
                }
                list.add(m2);
            }
            components.put("Canopy", list);
        }
        if (!info.hatchList.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.Hatch hatch : info.hatchList) {
                m2 = this.drawnPart(hatch);
                m2.put("MaxRotation", Float.valueOf(hatch.maxRot));
                if (hatch.isSlide) {
                    m2.put("IsSliding", true);
                }
                list.add(m2);
            }
            components.put("Hatch", list);
        }
        if (!info.lightHatchList.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.Hatch hatch : info.lightHatchList) {
                m2 = this.drawnPart(hatch);
                m2.put("MaxRotation", Float.valueOf(hatch.maxRot));
                if (hatch.isSlide) {
                    m2.put("IsSliding", true);
                }
                list.add(m2);
            }
            components.put("LightHatch", list);
        }
        if (!info.partWeaponBay.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.WeaponBay weaponBay : info.partWeaponBay) {
                String weaponNameStr = weaponBay.weaponName;
                if (!YamlEmitter.notBlank(weaponNameStr) && weaponBay.weaponIds != null && weaponBay.weaponIds.length > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (Integer id : weaponBay.weaponIds) {
                        MCH_AircraftInfo.WeaponSet ws = info.getWeaponSetById(id);
                        if (ws == null || !YamlEmitter.notBlank(ws.type)) continue;
                        names.add(ws.type);
                    }
                    if (!names.isEmpty()) {
                        weaponNameStr = String.join((CharSequence)" / ", names);
                    }
                }
                if (!YamlEmitter.notBlank(weaponNameStr)) continue;
                m = this.drawnPart(weaponBay);
                m.put("WeaponName", weaponNameStr);
                m.put("MaxRotation", Float.valueOf(weaponBay.maxRotFactor));
                if (weaponBay.isSlide) {
                    m.put("IsSliding", true);
                }
                list.add(m);
            }
            if (!list.isEmpty()) {
                components.put("WeaponBay", list);
            }
        }
        if (!info.partRotPart.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.RotPart rotPart : info.partRotPart) {
                m2 = this.drawnPart(rotPart);
                if (rotPart.rotSpeed != 0.0f) {
                    m2.put("Speed", Float.valueOf(rotPart.rotSpeed));
                }
                if (rotPart.rotAlways) {
                    m2.put("AlwaysRotate", true);
                }
                list.add(m2);
            }
            components.put("Rotation", list);
        }
        if (!info.partSteeringWheel.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.PartWheel partWheel : info.partSteeringWheel) {
                m2 = this.drawnPart(partWheel);
                m2.put("Direction", Float.valueOf(partWheel.rotDir));
                if (partWheel.pos2 != null) {
                    m2.put("Pivot", YamlEmitter.vec(partWheel.pos2));
                }
                list.add(m2);
            }
            components.put("SteeringWheel", list);
        }
        if (!info.partWheel.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.PartWheel partWheel : info.partWheel) {
                m2 = this.drawnPart(partWheel);
                m2.put("Direction", Float.valueOf(partWheel.rotDir));
                if (partWheel.pos2 != null) {
                    m2.put("Pivot", YamlEmitter.vec(partWheel.pos2));
                }
                list.add(m2);
            }
            components.put("Wheel", list);
        }
        if (!info.landingGear.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.LandingGear landingGear : info.landingGear) {
                m2 = this.drawnPart(landingGear);
                m2.put("MaxRotation", Float.valueOf(landingGear.maxRotFactor * 90.0f));
                if (landingGear.reverse) {
                    m2.put("IsReverse", true);
                }
                if (landingGear.hatch) {
                    m2.put("IsHatch", true);
                }
                if (landingGear.enableRot2) {
                    m2.put("ArticulatedRotation", YamlEmitter.vec(landingGear.rot2));
                    m2.put("MaxArticulatedRotation", Float.valueOf(landingGear.maxRotFactor2 * 90.0f));
                }
                if (landingGear.slide != null) {
                    m2.put("SlideVec", YamlEmitter.vec(landingGear.slide));
                }
                list.add(m2);
            }
            components.put("LandingGear", list);
        }
        if (!info.partWeapon.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.PartWeapon partWeapon : info.partWeapon) {
                m2 = this.drawnPart(partWeapon);
                if (partWeapon.name != null && partWeapon.name.length > 0) {
                    m2.put("WeaponNames", String.join((CharSequence)"/", partWeapon.name));
                }
                if (partWeapon.rotBarrel) {
                    m2.put("BarrelRot", true);
                }
                if (partWeapon.isMissile) {
                    m2.put("IsMissile", true);
                }
                if (partWeapon.hideGM) {
                    m2.put("HideGM", true);
                }
                if (partWeapon.yaw) {
                    m2.put("Yaw", true);
                }
                if (partWeapon.pitch) {
                    m2.put("Pitch", true);
                }
                if (partWeapon.recoilBuf != 0.0f) {
                    m2.put("RecoilBuf", Float.valueOf(partWeapon.recoilBuf));
                }
                if (partWeapon.turret) {
                    m2.put("Turret", true);
                }
                if (partWeapon.child != null && !partWeapon.child.isEmpty()) {
                    ArrayList children = new ArrayList();
                    for (MCH_AircraftInfo.PartWeaponChild ch : partWeapon.child) {
                        LinkedHashMap<String, Serializable> cm = new LinkedHashMap<String, Serializable>();
                        cm.put("Position", YamlEmitter.vec(ch.pos));
                        if (ch.rot != Vec3d.field_186680_a) {
                            cm.put("Rotation", YamlEmitter.vec(ch.rot));
                        }
                        if (ch.yaw) {
                            cm.put("Yaw", Boolean.valueOf(true));
                        }
                        if (ch.pitch) {
                            cm.put("Pitch", Boolean.valueOf(true));
                        }
                        if (ch.recoilBuf != 0.0f) {
                            cm.put("RecoilBuf", Float.valueOf(ch.recoilBuf));
                        }
                        children.add(cm);
                    }
                    m2.put("Children", children);
                }
                list.add(m2);
            }
            components.put("Weapon", list);
        }
        if (!info.searchLights.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.SearchLight searchLight : info.searchLights) {
                m2 = new LinkedHashMap<String, Object>();
                m2.put("Position", YamlEmitter.vec(searchLight.pos));
                m2.put("ColorStart", YamlEmitter.toHexRGB(searchLight.colorStart));
                m2.put("ColorEnd", YamlEmitter.toHexRGB(searchLight.colorEnd));
                m2.put("Height", Float.valueOf(searchLight.height));
                m2.put("Width", Float.valueOf(searchLight.width));
                if (searchLight.yaw != 0.0f) {
                    m2.put("Yaw", Float.valueOf(searchLight.yaw));
                }
                if (searchLight.pitch != 0.0f) {
                    m2.put("Pitch", Float.valueOf(searchLight.pitch));
                }
                if (searchLight.stRot != 0.0f) {
                    m2.put("StRot", Float.valueOf(searchLight.stRot));
                }
                if (searchLight.fixDir) {
                    m2.put("FixedDirection", true);
                }
                if (searchLight.steering) {
                    m2.put("Steering", true);
                }
                list.add(m2);
            }
            components.put("SearchLight", list);
        }
        if (!info.partTrackRoller.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.TrackRoller trackRoller : info.partTrackRoller) {
                list.add(this.drawnPart(trackRoller));
            }
            components.put("TrackRoller", list);
        }
        if (!info.partThrottle.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.Throttle throttle : info.partThrottle) {
                m2 = this.drawnPart(throttle);
                if (throttle.slide != null) {
                    m2.put("SlidePos", YamlEmitter.vec(throttle.slide));
                }
                if (throttle.rot2 != 0.0f) {
                    m2.put("MaxAngle", Float.valueOf(throttle.rot2));
                }
                list.add(m2);
            }
            components.put("Throttle", list);
        }
        if (!info.partCrawlerTrack.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.CrawlerTrack crawlerTrack : info.partCrawlerTrack) {
                m2 = this.drawnPart(crawlerTrack);
                if (crawlerTrack.len != 0.0f) {
                    m2.put("SegmentLength", Float.valueOf(crawlerTrack.len / 0.9f));
                }
                if (crawlerTrack.z != 0.0f) {
                    m2.put("ZOffset", Float.valueOf(crawlerTrack.z));
                }
                if (crawlerTrack.cx != null && crawlerTrack.cy != null) {
                    ArrayList<InlineSeq<Double>> tl = new ArrayList<InlineSeq<Double>>();
                    for (int i = 0; i < Math.min(crawlerTrack.cx.length, crawlerTrack.cy.length); ++i) {
                        tl.add(YamlEmitter.inline(crawlerTrack.cx[i], crawlerTrack.cy[i]));
                    }
                    if (!tl.isEmpty()) {
                        m2.put("TrackList", tl);
                    }
                }
                list.add(m2);
            }
            components.put("CrawlerTrack", list);
        }
        if (info instanceof MCH_HeliInfo) {
            MCH_HeliInfo hi = (MCH_HeliInfo)info;
            if (!hi.rotorList.isEmpty()) {
                ArrayList<Map<String, Object>> list2 = new ArrayList<Map<String, Object>>();
                for (MCH_HeliInfo.Rotor r : hi.rotorList) {
                    m = this.drawnPart(r);
                    if (r.bladeNum != 0) {
                        m.put("BladeCount", r.bladeNum);
                    }
                    if (r.bladeRot != 0) {
                        m.put("BladeRot", r.bladeRot);
                    }
                    if (r.haveFoldFunc) {
                        m.put("CanFold", true);
                    }
                    if (r.oldRenderMethod) {
                        m.put("OldRenderer", true);
                    }
                    list2.add(m);
                }
                components.put("HeliRotor", list2);
            }
        }
        if (!info.repellingHooks.isEmpty()) {
            list = new ArrayList();
            for (MCH_AircraftInfo.RepellingHook repellingHook : info.repellingHooks) {
                m2 = new LinkedHashMap<String, Object>();
                m2.put("Position", YamlEmitter.vec(repellingHook.pos));
                if (repellingHook.interval != 0) {
                    m2.put("Interval", repellingHook.interval);
                }
                list.add(m2);
            }
            components.put("RepelHook", list);
        }
    }

    static {
        DumperOptions opts = new DumperOptions();
        opts.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        opts.setPrettyFlow(true);
        InlineAwareRepresenter rep = new InlineAwareRepresenter(opts);
        rep.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setWidth(Integer.MAX_VALUE);
        options.setSplitLines(false);
        YAML = new Yaml(new InlineAwareRepresenter(options), options);
    }

    @NestHost(value=YamlEmitter.class)
    private static final class InlineSeq<E>
    extends ArrayList<E> {
        InlineSeq(int cap) {
            super(cap);
        }
    }

    @NestHost(value=YamlEmitter.class)
    private static final class ExAgg {
        final Set<Integer> seats = new LinkedHashSet<Integer>();
        final Set<Integer> racks = new LinkedHashSet<Integer>();

        ExAgg() {
        }
    }

    @NestHost(value=YamlEmitter.class)
    private static final class InlineAwareRepresenter
    extends Representer {
        public InlineAwareRepresenter(DumperOptions options) {
            super(options);
        }

        @Override
        protected Node representSequence(Tag tag, Iterable<?> sequence, DumperOptions.FlowStyle flowStyle) {
            if (sequence instanceof InlineSeq) {
                return super.representSequence(tag, sequence, DumperOptions.FlowStyle.FLOW);
            }
            return super.representSequence(tag, sequence, flowStyle);
        }
    }
}

