/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcheli-ce.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_N_Buffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@SideOnly(value=Side.CLIENT)
@NestMembers(value={ShaderProgram.class})
public class ShaderRegistry {
    private static final FloatBuffer MATRIX_BUFFER = BufferUtils.createFloatBuffer((int)16);
    private static final Map<String, ShaderProgram> shaderMap = new HashMap<String, ShaderProgram>();
    public static final String SHADER_PATH = "shaders/";

    public static void uploadMatrix4f(int uniformLoc, Matrix4f mat) {
        FloatBuffer cfr_ignored_0 = (FloatBuffer)J_N_Buffer.clear(MATRIX_BUFFER);
        mat.get(MATRIX_BUFFER);
        FloatBuffer cfr_ignored_1 = (FloatBuffer)J_N_Buffer.flip(MATRIX_BUFFER);
        GL20.glUniformMatrix4((int)uniformLoc, (boolean)false, (FloatBuffer)MATRIX_BUFFER);
    }

    public static void init() {
        ShaderRegistry.registerShader("basic");
    }

    private static void registerShader(String name) {
        IResource shaderVert = null;
        IResource shaderFrag = null;
        ResourceLocation fragLoc = new ResourceLocation("mcheli", String.format("%s%s.frag", SHADER_PATH, name));
        ResourceLocation vertLoc = new ResourceLocation("mcheli", String.format("%s%s.vert", SHADER_PATH, name));
        try {
            shaderVert = Minecraft.func_71410_x().func_110442_L().func_110536_a(vertLoc);
            shaderFrag = Minecraft.func_71410_x().func_110442_L().func_110536_a(fragLoc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ShaderProgram shaderProg = new ShaderProgram(shaderVert.func_110527_b(), vertLoc, shaderFrag.func_110527_b(), fragLoc);
        shaderMap.put(name, shaderProg);
    }

    private static String readStream(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            String string = sb.toString();
            return string;
        }
    }

    @Nullable
    public static ShaderProgram getShader(String key) {
        return shaderMap.get(key);
    }

    @NestHost(value=ShaderRegistry.class)
    public static class ShaderProgram {
        private final int programId;
        private final Map<String, Integer> uniformCache = new HashMap<String, Integer>();

        public ShaderProgram(InputStream vertStream, ResourceLocation vertexPath, InputStream fragStream, ResourceLocation fragPath) {
            int vert = this.compile(35633, ShaderRegistry.readStream(vertStream), vertexPath.toString());
            int frag = this.compile(35632, ShaderRegistry.readStream(fragStream), fragPath.toString());
            this.programId = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.programId, (int)vert);
            GL20.glAttachShader((int)this.programId, (int)frag);
            GL20.glLinkProgram((int)this.programId);
            GL20.glDeleteShader((int)vert);
            GL20.glDeleteShader((int)frag);
        }

        private int compile(int type, String src, String path) {
            int shader = GL20.glCreateShader((int)type);
            GL20.glShaderSource((int)shader, (CharSequence)src);
            GL20.glCompileShader((int)shader);
            if (GL20.glGetShaderi((int)shader, (int)35713) == 0) {
                throw new RuntimeException(ShaderProgram.jvmdowngrader$concat$compile$1(path, GL20.glGetShaderInfoLog((int)shader, (int)100)));
            }
            return shader;
        }

        public void bind() {
            GL20.glUseProgram((int)this.programId);
        }

        public void unbind() {
            GL20.glUseProgram((int)0);
        }

        public void cleanup() {
            GL20.glDeleteProgram((int)this.programId);
        }

        public int getUniformLocation(String name) {
            return this.uniformCache.computeIfAbsent(name, n -> GL20.glGetUniformLocation((int)this.programId, (CharSequence)n));
        }

        public void setUniform(String name, float v0, float v1, float v2) {
            GL20.glUniform3f((int)this.getUniformLocation(name), (float)v0, (float)v1, (float)v2);
        }

        public void setUniformMat4(String name, FloatBuffer matrix) {
            GL20.glUniformMatrix4((int)this.getUniformLocation(name), (boolean)false, (FloatBuffer)matrix);
        }

        private static /* synthetic */ String jvmdowngrader$concat$compile$1(String string, String string2) {
            return "Error compiling shader " + string + "\n" + string2;
        }
    }
}

