/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info;

import com.google.common.collect.Lists;
import com.norwood.mcheli.helper.info.ContentFactories;
import com.norwood.mcheli.helper.info.ContentLoader;
import com.norwood.mcheli.helper.info.ContentType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class FolderContentLoader
extends ContentLoader {
    private final Path root;

    public FolderContentLoader(String domain, File addonDir, String loaderVersion, Predicate<String> fileFilter) {
        super(domain, addonDir, loaderVersion, fileFilter);
        Path root;
        try {
            root = addonDir.toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            root = addonDir.toPath().toAbsolutePath().normalize();
        }
        this.root = root;
    }

    private static String normalizeName(String name) {
        String s = name.replace('\\', '/');
        while (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    @Override
    protected List<ContentLoader.ContentEntry> getEntries() {
        boolean loadDeep = "2".equals(this.loaderVersion);
        return this.walkDir(this.dir, null, loadDeep, 0);
    }

    private List<ContentLoader.ContentEntry> walkDir(File node, @Nullable ContentType type, boolean allowDeepFromHere, int depth) {
        ArrayList list = Lists.newArrayList();
        if (node == null || !node.exists()) {
            return list;
        }
        if (node.isDirectory()) {
            File[] children;
            if ((allowDeepFromHere || depth <= 1) && (children = node.listFiles()) != null) {
                for (File child : children) {
                    ContentType nextType = type;
                    if (nextType == null) {
                        nextType = ContentFactories.getType(child.getName());
                    }
                    boolean nextAllowDeep = allowDeepFromHere || depth == 0 && "assets".equals(child.getName());
                    list.addAll(this.walkDir(child, nextType, nextAllowDeep, depth + 1));
                }
            }
            return list;
        }
        try {
            String rel = this.relativeForwardSlash(node);
            if (this.isReadable(rel) && type != null) {
                list.add(this.makeEntry(rel, type, false));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private String relativeForwardSlash(File file) throws IOException {
        Path fileReal;
        try {
            fileReal = file.toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        Path rel = this.root.relativize(fileReal).normalize();
        if (rel.startsWith("..")) {
            throw new SecurityException(FolderContentLoader.jvmdowngrader$concat$relativeForwardSlash$1(String.valueOf(fileReal)));
        }
        String s = rel.toString();
        s = s.replace('\\', '/');
        return s;
    }

    @Override
    protected InputStream getInputStreamByName(String name) throws IOException {
        File file1 = this.getFile(name);
        if (file1 == null) {
            throw new FileNotFoundException(String.format("'%s' in AddonPack '%s'", name, this.dir));
        }
        return new BufferedInputStream(Files.newInputStream(file1.toPath(), new OpenOption[0]));
    }

    @Nullable
    private File getFile(String name) {
        Path candidate;
        String normalized = FolderContentLoader.normalizeName(name);
        try {
            candidate = this.root.resolve(normalized).normalize();
        }
        catch (InvalidPathException ipe) {
            return null;
        }
        if (!candidate.startsWith(this.root)) {
            return null;
        }
        if (Files.isRegularFile(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    private static /* synthetic */ String jvmdowngrader$concat$relativeForwardSlash$1(String string) {
        return "Resolved file escapes addon root: " + string;
    }
}

