/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.info;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.norwood.mcheli.MCH_BaseInfo;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.helper.MCH_Logger;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.addon.AddonResourceLocation;
import com.norwood.mcheli.helper.info.ContentFactories;
import com.norwood.mcheli.helper.info.ContentParseException;
import com.norwood.mcheli.helper.info.ContentParsers;
import com.norwood.mcheli.helper.info.ContentType;
import com.norwood.mcheli.helper.info.IContentData;
import com.norwood.mcheli.helper.info.parsers.IParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcheli-ce.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class, ContentEntry.class})
public abstract class ContentLoader {
    protected final String domain;
    protected final File dir;
    protected final String loaderVersion;
    private final Predicate<String> fileFilter;

    public ContentLoader(String domain, File addonDir, String loaderVersion, Predicate<String> fileFilter) {
        this.domain = domain;
        this.dir = addonDir;
        this.loaderVersion = loaderVersion;
        this.fileFilter = fileFilter;
    }

    public boolean isReadable(String path) {
        return this.fileFilter.test(path);
    }

    public Multimap<ContentType, ContentEntry> load() {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (ContentEntry entry : this.getEntries()) {
            map.put((Object)entry.getType(), (Object)entry);
        }
        return map;
    }

    protected abstract List<ContentEntry> getEntries();

    protected abstract InputStream getInputStreamByName(String var1) throws IOException;

    public <TYPE extends IContentData> List<TYPE> reloadAndParse(Class<TYPE> clazz, List<TYPE> oldContents, ContentType type) {
        LinkedList list = Lists.newLinkedList();
        for (IContentData oldContent : oldContents) {
            try {
                ContentEntry entry = this.makeEntry(oldContent.getContentPath(), type, true);
                IContentData content = entry.parse();
                if (content != null) {
                    content.onPostReload();
                } else {
                    content = oldContent;
                }
                if (!clazz.isInstance(content)) continue;
                list.add((IContentData)clazz.cast(content));
            }
            catch (IOException e) {
                MCH_Logger.get().error("IO Error from file loader!", (Throwable)e);
            }
        }
        return list;
    }

    public IContentData reloadAndParseSingle(IContentData oldData, String dir) {
        IContentData content = oldData;
        try {
            ContentType type = ContentFactories.getType(dir);
            if (type == null) {
                MCH_Logger.get().warn("Unknown content type for directory '{}'", (Object)dir);
                return content;
            }
            ContentEntry entry = this.makeEntry(oldData.getContentPath(), type, true);
            content = entry.parse();
            if (content != null) {
                content.onPostReload();
            } else {
                content = oldData;
            }
        }
        catch (IOException e) {
            MCH_Logger.get().error("IO Error from file loader!", (Throwable)e);
        }
        return content;
    }

    protected ContentEntry makeEntry(String filepath, ContentType type, boolean reload) throws IOException {
        List<String> lines;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStreamByName(filepath), StandardCharsets.UTF_8));){
            lines = reader.lines().collect(Collectors.toList());
        }
        return new ContentEntry(filepath, this.domain, type, lines, reload);
    }

    @NestHost(value=ContentLoader.class)
    public static class ContentEntry {
        private final String filepath;
        private final String domain;
        private final ContentType type;
        private final List<String> lines;
        private final boolean reload;

        ContentEntry(String filepath, String domain, ContentType type, List<String> lines, boolean reload) {
            this.filepath = filepath;
            this.domain = domain;
            this.type = type;
            this.lines = lines;
            this.reload = reload;
        }

        public ContentType getType() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public IContentData parse() {
            AddonResourceLocation location = MCH_Utils.addon(this.domain, Files.getNameWithoutExtension((String)this.filepath));
            if (!this.reload) {
                MCH_MOD.proxy.onParseStartFile(location);
            }
            try {
                String extension = Files.getFileExtension((String)this.filepath);
                IParser parser = ContentParsers.get(extension);
                if (parser == null) {
                    MCH_Logger.get().warn("No parser registered for extension '{}'", (Object)extension);
                    IContentData iContentData = null;
                    return iContentData;
                }
                IContentData content = this.invokeParser(parser, location);
                if (content != null && !content.validate()) {
                    MCH_Logger.get().debug("Invalid content info: {}", (Object)this.filepath);
                }
                IContentData iContentData = content;
                return iContentData;
            }
            catch (Exception ex) {
                String msg = "An error occurred while file loading ";
                if (ex instanceof ContentParseException) {
                    msg = ContentEntry.jvmdowngrader$concat$parse$1(msg, ((ContentParseException)ex).getLineNo());
                }
                MCH_Logger.get().error("{} file:{}, domain:{}", (Object)msg, (Object)location.func_110623_a(), (Object)this.domain, (Object)ex);
                IContentData iContentData = null;
                return iContentData;
            }
            finally {
                MCH_MOD.proxy.onParseFinishFile(location);
            }
        }

        @Nullable
        private IContentData invokeParser(IParser parser, AddonResourceLocation location) throws Exception {
            MCH_BaseInfo mCH_BaseInfo;
            switch (this.type) {
                default: {
                    throw new J_L_MatchException(null, null);
                }
                case HELICOPTER: {
                    mCH_BaseInfo = parser.parseHelicopter(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case PLANE: {
                    mCH_BaseInfo = parser.parsePlane(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case SHIP: {
                    mCH_BaseInfo = parser.parseShip(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case TANK: {
                    mCH_BaseInfo = parser.parseTank(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case VEHICLE: {
                    mCH_BaseInfo = parser.parseVehicle(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case WEAPON: {
                    mCH_BaseInfo = parser.parseWeapon(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case THROWABLE: {
                    mCH_BaseInfo = parser.parseThrowable(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case HUD: {
                    mCH_BaseInfo = parser.parseHud(location, this.filepath, this.lines, this.reload);
                    break;
                }
                case ITEM: {
                    mCH_BaseInfo = parser.parseItem(location, this.filepath, this.lines, this.reload);
                }
            }
            return mCH_BaseInfo;
        }

        private static /* synthetic */ String jvmdowngrader$concat$parse$1(String string, int n) {
            return string + "at line:" + n + ".";
        }
    }
}

