/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import org.jetbrains.annotations.NotNull;

public class MCH_WrapperItemLayerModel
implements IModel {
    private final ItemLayerModel model;
    private final ModelBlock raw;

    public MCH_WrapperItemLayerModel(ModelBlock modelBlock) {
        this.raw = modelBlock;
        this.model = new ItemLayerModel(modelBlock);
    }

    @NotNull
    public Collection<ResourceLocation> getTextures() {
        return this.model.getTextures();
    }

    @NotNull
    public IModel retexture(@NotNull ImmutableMap<String, String> textures) {
        return this.model.retexture(textures);
    }

    @NotNull
    public IBakedModel bake(@NotNull IModelState state, @NotNull VertexFormat format, @NotNull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ItemCameraTransforms transforms = this.raw.func_181682_g();
        EnumMap tMap = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
        tMap.putAll(PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)transforms));
        tMap.putAll(PerspectiveMapWrapper.getTransforms((IModelState)state));
        SimpleModelState perState = new SimpleModelState(ImmutableMap.copyOf((Map)tMap), state.apply(Optional.empty()));
        return this.model.bake((IModelState)perState, format, bakedTextureGetter);
    }
}

