/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.client;

import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.client._IModelCustom;
import com.norwood.mcheli.helper.client.model.loader.IVertexModelLoader;
import com.norwood.mcheli.helper.client.model.loader.MetasequoiaModelLoader;
import com.norwood.mcheli.helper.client.model.loader.WavefrontModelLoader;
import java.io.FileNotFoundException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Contract;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@SideOnly(value=Side.CLIENT)
@NestMembers(value={ModelLoadException.class})
public class MCH_Models {
    private static final IVertexModelLoader objLoader = new WavefrontModelLoader();
    private static final IVertexModelLoader mqoLoader = new MetasequoiaModelLoader();
    private static final IVertexModelLoader[] loaders = new IVertexModelLoader[]{objLoader, mqoLoader};

    @Contract(value="_ -> new")
    public static _IModelCustom loadModel(String name) throws ModelLoadException {
        ResourceLocation resource = MCH_Utils.suffix(MCH_Models.jvmdowngrader$concat$loadModel$1(name));
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        Throwable message = null;
        int fnfeCounter = loaders.length;
        for (IVertexModelLoader loader : loaders) {
            try {
                return loader.load(resourceManager, resource);
            }
            catch (FileNotFoundException fnfe) {
                MCH_Utils.logger().debug("model file not found '{}' at .{}", (Object)resource, (Object)loader.getExtension());
                --fnfeCounter;
            }
            catch (Throwable throwable) {
                MCH_Utils.logger().error("load model error '{}' at .{}", (Object)resource, (Object)loader.getExtension());
                message = throwable;
            }
        }
        if (fnfeCounter == 0) {
            throw new ModelLoadException(MCH_Models.jvmdowngrader$concat$loadModel$2(String.valueOf(resource)));
        }
        throw new ModelLoadException(MCH_Models.jvmdowngrader$concat$loadModel$3(String.valueOf(resource)), message);
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadModel$1(String string) {
        return "models/" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadModel$2(String string) {
        return string + " not found";
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadModel$3(String string) {
        return "model load error for " + string;
    }

    @NestHost(value=MCH_Models.class)
    public static class ModelLoadException
    extends Exception {
        public ModelLoadException(String message) {
            super(message);
        }

        public ModelLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

