/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.client;

import com.norwood.mcheli.MCH_ViewEntityDummy;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_EntitySeat;
import com.norwood.mcheli.tool.rangefinder.MCH_ItemRangeFinder;
import com.norwood.mcheli.uav.MCH_EntityUavStation;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="mcheli", value={Side.CLIENT})
public class MCH_CameraManager {
    private static final float DEF_THIRD_CAMERA_DIST = 4.0f;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static float cameraRoll = 0.0f;
    private static float cameraDistance = 4.0f;
    private static float cameraZoom = 1.0f;
    private static MCH_EntityAircraft ridingAircraft = null;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Tuple<EntityPlayer, MCH_EntityAircraft> ctx = MCH_CameraManager.getActivePilotContext();
        if (ctx == null) {
            return;
        }
        if (((MCH_EntityAircraft)ctx.func_76340_b()).getAcInfo() == null) {
            return;
        }
        ((MCH_EntityAircraft)ctx.func_76340_b()).getAcInfo().getHudCache().forEach(drawable -> drawable.renderHud(event, ctx));
    }

    @Nullable
    private static Tuple<EntityPlayer, MCH_EntityAircraft> getActivePilotContext() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || mc.field_71441_e == null) {
            return null;
        }
        MCH_EntityAircraft ac = MCH_CameraManager.getRiddenAircraft(mc, (EntityPlayer)player);
        if (ac == null) {
            return null;
        }
        return new Tuple((Object)player, (Object)ac);
    }

    @Nullable
    private static MCH_EntityAircraft getRiddenAircraft(Minecraft mc, EntityPlayer player) {
        Entity riding = player.func_184187_bx();
        if (riding instanceof MCH_EntityAircraft) {
            return (MCH_EntityAircraft)riding;
        }
        if (riding instanceof MCH_EntitySeat) {
            return ((MCH_EntitySeat)riding).getParent();
        }
        if (riding instanceof MCH_EntityUavStation) {
            return ((MCH_EntityUavStation)riding).getControlAircract();
        }
        return null;
    }

    @SubscribeEvent
    static void onCameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
        MCH_EntityAircraft ridingEntity;
        float f = event.getEntity().func_70047_e();
        if (MCH_CameraManager.mc.field_71474_y.field_74320_O > 0) {
            if (MCH_CameraManager.mc.field_71474_y.field_74320_O == 2) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-(cameraDistance - 4.0f)));
            if (MCH_CameraManager.mc.field_71474_y.field_74320_O == 2) {
                GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if ((ridingEntity = ridingAircraft) != null && ridingEntity.canSwitchFreeLook() && ridingEntity.isPilot((Entity)MCH_CameraManager.mc.field_71439_g)) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-f), (float)0.0f);
            GlStateManager.func_179114_b((float)cameraRoll, (float)0.0f, (float)0.0f, (float)1.0f);
            if (ridingEntity.isOverridePlayerPitch()) {
                GlStateManager.func_179114_b((float)ridingEntity.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)ridingEntity.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
                event.setPitch(event.getPitch() - ridingEntity.field_70125_A);
                event.setYaw(event.getYaw() - ridingEntity.field_70177_z);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)f, (float)0.0f);
        }
    }

    @SubscribeEvent
    static void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        MCH_ViewEntityDummy viewer = MCH_ViewEntityDummy.getInstance((World)MCH_CameraManager.mc.field_71441_e);
        if (viewer == event.getEntity() || MCH_ItemRangeFinder.isUsingScope((EntityPlayer)MCH_CameraManager.mc.field_71439_g)) {
            event.setFOV(event.getFOV() * (1.0f / cameraZoom));
        }
    }

    public static void setCameraRoll(float roll) {
        cameraRoll = roll = MathHelper.func_76142_g((float)roll);
    }

    public static void setCameraZoom(float zoom) {
        cameraZoom = zoom;
    }

    public static float getThirdPeasonCameraDistance() {
        return cameraDistance;
    }

    public static void setThirdPeasonCameraDistance(float distance) {
        cameraDistance = distance = MathHelper.func_76131_a((float)distance, (float)4.0f, (float)60.0f);
    }

    public static void setRidingAircraft(@Nullable MCH_EntityAircraft aircraft) {
        ridingAircraft = aircraft;
    }
}

