/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper.addon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.addon.AddonPack;
import com.norwood.mcheli.helper.addon.BuiltinAddonPack;
import com.norwood.mcheli.helper.addon.GeneratedAddonPack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AddonManager {
    public static final Pattern ZIP_PATTERN = Pattern.compile("(.+).(zip|jar)$");
    public static final String BUILTIN_ADDON_DOMAIN = "@builtin";
    private static final Map<String, AddonPack> ADDON_LIST = Maps.newLinkedHashMap();

    @Nullable
    public static AddonPack get(String addonDomain) {
        return BUILTIN_ADDON_DOMAIN.equals(addonDomain) ? BuiltinAddonPack.instance() : ADDON_LIST.get(addonDomain);
    }

    public static List<AddonPack> getLoadedAddons() {
        return ImmutableList.builder().addAll(ADDON_LIST.values()).build();
    }

    public static List<AddonPack> loadAddons(File addonDir) {
        MCH_MOD.getLogger().info(AddonManager.jvmdowngrader$concat$loadAddons$1(addonDir.getAbsolutePath()));
        AddonManager.checkExistAddonDir(addonDir);
        ArrayList addons = Lists.newArrayList();
        File[] addonFiles = addonDir.listFiles();
        MCH_MOD.getLogger().info(AddonManager.jvmdowngrader$concat$loadAddons$2(addonFiles.toString()));
        for (File addonFile : addonFiles) {
            AddonPack data;
            if (!AddonManager.validAddonPath(addonFile) || (data = AddonManager.loadAddon(addonFile)) == null) continue;
            addons.add(data);
        }
        MCH_Utils.logger().info("Load complete addons. count:{}", (Object)addons.size());
        return addons;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<AddonPack> loadAddonsAndAddResources(File addonDir) {
        File[] addonFiles;
        AddonManager.checkExistAddonDir(addonDir);
        ArrayList addons = Lists.newArrayList();
        for (File addonFile : addonFiles = addonDir.listFiles()) {
            AddonPack data;
            if (!AddonManager.validAddonPath(addonFile) || (data = AddonManager.loadAddonAndAddResource(addonFile, MCH_MOD.class)) == null) continue;
            addons.add(data);
        }
        AddonManager.checkExistAddonDir(GeneratedAddonPack.instance().getFile());
        AddonManager.addReloadableResource(GeneratedAddonPack.instance(), MCH_MOD.class);
        FMLClientHandler.instance().refreshResources((Predicate)null);
        MCH_Utils.logger().info("Load complete addons and add resources. count:{}", (Object)addons.size());
        return addons;
    }

    @Nullable
    private static AddonPack loadAddon(File addonFile) {
        try {
            AddonPack addonPack = AddonPack.create(addonFile);
            ADDON_LIST.put(addonPack.getDomain(), addonPack);
            return addonPack;
        }
        catch (Exception var2) {
            MCH_Utils.logger().error("Failed to load for pack:{} :", (Object)addonFile.getName(), (Object)var2);
            return null;
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    private static AddonPack loadAddonAndAddResource(File addonFile, Class<?> clazz) {
        AddonPack addonPack = AddonManager.loadAddon(addonFile);
        if (addonPack == null) {
            return null;
        }
        AddonManager.addReloadableResource(addonPack, clazz);
        return addonPack;
    }

    @SideOnly(value=Side.CLIENT)
    private static void addReloadableResource(AddonPack addonPack, Class<?> clazz) {
        HashMap descriptor = Maps.newHashMap();
        descriptor.put("modid", "mcheli");
        descriptor.put("name", AddonManager.jvmdowngrader$concat$addReloadableResource$1(addonPack.getName()));
        descriptor.put("version", addonPack.getVersion());
        File file = addonPack.getFile();
        FMLModContainer container = new FMLModContainer(clazz.getName(), new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), (Map)descriptor);
        container.bindMetadata(MetadataCollection.from(null, (String)""));
        FMLClientHandler.instance().addModAsResource((ModContainer)container);
    }

    private static boolean validAddonPath(File addonFile) {
        return !GeneratedAddonPack.isGeneratedAddonName(addonFile) && (addonFile.isDirectory() || ZIP_PATTERN.matcher(addonFile.getName()).matches());
    }

    private static void checkExistAddonDir(File addonDir) {
        if (!addonDir.exists()) {
            addonDir.mkdirs();
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadAddons$1(String string) {
        return "Loading content from: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadAddons$2(String string) {
        return "Found contents: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$addReloadableResource$1(String string) {
        return "MCHeli#" + string;
    }
}

