/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helper;

import com.google.common.collect.Sets;
import com.norwood.mcheli.helper.MCH_Utils;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="mcheli")
@Mod.EventBusSubscriber(modid="mcheli")
public class MCH_Items {
    private static final Set<Item> registryWrapper = Sets.newLinkedHashSet();

    @SubscribeEvent
    static void onItemRegistryEvent(RegistryEvent.Register<Item> event) {
        for (Item item : registryWrapper) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    public static void register(Item item, String name) {
        registryWrapper.add((Item)item.setRegistryName(MCH_Utils.suffix(name)));
    }

    public static void registerBlock(Block block) {
        registryWrapper.add((Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    @Nullable
    public static Item get(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(MCH_Utils.suffix(name));
    }

    public static String getName(Item item) {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString();
    }
}

