/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helicopter;

import com.norwood.mcheli.aircraft.MCH_Blade;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_RenderAircraft;
import com.norwood.mcheli.aircraft.MCH_Rotor;
import com.norwood.mcheli.helicopter.MCH_EntityHeli;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MCH_RenderHeli
extends MCH_RenderAircraft<MCH_EntityHeli> {
    public static final IRenderFactory<MCH_EntityHeli> FACTORY = MCH_RenderHeli::new;

    public MCH_RenderHeli(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 2.0f;
    }

    @Override
    public void renderAircraft(MCH_EntityAircraft entity, double posX, double posY, double posZ, float yaw, float pitch, float roll, float tickTime) {
        MCH_EntityHeli heli;
        MCH_HeliInfo heliInfo;
        if (entity instanceof MCH_EntityHeli && (heliInfo = (heli = (MCH_EntityHeli)entity).getHeliInfo()) != null) {
            this.renderDebugHitBox(heli, posX, posY += (double)0.35f, posZ, yaw, pitch);
            this.renderDebugPilotSeat(heli, posX, posY, posZ, yaw, pitch, roll);
            GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
            GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)roll, (float)0.0f, (float)0.0f, (float)1.0f);
            this.bindTexture(MCH_RenderHeli.jvmdowngrader$concat$renderAircraft$1(heli.getTextureName()), heli);
            MCH_RenderHeli.renderBody(heliInfo.model);
            this.drawModelBlade(heli, heliInfo, tickTime);
        }
    }

    public void drawModelBlade(MCH_EntityHeli heli, MCH_HeliInfo info, float tickTime) {
        for (int i = 0; i < heli.rotors.length && i < info.rotorList.size(); ++i) {
            MCH_HeliInfo.Rotor rotorInfo = info.rotorList.get(i);
            MCH_Rotor rotor = heli.rotors[i];
            GlStateManager.func_179094_E();
            if (rotorInfo.oldRenderMethod) {
                GlStateManager.func_179137_b((double)rotorInfo.pos.field_72450_a, (double)rotorInfo.pos.field_72448_b, (double)rotorInfo.pos.field_72449_c);
            }
            for (MCH_Blade b : rotor.blades) {
                GlStateManager.func_179094_E();
                float rot = b.getRotation();
                float prevRot = b.getPrevRotation();
                if (rot - prevRot < -180.0f) {
                    prevRot -= 360.0f;
                } else if (prevRot - rot < -180.0f) {
                    prevRot += 360.0f;
                }
                if (!rotorInfo.oldRenderMethod) {
                    GlStateManager.func_179137_b((double)rotorInfo.pos.field_72450_a, (double)rotorInfo.pos.field_72448_b, (double)rotorInfo.pos.field_72449_c);
                }
                GlStateManager.func_179114_b((float)(prevRot + (rot - prevRot) * tickTime), (float)((float)rotorInfo.rot.field_72450_a), (float)((float)rotorInfo.rot.field_72448_b), (float)((float)rotorInfo.rot.field_72449_c));
                if (!rotorInfo.oldRenderMethod) {
                    GlStateManager.func_179137_b((double)(-rotorInfo.pos.field_72450_a), (double)(-rotorInfo.pos.field_72448_b), (double)(-rotorInfo.pos.field_72449_c));
                }
                MCH_RenderHeli.renderPart(rotorInfo.model, info.model, rotorInfo.modelName);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(MCH_EntityHeli entity) {
        return TEX_DEFAULT;
    }

    private static /* synthetic */ String jvmdowngrader$concat$renderAircraft$1(String string) {
        return "textures/helicopters/" + string + ".png";
    }
}

