/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.helicopter;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_KeyName;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_AircraftCommonGui;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.helicopter.MCH_EntityHeli;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import com.norwood.mcheli.weapon.MCH_EntityTvMissile;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MCH_GuiHeli
extends MCH_AircraftCommonGui {
    public MCH_GuiHeli(Minecraft minecraft) {
        super(minecraft);
    }

    @Override
    public boolean isDrawGui(EntityPlayer player) {
        return MCH_EntityAircraft.getAircraft_RiddenOrControl((Entity)player) instanceof MCH_EntityHeli;
    }

    @Override
    public void drawGui(EntityPlayer player, boolean isThirdPersonView) {
        MCH_EntityAircraft ac = MCH_EntityAircraft.getAircraft_RiddenOrControl((Entity)player);
        if (ac instanceof MCH_EntityHeli) {
            MCH_EntityHeli heli = (MCH_EntityHeli)ac;
            if (!ac.isDestroyed()) {
                int seatID = ac.getSeatIdByEntity((Entity)player);
                GL11.glLineWidth((float)scaleFactor);
                if (heli.getCameraMode(player) == 1) {
                    this.drawNightVisionNoise();
                }
                if (!isThirdPersonView || MCH_Config.DisplayHUDThirdPerson.prmBool) {
                    if (seatID == 0 && heli.getIsGunnerMode((Entity)player)) {
                        this.drawHud(ac, player, 1);
                    } else {
                        this.drawHud(ac, player, seatID);
                    }
                }
                this.drawDebugtInfo(heli);
                if (!heli.getIsGunnerMode((Entity)player)) {
                    if (!isThirdPersonView || MCH_Config.DisplayHUDThirdPerson.prmBool) {
                        this.drawKeyBind(heli, player, seatID);
                    }
                    this.drawHitMarker(heli, -14101432, seatID);
                } else {
                    if (!isThirdPersonView || MCH_Config.DisplayHUDThirdPerson.prmBool) {
                        MCH_EntityTvMissile tvmissile = heli.getTVMissile();
                        if (!heli.isMissileCameraMode((Entity)player)) {
                            this.drawKeyBind(heli, player, seatID);
                        } else if (tvmissile != null) {
                            this.drawTvMissileNoise(heli, tvmissile);
                        }
                    }
                    this.drawHitMarker(heli, -805306369, seatID);
                }
            }
        }
    }

    public void drawKeyBind(MCH_EntityHeli heli, EntityPlayer player, int seatID) {
        MCH_HeliInfo info;
        if (!MCH_Config.HideKeybind.prmBool && (info = heli.getHeliInfo()) != null) {
            String msg;
            int c;
            int colorActive = -1342177281;
            int colorInactive = -1349546097;
            int RX = this.centerX + 120;
            int LX = this.centerX - 200;
            this.drawKeyBind(heli, info, player, seatID, RX, LX, colorActive, colorInactive);
            if (seatID == 0 && info.isEnableGunnerMode && !Keyboard.isKeyDown((int)MCH_Config.KeyFreeLook.prmInt)) {
                c = heli.isHoveringMode() ? colorInactive : colorActive;
                msg = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$1(heli.getIsGunnerMode((Entity)player) ? "Normal" : "Gunner", MCH_KeyName.getDescOrName(MCH_Config.KeySwitchMode.prmInt));
                this.drawString(msg, RX, this.centerY - 70, c);
            }
            if (seatID > 0 && heli.canSwitchGunnerModeOtherSeat(player)) {
                String msg2 = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$1(heli.getIsGunnerMode((Entity)player) ? "Normal" : "Camera", MCH_KeyName.getDescOrName(MCH_Config.KeySwitchMode.prmInt));
                this.drawString(msg2, RX, this.centerY - 40, colorActive);
            }
            if (seatID == 0 && !Keyboard.isKeyDown((int)MCH_Config.KeyFreeLook.prmInt)) {
                c = heli.getIsGunnerMode((Entity)player) ? colorInactive : colorActive;
                msg = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$1(heli.getIsGunnerMode((Entity)player) ? "Normal" : "Hovering", MCH_KeyName.getDescOrName(MCH_Config.KeySwitchHovering.prmInt));
                this.drawString(msg, RX, this.centerY - 60, c);
            }
            if (seatID == 0) {
                if (heli.getTowChainEntity() != null && !heli.getTowChainEntity().field_70128_L) {
                    String msg3 = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$1(MCH_KeyName.getDescOrName(MCH_Config.KeyExtra.prmInt));
                    this.drawString(msg3, RX, this.centerY - 30, colorActive);
                } else if (info.isEnableFoldBlade && MCH_Lib.getBlockIdY(heli.field_70170_p, heli.field_70165_t, heli.field_70163_u, heli.field_70161_v, 1, -2, true) > 0 && heli.getCurrentThrottle() <= 0.01) {
                    String msg4 = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$2(MCH_KeyName.getDescOrName(MCH_Config.KeyExtra.prmInt));
                    this.drawString(msg4, RX, this.centerY - 30, colorActive);
                }
            }
            if ((heli.getIsGunnerMode((Entity)player) || heli.isUAV()) && info.cameraZoom > 1) {
                String msg5 = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$3(MCH_KeyName.getDescOrName(MCH_Config.KeyZoom.prmInt));
                this.drawString(msg5, LX, this.centerY - 80, colorActive);
            } else if (seatID == 0 && (heli.canFoldHatch() || heli.canUnfoldHatch())) {
                String msg6 = MCH_GuiHeli.jvmdowngrader$concat$drawKeyBind$4(MCH_KeyName.getDescOrName(MCH_Config.KeyZoom.prmInt));
                this.drawString(msg6, LX, this.centerY - 80, colorActive);
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$1(String string, String string2) {
        return string + " : " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$1(String string) {
        return "Drop  : " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$2(String string) {
        return "FoldBlade  : " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$3(String string) {
        return "Zoom : " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$4(String string) {
        return "OpenHatch : " + string;
    }
}

