/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.gui;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_AircraftGui;
import com.norwood.mcheli.aircraft.MCH_AircraftGuiContainer;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.block.MCH_DraftingTableGui;
import com.norwood.mcheli.block.MCH_DraftingTableGuiContainer;
import com.norwood.mcheli.gui.MCH_ConfigGui;
import com.norwood.mcheli.gui.MCH_ConfigGuiContainer;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.network.PooledGuiParameter;
import com.norwood.mcheli.multiplay.MCH_ContainerScoreboard;
import com.norwood.mcheli.multiplay.MCH_GuiScoreboard;
import com.norwood.mcheli.uav.MCH_ContainerUavStation;
import com.norwood.mcheli.uav.MCH_EntityUavStation;
import com.norwood.mcheli.uav.MCH_GuiUavStation;
import com.norwood.mcheli.wrapper.W_GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MCH_GuiCommonHandler
implements IGuiHandler {
    public static final int GUIID_UAV_STATION = 0;
    public static final int GUIID_AIRCRAFT = 1;
    public static final int GUIID_CONFIG = 2;
    public static final int GUIID_INVENTORY = 3;
    public static final int GUIID_DRAFTING = 4;
    public static final int GUIID_MULTI_MNG = 5;

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Container container;
        MCH_Lib.DbgLog(world, "MCH_GuiCommonHandler.getServerGuiElement ID=%d (%d, %d, %d)", id, x, y, z);
        switch (id) {
            case 0: {
                Entity uavStation = PooledGuiParameter.getEntity(player);
                PooledGuiParameter.resetEntity(player);
                if (uavStation instanceof MCH_EntityUavStation) {
                    MCH_EntityUavStation station = (MCH_EntityUavStation)uavStation;
                    container = new MCH_ContainerUavStation(player.field_71071_by, station);
                    break;
                }
                container = null;
                break;
            }
            case 1: {
                MCH_EntityAircraft ac = null;
                Entity riding = player.func_184187_bx();
                if (riding instanceof MCH_EntityAircraft) {
                    MCH_EntityAircraft a;
                    ac = a = (MCH_EntityAircraft)riding;
                } else if (riding instanceof MCH_EntityUavStation) {
                    MCH_EntityUavStation station = (MCH_EntityUavStation)riding;
                    ac = station.getControlAircract();
                }
                if (ac != null) {
                    container = new MCH_AircraftGuiContainer(player, ac);
                    break;
                }
                container = null;
                break;
            }
            case 2: {
                container = new MCH_ConfigGuiContainer(player);
                break;
            }
            case 4: {
                container = new MCH_DraftingTableGuiContainer(player, x, y, z);
                break;
            }
            case 5: {
                if (!MCH_Utils.getServer().func_71264_H() || MCH_Config.DebugLog) {
                    container = new MCH_ContainerScoreboard(player);
                    break;
                }
                container = null;
                break;
            }
            default: {
                container = null;
            }
        }
        return container;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        W_GuiContainer w_GuiContainer;
        MCH_Lib.DbgLog(world, "MCH_GuiCommonHandler.getClientGuiElement ID=%d (%d, %d, %d)", id, x, y, z);
        switch (id) {
            case 0: {
                Entity uavStation = PooledGuiParameter.getEntity(player);
                PooledGuiParameter.resetEntity(player);
                if (uavStation instanceof MCH_EntityUavStation) {
                    MCH_EntityUavStation station = (MCH_EntityUavStation)uavStation;
                    w_GuiContainer = new MCH_GuiUavStation(player.field_71071_by, station);
                    break;
                }
                w_GuiContainer = null;
                break;
            }
            case 1: {
                MCH_EntityAircraft ac = null;
                Entity riding = player.func_184187_bx();
                if (riding instanceof MCH_EntityAircraft) {
                    MCH_EntityAircraft a;
                    ac = a = (MCH_EntityAircraft)riding;
                } else if (riding instanceof MCH_EntityUavStation) {
                    MCH_EntityUavStation station = (MCH_EntityUavStation)riding;
                    ac = station.getControlAircract();
                }
                if (ac != null) {
                    w_GuiContainer = new MCH_AircraftGui(player, ac);
                    break;
                }
                w_GuiContainer = null;
                break;
            }
            case 2: {
                w_GuiContainer = new MCH_ConfigGui(player);
                break;
            }
            case 4: {
                w_GuiContainer = new MCH_DraftingTableGui(player, x, y, z);
                break;
            }
            case 5: {
                w_GuiContainer = new MCH_GuiScoreboard(player);
                break;
            }
            default: {
                w_GuiContainer = null;
            }
        }
        return w_GuiContainer;
    }
}

