/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.core;

import com.norwood.mcheli.core.MCHCore;
import com.norwood.mcheli.core.ObfSafeName;
import com.norwood.mcheli.core.W_ClassWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class RenderGlobalTransformer
implements IClassTransformer {
    private static final ObfSafeName RENDER_ENTITIES = new ObfSafeName("renderEntities", "func_180446_a");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.client.renderer.RenderGlobal")) {
            return basicClass;
        }
        MCHCore.coreLogger.info("Patching class {} / {}", (Object)transformedName, (Object)name);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!RENDER_ENTITIES.matches(method.name) || !method.desc.equals("(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V")) continue;
                MCHCore.coreLogger.info("Patching method: {} / {}", (Object)RenderGlobalTransformer.RENDER_ENTITIES.mcp, (Object)method.name);
                this.patchRender(method);
            }
            W_ClassWriter writer = new W_ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            MCHCore.fail("net.minecraft.client.renderer.RenderGlobal", t);
            return basicClass;
        }
    }

    private void patchRender(MethodNode method) {
        for (AbstractInsnNode insn : method.instructions) {
            if (insn.getOpcode() != 54 || !(insn instanceof VarInsnNode)) continue;
            VarInsnNode varNode = (VarInsnNode)insn;
            if (varNode.var != 28) continue;
            InsnList inject = new InsnList();
            inject.add((AbstractInsnNode)new VarInsnNode(21, 28));
            inject.add((AbstractInsnNode)new VarInsnNode(25, 27));
            inject.add((AbstractInsnNode)new TypeInsnNode(193, "com/norwood/mcheli/aircraft/MCH_EntityAircraft"));
            inject.add((AbstractInsnNode)new InsnNode(4));
            inject.add((AbstractInsnNode)new InsnNode(130));
            inject.add((AbstractInsnNode)new InsnNode(126));
            inject.add((AbstractInsnNode)new VarInsnNode(54, 28));
            method.instructions.insert(insn, inject);
            MCHCore.coreLogger.info("Injected aircraft render skip after flag assignment (istore 28)");
            break;
        }
    }
}

