/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.core;

import com.norwood.mcheli.core.MCHCore;
import com.norwood.mcheli.core.ObfSafeName;
import com.norwood.mcheli.core.W_ClassWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityUnloadTransformer
implements IClassTransformer {
    ObfSafeName UNLOAD_ENTITES = new ObfSafeName("unloadEntities", "func_175681_c");

    private static void patchUnloadEntites(MethodNode method) {
        for (AbstractInsnNode insn : method.instructions.toArray()) {
            if (insn.getOpcode() != 25 || ((VarInsnNode)insn).var != 1) continue;
            InsnList inject = new InsnList();
            inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/norwood/mcheli/core/WorldUnloadHook", "onEntityUnload", "(Ljava/util/Collection;)Ljava/util/Collection;", false));
            method.instructions.insert(insn, inject);
            break;
        }
    }

    public byte[] transform(String name, String transformedName, byte[] clazz) {
        if (!"net.minecraft.world.World".equals(transformedName)) {
            return clazz;
        }
        MCHCore.coreLogger.info("Patching class {} / {}", (Object)transformedName, (Object)name);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(clazz);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!this.UNLOAD_ENTITES.matches(method.name) || !"(Ljava/util/Collection;)V".equals(method.desc)) continue;
                MCHCore.coreLogger.info("Patching method: {} / {}", (Object)this.UNLOAD_ENTITES.mcp, (Object)method.name);
                EntityUnloadTransformer.patchUnloadEntites(method);
            }
            W_ClassWriter writer = new W_ClassWriter(classReader, 1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            MCHCore.fail("net.minecraft.entity.EntityTrackerEntry", t);
            return clazz;
        }
    }
}

