/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.core;

import com.norwood.mcheli.core.MCHCore;
import com.norwood.mcheli.core.ObfSafeName;
import com.norwood.mcheli.core.W_ClassWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityTrackerEntryTransformer
implements IClassTransformer {
    private static final ObfSafeName IS_VISIBLE_TO = new ObfSafeName("isVisibleTo", "func_180233_c");
    private static final ObfSafeName TRACKED_ENTITY = new ObfSafeName("trackedEntity", "field_73132_a");
    private static final ObfSafeName IS_PLAYER_WATCHING = new ObfSafeName("isPlayerWatchingThisChunk", "func_73121_d");

    private static boolean patchIsVisibleTo(MethodNode method, String ownerInternalName) {
        for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 184 || !(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode minCall = (MethodInsnNode)insn;
            if (!"java/lang/Math".equals(minCall.owner) || !"min".equals(minCall.name) || !"(II)I".equals(minCall.desc)) continue;
            int localRange = method.maxLocals;
            int localMaxRange = method.maxLocals + 1;
            method.maxLocals += 2;
            InsnList inject = new InsnList();
            inject.add((AbstractInsnNode)new VarInsnNode(54, localMaxRange));
            inject.add((AbstractInsnNode)new VarInsnNode(54, localRange));
            inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            inject.add((AbstractInsnNode)new FieldInsnNode(180, ownerInternalName, TRACKED_ENTITY.getName(), "Lnet/minecraft/entity/Entity;"));
            inject.add((AbstractInsnNode)new VarInsnNode(21, localRange));
            inject.add((AbstractInsnNode)new VarInsnNode(21, localMaxRange));
            inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/norwood/mcheli/core/TrackerHook", "getRenderDistance", "(Lnet/minecraft/entity/Entity;II)I", false));
            method.instructions.insert((AbstractInsnNode)minCall, inject);
            method.instructions.remove((AbstractInsnNode)minCall);
            return true;
        }
        return false;
    }

    private static void patchIsPlayerWatching(MethodNode method, String ownerInternalName) {
        InsnList inject = new InsnList();
        LabelNode continueLabel = new LabelNode();
        inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        inject.add((AbstractInsnNode)new FieldInsnNode(180, ownerInternalName, TRACKED_ENTITY.getName(), "Lnet/minecraft/entity/Entity;"));
        inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/norwood/mcheli/core/TrackerHook", "shouldForceWatch", "(Lnet/minecraft/entity/Entity;)Z", false));
        inject.add((AbstractInsnNode)new JumpInsnNode(153, continueLabel));
        inject.add((AbstractInsnNode)new InsnNode(4));
        inject.add((AbstractInsnNode)new InsnNode(172));
        inject.add((AbstractInsnNode)continueLabel);
        inject.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insert(method.instructions.getFirst(), inject);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!"net.minecraft.entity.EntityTrackerEntry".equals(transformedName)) {
            return basicClass;
        }
        MCHCore.coreLogger.info("Patching class {} / {}", (Object)transformedName, (Object)name);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (IS_VISIBLE_TO.matches(method.name) && "(Lnet/minecraft/entity/player/EntityPlayerMP;)Z".equals(method.desc)) {
                    MCHCore.coreLogger.info("Patching method: {} / {}", (Object)EntityTrackerEntryTransformer.IS_VISIBLE_TO.mcp, (Object)method.name);
                    if (!EntityTrackerEntryTransformer.patchIsVisibleTo(method, classNode.name)) {
                        throw new IllegalStateException("Did not find Math.min call to patch in EntityTrackerEntry#isVisibleTo");
                    }
                }
                if (!IS_PLAYER_WATCHING.matches(method.name) || !"(Lnet/minecraft/entity/player/EntityPlayerMP;)Z".equals(method.desc)) continue;
                MCHCore.coreLogger.info("Patching method: {} / {}", (Object)EntityTrackerEntryTransformer.IS_PLAYER_WATCHING.mcp, (Object)method.name);
                EntityTrackerEntryTransformer.patchIsPlayerWatching(method, classNode.name);
            }
            W_ClassWriter writer = new W_ClassWriter(classReader, 1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            MCHCore.fail("net.minecraft.entity.EntityTrackerEntry", t);
            return basicClass;
        }
    }
}

