/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.core;

import com.norwood.mcheli.core.MCHCore;
import com.norwood.mcheli.core.ObfSafeName;
import com.norwood.mcheli.core.W_ClassWriter;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityRendererTransformer
implements IClassTransformer {
    private static final ObfSafeName RENDER_WORLD_PASS = new ObfSafeName("renderWorldPass", "func_175068_a");
    private static final ObfSafeName RENDER_ENTITIES = new ObfSafeName("renderEntities", "func_180446_a");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!"net.minecraft.client.renderer.EntityRenderer".equals(transformedName)) {
            return basicClass;
        }
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!RENDER_WORLD_PASS.matches(method.name)) continue;
                EntityRendererTransformer.patchRenderWorldPass(method);
            }
            W_ClassWriter writer = new W_ClassWriter(classReader, 1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            MCHCore.fail("net.minecraft.client.renderer.EntityRenderer", t);
            return basicClass;
        }
    }

    private static void patchRenderWorldPass(MethodNode method) {
        for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() != 182 || !(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode minsn = (MethodInsnNode)insn;
            if (!RENDER_ENTITIES.matches(minsn.name)) continue;
            InsnList inject = new InsnList();
            inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            inject.add((AbstractInsnNode)new VarInsnNode(23, 2));
            inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/norwood/mcheli/core/EntityRendererHook", "renderFarPass", "(Lnet/minecraft/client/renderer/EntityRenderer;F)V", false));
            method.instructions.insert(insn, inject);
            MCHCore.coreLogger.info("patched renderWorldPass");
            return;
        }
    }
}

