/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.core;

import com.norwood.mcheli.core.MCHCore;
import com.norwood.mcheli.core.ObfSafeName;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityRenderHooks
implements IClassTransformer {
    private static final ObfSafeName RENDER_WORLD_PASS = new ObfSafeName("renderWorldPass", "func_175068_a");
    private static final ObfSafeName RENDER_ENTITES = new ObfSafeName("renderEntities", "func_180446_a");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return basicClass;
        }
        MCHCore.coreLogger.info("Patching class {} / {}", (Object)transformedName, (Object)name);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode method : classNode.methods) {
                if (!RENDER_WORLD_PASS.matches(method.name) || !method.desc.equals("(IFJ)V")) continue;
                MCHCore.coreLogger.info("Patching method: {} / {}", (Object)EntityRenderHooks.RENDER_WORLD_PASS.mcp, (Object)method.name);
                EntityRenderHooks.patchRender(method);
            }
            ClassWriter writer = new ClassWriter(classReader, 3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            MCHCore.fail("net.minecraft.client.renderer.EntityRenderer", t);
            return basicClass;
        }
    }

    private static void patchRender(MethodNode method) {
        for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            MethodInsnNode renderCall;
            if (insn.getOpcode() != 182 || !(insn instanceof MethodInsnNode) || (renderCall = (MethodInsnNode)insn).getOpcode() != 182 || !renderCall.owner.equals("net/minecraft/client/renderer/RenderGlobal") || !RENDER_ENTITES.matches(renderCall.name) || !renderCall.desc.equals("(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V")) continue;
            ArrayList<AbstractInsnNode> stackArgs = new ArrayList<AbstractInsnNode>();
            for (AbstractInsnNode cursor = renderCall.getPrevious(); cursor != null && stackArgs.size() < 3; cursor = cursor.getPrevious()) {
                int op = cursor.getOpcode();
                if ((op < 21 || op > 25) && op != 18 && (op < 2 || op > 15)) continue;
                stackArgs.add(0, cursor);
            }
            int entityVar = ((VarInsnNode)stackArgs.get((int)0)).var;
            int cameraVar = ((VarInsnNode)stackArgs.get((int)1)).var;
            int partialVar = ((VarInsnNode)stackArgs.get((int)2)).var;
            InsnList toInject = EntityRenderHooks.createRenderVehicleHook(entityVar, cameraVar, partialVar);
            method.instructions.insert((AbstractInsnNode)renderCall, toInject);
        }
    }

    private static InsnList createRenderVehicleHook(int entityVar, int camVar, int partialVar) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new FieldInsnNode(178, "com/norwood/mcheli/core/VehicleRenderHook", "INSTANCE", "Lcom/norwood/mcheli/core/VehicleRenderHook;"));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, entityVar));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, camVar));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, partialVar));
        toInject.add((AbstractInsnNode)new MethodInsnNode(182, "com/norwood/mcheli/core/VehicleRenderHook", "renderVehicles", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V", false));
        return toInject;
    }
}

