/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.core;

import com.norwood.mcheli.core.MCHCore;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AviatorCodeGeneratorTransformer
implements IClassTransformer {
    private static final String TARGET_CLASS_NAME = "com.googlecode.aviator.code.asm.ASMCodeGenerator";
    private static final String TARGET_METHOD = "genNewLambdaCode";
    private static final String ASM_MV_OWNER = "com/googlecode/aviator/asm/MethodVisitor";

    private static boolean patchGenNewLambdaCode(MethodNode method) {
        AbstractInsnNode targetNode = null;
        boolean foundLdcName = false;
        for (AbstractInsnNode insn = method.instructions.getFirst(); insn != null; insn = insn.getNext()) {
            if (insn.getOpcode() == 18 && insn instanceof LdcInsnNode) {
                LdcInsnNode ldc = (LdcInsnNode)insn;
                if ("newLambda".equals(ldc.cst)) {
                    foundLdcName = true;
                }
            }
            if (!foundLdcName || insn.getOpcode() != 182 || !(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)insn;
            if (!ASM_MV_OWNER.equals(min.owner) || !"visitMethodInsn".equals(min.name)) continue;
            targetNode = insn;
            break;
        }
        if (targetNode != null) {
            InsnList inject = new InsnList();
            inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            inject.add((AbstractInsnNode)new FieldInsnNode(180, "com/googlecode/aviator/code/asm/ASMCodeGenerator", "mv", "Lcom/googlecode/aviator/asm/MethodVisitor;"));
            inject.add((AbstractInsnNode)new IntInsnNode(17, 192));
            inject.add((AbstractInsnNode)new LdcInsnNode((Object)"com/googlecode/aviator/runtime/type/AviatorObject"));
            inject.add((AbstractInsnNode)new MethodInsnNode(182, ASM_MV_OWNER, "visitTypeInsn", "(ILjava/lang/String;)V", false));
            method.instructions.insert(targetNode, inject);
            return true;
        }
        return false;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!TARGET_CLASS_NAME.equals(transformedName)) {
            return basicClass;
        }
        MCHCore.coreLogger.info("Patching class {} / {}", (Object)transformedName, (Object)name);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            boolean patched = false;
            for (MethodNode method : classNode.methods) {
                if (!TARGET_METHOD.equals(method.name)) continue;
                MCHCore.coreLogger.info("Patching method: {}", (Object)method.name);
                if (!AviatorCodeGeneratorTransformer.patchGenNewLambdaCode(method)) break;
                patched = true;
                break;
            }
            if (!patched) {
                throw new IllegalStateException("Did not find 'visitMethodInsn' call for 'newLambda' in genNewLambdaCode");
            }
            ClassWriter writer = new ClassWriter(classReader, 1);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        catch (Throwable t) {
            MCHCore.fail(TARGET_CLASS_NAME, t);
            return basicClass;
        }
    }
}

