/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.compat.hbm;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockAllocator;
import com.hbm.explosion.vanillant.interfaces.IBlockProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IPlayerProcessor;
import com.hbm.particle.helper.ExplosionCreator;
import com.hbm.particle.helper.ExplosionSmallCreator;
import com.norwood.mcheli.compat.ModCompatManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ExplosionEffect.class})
public class VNTSettingContainer {
    public static final String HBM_VANILLANT_PACKAGE = "com.hbm.explosion.vanillant.standard";
    public static Map<String, Class<?>> vanillantClassSet = null;
    private final Map<String, Object> rawEntry;
    private Object blockAllocator;
    private Object blockProcessor;
    private Object entityProcessor;
    private Object playerProcessor;
    public ExplosionEffect explosionEffect = ExplosionEffect.standard();

    public VNTSettingContainer(Map<String, Object> rawEntry) {
        this.rawEntry = rawEntry;
    }

    public static Constructor<?> findMatchingConstructor(Class<?> clazz, List<?> args2) throws NoSuchMethodException {
        Constructor<?>[] constructors;
        block0: for (Constructor<?> ctor : constructors = clazz.getDeclaredConstructors()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != args2.size()) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                Class<?> paramType = paramTypes[i];
                Object arg = args2.get(i);
                if (arg != null && !VNTSettingContainer.isAssignable(paramType, arg.getClass())) continue block0;
            }
            ctor.setAccessible(true);
            return ctor;
        }
        throw new NoSuchMethodException(VNTSettingContainer.jvmdowngrader$concat$findMatchingConstructor$1(clazz.getSimpleName()));
    }

    private static boolean isAssignable(Class<?> targetType, Class<?> valueType) {
        if (targetType.isPrimitive()) {
            if (targetType == Integer.TYPE) {
                return valueType == Integer.class;
            }
            if (targetType == Long.TYPE) {
                return valueType == Long.class;
            }
            if (targetType == Float.TYPE) {
                return valueType == Float.class;
            }
            if (targetType == Double.TYPE) {
                return valueType == Double.class;
            }
            if (targetType == Boolean.TYPE) {
                return valueType == Boolean.class;
            }
            if (targetType == Character.TYPE) {
                return valueType == Character.class;
            }
            if (targetType == Byte.TYPE) {
                return valueType == Byte.class;
            }
            if (targetType == Short.TYPE) {
                return valueType == Short.class;
            }
            return false;
        }
        return targetType.isAssignableFrom(valueType);
    }

    @Optional.Method(modid="hbm")
    public void loadRuntimeInstances() {
        if (vanillantClassSet == null || vanillantClassSet.isEmpty()) {
            vanillantClassSet = ModCompatManager.getClassesInPackage(HBM_VANILLANT_PACKAGE);
        }
        this.blockProcessor = this.processMap((Map)this.rawEntry.get("BlockProcessor"));
        this.blockAllocator = this.processMap((Map)this.rawEntry.get("BlockAllocator"));
        this.entityProcessor = this.processMap((Map)this.rawEntry.get("EntityProcessor"));
        this.playerProcessor = this.processMap((Map)this.rawEntry.get("PlayerProcessor"));
    }

    @Optional.Method(modid="hbm")
    public void buildExplosion(World world, double x, double y, double z, float size, Entity exploder, boolean effectOnly) {
        if (!effectOnly) {
            ExplosionVNT vnt = new ExplosionVNT(world, x, y, z, size, exploder);
            vnt.setBlockAllocator((IBlockAllocator)this.blockAllocator);
            vnt.setEntityProcessor((IEntityProcessor)this.entityProcessor);
            vnt.setBlockProcessor((IBlockProcessor)this.blockProcessor);
            vnt.setPlayerProcessor((IPlayerProcessor)this.playerProcessor);
            vnt.explode();
        }
        this.explosionEffect.execute(world, x, y, z);
    }

    public Object processMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object instance = null;
        if (map.containsKey("Type")) {
            String typeName = (String)map.get("Type");
            Class<?> clazz = vanillantClassSet.get(typeName);
            if (clazz == null) {
                System.out.println(VNTSettingContainer.jvmdowngrader$concat$processMap$1(typeName));
                return null;
            }
            Object ctorArgs = map.get("Constructor");
            try {
                if (ctorArgs instanceof List) {
                    List argsList = (List)ctorArgs;
                    Constructor<?> ctor = VNTSettingContainer.findMatchingConstructor(clazz, argsList);
                    instance = ctor.newInstance(argsList.toArray());
                } else {
                    instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("Type") || key.equals("Constructor")) continue;
            try {
                if (value instanceof Map) {
                    Map nestedMap = (Map)value;
                    Object nestedObj = this.processMap(nestedMap);
                    this.invokeSetter(instance, key, nestedObj);
                    continue;
                }
                this.invokeSetter(instance, key, value);
            }
            catch (Exception e) {
                System.out.println(VNTSettingContainer.jvmdowngrader$concat$processMap$2(key));
                e.printStackTrace();
            }
        }
        return instance;
    }

    private void invokeSetter(Object instance, String key, Object value) {
        if (instance == null || value == null) {
            return;
        }
        Class<?> clazz = instance.getClass();
        String methodName = VNTSettingContainer.jvmdowngrader$concat$invokeSetter$1(Character.toLowerCase(key.charAt(0)), key.substring(1));
        try {
            Method m = clazz.getMethod(methodName, value.getClass());
            m.invoke(instance, value);
        }
        catch (NoSuchMethodException e) {
            try {
                Field f = clazz.getDeclaredField(key);
                f.setAccessible(true);
                f.set(instance, value);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$findMatchingConstructor$1(String string) {
        return "No matching constructor found for " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processMap$1(String string) {
        return "Unknown class type: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$processMap$2(String string) {
        return "Failed to process key: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$invokeSetter$1(char c, String string) {
        return c + string;
    }

    @NestHost(value=VNTSettingContainer.class)
    public static class ExplosionEffect {
        public boolean isSmall;
        public int cloudCount = 0;
        public float cloudScale = 1.0f;
        public float cloudSpeedMult = 1.0f;
        public float waveScale = 1.0f;
        public int debrisCount = 0;
        public int debrisSize = 0;
        public int debrisRetry = 0;
        public float debrisVelocity = 0.0f;
        public float debrisHorizontalDeviation = 0.0f;
        public float debrisVerticalOffset = 0.0f;
        public float soundRange = 0.0f;

        public ExplosionEffect(boolean isSmall, int cloudCount, float cloudScale, float cloudSpeedMult, float waveScale, int debrisCount, int debrisSize, int debrisRetry, float debrisVelocity, float debrisHorizontalDeviation, float debrisVerticalOffset, float soundRange) {
            this.isSmall = isSmall;
            this.cloudCount = cloudCount;
            this.cloudScale = cloudScale;
            this.cloudSpeedMult = cloudSpeedMult;
            this.waveScale = waveScale;
            this.debrisCount = debrisCount;
            this.debrisSize = debrisSize;
            this.debrisRetry = debrisRetry;
            this.debrisVelocity = debrisVelocity;
            this.debrisHorizontalDeviation = debrisHorizontalDeviation;
            this.debrisVerticalOffset = debrisVerticalOffset;
            this.soundRange = soundRange;
        }

        @Optional.Method(modid="hbm")
        public void execute(World world, double x, double y, double z) {
            if (this.isSmall) {
                ExplosionSmallCreator.composeEffect((World)world, (double)x, (double)y, (double)z, (int)this.cloudCount, (float)this.cloudScale, (float)this.cloudSpeedMult);
            } else {
                ExplosionCreator.composeEffect((World)world, (double)x, (double)y, (double)z, (int)this.cloudCount, (float)this.cloudScale, (float)this.cloudSpeedMult, (float)this.waveScale, (int)this.debrisCount, (int)this.debrisSize, (int)this.debrisRetry, (float)this.debrisVelocity, (float)this.debrisHorizontalDeviation, (float)this.debrisVerticalOffset, (float)this.soundRange);
            }
        }

        public static ExplosionEffect medium() {
            return new ExplosionEffect(false, 10, 2.0f, 0.5f, 25.0f, 5, 8, 20, 0.75f, 1.0f, -2.0f, 150.0f);
        }

        public static ExplosionEffect standard() {
            return new ExplosionEffect(false, 15, 5.0f, 1.0f, 45.0f, 10, 16, 50, 1.0f, 3.0f, -2.0f, 200.0f);
        }

        public static ExplosionEffect large() {
            return new ExplosionEffect(false, 30, 6.5f, 2.0f, 65.0f, 25, 16, 50, 1.25f, 3.0f, -2.0f, 350.0f);
        }

        @Generated
        public ExplosionEffect() {
        }
    }
}

